/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.MonadError;
import cats.Reducible;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.NonEmptySetImpl$;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.ContextShift;
import cats.effect.ExitCase;
import cats.effect.Fiber;
import cats.effect.Fiber$;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.effect.concurrent.Deferred;
import cats.effect.concurrent.Deferred$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.effect.concurrent.TryableDeferred;
import cats.effect.implicits.package$;
import cats.implicits$;
import cats.kernel.Eq;
import cats.kernel.Monoid;
import cats.kernel.Semigroup;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.MonadErrorRethrowOps$;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Queue;
import fs2.concurrent.Queue$;
import fs2.internal.FreeC;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.ConsumerSettings;
import fs2.kafka.ConsumerShutdownException$;
import fs2.kafka.Deserializer;
import fs2.kafka.Jitter;
import fs2.kafka.Jitter$;
import fs2.kafka.KafkaConsumer;
import fs2.kafka.KafkaConsumer$;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.KafkaConsumerActor$Request$;
import fs2.kafka.internal.KafkaConsumerActor$State$;
import fs2.kafka.internal.Logging;
import fs2.kafka.internal.Logging$;
import fs2.kafka.internal.WithConsumer;
import fs2.kafka.internal.WithConsumer$;
import fs2.kafka.internal.converters$;
import fs2.kafka.internal.instances$;
import fs2.kafka.internal.syntax$;
import fs2.kafka.internal.syntax$FiniteDurationSyntax$;
import fs2.kafka.internal.syntax$FoldableSyntax$;
import fs2.kafka.internal.syntax$JavaUtilMapSyntax$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class KafkaConsumer$ {
    public static KafkaConsumer$ MODULE$;

    static {
        new KafkaConsumer$();
    }

    private <F, K, V> Resource<F, Fiber<F, BoxedUnit>> startConsumerActor(Queue<F, KafkaConsumerActor.Request<F, K, V>> requests, Queue<F, KafkaConsumerActor.Request<F, K, V>> polls, KafkaConsumerActor<F, K, V> actor, Concurrent<F> F, ContextShift<F> context) {
        return Resource$.MODULE$.make(implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(F), F).flatMap((Function1 & Serializable & scala.Serializable)deferred -> implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps(F.guaranteeCase(FlatMapOps$.MODULE$.foreverM$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(requests.tryDequeue1(), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.map((Function1 & Serializable & scala.Serializable)x -> F.pure(x)).getOrElse((Function0 & Serializable & scala.Serializable)() -> polls.dequeue1())), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(actor.handle((KafkaConsumerActor.Request)x$2), (FlatMap)F), (Function0 & Serializable & scala.Serializable)() -> context.shift(), (FlatMap)F)), (FlatMap)F), (FlatMap)F), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            ExitCase exitCase = x0$1;
            if (exitCase instanceof ExitCase.Error) {
                ExitCase.Error error = (ExitCase.Error)exitCase;
                Throwable e = (Throwable)error.e();
                object = deferred.complete((Object)scala.package$.MODULE$.Left().apply((Object)e));
            } else {
                object = deferred.complete((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
            }
            return object;
        }), F).start(), (Functor)F).map((Function1 & Serializable & scala.Serializable)fiber -> Fiber$.MODULE$.apply(MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)F), (MonadError)F), implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps(fiber.cancel(), F).start(), (Functor)F).void()))), (Function1 & Serializable & scala.Serializable)x$3 -> x$3.cancel(), F);
    }

    private <F, K, V> Resource<F, Fiber<F, BoxedUnit>> startPollScheduler(Queue<F, KafkaConsumerActor.Request<F, K, V>> polls, FiniteDuration pollInterval, Concurrent<F> F, Timer<F> timer) {
        return Resource$.MODULE$.make(implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(F), F).flatMap((Function1 & Serializable & scala.Serializable)deferred -> implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps(F.guaranteeCase(FlatMapOps$.MODULE$.foreverM$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(implicits$.MODULE$.toFlatMapOps(polls.enqueue1(KafkaConsumerActor$Request$.MODULE$.poll()), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> timer.sleep(pollInterval)), (FlatMap)F), (FlatMap)F), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            ExitCase exitCase = x0$1;
            if (exitCase instanceof ExitCase.Error) {
                ExitCase.Error error = (ExitCase.Error)exitCase;
                Throwable e = (Throwable)error.e();
                object = deferred.complete((Object)scala.package$.MODULE$.Left().apply((Object)e));
            } else {
                object = deferred.complete((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
            }
            return object;
        }), F).start(), (Functor)F).map((Function1 & Serializable & scala.Serializable)fiber -> Fiber$.MODULE$.apply(MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)F), (MonadError)F), implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps(fiber.cancel(), F).start(), (Functor)F).void()))), (Function1 & Serializable & scala.Serializable)x$5 -> x$5.cancel(), F);
    }

    private <F, K, V> KafkaConsumer<F, K, V> createKafkaConsumer(Queue<F, KafkaConsumerActor.Request<F, K, V>> requests, ConsumerSettings<F, K, V> settings, Fiber<F, BoxedUnit> actor, Fiber<F, BoxedUnit> polls, Ref<F, Object> streamIdRef, int id, WithConsumer<F> withConsumer, Concurrent<F> F) {
        return new KafkaConsumer<F, K, V>(F, actor, polls, settings, requests, streamIdRef, withConsumer, id){
            private final Fiber<F, BoxedUnit> fiber;
            private final Concurrent F$3;
            private final Fiber actor$2;
            private final Fiber polls$3;
            private final ConsumerSettings settings$1;
            private final Queue requests$2;
            private final Ref streamIdRef$1;
            private final WithConsumer withConsumer$1;
            private final int id$1;

            public Fiber<F, BoxedUnit> fiber() {
                return this.fiber;
            }

            public FreeC<F, Stream<F, CommittableConsumerRecord<F, K, V>>, BoxedUnit> partitionedStream() {
                Object chunkQueue = Queue$.MODULE$.bounded(this.settings$1.maxPrefetchBatches() - 1, this.F$3);
                Object partitionQueue = Queue$.MODULE$.unbounded(this.F$3);
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(partitionQueue), (Function1 & Serializable & scala.Serializable)partitions -> new Stream(anon.1.$anonfun$partitionedStream$20(this, chunkQueue, partitions)));
            }

            public FreeC<F, CommittableConsumerRecord<F, K, V>, BoxedUnit> stream() {
                return Stream$.MODULE$.parJoinUnbounded$extension(this.partitionedStream(), Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), this.F$3);
            }

            private <A> F request(Function1<Deferred<F, Either<Throwable, A>>, KafkaConsumerActor.Request<F, K, V>> request) {
                return (F)implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(this.F$3), (FlatMap)this.F$3).flatMap((Function1 & Serializable & scala.Serializable)deferred -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.requests$2.enqueue1(request.apply(deferred)), (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> implicits$.MODULE$.toFlatMapOps($this.F$3.race(this.fiber().join(), MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)$this.F$3), (MonadError)$this.F$3)), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        BoxedUnit boxedUnit = (BoxedUnit)left.value();
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit3 = boxedUnit;
                        if (boxedUnit2 == null) {
                            if (boxedUnit3 == null) return $this.F$3.raiseError((Object)((Object)((Object)ConsumerShutdownException$.MODULE$.apply())));
                        } else if (boxedUnit2.equals(boxedUnit3)) {
                            return $this.F$3.raiseError((Object)((Object)((Object)ConsumerShutdownException$.MODULE$.apply())));
                        }
                    }
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Right right = (Right)either;
                    Object a = right.value();
                    return $this.F$3.pure(a);
                }), (FlatMap)$this.F$3));
            }

            public F assignment() {
                return this.assignment(Option$.MODULE$.empty());
            }

            private F assignment(Option<KafkaConsumerActor.OnRebalance<F, K, V>> onRebalance) {
                return this.request((Function1 & Serializable & scala.Serializable)deferred -> new KafkaConsumerActor.Request.Assignment<F, K, V>(deferred, onRebalance));
            }

            public FreeC<F, SortedSet<TopicPartition>, BoxedUnit> assignmentStream() {
                return Stream$.MODULE$.flatten$extension(Stream$.MODULE$.eval(implicits$.MODULE$.toFlatMapOps(Queue$.MODULE$.unbounded(this.F$3), (FlatMap)this.F$3).flatMap((Function1 & Serializable & scala.Serializable)updateQueue -> implicits$.MODULE$.toFlatMapOps(Ref.ApplyBuilders$.MODULE$.of$extension(Ref$.MODULE$.apply((Sync)$this.F$3), (Object)SortedSet$.MODULE$.empty(instances$.MODULE$.topicPartitionOrdering())), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)assignmentRef -> implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply($this.F$3), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)initialAssignmentDeferred -> {
                    KafkaConsumerActor.OnRebalance onRebalance = this.onRebalanceWith$1((Queue)updateQueue, (Ref)assignmentRef, initialAssignmentDeferred.get());
                    return implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFlatMapOps(this.assignment((Option<KafkaConsumerActor.OnRebalance<F, K, V>>)new Some((Object)onRebalance)), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)initialAssignment -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(assignmentRef.set(initialAssignment), (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> updateQueue.enqueue1(initialAssignment), (FlatMap)$this.F$3), (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> initialAssignmentDeferred.complete((Object)BoxedUnit.UNIT), (FlatMap)$this.F$3)), (Functor)$this.F$3).as((Object)new Stream(Stream$.MODULE$.changes$extension(updateQueue.dequeue(), (Eq)implicits$.MODULE$.catsKernelStdOrderForSortedSet(instances$.MODULE$.topicPartitionOrder()))));
                })))), Predef$.MODULE$.$conforms());
            }

            public F seek(TopicPartition partition, long offset) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> consumer.seek(partition, offset)));
            }

            public F seekToBeginning() {
                return this.seekToBeginning((G)List$.MODULE$.empty(), (Foldable<G>)implicits$.MODULE$.catsStdInstancesForList());
            }

            public <G> F seekToBeginning(G partitions, Foldable<G> G) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> consumer.seekToBeginning(syntax$FoldableSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FoldableSyntax(partitions), G))));
            }

            public F seekToEnd() {
                return this.seekToEnd((G)List$.MODULE$.empty(), (Foldable<G>)implicits$.MODULE$.catsStdInstancesForList());
            }

            public <G> F seekToEnd(G partitions, Foldable<G> G) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> consumer.seekToEnd(syntax$FoldableSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FoldableSyntax(partitions), G))));
            }

            public F partitionsFor(String topic) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)converters$.MODULE$.collection().asScalaBufferConverter(consumer.partitionsFor(topic)).asScala()).toList()));
            }

            public F partitionsFor(String topic, FiniteDuration timeout) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)converters$.MODULE$.collection().asScalaBufferConverter(consumer.partitionsFor(topic, syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout)))).asScala()).toList()));
            }

            public F position(TopicPartition partition) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> consumer.position(partition)));
            }

            public F position(TopicPartition partition, FiniteDuration timeout) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> consumer.position(partition, syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout)))));
            }

            public F subscribeTo(String firstTopic, Seq<String> remainingTopics) {
                return this.subscribe(NonEmptyList$.MODULE$.of((Object)firstTopic, remainingTopics), (Reducible)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList());
            }

            public <G> F subscribe(G topics, Reducible<G> G) {
                return this.request((Function1 & Serializable & scala.Serializable)deferred -> new KafkaConsumerActor.Request.SubscribeTopics<F, K, V>((NonEmptyList<String>)implicits$.MODULE$.toReducibleOps(topics, G).toNonEmptyList(), deferred));
            }

            public F subscribe(Regex regex) {
                return this.request((Function1 & Serializable & scala.Serializable)deferred -> new KafkaConsumerActor.Request.SubscribePattern<F, K, V>(regex.pattern(), deferred));
            }

            public F unsubscribe() {
                return this.request((Function1 & Serializable & scala.Serializable)deferred -> new KafkaConsumerActor.Request.Unsubscribe<F, K, V>(deferred));
            }

            public F assign(Object partitions) {
                return this.request((Function1 & Serializable & scala.Serializable)deferred -> new KafkaConsumerActor.Request.Assign<F, K, V>(partitions, deferred));
            }

            public F assign(String topic, Object partitions) {
                return this.assign(NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(partitions).map((Function1 & Serializable & scala.Serializable)x$11 -> anon.1.$anonfun$assign$2(topic, BoxesRunTime.unboxToInt((Object)x$11)), instances$.MODULE$.topicPartitionOrder()));
            }

            public F assign(String topic) {
                return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.partitionsFor(topic), (Functor)this.F$3).map((Function1 & Serializable & scala.Serializable)partitionInfo -> cats.data.package$.MODULE$.NonEmptySet().fromSet((SortedSet)SortedSet$.MODULE$.apply((Seq)partitionInfo.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)anon.1.$anonfun$assign$4(x$12)), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForInt())))), (FlatMap)this.F$3).flatMap((Function1 & Serializable & scala.Serializable)partitions -> partitions.fold((Function0 & Serializable & scala.Serializable)() -> $this.F$3.unit(), (Function1 & Serializable & scala.Serializable)x$13 -> this.assign(topic, x$13)));
            }

            public F beginningOffsets(scala.collection.immutable.Set<TopicPartition> partitions) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0 & Serializable & scala.Serializable)() -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(consumer.beginningOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava())))));
            }

            public F beginningOffsets(scala.collection.immutable.Set<TopicPartition> partitions, FiniteDuration timeout) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0 & Serializable & scala.Serializable)() -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(consumer.beginningOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava(), syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout)))))));
            }

            public F endOffsets(scala.collection.immutable.Set<TopicPartition> partitions) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0 & Serializable & scala.Serializable)() -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(consumer.endOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava())))));
            }

            public F endOffsets(scala.collection.immutable.Set<TopicPartition> partitions, FiniteDuration timeout) {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0 & Serializable & scala.Serializable)() -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(consumer.endOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava(), syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout)))))));
            }

            public F metrics() {
                return this.withConsumer$1.apply((Function1 & Serializable & scala.Serializable)consumer -> $this.F$3.delay((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)converters$.MODULE$.collection().mapAsScalaMapConverter(consumer.metrics()).asScala()).toMap(Predef$.MODULE$.$conforms())));
            }

            public String toString() {
                return new StringBuilder(14).append("KafkaConsumer$").append(this.id$1).toString();
            }

            private final Object fetchPartition$1(Deferred deferred, TopicPartition partition$1, int streamId$1, Object shutdown$1, TryableDeferred stopReqs$1, Queue chunks$1) {
                KafkaConsumerActor.Request.Fetch<F, K, V> request = new KafkaConsumerActor.Request.Fetch<F, K, V>(partition$1, streamId$1, deferred);
                Object fetch = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.requests$2.enqueue1(request), (FlatMap)this.F$3), (Function0 & Serializable & scala.Serializable)() -> deferred.get(), (FlatMap)this.F$3);
                return implicits$.MODULE$.toFlatMapOps(this.F$3.race(shutdown$1, fetch), (FlatMap)this.F$3).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        BoxedUnit boxedUnit = (BoxedUnit)left.value();
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit3 = boxedUnit;
                        if (boxedUnit2 == null) {
                            if (boxedUnit3 == null) return stopReqs$1.complete((Object)BoxedUnit.UNIT);
                        } else if (boxedUnit2.equals(boxedUnit3)) {
                            return stopReqs$1.complete((Object)BoxedUnit.UNIT);
                        }
                    }
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Right right = (Right)either;
                    Tuple2 tuple2 = (Tuple2)right.value();
                    if (tuple2 == null) throw new MatchError((Object)either);
                    Chunk chunk = (Chunk)tuple2._1();
                    KafkaConsumerActor.FetchCompletedReason reason = (KafkaConsumerActor.FetchCompletedReason)tuple2._2();
                    Object enqueueChunk = chunk.nonEmpty() ? chunks$1.enqueue1((Object)new Some((Object)chunk)) : $this.F$3.unit();
                    Object completeRevoked = reason.topicPartitionRevoked() ? stopReqs$1.complete((Object)BoxedUnit.UNIT) : $this.F$3.unit();
                    return FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(enqueueChunk, (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> completeRevoked, (FlatMap)$this.F$3);
                });
            }

            public static final /* synthetic */ FreeC $anonfun$partitionedStream$9(Chunk os) {
                return Stream$.MODULE$.chunk(os);
            }

            private final Object enqueueStream$1(int streamId, TopicPartition partition, Queue partitions, Object chunkQueue$1) {
                return implicits$.MODULE$.toFlatMapOps(chunkQueue$1, (FlatMap)this.F$3).flatMap((Function1 & Serializable & scala.Serializable)chunks -> implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply($this.F$3), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)dequeueDone -> {
                    Object shutdown = implicits$.MODULE$.toFunctorOps($this.F$3.race(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(this.fiber().join(), (ApplicativeError)$this.F$3), (ApplicativeError)$this.F$3), dequeueDone.get()), (Functor)$this.F$3).void();
                    return implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.tryable($this.F$3), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)stopReqs -> partitions.enqueue1((Object)new Stream(Stream$.MODULE$.flatten$extension(Stream$.MODULE$.eval(implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps($this.F$3.guarantee(Stream$.MODULE$.compile$extension(Stream$.MODULE$.interruptWhen$extension3(Stream$.MODULE$.repeatEval(implicits$.MODULE$.toFlatMapOps(stopReqs.tryGet(), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Option option = x0$1;
                        if (None$.MODULE$.equals(option)) {
                            return FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(Deferred$.MODULE$.apply($this.F$3), (FlatMap)$this.F$3), (Function1 & Serializable & scala.Serializable)deferred -> this.fetchPartition$1((Deferred)deferred, partition, streamId, shutdown, (TryableDeferred)stopReqs, (Queue)chunks), (FlatMap)$this.F$3);
                        }
                        if (!(option instanceof Some)) throw new MatchError((Object)option);
                        Some some = (Some)option;
                        BoxedUnit boxedUnit = (BoxedUnit)some.value();
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit3 = boxedUnit;
                        if (boxedUnit2 != null) {
                            if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)option);
                            return $this.F$3.unit();
                        }
                        if (boxedUnit3 == null) return $this.F$3.unit();
                        throw new MatchError((Object)option);
                    })), ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(implicits$.MODULE$.toFunctorOps($this.F$3.race(shutdown, stopReqs.get()), (Functor)$this.F$3).void(), (ApplicativeError)$this.F$3), (ApplicativeError)$this.F$3), $this.F$3), Stream.Compiler$.MODULE$.syncInstance((Sync)$this.F$3)).drain(), implicits$.MODULE$.toFunctorOps($this.F$3.race(dequeueDone.get(), chunks.enqueue1((Object)None$.MODULE$)), (Functor)$this.F$3).void()), $this.F$3).start(), (Functor)$this.F$3).as((Object)new Stream(Stream$.MODULE$.onFinalize$extension(Stream.InvariantOps$.MODULE$.covary$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.unNoneTerminate$extension(chunks.dequeue(), Predef$.MODULE$.$conforms()), (Function1 & Serializable & scala.Serializable)os -> new Stream(anon.1.$anonfun$partitionedStream$9(os))))), dequeueDone.complete((Object)BoxedUnit.UNIT), (Applicative)$this.F$3)))), Predef$.MODULE$.$conforms()))));
                }));
            }

            private final Object enqueueStreams$1(int streamId, Object assigned, Queue partitions, Object chunkQueue$1) {
                return implicits$.MODULE$.toFoldableOps(assigned, (Foldable)NonEmptySetImpl$.MODULE$.catsDataInstancesForNonEmptySet()).foldLeft(this.F$3.unit(), (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(x$7, (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> this.enqueueStream$1(streamId, (TopicPartition)x$8, partitions, chunkQueue$1), (FlatMap)$this.F$3));
            }

            private final KafkaConsumerActor.OnRebalance onRebalance$1(int streamId, Queue partitions, Object chunkQueue$1) {
                return new KafkaConsumerActor.OnRebalance<F, K, V>((Function1 & Serializable & scala.Serializable)assigned -> cats.data.package$.MODULE$.NonEmptySet().fromSet(assigned).fold((Function0 & Serializable & scala.Serializable)() -> $this.F$3.unit(), (Function1 & Serializable & scala.Serializable)x$9 -> this.enqueueStreams$1(streamId, x$9, partitions, chunkQueue$1)), (Function1 & Serializable & scala.Serializable)x$10 -> $this.F$3.unit());
            }

            private final Object requestAssignment$1(int streamId, Queue partitions, Object chunkQueue$1) {
                return implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(this.F$3), (FlatMap)this.F$3).flatMap((Function1 & Serializable & scala.Serializable)deferred -> {
                    KafkaConsumerActor.Request.Assignment<F, K, V> request = new KafkaConsumerActor.Request.Assignment<F, K, V>(deferred, new Some((Object)this.onRebalance$1(streamId, partitions, chunkQueue$1)));
                    Object assignment = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.requests$2.enqueue1(request), (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)$this.F$3), (MonadError)$this.F$3), (FlatMap)$this.F$3);
                    return implicits$.MODULE$.toFunctorOps($this.F$3.race(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(this.fiber().join(), (ApplicativeError)$this.F$3), (ApplicativeError)$this.F$3), assignment), (Functor)$this.F$3).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        SortedSet sortedSet;
                        Either either = x0$1;
                        if (either instanceof Left) {
                            sortedSet = SortedSet$.MODULE$.empty(instances$.MODULE$.topicPartitionOrdering());
                        } else if (either instanceof Right) {
                            SortedSet assigned;
                            Right right = (Right)either;
                            sortedSet = assigned = (SortedSet)right.value();
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return sortedSet;
                    });
                });
            }

            private final Object initialEnqueue$1(int streamId, Queue partitions, Object chunkQueue$1) {
                return implicits$.MODULE$.toFlatMapOps(this.requestAssignment$1(streamId, partitions, chunkQueue$1), (FlatMap)this.F$3).flatMap((Function1 & Serializable & scala.Serializable)assigned -> {
                    Object object;
                    if (assigned.nonEmpty()) {
                        Object nonEmpty = cats.data.package$.MODULE$.NonEmptySet().fromSetUnsafe(assigned);
                        object = this.enqueueStreams$1(streamId, nonEmpty, partitions, chunkQueue$1);
                    } else {
                        object = $this.F$3.unit();
                    }
                    return object;
                });
            }

            public static final /* synthetic */ Tuple2 $anonfun$partitionedStream$21(int n) {
                return new Tuple2.mcII.sp(n + 1, n);
            }

            public static final /* synthetic */ FreeC $anonfun$partitionedStream$23(anon.1 $this, Queue partitions$6, BoxedUnit _) {
                return Stream$.MODULE$.interruptWhen$extension3(partitions$6.dequeue(), ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError($this.fiber().join(), (ApplicativeError)$this.F$3), (ApplicativeError)$this.F$3), $this.F$3);
            }

            public static final /* synthetic */ FreeC $anonfun$partitionedStream$22(anon.1 $this, Queue partitions$6, Object chunkQueue$1, int streamId) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval($this.initialEnqueue$1(streamId, partitions$6, chunkQueue$1)), (Function1 & Serializable & scala.Serializable)_ -> new Stream(anon.1.$anonfun$partitionedStream$23($this, partitions$6, _)));
            }

            public static final /* synthetic */ FreeC $anonfun$partitionedStream$20(anon.1 $this, Object chunkQueue$1, Queue partitions) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval($this.streamIdRef$1.modify((Function1 & Serializable & scala.Serializable)n -> anon.1.$anonfun$partitionedStream$21(BoxesRunTime.unboxToInt((Object)n)))), (Function1 & Serializable & scala.Serializable)streamId -> new Stream(anon.1.$anonfun$partitionedStream$22($this, partitions, chunkQueue$1, BoxesRunTime.unboxToInt((Object)streamId))));
            }

            private final KafkaConsumerActor.OnRebalance onRebalanceWith$1(Queue updateQueue, Ref assignmentRef, Object initialAssignmentDone) {
                return new KafkaConsumerActor.OnRebalance<F, K, V>((Function1 & Serializable & scala.Serializable)assigned -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(initialAssignmentDone, (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> implicits$.MODULE$.toFlatMapOps(assignmentRef.modify((Function1 & Serializable & scala.Serializable)assignment -> {
                    SortedSet newAssignment = (SortedSet)assignment.$plus$plus((GenTraversableOnce)assigned);
                    return new Tuple2((Object)newAssignment, (Object)newAssignment);
                }), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)a -> updateQueue.enqueue1(a)), (FlatMap)$this.F$3), (Function1 & Serializable & scala.Serializable)revoked -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(initialAssignmentDone, (FlatMap)$this.F$3), (Function0 & Serializable & scala.Serializable)() -> implicits$.MODULE$.toFlatMapOps(assignmentRef.modify((Function1 & Serializable & scala.Serializable)assignment -> {
                    SortedSet newAssignment = (SortedSet)assignment.$minus$minus((GenTraversableOnce)revoked);
                    return new Tuple2((Object)newAssignment, (Object)newAssignment);
                }), (FlatMap)$this.F$3).flatMap((Function1 & Serializable & scala.Serializable)a -> updateQueue.enqueue1(a)), (FlatMap)$this.F$3));
            }

            public static final /* synthetic */ TopicPartition $anonfun$assign$2(String topic$3, int x$11) {
                return new TopicPartition(topic$3, x$11);
            }

            public static final /* synthetic */ int $anonfun$assign$4(PartitionInfo x$12) {
                return x$12.partition();
            }
            {
                this.F$3 = F$3;
                this.actor$2 = actor$2;
                this.polls$3 = polls$3;
                this.settings$1 = settings$1;
                this.requests$2 = requests$2;
                this.streamIdRef$1 = streamIdRef$1;
                this.withConsumer$1 = withConsumer$1;
                this.id$1 = id$1;
                Fiber actorFiber = Fiber$.MODULE$.apply(F$3.guaranteeCase(actor$2.join(), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ExitCase exitCase = x0$1;
                    Object object = ExitCase.Completed$.MODULE$.equals(exitCase) ? $this.polls$3.cancel() : $this.F$3.unit();
                    return object;
                }), actor$2.cancel());
                Fiber pollsFiber = Fiber$.MODULE$.apply(F$3.guaranteeCase(polls$3.join(), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ExitCase exitCase = x0$2;
                    Object object = ExitCase.Completed$.MODULE$.equals(exitCase) ? $this.actor$2.cancel() : $this.F$3.unit();
                    return object;
                }), polls$3.cancel());
                this.fiber = (Fiber)implicits$.MODULE$.catsSyntaxSemigroup((Object)actorFiber, (Semigroup)Fiber$.MODULE$.fiberMonoid(F$3, (Monoid)implicits$.MODULE$.catsKernelStdAlgebraForUnit())).combine((Object)pollsFiber);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$partitionedStream$20$adapted(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object fs2.concurrent.Queue ), $anonfun$request$1(fs2.kafka.KafkaConsumer$$anon$1 scala.Function1 cats.effect.concurrent.Deferred ), $anonfun$assignment$1(scala.Option cats.effect.concurrent.Deferred ), $anonfun$assignmentStream$9(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue ), $anonfun$seek$1(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition long org.apache.kafka.clients.consumer.Consumer ), $anonfun$seekToBeginning$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.Foldable org.apache.kafka.clients.consumer.Consumer ), $anonfun$seekToEnd$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.Foldable org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionsFor$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionsFor$3(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$position$1(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition org.apache.kafka.clients.consumer.Consumer ), $anonfun$position$3(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$subscribe$1(java.lang.Object cats.Reducible cats.effect.concurrent.Deferred ), $anonfun$subscribe$2(scala.util.matching.Regex cats.effect.concurrent.Deferred ), $anonfun$unsubscribe$1(cats.effect.concurrent.Deferred ), $anonfun$assign$1(java.lang.Object cats.effect.concurrent.Deferred ), $anonfun$assign$2$adapted(java.lang.String java.lang.Object ), $anonfun$assign$3(scala.collection.immutable.List ), $anonfun$assign$5(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String scala.Option ), $anonfun$beginningOffsets$1(fs2.kafka.KafkaConsumer$$anon$1 scala.collection.immutable.Set org.apache.kafka.clients.consumer.Consumer ), $anonfun$beginningOffsets$3(fs2.kafka.KafkaConsumer$$anon$1 scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$endOffsets$1(fs2.kafka.KafkaConsumer$$anon$1 scala.collection.immutable.Set org.apache.kafka.clients.consumer.Consumer ), $anonfun$endOffsets$3(fs2.kafka.KafkaConsumer$$anon$1 scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$metrics$1(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionedStream$6(java.lang.Object ), $anonfun$partitionedStream$4(cats.effect.concurrent.Deferred ), $anonfun$partitionedStream$5(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.TryableDeferred fs2.concurrent.Queue scala.util.Either ), $anonfun$partitionedStream$8(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition int java.lang.Object cats.effect.concurrent.TryableDeferred fs2.concurrent.Queue cats.effect.concurrent.Deferred ), $anonfun$partitionedStream$7(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition int java.lang.Object cats.effect.concurrent.TryableDeferred fs2.concurrent.Queue scala.Option ), $anonfun$partitionedStream$9$adapted(fs2.Chunk ), $anonfun$partitionedStream$3(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue org.apache.kafka.common.TopicPartition int java.lang.Object fs2.concurrent.Queue cats.effect.concurrent.Deferred cats.effect.concurrent.TryableDeferred ), $anonfun$partitionedStream$2(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue org.apache.kafka.common.TopicPartition int fs2.concurrent.Queue cats.effect.concurrent.Deferred ), $anonfun$partitionedStream$1(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue org.apache.kafka.common.TopicPartition int fs2.concurrent.Queue ), $anonfun$partitionedStream$11(fs2.kafka.KafkaConsumer$$anon$1 int org.apache.kafka.common.TopicPartition fs2.concurrent.Queue java.lang.Object ), $anonfun$partitionedStream$10(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.Queue java.lang.Object java.lang.Object org.apache.kafka.common.TopicPartition ), $anonfun$partitionedStream$13(fs2.kafka.KafkaConsumer$$anon$1 ), $anonfun$partitionedStream$14(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.Queue java.lang.Object java.lang.Object ), $anonfun$partitionedStream$12(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.Queue java.lang.Object scala.collection.immutable.SortedSet ), $anonfun$partitionedStream$15(fs2.kafka.KafkaConsumer$$anon$1 scala.collection.immutable.SortedSet ), $anonfun$partitionedStream$17(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Deferred ), $anonfun$partitionedStream$18(scala.util.Either ), $anonfun$partitionedStream$16(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.Queue java.lang.Object cats.effect.concurrent.Deferred ), $anonfun$partitionedStream$19(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.Queue java.lang.Object scala.collection.immutable.SortedSet ), $anonfun$partitionedStream$23$adapted(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue scala.runtime.BoxedUnit ), $anonfun$partitionedStream$21$adapted(java.lang.Object ), $anonfun$partitionedStream$22$adapted(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue java.lang.Object java.lang.Object ), $anonfun$request$3(fs2.kafka.KafkaConsumer$$anon$1 scala.util.Either ), $anonfun$request$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Deferred ), $anonfun$assignmentStream$3(scala.collection.immutable.SortedSet scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$4(fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref scala.collection.immutable.SortedSet fs2.concurrent.Queue ), $anonfun$assignmentStream$7(scala.collection.immutable.SortedSet scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$8(fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$6(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref scala.collection.immutable.SortedSet fs2.concurrent.Queue ), $anonfun$assignmentStream$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.concurrent.Ref fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$5(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.concurrent.Ref fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$13(fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$14(cats.effect.concurrent.Deferred ), $anonfun$assignmentStream$12(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref fs2.concurrent.Queue cats.effect.concurrent.Deferred scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$11(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue cats.effect.concurrent.Ref cats.effect.concurrent.Deferred ), $anonfun$assignmentStream$10(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.Queue cats.effect.concurrent.Ref ), $anonfun$seek$2(org.apache.kafka.clients.consumer.Consumer org.apache.kafka.common.TopicPartition long ), $anonfun$seekToBeginning$2(org.apache.kafka.clients.consumer.Consumer java.lang.Object cats.Foldable ), $anonfun$seekToEnd$2(org.apache.kafka.clients.consumer.Consumer java.lang.Object cats.Foldable ), $anonfun$partitionsFor$2(org.apache.kafka.clients.consumer.Consumer java.lang.String ), $anonfun$partitionsFor$4(org.apache.kafka.clients.consumer.Consumer java.lang.String scala.concurrent.duration.FiniteDuration ), $anonfun$position$2(org.apache.kafka.clients.consumer.Consumer org.apache.kafka.common.TopicPartition ), $anonfun$position$4(org.apache.kafka.clients.consumer.Consumer org.apache.kafka.common.TopicPartition scala.concurrent.duration.FiniteDuration ), $anonfun$assign$4$adapted(org.apache.kafka.common.PartitionInfo ), $anonfun$assign$6(fs2.kafka.KafkaConsumer$$anon$1 ), $anonfun$assign$7(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String java.lang.Object ), $anonfun$beginningOffsets$2(org.apache.kafka.clients.consumer.Consumer scala.collection.immutable.Set ), $anonfun$beginningOffsets$4(org.apache.kafka.clients.consumer.Consumer scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration ), $anonfun$endOffsets$2(org.apache.kafka.clients.consumer.Consumer scala.collection.immutable.Set ), $anonfun$endOffsets$4(org.apache.kafka.clients.consumer.Consumer scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration ), $anonfun$metrics$2(org.apache.kafka.clients.consumer.Consumer ), $anonfun$fiber$1(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.ExitCase ), $anonfun$fiber$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.ExitCase )}, serializedLambda);
            }
        };
    }

    public <F, K, V> Resource<F, KafkaConsumer<F, K, V>> consumerResource(ConsumerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context, Timer<F> timer) {
        return Resource$.MODULE$.liftF(settings.keyDeserializer(), F).flatMap((Function1 & Serializable & scala.Serializable)keyDeserializer -> Resource$.MODULE$.liftF(settings.valueDeserializer(), (Applicative)F).flatMap((Function1 & Serializable & scala.Serializable)valueDeserializer -> Resource$.MODULE$.liftF(F.delay((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new Object().hashCode()), (Applicative)F).flatMap((Function1 & Serializable & scala.Serializable)id -> KafkaConsumer$.$anonfun$consumerResource$4(F, settings, context, keyDeserializer, valueDeserializer, timer, BoxesRunTime.unboxToInt((Object)id)))));
    }

    public static final /* synthetic */ Resource $anonfun$consumerResource$4(ConcurrentEffect F$4, ConsumerSettings settings$2, ContextShift context$2, Deserializer keyDeserializer$1, Deserializer valueDeserializer$1, Timer timer$2, int id) {
        return Resource$.MODULE$.liftF(Jitter$.MODULE$.default(F$4), (Applicative)F$4).flatMap((Function1 & Serializable & scala.Serializable)x$16 -> {
            Jitter jitter;
            Jitter jitter2 = jitter = x$16;
            Resource resource = Resource$.MODULE$.liftF(Logging$.MODULE$.default(id, F$4), (Applicative)F$4).flatMap((Function1 & Serializable & scala.Serializable)x$15 -> {
                Logging logging;
                Logging logging2 = logging = x$15;
                Resource resource = Resource$.MODULE$.liftF(Queue$.MODULE$.unbounded((Concurrent)F$4), (Applicative)F$4).flatMap((Function1 & Serializable & scala.Serializable)requests -> Resource$.MODULE$.liftF(Queue$.MODULE$.bounded(1, (Concurrent)F$4), (Applicative)F$4).flatMap((Function1 & Serializable & scala.Serializable)polls -> Resource$.MODULE$.liftF(Ref$.MODULE$.of(KafkaConsumerActor$State$.MODULE$.empty(), (Sync)F$4), (Applicative)F$4).flatMap((Function1 & Serializable & scala.Serializable)ref -> Resource$.MODULE$.liftF(Ref$.MODULE$.of((Object)BoxesRunTime.boxToInteger((int)0), (Sync)F$4), (Applicative)F$4).flatMap((Function1 & Serializable & scala.Serializable)streamId -> WithConsumer$.MODULE$.apply(settings$2, F$4, context$2).flatMap((Function1 & Serializable & scala.Serializable)withConsumer -> {
                    KafkaConsumerActor actor2 = new KafkaConsumerActor(settings$2, keyDeserializer$1, valueDeserializer$1, ref, requests, withConsumer, F$4, logging2, jitter2, timer$2);
                    return MODULE$.startConsumerActor((Queue)requests, (Queue)polls, actor2, (Concurrent)F$4, (ContextShift)context$2).flatMap((Function1 & Serializable & scala.Serializable)actor -> MODULE$.startPollScheduler((Queue)polls, settings$2.pollInterval(), (Concurrent)F$4, (Timer)timer$2).map((Function1 & Serializable & scala.Serializable)polls -> MODULE$.createKafkaConsumer((Queue)requests, settings$2, (Fiber)actor, (Fiber)polls, (Ref)streamId, id, (WithConsumer)withConsumer, (Concurrent)F$4), (Applicative)F$4));
                })))));
                return resource;
            });
            return resource;
        });
    }

    private KafkaConsumer$() {
        MODULE$ = this;
    }
}

