/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.ContextShift;
import cats.effect.IO$;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.concurrent.Deferred;
import cats.effect.concurrent.Deferred$;
import cats.implicits$;
import cats.syntax.MonadErrorRethrowOps$;
import fs2.Chunk$;
import fs2.kafka.KafkaProducer;
import fs2.kafka.ProducerRecord;
import fs2.kafka.ProducerRecords;
import fs2.kafka.ProducerResult$;
import fs2.kafka.ProducerSettings;
import fs2.kafka.Serializer;
import fs2.kafka.internal.WithProducer;
import fs2.kafka.internal.WithProducer$;
import fs2.kafka.internal.converters$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class KafkaProducer$ {
    public static KafkaProducer$ MODULE$;

    static {
        new KafkaProducer$();
    }

    public <F, K, V> Resource<F, KafkaProducer.Metrics<F, K, V>> resource(ProducerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context) {
        return Resource$.MODULE$.liftF(settings.keySerializer(), F).flatMap((Function1 & Serializable & scala.Serializable)keySerializer -> Resource$.MODULE$.liftF(settings.valueSerializer(), (Applicative)F).flatMap((Function1 & Serializable & scala.Serializable)valueSerializer -> WithProducer$.MODULE$.apply(settings, F, context).map((Function1 & Serializable & scala.Serializable)withProducer -> new KafkaProducer.Metrics<F, K, V>((WithProducer)withProducer, (Serializer)keySerializer, (Serializer)valueSerializer, F){
            private final WithProducer withProducer$1;
            private final Serializer keySerializer$1;
            private final Serializer valueSerializer$1;
            private final ConcurrentEffect F$1;

            public <P> F produce(ProducerRecords<K, V, P> records) {
                return this.withProducer$1.apply((Function1 & Serializable & scala.Serializable)producer -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps(records.records(), Chunk$.MODULE$.instance()).traverse(KafkaProducer$.MODULE$.produceRecord($this.keySerializer$1, $this.valueSerializer$1, (Producer<byte[], byte[]>)producer, $this.F$1), (Applicative)$this.F$1), (Functor)$this.F$1).map((Function1 & Serializable & scala.Serializable)x$1 -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps(x$1, Chunk$.MODULE$.instance()).sequence(Predef$.MODULE$.$conforms(), (Applicative)$this.F$1), (Functor)$this.F$1).map((Function1 & Serializable & scala.Serializable)x$2 -> ProducerResult$.MODULE$.apply(x$2, records.passthrough()))));
            }

            public F metrics() {
                return this.withProducer$1.apply((Function1 & Serializable & scala.Serializable)producer -> $this.F$1.delay((Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)converters$.MODULE$.collection().mapAsScalaMapConverter(producer.metrics()).asScala()).toMap(Predef$.MODULE$.$conforms())));
            }

            public String toString() {
                return new StringBuilder(14).append("KafkaProducer$").append(System.identityHashCode(this)).toString();
            }
            {
                this.withProducer$1 = withProducer$1;
                this.keySerializer$1 = keySerializer$1;
                this.valueSerializer$1 = valueSerializer$1;
                this.F$1 = F$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$produce$1(fs2.kafka.KafkaProducer$$anon$1 fs2.kafka.ProducerRecords org.apache.kafka.clients.producer.Producer ), $anonfun$metrics$1(fs2.kafka.KafkaProducer$$anon$1 org.apache.kafka.clients.producer.Producer ), $anonfun$produce$3(fs2.kafka.ProducerRecords fs2.Chunk ), $anonfun$produce$2(fs2.kafka.KafkaProducer$$anon$1 fs2.kafka.ProducerRecords fs2.Chunk ), $anonfun$metrics$2(org.apache.kafka.clients.producer.Producer )}, serializedLambda);
            }
        }, (Applicative)F)));
    }

    public <F, K, V> Function1<ProducerRecord<K, V>, F> produceRecord(Serializer<F, K> keySerializer, Serializer<F, V> valueSerializer, Producer<byte[], byte[]> producer, ConcurrentEffect<F> F) {
        return (Function1 & Serializable & scala.Serializable)record -> implicits$.MODULE$.toFlatMapOps(MODULE$.asJavaRecord(keySerializer, valueSerializer, (ProducerRecord)record, (Apply)F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)javaRecord -> implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply((Concurrent)F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)deferred -> implicits$.MODULE$.toFunctorOps(F.delay((Function0 & Serializable & scala.Serializable)() -> producer.send(javaRecord, MODULE$.callback((Function2<RecordMetadata, Exception, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(metadata, exception) -> {
            KafkaProducer$.$anonfun$produceRecord$5(deferred, record, F, metadata, exception);
            return BoxedUnit.UNIT;
        }))), (Functor)F).as(MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)F), (MonadError)F))));
    }

    private <F, K, V> F serializeToBytes(Serializer<F, K> keySerializer, Serializer<F, V> valueSerializer, ProducerRecord<K, V> record, Apply<F> F) {
        F keyBytes = keySerializer.serialize(record.topic(), record.headers(), record.key());
        F valueBytes = valueSerializer.serialize(record.topic(), record.headers(), record.value());
        return (F)implicits$.MODULE$.catsSyntaxSemigroupal(keyBytes, F).product(valueBytes);
    }

    private <F, K, V> F asJavaRecord(Serializer<F, K> keySerializer, Serializer<F, V> valueSerializer, ProducerRecord<K, V> record, Apply<F> F) {
        return (F)implicits$.MODULE$.toFunctorOps(this.serializeToBytes(keySerializer, valueSerializer, record, F), F).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] keyBytes = (byte[])tuple2._1();
            byte[] valueBytes = (byte[])tuple2._2();
            org.apache.kafka.clients.producer.ProducerRecord producerRecord = new org.apache.kafka.clients.producer.ProducerRecord(record.topic(), record.partition().isDefined() ? Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)record.partition().get())) : null, record.timestamp().isDefined() ? Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)record.timestamp().get())) : null, (Object)keyBytes, (Object)valueBytes, (Iterable)record.headers().asJava());
            return producerRecord;
        });
    }

    private Callback callback(Function2<RecordMetadata, Exception, BoxedUnit> f) {
        return new Callback(f){
            private final Function2 f$1;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                this.f$1.apply((Object)metadata, (Object)exception);
            }
            {
                this.f$1 = f$1;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$produceRecord$5(Deferred deferred$1, ProducerRecord record$1, ConcurrentEffect F$2, RecordMetadata metadata, Exception exception) {
        Object complete = deferred$1.complete(exception == null ? package$.MODULE$.Right().apply((Object)new Tuple2((Object)record$1, (Object)metadata)) : package$.MODULE$.Left().apply((Object)exception));
        F$2.runAsync(complete, (Function1 & Serializable & scala.Serializable)x$3 -> IO$.MODULE$.unit()).unsafeRunSync();
    }

    private KafkaProducer$() {
        MODULE$ = this;
    }
}

