/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.MonadError;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.ContextShift;
import cats.effect.IO$;
import cats.effect.Resource;
import cats.effect.concurrent.Deferred;
import cats.effect.concurrent.Deferred$;
import cats.implicits$;
import cats.syntax.MonadErrorRethrowOps$;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.internal.FreeC;
import fs2.kafka.KafkaProducer;
import fs2.kafka.KafkaProducerConnection$;
import fs2.kafka.ProducerRecord;
import fs2.kafka.ProducerRecords;
import fs2.kafka.ProducerResult;
import fs2.kafka.ProducerResult$;
import fs2.kafka.ProducerSettings;
import fs2.kafka.Serializer;
import fs2.kafka.internal.WithProducer;
import fs2.kafka.internal.converters$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RecordMetadata;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class KafkaProducer$ {
    public static KafkaProducer$ MODULE$;

    static {
        new KafkaProducer$();
    }

    public <F, K, V> Resource<F, KafkaProducer.Metrics<F, K, V>> resource(ProducerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context) {
        return KafkaProducerConnection$.MODULE$.resource(settings, F, context).evalMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withSerializersFrom(settings), F);
    }

    public <F, K, V> KafkaProducer.Metrics<F, K, V> from(WithProducer<F> withProducer, Serializer<F, K> keySerializer, Serializer<F, V> valueSerializer, ConcurrentEffect<F> evidence$1) {
        return new KafkaProducer.Metrics<F, K, V>(withProducer, keySerializer, valueSerializer, evidence$1){
            private final WithProducer withProducer$1;
            private final Serializer keySerializer$1;
            private final Serializer valueSerializer$1;
            private final ConcurrentEffect evidence$1$1;

            public <P> F produce(ProducerRecords<K, V, P> records) {
                return this.withProducer$1.apply((Function2 & Serializable & scala.Serializable)(producer, x$2) -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps(records.records(), Chunk$.MODULE$.instance()).traverse(KafkaProducer$.MODULE$.produceRecord($this.keySerializer$1, $this.valueSerializer$1, (Producer<byte[], byte[]>)producer, $this.evidence$1$1), (Applicative)$this.evidence$1$1), (Functor)$this.evidence$1$1).map((Function1 & Serializable & scala.Serializable)x$3 -> implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps(x$3, Chunk$.MODULE$.instance()).sequence(Predef$.MODULE$.$conforms(), (Applicative)$this.evidence$1$1), (Functor)$this.evidence$1$1).map((Function1 & Serializable & scala.Serializable)x$4 -> ProducerResult$.MODULE$.apply(x$4, records.passthrough()))));
            }

            public F metrics() {
                return this.withProducer$1.blocking((Function1 & Serializable & scala.Serializable)x$5 -> ((TraversableOnce)converters$.MODULE$.collection().mapAsScalaMapConverter(x$5.metrics()).asScala()).toMap(Predef$.MODULE$.$conforms()));
            }

            public String toString() {
                return new StringBuilder(14).append("KafkaProducer$").append(System.identityHashCode(this)).toString();
            }
            {
                this.withProducer$1 = withProducer$1;
                this.keySerializer$1 = keySerializer$1;
                this.valueSerializer$1 = valueSerializer$1;
                this.evidence$1$1 = evidence$1$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$produce$1(fs2.kafka.KafkaProducer$$anon$1 fs2.kafka.ProducerRecords org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking ), $anonfun$metrics$1(org.apache.kafka.clients.producer.Producer ), $anonfun$produce$3(fs2.kafka.ProducerRecords fs2.Chunk ), $anonfun$produce$2(fs2.kafka.KafkaProducer$$anon$1 fs2.kafka.ProducerRecords fs2.Chunk )}, serializedLambda);
            }
        };
    }

    public <F> ConcurrentEffect<F> resource(ConcurrentEffect<F> F) {
        return F;
    }

    public <F, K, V> FreeC<F, KafkaProducer.Metrics<F, K, V>, BoxedUnit> stream(ProducerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context) {
        return Stream$.MODULE$.resource(this.resource(settings, F, context));
    }

    public <F> ConcurrentEffect<F> stream(ConcurrentEffect<F> F) {
        return F;
    }

    public <F, K, V> Function1<ProducerRecord<K, V>, F> produceRecord(Serializer<F, K> keySerializer, Serializer<F, V> valueSerializer, Producer<byte[], byte[]> producer, ConcurrentEffect<F> F) {
        return (Function1 & Serializable & scala.Serializable)record -> implicits$.MODULE$.toFlatMapOps(MODULE$.asJavaRecord(keySerializer, valueSerializer, (ProducerRecord)record, (Apply)F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)javaRecord -> implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply((Concurrent)F), (FlatMap)F).flatMap((Function1 & Serializable & scala.Serializable)deferred -> implicits$.MODULE$.toFunctorOps(F.delay((Function0 & Serializable & scala.Serializable)() -> producer.send(javaRecord, MODULE$.callback((Function2<RecordMetadata, Exception, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(metadata, exception) -> {
            KafkaProducer$.$anonfun$produceRecord$5(deferred, record, F, metadata, exception);
            return BoxedUnit.UNIT;
        }))), (Functor)F).as(MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)F), (MonadError)F))));
    }

    public <F, K, V, P> Function1<Stream<F, ProducerRecords<K, V, P>>, Stream<F, ProducerResult<K, V, P>>> pipe(ProducerSettings<F, K, V> settings, ConcurrentEffect<F> evidence$2, ContextShift<F> evidence$3) {
        return (Function1 & Serializable & scala.Serializable)records -> new Stream(Stream$.MODULE$.flatMap$extension(KafkaProducer$.MODULE$.stream(settings, evidence$2, evidence$3), (Function1 & Serializable & scala.Serializable)x$7 -> new Stream(KafkaProducer$.$anonfun$pipe$2(settings$2, evidence$2$1, records, x$7))));
    }

    public <F, K, V, P> Function1<Stream<F, ProducerRecords<K, V, P>>, Stream<F, ProducerResult<K, V, P>>> pipe(ProducerSettings<F, K, V> settings, KafkaProducer<F, K, V> producer, Concurrent<F> evidence$4) {
        return (Function1 & Serializable & scala.Serializable)x$8 -> new Stream(Stream$.MODULE$.mapAsync$extension(Stream$.MODULE$.evalMap$extension(((Stream)x$8).fs2$Stream$$free(), (Function1 & Serializable & scala.Serializable)records -> producer$2.produce(records)), settings.parallelism(), (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x), evidence$4));
    }

    private <F, K, V> F serializeToBytes(Serializer<F, K> keySerializer, Serializer<F, V> valueSerializer, ProducerRecord<K, V> record, Apply<F> F) {
        F keyBytes = keySerializer.serialize(record.topic(), record.headers(), record.key());
        F valueBytes = valueSerializer.serialize(record.topic(), record.headers(), record.value());
        return (F)implicits$.MODULE$.catsSyntaxSemigroupal(keyBytes, F).product(valueBytes);
    }

    private <F, K, V> F asJavaRecord(Serializer<F, K> keySerializer, Serializer<F, V> valueSerializer, ProducerRecord<K, V> record, Apply<F> F) {
        return (F)implicits$.MODULE$.toFunctorOps(this.serializeToBytes(keySerializer, valueSerializer, record, F), F).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] keyBytes = (byte[])tuple2._1();
            byte[] valueBytes = (byte[])tuple2._2();
            org.apache.kafka.clients.producer.ProducerRecord producerRecord = new org.apache.kafka.clients.producer.ProducerRecord(record.topic(), (Integer)record.partition().fold((Function0 & Serializable & scala.Serializable)() -> null, (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x)))))), (Long)record.timestamp().fold((Function0 & Serializable & scala.Serializable)() -> null, (Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x)))))), (Object)keyBytes, (Object)valueBytes, (Iterable)record.headers().asJava());
            return producerRecord;
        });
    }

    private Callback callback(Function2<RecordMetadata, Exception, BoxedUnit> f) {
        return new Callback(f){
            private final Function2 f$1;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                this.f$1.apply((Object)metadata, (Object)exception);
            }
            {
                this.f$1 = f$1;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$produceRecord$5(Deferred deferred$1, ProducerRecord record$1, ConcurrentEffect F$1, RecordMetadata metadata, Exception exception) {
        Object complete = deferred$1.complete(exception == null ? package$.MODULE$.Right().apply((Object)new Tuple2((Object)record$1, (Object)metadata)) : package$.MODULE$.Left().apply((Object)exception));
        F$1.runAsync(complete, (Function1 & Serializable & scala.Serializable)x$6 -> IO$.MODULE$.unit()).unsafeRunSync();
    }

    public static final /* synthetic */ FreeC $anonfun$pipe$2(ProducerSettings settings$2, ConcurrentEffect evidence$2$1, FreeC records$2, KafkaProducer.Metrics x$7) {
        return ((Stream)MODULE$.pipe((ProducerSettings)settings$2, x$7, (Concurrent)evidence$2$1).apply((Object)new Stream(records$2))).fs2$Stream$$free();
    }

    private KafkaProducer$() {
        MODULE$ = this;
    }
}

