/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant;
import cats.MonadError;
import cats.Reducible;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.NonEmptySetImpl$;
import cats.data.OptionT;
import cats.effect.Bracket;
import cats.effect.Concurrent;
import cats.effect.ConcurrentEffect;
import cats.effect.ContextShift;
import cats.effect.ExitCase;
import cats.effect.Fiber;
import cats.effect.Fiber$;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Timer;
import cats.effect.concurrent.Deferred;
import cats.effect.concurrent.Deferred$;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.effect.concurrent.TryableDeferred;
import cats.effect.implicits.package$;
import cats.effect.syntax.BracketOps$;
import cats.implicits$;
import cats.kernel.Eq;
import cats.kernel.Monoid;
import cats.kernel.Semigroup;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.MonadErrorRethrowOps$;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.NoneTerminatedQueue;
import fs2.concurrent.Queue;
import fs2.concurrent.Queue$;
import fs2.internal.FreeC;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.ConsumerSettings;
import fs2.kafka.ConsumerShutdownException$;
import fs2.kafka.Deserializer;
import fs2.kafka.Jitter;
import fs2.kafka.Jitter$;
import fs2.kafka.KafkaConsumer;
import fs2.kafka.KafkaConsumer$;
import fs2.kafka.instances$;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.KafkaConsumerActor$Request$;
import fs2.kafka.internal.KafkaConsumerActor$State$;
import fs2.kafka.internal.Logging;
import fs2.kafka.internal.Logging$;
import fs2.kafka.internal.WithConsumer;
import fs2.kafka.internal.WithConsumer$;
import fs2.kafka.internal.converters$;
import fs2.kafka.internal.syntax$;
import fs2.kafka.internal.syntax$FiniteDurationSyntax$;
import fs2.kafka.internal.syntax$FoldableSyntax$;
import fs2.kafka.internal.syntax$JavaUtilMapSyntax$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class KafkaConsumer$ {
    public static KafkaConsumer$ MODULE$;

    static {
        new KafkaConsumer$();
    }

    private <F, A> Resource<F, Fiber<F, BoxedUnit>> spawnRepeating(F fa, Concurrent<F> evidence$1) {
        return Resource$.MODULE$.make(implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(evidence$1), evidence$1).flatMap((Function1 & Serializable & scala.Serializable)deferred -> implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps(BracketOps$.MODULE$.guaranteeCase$extension(package$.MODULE$.catsEffectSyntaxBracket(FlatMapOps$.MODULE$.foreverM$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(fa, (FlatMap)evidence$1), (FlatMap)evidence$1), (Bracket)evidence$1), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            ExitCase exitCase = x0$1;
            if (exitCase instanceof ExitCase.Error) {
                ExitCase.Error error = (ExitCase.Error)exitCase;
                Throwable e = (Throwable)error.e();
                object = deferred.complete((Object)scala.package$.MODULE$.Left().apply((Object)e));
            } else {
                object = deferred.complete((Object)scala.package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
            }
            return object;
        }, (Bracket)evidence$1), evidence$1).start(), (Functor)evidence$1).map((Function1 & Serializable & scala.Serializable)fiber -> Fiber$.MODULE$.apply(MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)evidence$1), (MonadError)evidence$1), implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps(fiber.cancel(), evidence$1).start(), (Functor)evidence$1).void()))), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.cancel(), evidence$1);
    }

    private <F, K, V> Resource<F, Fiber<F, BoxedUnit>> startConsumerActor(Queue<F, KafkaConsumerActor.Request<F, K, V>> requests, Queue<F, KafkaConsumerActor.Request<F, K, V>> polls, KafkaConsumerActor<F, K, V> actor, Concurrent<F> F, ContextShift<F> context) {
        return this.spawnRepeating(implicits$.MODULE$.toFlatMapOps(new OptionT(requests.tryDequeue1()).getOrElseF((Function0 & Serializable & scala.Serializable)() -> polls.dequeue1(), F), F).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(actor.handle((KafkaConsumerActor.Request)x$2), (FlatMap)F), (Function0 & Serializable & scala.Serializable)() -> context.shift(), (FlatMap)F)), F);
    }

    private <F, K, V> Resource<F, Fiber<F, BoxedUnit>> startPollScheduler(Queue<F, KafkaConsumerActor.Request<F, K, V>> polls, FiniteDuration pollInterval, Concurrent<F> F, Timer<F> timer) {
        return this.spawnRepeating(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(polls.enqueue1(KafkaConsumerActor$Request$.MODULE$.poll()), F), (Function0 & Serializable & scala.Serializable)() -> timer.sleep(pollInterval), F), F);
    }

    private <F, K, V> KafkaConsumer<F, K, V> createKafkaConsumer(Queue<F, KafkaConsumerActor.Request<F, K, V>> requests, ConsumerSettings<F, K, V> settings, Fiber<F, BoxedUnit> actor, Fiber<F, BoxedUnit> polls, Ref<F, Object> streamIdRef, int id, WithConsumer<F> withConsumer, TryableDeferred<F, BoxedUnit> stopConsumingDeferred, Concurrent<F> F) {
        return new KafkaConsumer<F, K, V>(actor, F, polls, settings, stopConsumingDeferred, requests, streamIdRef, withConsumer, id){
            private final Fiber<F, BoxedUnit> fiber;
            private final Fiber actor$2;
            private final Concurrent F$2;
            private final Fiber polls$2;
            private final ConsumerSettings settings$1;
            private final TryableDeferred stopConsumingDeferred$1;
            private final Queue requests$1;
            private final Ref streamIdRef$1;
            private final WithConsumer withConsumer$1;
            private final int id$1;

            public Fiber<F, BoxedUnit> fiber() {
                return this.fiber;
            }

            public FreeC<F, Map<TopicPartition, Stream<F, CommittableConsumerRecord<F, K, V>>>, BoxedUnit> partitionsMapStream() {
                Object chunkQueue = Queue$.MODULE$.bounded(this.settings$1.maxPrefetchBatches() - 1, this.F$2);
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(this.stopConsumingDeferred$1.tryGet()), (Function1 & Serializable & scala.Serializable)x0$1 -> new Stream(anon.1.$anonfun$partitionsMapStream$31(this, chunkQueue, x0$1)));
            }

            public FreeC<F, Stream<F, CommittableConsumerRecord<F, K, V>>, BoxedUnit> partitionedStream() {
                return Stream$.MODULE$.flatMap$extension(this.partitionsMapStream(), (Function1 & Serializable & scala.Serializable)partitionsMap -> new Stream(anon.1.$anonfun$partitionedStream$1(partitionsMap)));
            }

            public FreeC<F, CommittableConsumerRecord<F, K, V>, BoxedUnit> stream() {
                return Stream$.MODULE$.parJoinUnbounded$extension(this.partitionedStream(), Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), this.F$2);
            }

            public F commitAsync(Map<TopicPartition, OffsetAndMetadata> offsets) {
                return this.request((Function1 & Serializable & scala.Serializable)callback -> {
                    Function1 x$1 = callback;
                    Map x$2 = offsets;
                    return new KafkaConsumerActor.Request.ManualCommitAsync<F, K, V>((Map<TopicPartition, OffsetAndMetadata>)x$2, x$1);
                });
            }

            public F commitSync(Map<TopicPartition, OffsetAndMetadata> offsets) {
                return this.request((Function1 & Serializable & scala.Serializable)callback -> {
                    Function1 x$1 = callback;
                    Map x$2 = offsets;
                    return new KafkaConsumerActor.Request.ManualCommitSync<F, K, V>((Map<TopicPartition, OffsetAndMetadata>)x$2, x$1);
                });
            }

            private <A> F request(Function1<Function1<Either<Throwable, A>, F>, KafkaConsumerActor.Request<F, K, V>> request) {
                return (F)MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(this.F$2), (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)deferred -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.requests$1.enqueue1(request.apply((Function1 & Serializable & scala.Serializable)a -> deferred.complete(a))), (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> $this.F$2.race(implicits$.MODULE$.toFunctorOps(this.awaitTermination(), (Functor)$this.F$2).as((Object)((Object)ConsumerShutdownException$.MODULE$.apply())), MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)$this.F$2), (MonadError)$this.F$2)), (FlatMap)$this.F$2)), (MonadError)this.F$2), (MonadError)this.F$2);
            }

            public F assignment() {
                return this.assignment(Option$.MODULE$.empty());
            }

            private F assignment(Option<KafkaConsumerActor.OnRebalance<F, K, V>> onRebalance) {
                return this.request((Function1 & Serializable & scala.Serializable)callback -> new KafkaConsumerActor.Request.Assignment<F, K, V>(callback, onRebalance));
            }

            public FreeC<F, SortedSet<TopicPartition>, BoxedUnit> assignmentStream() {
                return Stream$.MODULE$.flatten$extension(Stream$.MODULE$.eval(implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3(Queue$.MODULE$.unbounded(this.F$2), Ref.ApplyBuilders$.MODULE$.of$extension(Ref$.MODULE$.apply((Sync)this.F$2), (Object)SortedSet$.MODULE$.empty(instances$.MODULE$.fs2KafkaTopicPartitionOrdering())), Deferred$.MODULE$.apply(this.F$2))).tupled((Invariant)this.F$2, (Semigroupal)this.F$2), (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Queue updateQueue = (Queue)tuple3._1();
                    Ref assignmentRef = (Ref)tuple3._2();
                    Deferred initialAssignmentDeferred = (Deferred)tuple3._3();
                    KafkaConsumerActor.OnRebalance onRebalance = this.onRebalanceWith$1(updateQueue, assignmentRef, initialAssignmentDeferred.get());
                    Object object = implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toFlatMapOps(this.assignment((Option<KafkaConsumerActor.OnRebalance<F, K, V>>)new Some((Object)onRebalance)), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)initialAssignment -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(assignmentRef.set(initialAssignment), (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> updateQueue.enqueue1(initialAssignment), (FlatMap)$this.F$2), (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> initialAssignmentDeferred.complete((Object)BoxedUnit.UNIT), (FlatMap)$this.F$2)), (Functor)$this.F$2).as((Object)new Stream(Stream$.MODULE$.changes$extension(updateQueue.dequeue(), (Eq)implicits$.MODULE$.catsKernelStdOrderForSortedSet(instances$.MODULE$.fs2KafkaTopicPartitionOrder()))));
                    return object;
                })), Predef$.MODULE$.$conforms());
            }

            public F seek(TopicPartition partition, long offset) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$9 -> {
                    anon.1.$anonfun$seek$1(partition, offset, x$9);
                    return BoxedUnit.UNIT;
                });
            }

            public F seekToBeginning() {
                return this.seekToBeginning((G)List$.MODULE$.empty(), (Foldable<G>)implicits$.MODULE$.catsStdInstancesForList());
            }

            public <G> F seekToBeginning(G partitions, Foldable<G> G) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$10 -> {
                    anon.1.$anonfun$seekToBeginning$1(partitions, G, x$10);
                    return BoxedUnit.UNIT;
                });
            }

            public F seekToEnd() {
                return this.seekToEnd((G)List$.MODULE$.empty(), (Foldable<G>)implicits$.MODULE$.catsStdInstancesForList());
            }

            public <G> F seekToEnd(G partitions, Foldable<G> G) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$11 -> {
                    anon.1.$anonfun$seekToEnd$1(partitions, G, x$11);
                    return BoxedUnit.UNIT;
                });
            }

            public F partitionsFor(String topic) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$12 -> ((TraversableOnce)converters$.MODULE$.collection().asScalaBufferConverter(x$12.partitionsFor(topic)).asScala()).toList());
            }

            public F partitionsFor(String topic, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$13 -> ((TraversableOnce)converters$.MODULE$.collection().asScalaBufferConverter(x$13.partitionsFor(topic, syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout)))).asScala()).toList());
            }

            public F position(TopicPartition partition) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$position$1(partition, x$14)));
            }

            public F position(TopicPartition partition, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$position$2(partition, timeout, x$15)));
            }

            public F subscribeTo(String firstTopic, Seq<String> remainingTopics) {
                return this.subscribe(NonEmptyList$.MODULE$.of((Object)firstTopic, remainingTopics), (Reducible)NonEmptyList$.MODULE$.catsDataInstancesForNonEmptyList());
            }

            public <G> F subscribe(G topics, Reducible<G> G) {
                return this.request((Function1 & Serializable & scala.Serializable)callback -> new KafkaConsumerActor.Request.SubscribeTopics<F, K, V>((NonEmptyList<String>)implicits$.MODULE$.toReducibleOps(topics, G).toNonEmptyList(), callback));
            }

            public F subscribe(Regex regex) {
                return this.request((Function1 & Serializable & scala.Serializable)callback -> new KafkaConsumerActor.Request.SubscribePattern<F, K, V>(regex.pattern(), callback));
            }

            public F unsubscribe() {
                return this.request((Function1 & Serializable & scala.Serializable)callback -> new KafkaConsumerActor.Request.Unsubscribe<F, K, V>(callback));
            }

            public F stopConsuming() {
                return (F)implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(this.stopConsumingDeferred$1.complete((Object)BoxedUnit.UNIT), (ApplicativeError)this.F$2), (ApplicativeError)this.F$2), (Functor)this.F$2).void();
            }

            public F assign(Object partitions) {
                return this.request((Function1 & Serializable & scala.Serializable)callback -> new KafkaConsumerActor.Request.Assign<F, K, V>(partitions, callback));
            }

            public F assign(String topic, Object partitions) {
                return this.assign(NonEmptySetImpl$.MODULE$.catsNonEmptySetOps(partitions).map((Function1 & Serializable & scala.Serializable)x$16 -> anon.1.$anonfun$assign$2(topic, BoxesRunTime.unboxToInt((Object)x$16)), instances$.MODULE$.fs2KafkaTopicPartitionOrder()));
            }

            public F assign(String topic) {
                return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.partitionsFor(topic), (Functor)this.F$2).map((Function1 & Serializable & scala.Serializable)partitionInfo -> cats.data.package$.MODULE$.NonEmptySet().fromSet((SortedSet)SortedSet$.MODULE$.apply((Seq)partitionInfo.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)anon.1.$anonfun$assign$4(x$17)), List$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsKernelOrderingForOrder(implicits$.MODULE$.catsKernelStdOrderForInt())))), (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)partitions -> implicits$.MODULE$.toFunctorOps(partitions.fold((Function0 & Serializable & scala.Serializable)() -> $this.F$2.unit(), (Function1 & Serializable & scala.Serializable)x$18 -> this.assign(topic, x$18)), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)_ -> {
                    anon.1.$anonfun$assign$8(_);
                    return BoxedUnit.UNIT;
                }));
            }

            public F beginningOffsets(scala.collection.immutable.Set<TopicPartition> partitions) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$19 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$19.beginningOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava()))));
            }

            public F beginningOffsets(scala.collection.immutable.Set<TopicPartition> partitions, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$20 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$20.beginningOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava(), syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout))))));
            }

            public F endOffsets(scala.collection.immutable.Set<TopicPartition> partitions) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$21 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$21.endOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava()))));
            }

            public F endOffsets(scala.collection.immutable.Set<TopicPartition> partitions, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$22 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$22.endOffsets((Collection)converters$.MODULE$.collection().setAsJavaSetConverter((Set)partitions).asJava(), syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout))))));
            }

            public F metrics() {
                return this.withConsumer$1.blocking((Function1 & Serializable & scala.Serializable)x$23 -> ((TraversableOnce)converters$.MODULE$.collection().mapAsScalaMapConverter(x$23.metrics()).asScala()).toMap(Predef$.MODULE$.$conforms()));
            }

            public String toString() {
                return new StringBuilder(14).append("KafkaConsumer$").append(this.id$1).toString();
            }

            private final Object fetchPartition$1(Deferred deferred, TopicPartition partition$1, int streamId$1, Object shutdown$1, TryableDeferred stopReqs$1, Queue chunks$1) {
                KafkaConsumerActor.Request.Fetch<F, K, V> request = new KafkaConsumerActor.Request.Fetch<F, K, V>(partition$1, streamId$1, (Function1 & Serializable & scala.Serializable)a -> deferred.complete(a));
                Object fetch = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(this.requests$1.enqueue1(request), (FlatMap)this.F$2), (Function0 & Serializable & scala.Serializable)() -> deferred.get(), (FlatMap)this.F$2);
                return implicits$.MODULE$.toFlatMapOps(this.F$2.race(shutdown$1, fetch), (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Left) {
                        Left left = (Left)either;
                        BoxedUnit boxedUnit = (BoxedUnit)left.value();
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit3 = boxedUnit;
                        if (boxedUnit2 == null) {
                            if (boxedUnit3 == null) return stopReqs$1.complete((Object)BoxedUnit.UNIT);
                        } else if (boxedUnit2.equals(boxedUnit3)) {
                            return stopReqs$1.complete((Object)BoxedUnit.UNIT);
                        }
                    }
                    if (!(either instanceof Right)) throw new MatchError((Object)either);
                    Right right = (Right)either;
                    Tuple2 tuple2 = (Tuple2)right.value();
                    if (tuple2 == null) throw new MatchError((Object)either);
                    Chunk chunk = (Chunk)tuple2._1();
                    KafkaConsumerActor.FetchCompletedReason reason = (KafkaConsumerActor.FetchCompletedReason)tuple2._2();
                    Object enqueueChunk = ApplicativeOps$.MODULE$.unlessA$extension(implicits$.MODULE$.catsSyntaxApplicative(chunks$1.enqueue1((Object)new Some((Object)chunk))), chunk.isEmpty(), (Applicative)$this.F$2);
                    Object completeRevoked = ApplicativeOps$.MODULE$.whenA$extension(implicits$.MODULE$.catsSyntaxApplicative(stopReqs$1.complete((Object)BoxedUnit.UNIT)), reason.topicPartitionRevoked(), (Applicative)$this.F$2);
                    return FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(enqueueChunk, (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> completeRevoked, (FlatMap)$this.F$2);
                });
            }

            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$11(Chunk os) {
                return Stream$.MODULE$.chunk(os);
            }

            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$4(anon.1 $this, TopicPartition partition$1, int streamId$1, Object shutdown$1, Queue chunks$1, Deferred dequeueDone$1, TryableDeferred stopReqs) {
                return Stream$.MODULE$.flatten$extension(Stream$.MODULE$.eval(implicits$.MODULE$.toFunctorOps(package$.MODULE$.toConcurrentOps(BracketOps$.MODULE$.guarantee$extension(package$.MODULE$.catsEffectSyntaxBracket(Stream$.MODULE$.compile$extension(Stream$.MODULE$.interruptWhen$extension3(Stream$.MODULE$.repeatEval(implicits$.MODULE$.toFlatMapOps(stopReqs.tryGet(), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        return FlatMapOps$.MODULE$.$greater$greater$eq$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(Deferred$.MODULE$.apply($this.F$2), (FlatMap)$this.F$2), (Function1 & Serializable & scala.Serializable)deferred -> $this.fetchPartition$1((Deferred)deferred, partition$1, streamId$1, shutdown$1, stopReqs, chunks$1), (FlatMap)$this.F$2);
                    }
                    if (!(option instanceof Some)) throw new MatchError((Object)option);
                    Some some = (Some)option;
                    BoxedUnit boxedUnit = (BoxedUnit)some.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (boxedUnit2 != null) {
                        if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)option);
                        return $this.F$2.unit();
                    }
                    if (boxedUnit3 == null) return $this.F$2.unit();
                    throw new MatchError((Object)option);
                })), ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(implicits$.MODULE$.toFunctorOps($this.F$2.race(shutdown$1, stopReqs.get()), (Functor)$this.F$2).void(), (ApplicativeError)$this.F$2), (ApplicativeError)$this.F$2), $this.F$2), Stream.Compiler$.MODULE$.syncInstance((Sync)$this.F$2)).drain(), (Bracket)$this.F$2), implicits$.MODULE$.toFunctorOps($this.F$2.race(dequeueDone$1.get(), chunks$1.enqueue1((Object)None$.MODULE$)), (Functor)$this.F$2).void(), (Bracket)$this.F$2), $this.F$2).start(), (Functor)$this.F$2).as((Object)new Stream(Stream$.MODULE$.onFinalize$extension(Stream.InvariantOps$.MODULE$.covary$extension(Stream$.MODULE$.InvariantOps(Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.unNoneTerminate$extension(chunks$1.dequeue(), Predef$.MODULE$.$conforms()), (Function1 & Serializable & scala.Serializable)os -> new Stream(anon.1.$anonfun$partitionsMapStream$11(os))))), dequeueDone$1.complete((Object)BoxedUnit.UNIT), (Applicative)$this.F$2)))), Predef$.MODULE$.$conforms());
            }

            private final Object createPartitionStream$1(int streamId, TopicPartition partition, Object assignmentRevoked, Object chunkQueue$1) {
                return implicits$.MODULE$.toFlatMapOps(chunkQueue$1, (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)chunks -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(Deferred$.MODULE$.apply($this.F$2), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)dequeueDone -> {
                    Object shutdown = implicits$.MODULE$.toFunctorOps($this.F$2.race($this.F$2.race(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(this.awaitTermination(), (ApplicativeError)$this.F$2), (ApplicativeError)$this.F$2), dequeueDone.get()), $this.F$2.race($this.stopConsumingDeferred$1.get(), assignmentRevoked)), (Functor)$this.F$2).void();
                    return new Tuple2(dequeueDone, shutdown);
                }), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                    Tuple2 tuple2 = x$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Deferred dequeueDone = (Deferred)tuple2._1();
                    Object shutdown = tuple2._2();
                    Object object = implicits$.MODULE$.toFunctorOps(Deferred$.MODULE$.tryable($this.F$2), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)stopReqs -> new Stream(anon.1.$anonfun$partitionsMapStream$4(this, partition, streamId, shutdown, chunks, dequeueDone, stopReqs)));
                    return object;
                }));
            }

            public static final /* synthetic */ Tuple2 $anonfun$partitionsMapStream$13(TopicPartition partition$2, FreeC stream) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition$2), (Object)new Stream(stream));
            }

            private final Object enqueueAssignment$1(int streamId, SortedSet assigned, NoneTerminatedQueue partitionsMapQueue, Object assignmentRevoked, Object chunkQueue$1) {
                Object assignment2 = assigned.isEmpty() ? this.F$2.pure((Object)Predef$.MODULE$.Map().empty()) : implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps((Object)assigned.toVector(), implicits$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable & scala.Serializable)partition -> implicits$.MODULE$.toFunctorOps(this.createPartitionStream$1(streamId, (TopicPartition)partition, assignmentRevoked, chunkQueue$1), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)stream -> anon.1.$anonfun$partitionsMapStream$13(partition, ((Stream)stream).fs2$Stream$$free())), (Applicative)this.F$2), (Functor)this.F$2).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toMap(Predef$.MODULE$.$conforms()));
                return implicits$.MODULE$.toFlatMapOps(assignment2, (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)assignment -> implicits$.MODULE$.toFlatMapOps($this.stopConsumingDeferred$1.tryGet(), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        return partitionsMapQueue.enqueue1((Object)new Some(assignment));
                    }
                    if (!(option instanceof Some)) throw new MatchError((Object)option);
                    Some some = (Some)option;
                    BoxedUnit boxedUnit = (BoxedUnit)some.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (boxedUnit2 != null) {
                        if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)option);
                        return $this.F$2.unit();
                    }
                    if (boxedUnit3 == null) return $this.F$2.unit();
                    throw new MatchError((Object)option);
                }));
            }

            public static final /* synthetic */ void $anonfun$partitionsMapStream$20(BoxedUnit _) {
            }

            private final KafkaConsumerActor.OnRebalance onRebalance$1(int streamId, Ref prevAssignmentFinisherRef, NoneTerminatedQueue partitionsMapQueue, Object chunkQueue$1) {
                Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)x$5 -> implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply($this.F$2), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)newFinisher -> implicits$.MODULE$.toFlatMapOps(prevAssignmentFinisherRef.getAndSet(newFinisher), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)prevAssignmentFinisher -> implicits$.MODULE$.toFunctorOps(prevAssignmentFinisher.complete((Object)BoxedUnit.UNIT), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)_ -> {
                    anon.1.$anonfun$partitionsMapStream$20(_);
                    return BoxedUnit.UNIT;
                })));
                Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)assigned -> implicits$.MODULE$.toFlatMapOps(prevAssignmentFinisherRef.get(), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)prevAssignmentFinisher -> this.enqueueAssignment$1(streamId, (SortedSet)assigned, partitionsMapQueue, prevAssignmentFinisher.get(), chunkQueue$1));
                return new KafkaConsumerActor.OnRebalance<F, K, V>(x$2, x$1);
            }

            private final Object requestAssignment$1(int streamId, Ref prevAssignmentFinisherRef, NoneTerminatedQueue partitionsMapQueue, Object chunkQueue$1) {
                return implicits$.MODULE$.toFlatMapOps(Deferred$.MODULE$.apply(this.F$2), (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)deferred -> {
                    KafkaConsumerActor.Request.Assignment<F, K, V> request = new KafkaConsumerActor.Request.Assignment<F, K, V>((Function1 & Serializable & scala.Serializable)a -> deferred.complete(a), new Some((Object)this.onRebalance$1(streamId, prevAssignmentFinisherRef, partitionsMapQueue, chunkQueue$1)));
                    Object assignment = FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.requests$1.enqueue1(request), (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> MonadErrorRethrowOps$.MODULE$.rethrow$extension(implicits$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)$this.F$2), (MonadError)$this.F$2), (FlatMap)$this.F$2);
                    return implicits$.MODULE$.toFunctorOps($this.F$2.race(ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError(this.awaitTermination(), (ApplicativeError)$this.F$2), (ApplicativeError)$this.F$2), assignment), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        SortedSet sortedSet;
                        Either either = x0$1;
                        if (either instanceof Left) {
                            sortedSet = SortedSet$.MODULE$.empty(instances$.MODULE$.fs2KafkaTopicPartitionOrdering());
                        } else if (either instanceof Right) {
                            SortedSet assigned;
                            Right right = (Right)either;
                            sortedSet = assigned = (SortedSet)right.value();
                        } else {
                            throw new MatchError((Object)either);
                        }
                        return sortedSet;
                    });
                });
            }

            public static final /* synthetic */ void $anonfun$partitionsMapStream$30(BoxedUnit _) {
            }

            private final Object initialEnqueue$1(int streamId, NoneTerminatedQueue partitionsMapQueue, Ref prevAssignmentFinisherRef, Object chunkQueue$1) {
                return implicits$.MODULE$.toFlatMapOps(prevAssignmentFinisherRef.get(), (FlatMap)this.F$2).flatMap((Function1 & Serializable & scala.Serializable)prevAssignmentFinisher -> implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFunctorOps(this.requestAssignment$1(streamId, prevAssignmentFinisherRef, partitionsMapQueue, chunkQueue$1), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)assigned -> {
                    Object assignmentRevoked = prevAssignmentFinisher.get();
                    return new Tuple2(assigned, assignmentRevoked);
                }), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
                    Tuple2 tuple2 = x$6;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SortedSet assigned = (SortedSet)tuple2._1();
                    Object assignmentRevoked = tuple2._2();
                    Object object = implicits$.MODULE$.toFunctorOps(this.enqueueAssignment$1(streamId, assigned, partitionsMapQueue, assignmentRevoked, chunkQueue$1), (Functor)$this.F$2).map((Function1 & Serializable & scala.Serializable)_ -> {
                        anon.1.$anonfun$partitionsMapStream$30(_);
                        return BoxedUnit.UNIT;
                    });
                    return object;
                }));
            }

            public static final /* synthetic */ Tuple2 $anonfun$partitionsMapStream$33(int n) {
                return new Tuple2.mcII.sp(n + 1, n);
            }

            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$37(anon.1 $this, NoneTerminatedQueue partitionsMapQueue$5, BoxedUnit _) {
                return Stream$.MODULE$.map$extension(Stream$.MODULE$.concurrently$extension(Stream$.MODULE$.interruptWhen$extension3(partitionsMapQueue$5.dequeue(), ApplicativeErrorOps$.MODULE$.attempt$extension(implicits$.MODULE$.catsSyntaxApplicativeError($this.awaitTermination(), (ApplicativeError)$this.F$2), (ApplicativeError)$this.F$2), $this.F$2), Stream$.MODULE$.eval(FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps($this.stopConsumingDeferred$1.get(), (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> partitionsMapQueue$5.enqueue1((Object)None$.MODULE$), (FlatMap)$this.F$2)), $this.F$2), (Function1 & Serializable & scala.Serializable)out -> out);
            }

            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$36(anon.1 $this, int streamId$6, NoneTerminatedQueue partitionsMapQueue$5, Object chunkQueue$1, Ref prevAssignmentFinisherRef) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval($this.initialEnqueue$1(streamId$6, partitionsMapQueue$5, prevAssignmentFinisherRef, chunkQueue$1)), (Function1 & Serializable & scala.Serializable)_ -> new Stream(anon.1.$anonfun$partitionsMapStream$37($this, partitionsMapQueue$5, _)));
            }

            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$35(anon.1 $this, int streamId$6, NoneTerminatedQueue partitionsMapQueue$5, Object chunkQueue$1, Deferred prevAssignmentFinisher) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(Ref.ApplyBuilders$.MODULE$.of$extension(Ref$.MODULE$.apply((Sync)$this.F$2), (Object)prevAssignmentFinisher)), (Function1 & Serializable & scala.Serializable)prevAssignmentFinisherRef -> new Stream(anon.1.$anonfun$partitionsMapStream$36($this, streamId$6, partitionsMapQueue$5, chunkQueue$1, prevAssignmentFinisherRef)));
            }

            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$34(anon.1 $this, NoneTerminatedQueue partitionsMapQueue$5, Object chunkQueue$1, int streamId) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(Deferred$.MODULE$.apply($this.F$2)), (Function1 & Serializable & scala.Serializable)prevAssignmentFinisher -> new Stream(anon.1.$anonfun$partitionsMapStream$35($this, streamId, partitionsMapQueue$5, chunkQueue$1, prevAssignmentFinisher)));
            }

            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$32(anon.1 $this, Object chunkQueue$1, NoneTerminatedQueue partitionsMapQueue) {
                return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval($this.streamIdRef$1.modify((Function1 & Serializable & scala.Serializable)n -> anon.1.$anonfun$partitionsMapStream$33(BoxesRunTime.unboxToInt((Object)n)))), (Function1 & Serializable & scala.Serializable)streamId -> new Stream(anon.1.$anonfun$partitionsMapStream$34($this, partitionsMapQueue, chunkQueue$1, BoxesRunTime.unboxToInt((Object)streamId))));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public static final /* synthetic */ FreeC $anonfun$partitionsMapStream$31(anon.1 $this, Object chunkQueue$1, Option x0$1) {
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    return Stream$.MODULE$.flatMap$extension(Stream$.MODULE$.eval(Queue$.MODULE$.noneTerminated($this.F$2)), (Function1 & Serializable & scala.Serializable)partitionsMapQueue -> new Stream(anon.1.$anonfun$partitionsMapStream$32($this, chunkQueue$1, partitionsMapQueue)));
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                Some some = (Some)option;
                BoxedUnit boxedUnit = (BoxedUnit)some.value();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                BoxedUnit boxedUnit3 = boxedUnit;
                if (boxedUnit2 != null) {
                    if (!boxedUnit2.equals(boxedUnit3)) throw new MatchError((Object)option);
                    return Stream$.MODULE$.covaryAll$extension(Stream$.MODULE$.empty());
                }
                if (boxedUnit3 == null) return Stream$.MODULE$.covaryAll$extension(Stream$.MODULE$.empty());
                throw new MatchError((Object)option);
            }

            public static final /* synthetic */ FreeC $anonfun$partitionedStream$2(Tuple2 x0$1) {
                FreeC partitionStream;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                FreeC freeC = partitionStream = ((Stream)tuple2._2()).fs2$Stream$$free();
                return freeC;
            }

            public static final /* synthetic */ FreeC $anonfun$partitionedStream$1(Map partitionsMap) {
                return Stream$.MODULE$.emits((Seq)partitionsMap.toVector().map((Function1 & Serializable & scala.Serializable)x0$1 -> new Stream(anon.1.$anonfun$partitionedStream$2(x0$1)), Vector$.MODULE$.canBuildFrom()));
            }

            private final KafkaConsumerActor.OnRebalance onRebalanceWith$1(Queue updateQueue, Ref assignmentRef, Object initialAssignmentDone) {
                return new KafkaConsumerActor.OnRebalance<F, K, V>((Function1 & Serializable & scala.Serializable)assigned -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(initialAssignmentDone, (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> implicits$.MODULE$.toFlatMapOps(assignmentRef.updateAndGet((Function1 & Serializable & scala.Serializable)x$7 -> (SortedSet)x$7.$plus$plus((GenTraversableOnce)assigned)), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)a -> updateQueue.enqueue1(a)), (FlatMap)$this.F$2), (Function1 & Serializable & scala.Serializable)revoked -> FlatMapOps$.MODULE$.$greater$greater$extension(implicits$.MODULE$.catsSyntaxFlatMapOps(initialAssignmentDone, (FlatMap)$this.F$2), (Function0 & Serializable & scala.Serializable)() -> implicits$.MODULE$.toFlatMapOps(assignmentRef.updateAndGet((Function1 & Serializable & scala.Serializable)x$8 -> (SortedSet)x$8.$minus$minus((GenTraversableOnce)revoked)), (FlatMap)$this.F$2).flatMap((Function1 & Serializable & scala.Serializable)a -> updateQueue.enqueue1(a)), (FlatMap)$this.F$2));
            }

            public static final /* synthetic */ void $anonfun$seek$1(TopicPartition partition$3, long offset$1, Consumer x$9) {
                x$9.seek(partition$3, offset$1);
            }

            public static final /* synthetic */ void $anonfun$seekToBeginning$1(Object partitions$1, Foldable G$1, Consumer x$10) {
                x$10.seekToBeginning(syntax$FoldableSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FoldableSyntax(partitions$1), G$1));
            }

            public static final /* synthetic */ void $anonfun$seekToEnd$1(Object partitions$2, Foldable G$2, Consumer x$11) {
                x$11.seekToEnd(syntax$FoldableSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FoldableSyntax(partitions$2), G$2));
            }

            public static final /* synthetic */ long $anonfun$position$1(TopicPartition partition$4, Consumer x$14) {
                return x$14.position(partition$4);
            }

            public static final /* synthetic */ long $anonfun$position$2(TopicPartition partition$5, FiniteDuration timeout$2, Consumer x$15) {
                return x$15.position(partition$5, syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout$2)));
            }

            public static final /* synthetic */ TopicPartition $anonfun$assign$2(String topic$3, int x$16) {
                return new TopicPartition(topic$3, x$16);
            }

            public static final /* synthetic */ int $anonfun$assign$4(PartitionInfo x$17) {
                return x$17.partition();
            }

            public static final /* synthetic */ void $anonfun$assign$8(BoxedUnit _) {
            }
            {
                this.actor$2 = actor$2;
                this.F$2 = F$2;
                this.polls$2 = polls$2;
                this.settings$1 = settings$1;
                this.stopConsumingDeferred$1 = stopConsumingDeferred$1;
                this.requests$1 = requests$1;
                this.streamIdRef$1 = streamIdRef$1;
                this.withConsumer$1 = withConsumer$1;
                this.id$1 = id$1;
                Fiber actorFiber = Fiber$.MODULE$.apply(BracketOps$.MODULE$.guaranteeCase$extension(package$.MODULE$.catsEffectSyntaxBracket(actor$2.join(), (Bracket)F$2), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                    ExitCase exitCase = x0$1;
                    Object object = ExitCase.Completed$.MODULE$.equals(exitCase) ? $this.polls$2.cancel() : $this.F$2.unit();
                    return object;
                }, (Bracket)F$2), actor$2.cancel());
                Fiber pollsFiber = Fiber$.MODULE$.apply(BracketOps$.MODULE$.guaranteeCase$extension(package$.MODULE$.catsEffectSyntaxBracket(polls$2.join(), (Bracket)F$2), (Function1 & Serializable & scala.Serializable)x0$2 -> {
                    ExitCase exitCase = x0$2;
                    Object object = ExitCase.Completed$.MODULE$.equals(exitCase) ? $this.actor$2.cancel() : $this.F$2.unit();
                    return object;
                }, (Bracket)F$2), polls$2.cancel());
                this.fiber = (Fiber)implicits$.MODULE$.catsSyntaxSemigroup((Object)actorFiber, (Semigroup)Fiber$.MODULE$.fiberMonoid(F$2, (Monoid)implicits$.MODULE$.catsKernelStdAlgebraForUnit())).combine((Object)pollsFiber);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$partitionsMapStream$31$adapted(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object scala.Option ), $anonfun$partitionedStream$1$adapted(scala.collection.immutable.Map ), $anonfun$commitAsync$1(scala.collection.immutable.Map scala.Function1 ), $anonfun$commitSync$1(scala.collection.immutable.Map scala.Function1 ), $anonfun$request$1(fs2.kafka.KafkaConsumer$$anon$1 scala.Function1 cats.effect.concurrent.Deferred ), $anonfun$assignment$1(scala.Option scala.Function1 ), $anonfun$assignmentStream$9(fs2.kafka.KafkaConsumer$$anon$1 scala.Tuple3 ), $anonfun$seek$1$adapted(org.apache.kafka.common.TopicPartition long org.apache.kafka.clients.consumer.Consumer ), $anonfun$seekToBeginning$1$adapted(java.lang.Object cats.Foldable org.apache.kafka.clients.consumer.Consumer ), $anonfun$seekToEnd$1$adapted(java.lang.Object cats.Foldable org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionsFor$1(java.lang.String org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionsFor$2(java.lang.String scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$position$1$adapted(org.apache.kafka.common.TopicPartition org.apache.kafka.clients.consumer.Consumer ), $anonfun$position$2$adapted(org.apache.kafka.common.TopicPartition scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$subscribe$1(java.lang.Object cats.Reducible scala.Function1 ), $anonfun$subscribe$2(scala.util.matching.Regex scala.Function1 ), $anonfun$unsubscribe$1(scala.Function1 ), $anonfun$assign$1(java.lang.Object scala.Function1 ), $anonfun$assign$2$adapted(java.lang.String java.lang.Object ), $anonfun$assign$3(scala.collection.immutable.List ), $anonfun$assign$5(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String scala.Option ), $anonfun$beginningOffsets$1(scala.collection.immutable.Set org.apache.kafka.clients.consumer.Consumer ), $anonfun$beginningOffsets$2(scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$endOffsets$1(scala.collection.immutable.Set org.apache.kafka.clients.consumer.Consumer ), $anonfun$endOffsets$2(scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$metrics$1(org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionsMapStream$8(java.lang.Object ), $anonfun$partitionsMapStream$5(cats.effect.concurrent.Deferred scala.Tuple2 ), $anonfun$partitionsMapStream$6(cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$7(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.TryableDeferred fs2.concurrent.Queue scala.util.Either ), $anonfun$partitionsMapStream$10(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition int java.lang.Object cats.effect.concurrent.TryableDeferred fs2.concurrent.Queue cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$9(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition int java.lang.Object cats.effect.concurrent.TryableDeferred fs2.concurrent.Queue scala.Option ), $anonfun$partitionsMapStream$11$adapted(fs2.Chunk ), $anonfun$partitionsMapStream$4$adapted(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition int java.lang.Object fs2.concurrent.Queue cats.effect.concurrent.Deferred cats.effect.concurrent.TryableDeferred ), $anonfun$partitionsMapStream$2(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$3(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition int fs2.concurrent.Queue scala.Tuple2 ), $anonfun$partitionsMapStream$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object org.apache.kafka.common.TopicPartition int fs2.concurrent.Queue ), $anonfun$partitionsMapStream$13$adapted(org.apache.kafka.common.TopicPartition java.lang.Object ), $anonfun$partitionsMapStream$16(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.NoneTerminatedQueue scala.collection.immutable.Map scala.Option ), $anonfun$partitionsMapStream$12(fs2.kafka.KafkaConsumer$$anon$1 int java.lang.Object java.lang.Object org.apache.kafka.common.TopicPartition ), $anonfun$partitionsMapStream$14(scala.collection.immutable.Vector ), $anonfun$partitionsMapStream$15(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.NoneTerminatedQueue scala.collection.immutable.Map ), $anonfun$partitionsMapStream$20$adapted(scala.runtime.BoxedUnit ), $anonfun$partitionsMapStream$19(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$18(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$22(fs2.kafka.KafkaConsumer$$anon$1 int scala.collection.immutable.SortedSet fs2.concurrent.NoneTerminatedQueue java.lang.Object cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$17(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref scala.collection.immutable.SortedSet ), $anonfun$partitionsMapStream$21(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref int fs2.concurrent.NoneTerminatedQueue java.lang.Object scala.collection.immutable.SortedSet ), $anonfun$partitionsMapStream$24(cats.effect.concurrent.Deferred scala.util.Either ), $anonfun$partitionsMapStream$25(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$26(scala.util.Either ), $anonfun$partitionsMapStream$23(fs2.kafka.KafkaConsumer$$anon$1 int cats.effect.concurrent.Ref fs2.concurrent.NoneTerminatedQueue java.lang.Object cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$30$adapted(scala.runtime.BoxedUnit ), $anonfun$partitionsMapStream$28(cats.effect.concurrent.Deferred scala.collection.immutable.SortedSet ), $anonfun$partitionsMapStream$29(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.NoneTerminatedQueue java.lang.Object scala.Tuple2 ), $anonfun$partitionsMapStream$27(fs2.kafka.KafkaConsumer$$anon$1 int cats.effect.concurrent.Ref fs2.concurrent.NoneTerminatedQueue java.lang.Object cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$38(fs2.concurrent.NoneTerminatedQueue ), $anonfun$partitionsMapStream$39(scala.collection.immutable.Map ), $anonfun$partitionsMapStream$37$adapted(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.NoneTerminatedQueue scala.runtime.BoxedUnit ), $anonfun$partitionsMapStream$36$adapted(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.NoneTerminatedQueue java.lang.Object cats.effect.concurrent.Ref ), $anonfun$partitionsMapStream$35$adapted(fs2.kafka.KafkaConsumer$$anon$1 int fs2.concurrent.NoneTerminatedQueue java.lang.Object cats.effect.concurrent.Deferred ), $anonfun$partitionsMapStream$33$adapted(java.lang.Object ), $anonfun$partitionsMapStream$34$adapted(fs2.kafka.KafkaConsumer$$anon$1 fs2.concurrent.NoneTerminatedQueue java.lang.Object java.lang.Object ), $anonfun$partitionsMapStream$32$adapted(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object fs2.concurrent.NoneTerminatedQueue ), $anonfun$partitionedStream$2$adapted(scala.Tuple2 ), $anonfun$request$2(cats.effect.concurrent.Deferred scala.util.Either ), $anonfun$request$3(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Deferred ), $anonfun$assignmentStream$3(scala.collection.immutable.SortedSet scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$4(fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref scala.collection.immutable.SortedSet fs2.concurrent.Queue ), $anonfun$assignmentStream$7(scala.collection.immutable.SortedSet scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$8(fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$6(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref scala.collection.immutable.SortedSet fs2.concurrent.Queue ), $anonfun$assignmentStream$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.concurrent.Ref fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$5(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.concurrent.Ref fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$11(fs2.concurrent.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$12(cats.effect.concurrent.Deferred ), $anonfun$assignmentStream$10(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.concurrent.Ref fs2.concurrent.Queue cats.effect.concurrent.Deferred scala.collection.immutable.SortedSet ), $anonfun$assign$4$adapted(org.apache.kafka.common.PartitionInfo ), $anonfun$assign$6(fs2.kafka.KafkaConsumer$$anon$1 ), $anonfun$assign$7(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String java.lang.Object ), $anonfun$assign$8$adapted(scala.runtime.BoxedUnit ), $anonfun$fiber$1(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.ExitCase ), $anonfun$fiber$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.ExitCase )}, serializedLambda);
            }
        };
    }

    public <F, K, V> Resource<F, KafkaConsumer<F, K, V>> consumerResource(ConsumerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context, Timer<F> timer) {
        return this.resource(settings, F, context, timer);
    }

    public <F, K, V> Resource<F, KafkaConsumer<F, K, V>> resource(ConsumerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context, Timer<F> timer) {
        return Resource$.MODULE$.eval(settings.keyDeserializer(), F).flatMap((Function1 & Serializable & scala.Serializable)keyDeserializer -> Resource$.MODULE$.eval(settings.valueDeserializer(), (Applicative)F).flatMap((Function1 & Serializable & scala.Serializable)valueDeserializer -> Resource$.MODULE$.eval(F.delay((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new Object().hashCode()), (Applicative)F).flatMap((Function1 & Serializable & scala.Serializable)id -> KafkaConsumer$.$anonfun$resource$4(F, settings, context, keyDeserializer, valueDeserializer, timer, BoxesRunTime.unboxToInt((Object)id)))));
    }

    public <F> ConcurrentEffect<F> resource(ConcurrentEffect<F> F) {
        return F;
    }

    public <F, K, V> FreeC<F, KafkaConsumer<F, K, V>, BoxedUnit> stream(ConsumerSettings<F, K, V> settings, ConcurrentEffect<F> F, ContextShift<F> context, Timer<F> timer) {
        return Stream$.MODULE$.resource(this.resource(settings, F, context, timer));
    }

    public <F> ConcurrentEffect<F> stream(ConcurrentEffect<F> F) {
        return F;
    }

    public static final /* synthetic */ Resource $anonfun$resource$4(ConcurrentEffect F$3, ConsumerSettings settings$2, ContextShift context$2, Deserializer keyDeserializer$1, Deserializer valueDeserializer$1, Timer timer$2, int id) {
        return Resource$.MODULE$.eval(Jitter$.MODULE$.default(F$3), (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)jitter -> Resource$.MODULE$.eval(Logging$.MODULE$.default(id, F$3), (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)logging -> Resource$.MODULE$.eval(Queue$.MODULE$.unbounded((Concurrent)F$3), (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)requests -> Resource$.MODULE$.eval(Queue$.MODULE$.bounded(1, (Concurrent)F$3), (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)polls -> Resource$.MODULE$.eval(Ref$.MODULE$.of(KafkaConsumerActor$State$.MODULE$.empty(), (Sync)F$3), (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)ref -> Resource$.MODULE$.eval(Ref$.MODULE$.of((Object)BoxesRunTime.boxToInteger((int)0), (Sync)F$3), (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)streamId -> Resource$.MODULE$.eval(Deferred$.MODULE$.tryable((Concurrent)F$3), (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)stopConsumingDeferred -> WithConsumer$.MODULE$.apply(settings$2, F$3, context$2).map((Function1 & Serializable & scala.Serializable)withConsumer -> {
            Jitter jitter0 = jitter;
            Logging logging0 = logging;
            KafkaConsumerActor actor = new KafkaConsumerActor(settings$2, keyDeserializer$1, valueDeserializer$1, ref, requests, withConsumer, F$3, context$2, logging0, jitter0, timer$2);
            return new Tuple2(withConsumer, actor);
        }, (Applicative)F$3).flatMap((Function1 & Serializable & scala.Serializable)x$24 -> {
            Tuple2 tuple2 = x$24;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            WithConsumer withConsumer = (WithConsumer)tuple2._1();
            KafkaConsumerActor actor2 = (KafkaConsumerActor)tuple2._2();
            Resource resource = MODULE$.startConsumerActor((Queue)requests, (Queue)polls, actor2, (Concurrent)F$3, (ContextShift)context$2).flatMap((Function1 & Serializable & scala.Serializable)actor -> MODULE$.startPollScheduler((Queue)polls, settings$2.pollInterval(), (Concurrent)F$3, (Timer)timer$2).map((Function1 & Serializable & scala.Serializable)polls -> MODULE$.createKafkaConsumer((Queue)requests, settings$2, (Fiber)actor, (Fiber)polls, (Ref)streamId, id, withConsumer, (TryableDeferred)stopConsumingDeferred, (Concurrent)F$3), (Applicative)F$3));
            return resource;
        }))))))));
    }

    private KafkaConsumer$() {
        MODULE$ = this;
    }
}

