/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Semigroupal;
import cats.effect.kernel.Async;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.syntax.MonadCancelOps$;
import cats.effect.package$;
import cats.effect.syntax.package;
import cats.syntax.FlattenOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.kafka.CommittableOffsetBatch;
import fs2.kafka.CommittableOffsetBatch$;
import fs2.kafka.ConsumerGroupException$;
import fs2.kafka.KafkaProducer$;
import fs2.kafka.ProducerRecord;
import fs2.kafka.ProducerRecords;
import fs2.kafka.ProducerResult$;
import fs2.kafka.Serializer;
import fs2.kafka.TransactionalKafkaProducer;
import fs2.kafka.TransactionalKafkaProducer$TransactionalProducerPartiallyApplied$;
import fs2.kafka.TransactionalProducerRecords;
import fs2.kafka.TransactionalProducerSettings;
import fs2.kafka.internal.Blocking;
import fs2.kafka.internal.WithTransactionalProducer;
import fs2.kafka.internal.WithTransactionalProducer$;
import fs2.kafka.internal.converters$;
import fs2.kafka.producer.MkProducer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import org.apache.kafka.clients.producer.Producer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class TransactionalKafkaProducer$ {
    public static TransactionalKafkaProducer$ MODULE$;

    static {
        new TransactionalKafkaProducer$();
    }

    public <F, K, V> Resource<F, TransactionalKafkaProducer.WithoutOffsets<F, K, V>> resource(TransactionalProducerSettings<F, K, V> settings, Async<F> F, MkProducer<F> mk) {
        return (Resource)package.all$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3((Object)package$.MODULE$.Resource().eval(settings.producerSettings().keySerializer()), (Object)package$.MODULE$.Resource().eval(settings.producerSettings().valueSerializer()), WithTransactionalProducer$.MODULE$.apply(mk, settings, F))).mapN((Function3 & Serializable & scala.Serializable)(keySerializer, valueSerializer, withProducer) -> new TransactionalKafkaProducer.WithoutOffsets<F, K, V>(F, (WithTransactionalProducer)withProducer, (Serializer)keySerializer, (Serializer)valueSerializer){
            private final Async F$1;
            private final WithTransactionalProducer withProducer$1;
            private final Serializer keySerializer$1;
            private final Serializer valueSerializer$1;

            public <P> F produce(TransactionalProducerRecords<F, P, K, V> records) {
                return (F)package.all$.MODULE$.toFunctorOps(this.produceTransactionWithOffsets(records), (Functor)this.F$1).map((Function1 & Serializable & scala.Serializable)x$1 -> ProducerResult$.MODULE$.apply(x$1, records.passthrough()));
            }

            private <P> F produceTransactionWithOffsets(TransactionalProducerRecords<F, P, K, V> records) {
                Object object;
                if (records.records().isEmpty()) {
                    object = this.F$1.pure((Object)Chunk$.MODULE$.empty());
                } else {
                    CommittableOffsetBatch<F> batch = CommittableOffsetBatch$.MODULE$.fromFoldableMap(records.records(), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.offset(), this.F$1, Chunk$.MODULE$.instance());
                    Object consumerGroupId = batch.consumerGroupIdsMissing() || batch.consumerGroupIds().size() != 1 ? this.F$1.raiseError((Object)((Object)ConsumerGroupException$.MODULE$.apply(batch.consumerGroupIds()))) : this.F$1.pure(batch.consumerGroupIds().head());
                    object = package.all$.MODULE$.toFlatMapOps(consumerGroupId, (FlatMap)this.F$1).flatMap((Function1 & Serializable & scala.Serializable)groupId -> {
                        Function2 & Serializable & scala.Serializable sendOffsets = (Function2 & Serializable & scala.Serializable)(producer, blocking) -> blocking.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> producer.sendOffsetsToTransaction((Map)converters$.MODULE$.collection().mapAsJavaMapConverter(batch.offsets()).asJava(), groupId));
                        return this.produceTransaction((Chunk<ProducerRecord<K, V>>)records.records().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.records()), (Option<Function2<Producer<byte[], byte[]>, Blocking<F>, F>>)new Some((Object)sendOffsets));
                    });
                }
                return (F)object;
            }

            public <P> F produceWithoutOffsets(ProducerRecords<P, K, V> records) {
                return (F)package.all$.MODULE$.toFunctorOps(this.produceTransaction(records.records(), (Option<Function2<Producer<byte[], byte[]>, Blocking<F>, F>>)None$.MODULE$), (Functor)this.F$1).map((Function1 & Serializable & scala.Serializable)x$4 -> ProducerResult$.MODULE$.apply(x$4, records.passthrough()));
            }

            private <P> F produceTransaction(Chunk<ProducerRecord<K, V>> records, Option<Function2<Producer<byte[], byte[]>, Blocking<F>, F>> sendOffsets) {
                return (F)(records.isEmpty() ? this.F$1.pure((Object)Chunk$.MODULE$.empty()) : FlattenOps$.MODULE$.flatten$extension(package.all$.MODULE$.catsSyntaxFlatten(this.withProducer$1.exclusiveAccess((Function2 & Serializable & scala.Serializable)(producer, blocking) -> MonadCancelOps$.MODULE$.bracketCase$extension(package.all$.MODULE$.monadCancelOps(blocking.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> producer.beginTransaction()), (MonadCancel)$this.F$1), (Function1 & Serializable & scala.Serializable)x$5 -> {
                    Object produce = package.all$.MODULE$.toFunctorOps(records.traverse(KafkaProducer$.MODULE$.produceRecord($this.keySerializer$1, $this.valueSerializer$1, (Producer<byte[], byte[]>)producer, blocking, $this.F$1), (Applicative)$this.F$1), (Functor)$this.F$1).map((Function1 & Serializable & scala.Serializable)x$6 -> package.all$.MODULE$.toTraverseOps(x$6, Chunk$.MODULE$.instance()).sequence(Predef$.MODULE$.$conforms(), (Applicative)$this.F$1));
                    return sendOffsets.fold((Function0 & Serializable & scala.Serializable)() -> produce, (Function1 & Serializable & scala.Serializable)f -> package.all$.MODULE$.toFlatMapOps(produce, (FlatMap)$this.F$1).flatTap((Function1 & Serializable & scala.Serializable)x$7 -> f.apply(producer, blocking)));
                }, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                    Outcome outcome;
                    boolean bl;
                    F f;
                    Outcome outcome2;
                    Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                    if (tuple2 != null && (outcome2 = (Outcome)tuple2._2()) instanceof Outcome.Succeeded) {
                        f = blocking.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> producer.commitTransaction());
                    } else if (tuple2 != null && (bl = (outcome = (Outcome)tuple2._2()) instanceof Outcome.Canceled ? true : outcome instanceof Outcome.Errored)) {
                        f = blocking.apply((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> producer.abortTransaction());
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    return f;
                }, (MonadCancel)$this.F$1)), (FlatMap)this.F$1), (FlatMap)this.F$1));
            }

            public F metrics() {
                return this.withProducer$1.blocking((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)converters$.MODULE$.collection().mapAsScalaMapConverter(x$8.metrics()).asScala()).toMap(Predef$.MODULE$.$conforms()));
            }

            public String toString() {
                return new StringBuilder(27).append("TransactionalKafkaProducer$").append(System.identityHashCode(this)).toString();
            }
            {
                this.F$1 = F$1;
                this.withProducer$1 = withProducer$1;
                this.keySerializer$1 = keySerializer$1;
                this.valueSerializer$1 = valueSerializer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$produce$1(fs2.kafka.TransactionalProducerRecords fs2.Chunk ), $anonfun$produceTransactionWithOffsets$1(fs2.kafka.CommittableProducerRecords ), $anonfun$produceTransactionWithOffsets$2(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.kafka.CommittableOffsetBatch fs2.kafka.TransactionalProducerRecords java.lang.String ), $anonfun$produceWithoutOffsets$1(fs2.kafka.ProducerRecords fs2.Chunk ), $anonfun$produceTransaction$1(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk scala.Option org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking ), $anonfun$metrics$1(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransactionWithOffsets$4(org.apache.kafka.clients.producer.Producer fs2.kafka.CommittableOffsetBatch java.lang.String ), $anonfun$produceTransactionWithOffsets$3(fs2.kafka.CommittableOffsetBatch java.lang.String org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking ), $anonfun$produceTransactionWithOffsets$5(fs2.kafka.CommittableProducerRecords ), $anonfun$produceTransaction$7(scala.Function2 org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking java.lang.Object ), $anonfun$produceTransaction$4(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk ), $anonfun$produceTransaction$5(java.lang.Object ), $anonfun$produceTransaction$6(fs2.kafka.TransactionalKafkaProducer$$anon$1 java.lang.Object org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking scala.Function2 ), $anonfun$produceTransaction$9(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$10(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$2(org.apache.kafka.clients.producer.Producer ), $anonfun$produceTransaction$3(fs2.kafka.TransactionalKafkaProducer$$anon$1 fs2.Chunk org.apache.kafka.clients.producer.Producer fs2.kafka.internal.Blocking scala.Option scala.runtime.BoxedUnit ), $anonfun$produceTransaction$8(fs2.kafka.internal.Blocking org.apache.kafka.clients.producer.Producer scala.runtime.BoxedUnit cats.effect.kernel.Outcome )}, serializedLambda);
            }
        }, (Functor)Resource$.MODULE$.catsEffectAsyncForResource(F), (Semigroupal)Resource$.MODULE$.catsEffectAsyncForResource(F));
    }

    public <F, K, V> Stream<F, TransactionalKafkaProducer.WithoutOffsets<F, K, V>> stream(TransactionalProducerSettings<F, K, V> settings, Async<F> F, MkProducer<F> mk) {
        return Stream$.MODULE$.resource(this.resource(settings, F, mk), F);
    }

    public <F> boolean apply() {
        return TransactionalKafkaProducer$TransactionalProducerPartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    private <F> MkProducer<F> mkAmbig1() {
        throw new AssertionError((Object)"should not be used");
    }

    private <F> MkProducer<F> mkAmbig2() {
        throw new AssertionError((Object)"should not be used");
    }

    private TransactionalKafkaProducer$() {
        MODULE$ = this;
    }
}

