/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Apply;
import cats.Show;
import cats.Show$;
import cats.implicits$;
import fs2.kafka.ConsumerRecord;
import fs2.kafka.Deserializer;
import fs2.kafka.Headers;
import fs2.kafka.Headers$;
import fs2.kafka.Timestamp;
import fs2.kafka.Timestamp$;
import fs2.kafka.internal.syntax$;
import fs2.kafka.internal.syntax$KafkaHeadersSyntax$;
import java.io.Serializable;
import org.apache.kafka.common.record.TimestampType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConsumerRecord$ {
    public static final ConsumerRecord$ MODULE$ = new ConsumerRecord$();

    public <K, V> ConsumerRecord<K, V> apply(String topic, int partition, long offset, K key, V value) {
        return new ConsumerRecord.ConsumerRecordImpl<K, V>(topic, partition, offset, key, value, Headers$.MODULE$.empty(), Timestamp$.MODULE$.none(), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    private <F, K, V> F deserializeFromBytes(org.apache.kafka.clients.consumer.ConsumerRecord<byte[], byte[]> record, Headers headers, Deserializer<F, K> keyDeserializer, Deserializer<F, V> valueDeserializer, Apply<F> F) {
        F key = keyDeserializer.deserialize(record.topic(), headers, (byte[])record.key());
        F value = valueDeserializer.deserialize(record.topic(), headers, (byte[])record.value());
        return (F)implicits$.MODULE$.catsSyntaxSemigroupal(key, F).product(value);
    }

    public <F, K, V> F fromJava(org.apache.kafka.clients.consumer.ConsumerRecord<byte[], byte[]> record, Deserializer<F, K> keyDeserializer, Deserializer<F, V> valueDeserializer, Apply<F> F) {
        Headers headers = syntax$KafkaHeadersSyntax$.MODULE$.asScala$extension(syntax$.MODULE$.KafkaHeadersSyntax(record.headers()));
        return (F)implicits$.MODULE$.toFunctorOps(this.deserializeFromBytes(record, headers, keyDeserializer, valueDeserializer, F), F).map((Function1 & Serializable)x0$1 -> {
            Timestamp timestamp;
            long l;
            int n;
            String string;
            Object value;
            Object key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                key = tuple2._1();
                value = tuple2._2();
                string = record.topic();
                n = record.partition();
                l = record.offset();
                if (record.timestamp() != -1L) {
                    TimestampType timestampType = record.timestampType();
                    Timestamp timestamp2 = TimestampType.CREATE_TIME.equals(timestampType) ? Timestamp$.MODULE$.createTime(record.timestamp()) : (TimestampType.LOG_APPEND_TIME.equals(timestampType) ? Timestamp$.MODULE$.logAppendTime(record.timestamp()) : Timestamp$.MODULE$.unknownTime(record.timestamp()));
                    timestamp = timestamp2;
                } else {
                    timestamp = Timestamp$.MODULE$.none();
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            ConsumerRecord.ConsumerRecordImpl<Object, Object> consumerRecordImpl = new ConsumerRecord.ConsumerRecordImpl<Object, Object>(string, n, l, key, value, headers, timestamp, (Option<Object>)(record.serializedKeySize() != -1 ? new Some((Object)BoxesRunTime.boxToInteger((int)record.serializedKeySize())) : None$.MODULE$), (Option<Object>)(record.serializedValueSize() != -1 ? new Some((Object)BoxesRunTime.boxToInteger((int)record.serializedValueSize())) : None$.MODULE$), (Option<Object>)(record.leaderEpoch().isPresent() ? new Some((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)record.leaderEpoch().get()))) : None$.MODULE$));
            return consumerRecordImpl;
        });
    }

    public <K, V> Show<ConsumerRecord<K, V>> consumerRecordShow(Show<K> K, Show<V> V) {
        return Show$.MODULE$.show((Function1 & Serializable)record -> {
            StringBuilder b = new StringBuilder("ConsumerRecord(");
            b.append("topic = ").append(record.topic());
            b.append(", partition = ").append(record.partition());
            b.append(", offset = ").append(record.offset());
            b.append(", key = ").append(implicits$.MODULE$.toShow(record.key(), K).show());
            b.append(", value = ").append(implicits$.MODULE$.toShow(record.value(), V).show());
            Object object = record.headers().nonEmpty() ? b.append(", headers = ").append(record.headers()) : BoxedUnit.UNIT;
            Object object2 = record.timestamp().nonEmpty() ? b.append(", timestamp = ").append(record.timestamp()) : BoxedUnit.UNIT;
            Object object3 = record.serializedKeySize().nonEmpty() ? b.append(", serializedKeySize = ").append(BoxesRunTime.unboxToInt((Object)record.serializedKeySize().get())) : BoxedUnit.UNIT;
            Object object4 = record.serializedValueSize().nonEmpty() ? b.append(", serializedValueSize = ").append(BoxesRunTime.unboxToInt((Object)record.serializedValueSize().get())) : BoxedUnit.UNIT;
            Object object5 = record.leaderEpoch().nonEmpty() ? b.append(", leaderEpoch = ").append(BoxesRunTime.unboxToInt((Object)record.leaderEpoch().get())) : BoxedUnit.UNIT;
            return b.append(")").toString();
        });
    }

    private ConsumerRecord$() {
    }
}

