/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant;
import cats.MonadError;
import cats.Reducible;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.data.NonEmptySetImpl$;
import cats.data.OptionT;
import cats.effect.implicits$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.GenSpawn;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.syntax.GenSpawnOps$;
import cats.effect.kernel.syntax.GenTemporalOps_$;
import cats.effect.package$;
import cats.effect.std.Dispatcher;
import cats.effect.std.Dispatcher$;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.effect.std.QueueSink;
import cats.effect.std.QueueSource;
import cats.kernel.Eq;
import cats.kernel.Eq$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.MonadErrorRethrowOps$;
import cats.syntax.package;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.ConsumerSettings;
import fs2.kafka.ConsumerShutdownException$;
import fs2.kafka.GenericDeserializer;
import fs2.kafka.Jitter;
import fs2.kafka.Jitter$;
import fs2.kafka.KafkaConsumer;
import fs2.kafka.KafkaConsumer$;
import fs2.kafka.KafkaConsumer$ConsumerPartiallyApplied$;
import fs2.kafka.NotSubscribedException$;
import fs2.kafka.consumer.MkConsumer;
import fs2.kafka.instances$;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.KafkaConsumerActor$Request$;
import fs2.kafka.internal.KafkaConsumerActor$State$;
import fs2.kafka.internal.LogEntry;
import fs2.kafka.internal.Logging;
import fs2.kafka.internal.Logging$;
import fs2.kafka.internal.WithConsumer;
import fs2.kafka.internal.WithConsumer$;
import fs2.kafka.internal.converters$;
import fs2.kafka.internal.syntax$;
import fs2.kafka.internal.syntax$FiniteDurationSyntax$;
import fs2.kafka.internal.syntax$FoldableSyntax$;
import fs2.kafka.internal.syntax$JavaUtilCollectionSyntax$;
import fs2.kafka.internal.syntax$JavaUtilMapSyntax$;
import fs2.kafka.internal.syntax$LoggingSyntax$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;

public final class KafkaConsumer$ {
    public static final KafkaConsumer$ MODULE$ = new KafkaConsumer$();

    private <F, K, V> F runConsumerActor(QueueSource<F, KafkaConsumerActor.Request<F, K, V>> requests, QueueSource<F, KafkaConsumerActor.Request.Poll<F>> polls, KafkaConsumerActor<F, K, V> actor, Async<F> F) {
        return (F)FlatMapOps$.MODULE$.foreverM$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFlatMapOps(new OptionT(requests.tryTake()).getOrElseF((Function0 & Serializable)() -> package.all$.MODULE$.toFunctorOps(polls.take(), (Functor)F).widen(), F), F).flatMap((Function1 & Serializable)request -> actor.handle((KafkaConsumerActor.Request)request)), F), F);
    }

    private <F, K, V> F runPollScheduler(QueueSink<F, KafkaConsumerActor.Request.Poll<F>> polls, FiniteDuration pollInterval, GenTemporal<F, Throwable> F) {
        return (F)FlatMapOps$.MODULE$.foreverM$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(GenTemporalOps_$.MODULE$.andWait$extension(implicits$.MODULE$.genTemporalOps_(polls.offer(KafkaConsumerActor$Request$.MODULE$.poll())), pollInterval, F), F), F);
    }

    private <F, K, V> Resource<F, Fiber<F, Throwable, BoxedUnit>> startBackgroundConsumer(QueueSource<F, KafkaConsumerActor.Request<F, K, V>> requests, Queue<F, KafkaConsumerActor.Request.Poll<F>> polls, KafkaConsumerActor<F, K, V> actor, FiniteDuration pollInterval, Async<F> F) {
        return package$.MODULE$.Resource().make(GenSpawnOps$.MODULE$.start$extension(implicits$.MODULE$.genSpawnOps(package.all$.MODULE$.toFunctorOps(F.race(this.runConsumerActor(requests, (QueueSource<F, KafkaConsumerActor.Request.Poll<F>>)polls, actor, F), this.runPollScheduler((QueueSink<F, KafkaConsumerActor.Request.Poll<F>>)polls, pollInterval, (GenTemporal<F, Throwable>)F)), F).void(), F), F), (Function1 & Serializable)x$1 -> package.all$.MODULE$.toFunctorOps(GenSpawnOps$.MODULE$.start$extension(implicits$.MODULE$.genSpawnOps(x$1.cancel(), (GenSpawn)F), (GenSpawn)F), (Functor)F).void(), F);
    }

    private <F, K, V> KafkaConsumer<F, K, V> createKafkaConsumer(QueueSink<F, KafkaConsumerActor.Request<F, K, V>> requests, KafkaConsumerActor<F, K, V> actor, Fiber<F, Throwable, BoxedUnit> fiber, int id, WithConsumer<F> withConsumer, Deferred<F, BoxedUnit> stopConsumingDeferred, Async<F> F, Logging<F> logging) {
        return new KafkaConsumer<F, K, V>(actor, F, stopConsumingDeferred, requests, logging, withConsumer, id, fiber){
            private final KafkaConsumerActor actor$2;
            private final Async F$3;
            private final Deferred stopConsumingDeferred$1;
            private final QueueSink requests$1;
            private final Logging logging$1;
            private final WithConsumer withConsumer$1;
            private final int id$1;
            private final Fiber fiber$1;

            public Stream<F, scala.collection.immutable.Map<TopicPartition, Stream<F, CommittableConsumerRecord<F, K, V>>>> partitionsMapStream() {
                return Stream$.MODULE$.eval(this.stopConsumingDeferred$1.tryGet()).flatMap((Function1 & Serializable)x0$1 -> {
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        return Stream$.MODULE$.eval(Queue$.MODULE$.unbounded((GenConcurrent)$this.F$3)).flatMap((Function1 & Serializable)partitionsMapQueue -> Stream$.MODULE$.eval(this.initialEnqueue$1((Queue)partitionsMapQueue)).flatMap((Function1 & Serializable)x$4 -> {
                            BoxedUnit boxedUnit = x$4;
                            return Stream$.MODULE$.fromQueueNoneTerminated((QueueSource)partitionsMapQueue, Stream$.MODULE$.fromQueueNoneTerminated$default$2(), (Functor)$this.F$3).interruptWhen(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(this.awaitTermination(), (ApplicativeError)$this.F$3), (ApplicativeError)$this.F$3)).concurrently(Stream$.MODULE$.eval(FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.stopConsumingDeferred$1.get(), (FlatMap)$this.F$3), (Function0 & Serializable)() -> partitionsMapQueue.offer((Object)None$.MODULE$), (FlatMap)$this.F$3)), (GenConcurrent)$this.F$3);
                        }, NotGiven$.MODULE$.default()), NotGiven$.MODULE$.default());
                    }
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BoxedUnit boxedUnit = (BoxedUnit)some.value();
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit3 = boxedUnit;
                        if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) {
                            return Stream$.MODULE$.empty().covaryAll();
                        }
                    }
                    throw new MatchError((Object)option);
                }, NotGiven$.MODULE$.default());
            }

            public Stream<F, Stream<F, CommittableConsumerRecord<F, K, V>>> partitionedStream() {
                return this.partitionsMapStream().flatMap((Function1 & Serializable)partitionsMap -> Stream$.MODULE$.iterable(partitionsMap.values()), NotGiven$.MODULE$.default());
            }

            public Stream<F, CommittableConsumerRecord<F, K, V>> stream() {
                return Stream.NestedStreamOps$.MODULE$.parJoinUnbounded$extension(Stream$.MODULE$.NestedStreamOps(this.partitionedStream()), (GenConcurrent)this.F$3);
            }

            public F commitAsync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
                return this.actor$2.offsetCommitAsync(offsets);
            }

            public F commitSync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
                return this.request((Function1 & Serializable)callback -> {
                    Function1 x$1 = callback;
                    scala.collection.immutable.Map x$2 = offsets;
                    return new KafkaConsumerActor.Request.ManualCommitSync<F>((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)x$2, x$1);
                });
            }

            private <A> F request(Function1<Function1<Either<Throwable, A>, F>, KafkaConsumerActor.Request<F, K, V>> request) {
                return (F)MonadErrorRethrowOps$.MODULE$.rethrow$extension(package.all$.MODULE$.catsSyntaxMonadErrorRethrow(package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Deferred().apply((GenConcurrent)this.F$3), (FlatMap)this.F$3).flatMap((Function1 & Serializable)deferred -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.requests$1.offer(request.apply((Function1 & Serializable)x$5 -> package.all$.MODULE$.toFunctorOps(deferred.complete(x$5), (Functor)$this.F$3).void())), (FlatMap)$this.F$3), (Function0 & Serializable)() -> $this.F$3.race(package.all$.MODULE$.toFunctorOps(this.awaitTermination(), (Functor)$this.F$3).as((Object)((Object)ConsumerShutdownException$.MODULE$.apply())), MonadErrorRethrowOps$.MODULE$.rethrow$extension(package.all$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)$this.F$3), (MonadError)$this.F$3)), (FlatMap)$this.F$3)), (MonadError)this.F$3), (MonadError)this.F$3);
            }

            public F assignment() {
                return this.assignment(Option$.MODULE$.empty());
            }

            private F assignment(Option<KafkaConsumerActor.OnRebalance<F>> onRebalance) {
                return (F)this.withPermit(FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(MonadErrorOps$.MODULE$.ensure$extension(package.all$.MODULE$.catsSyntaxMonadError(onRebalance.fold((Function0 & Serializable)() -> $this.actor$2.ref().updateAndGet((Function1 & Serializable)x$6 -> x$6.asStreaming()), (Function1 & Serializable)on -> $this.actor$2.ref().flatModify((Function1 & Serializable)state -> {
                    KafkaConsumerActor.State<F, K, V> newState = state.withOnRebalance(on).asStreaming();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(newState), package.all$.MODULE$.toFunctorOps($this.logging$1.log(new LogEntry.StoredOnRebalance<F>(on, newState)), (Functor)$this.F$3).as(newState));
                }, (MonadCancel)$this.F$3)), (MonadError)this.F$3), (Function0 & Serializable)() -> NotSubscribedException$.MODULE$.apply(), (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$assignment$6(x$7)), (MonadError)this.F$3), (FlatMap)this.F$3), (Function0 & Serializable)() -> $this.withConsumer$1.blocking((Function1 & Serializable)x$8 -> syntax$JavaUtilCollectionSyntax$.MODULE$.toSortedSet$extension(syntax$.MODULE$.JavaUtilCollectionSyntax(x$8.assignment()), instances$.MODULE$.fs2KafkaTopicPartitionOrdering())), (FlatMap)this.F$3));
            }

            public Stream<F, SortedSet<TopicPartition>> assignmentStream() {
                return Stream$.MODULE$.eval(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.catsSyntaxTuple3Semigroupal(new Tuple3(Queue$.MODULE$.unbounded((GenConcurrent)this.F$3), Ref.ApplyBuilders$.MODULE$.of$extension(package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)this.F$3)), SortedSet$.MODULE$.empty(instances$.MODULE$.fs2KafkaTopicPartitionOrdering())), package$.MODULE$.Deferred().apply((GenConcurrent)this.F$3))).tupled((Invariant)this.F$3, (Semigroupal)this.F$3), (FlatMap)this.F$3).flatMap((Function1 & Serializable)x0$1 -> {
                    Tuple3 tuple3 = x0$1;
                    if (tuple3 != null) {
                        Queue updateQueue = (Queue)tuple3._1();
                        Ref assignmentRef = (Ref)tuple3._2();
                        Deferred initialAssignmentDeferred = (Deferred)tuple3._3();
                        KafkaConsumerActor.OnRebalance onRebalance = this.onRebalanceWith$1(updateQueue, assignmentRef, initialAssignmentDeferred.get());
                        return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFlatMapOps(this.assignment((Option<KafkaConsumerActor.OnRebalance<F>>)new Some((Object)onRebalance)), (FlatMap)$this.F$3).flatMap((Function1 & Serializable)initialAssignment -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(assignmentRef.set(initialAssignment), (FlatMap)$this.F$3), (Function0 & Serializable)() -> updateQueue.offer(initialAssignment), (FlatMap)$this.F$3), (FlatMap)$this.F$3), (Function0 & Serializable)() -> initialAssignmentDeferred.complete((Object)BoxedUnit.UNIT), (FlatMap)$this.F$3)), (Functor)$this.F$3).as((Object)Stream$.MODULE$.fromQueueUnterminated((QueueSource)updateQueue, Stream$.MODULE$.fromQueueUnterminated$default$2(), (Functor)$this.F$3).changes((Eq)Eq$.MODULE$.catsKernelOrderForSortedSet(instances$.MODULE$.fs2KafkaTopicPartitionOrder())));
                    }
                    throw new MatchError((Object)tuple3);
                })).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            public F seek(TopicPartition partition, long offset) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$9 -> {
                    anon.1.$anonfun$seek$1(partition, offset, x$9);
                    return BoxedUnit.UNIT;
                });
            }

            public <G> F seekToBeginning(G partitions, Foldable<G> G) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$10 -> {
                    anon.1.$anonfun$seekToBeginning$1(partitions, G, x$10);
                    return BoxedUnit.UNIT;
                });
            }

            public <G> F seekToEnd(G partitions, Foldable<G> G) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$11 -> {
                    anon.1.$anonfun$seekToEnd$1(partitions, G, x$11);
                    return BoxedUnit.UNIT;
                });
            }

            public F partitionsFor(String topic) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$12 -> converters$.MODULE$.collection().ListHasAsScala(x$12.partitionsFor(topic)).asScala().toList());
            }

            public F partitionsFor(String topic, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$13 -> converters$.MODULE$.collection().ListHasAsScala(x$13.partitionsFor(topic, syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout)))).asScala().toList());
            }

            public F position(TopicPartition partition) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$position$1(partition, x$14)));
            }

            public F position(TopicPartition partition, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$15 -> BoxesRunTime.boxToLong((long)anon.1.$anonfun$position$2(partition, timeout, x$15)));
            }

            public F committed(scala.collection.immutable.Set<TopicPartition> partitions) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$16 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$16.committed(converters$.MODULE$.collection().SetHasAsJava((Set)partitions).asJava()))));
            }

            public F committed(scala.collection.immutable.Set<TopicPartition> partitions, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$17 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$17.committed(converters$.MODULE$.collection().SetHasAsJava((Set)partitions).asJava(), syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout))))));
            }

            public <G> F subscribe(G topics, Reducible<G> G) {
                return (F)this.withPermit(this.F$3.uncancelable((Function1 & Serializable)x$18 -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.withConsumer$1.blocking((Function1 & Serializable)x$19 -> {
                    anon.1.$anonfun$subscribe$2(this, topics, G, x$19);
                    return BoxedUnit.UNIT;
                }), (FlatMap)$this.F$3), (Function0 & Serializable)() -> syntax$LoggingSyntax$.MODULE$.log$extension(syntax$.MODULE$.LoggingSyntax($this.actor$2.ref().updateAndGet((Function1 & Serializable)x$20 -> x$20.asSubscribed())), (Function1 & Serializable)x$21 -> new LogEntry.SubscribedTopics<F>((NonEmptyList<String>)package.all$.MODULE$.toReducibleOps(topics, G).toNonEmptyList(), x$21), $this.F$3, $this.logging$1), (FlatMap)$this.F$3)));
            }

            private <A> F withPermit(F fa) {
                return (F)package.all$.MODULE$.toFlatMapOps(this.F$3.deferred(), (FlatMap)this.F$3).flatMap((Function1 & Serializable)deferred -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.requests$1.offer(new KafkaConsumerActor.Request.WithPermit<Object, A>(fa, (Function1 & Serializable)x$22 -> package.all$.MODULE$.toFunctorOps(deferred.complete(x$22), (Functor)$this.F$3).void())), (FlatMap)$this.F$3), (Function0 & Serializable)() -> MonadErrorRethrowOps$.MODULE$.rethrow$extension(package.all$.MODULE$.catsSyntaxMonadErrorRethrow(deferred.get(), (MonadError)$this.F$3), (MonadError)$this.F$3), (FlatMap)$this.F$3));
            }

            public F subscribe(Regex regex) {
                return (F)this.withPermit(this.F$3.uncancelable((Function1 & Serializable)x$23 -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.withConsumer$1.blocking((Function1 & Serializable)x$24 -> {
                    anon.1.$anonfun$subscribe$7(this, regex, x$24);
                    return BoxedUnit.UNIT;
                }), (FlatMap)$this.F$3), (Function0 & Serializable)() -> syntax$LoggingSyntax$.MODULE$.log$extension(syntax$.MODULE$.LoggingSyntax($this.actor$2.ref().updateAndGet((Function1 & Serializable)x$25 -> x$25.asSubscribed())), (Function1 & Serializable)x$26 -> new LogEntry.SubscribedPattern<F>(regex.pattern(), x$26), $this.F$3, $this.logging$1), (FlatMap)$this.F$3)));
            }

            public F unsubscribe() {
                return (F)this.withPermit(this.F$3.uncancelable((Function1 & Serializable)x$27 -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.withConsumer$1.blocking((Function1 & Serializable)x$28 -> {
                    anon.1.$anonfun$unsubscribe$2(x$28);
                    return BoxedUnit.UNIT;
                }), (FlatMap)$this.F$3), (Function0 & Serializable)() -> syntax$LoggingSyntax$.MODULE$.log$extension(syntax$.MODULE$.LoggingSyntax($this.actor$2.ref().updateAndGet((Function1 & Serializable)x$29 -> x$29.asUnsubscribed())), (Function1 & Serializable)x$30 -> new LogEntry.Unsubscribed<F>(x$30), $this.F$3, $this.logging$1), (FlatMap)$this.F$3)));
            }

            public F stopConsuming() {
                return (F)package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(this.stopConsumingDeferred$1.complete((Object)BoxedUnit.UNIT), (ApplicativeError)this.F$3), (ApplicativeError)this.F$3), (Functor)this.F$3).void();
            }

            public F assign(Object partitions) {
                return (F)this.withPermit(this.F$3.uncancelable((Function1 & Serializable)x$31 -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps($this.withConsumer$1.blocking((Function1 & Serializable)x$32 -> {
                    anon.1.$anonfun$assign$2(partitions, x$32);
                    return BoxedUnit.UNIT;
                }), (FlatMap)$this.F$3), (Function0 & Serializable)() -> syntax$LoggingSyntax$.MODULE$.log$extension(syntax$.MODULE$.LoggingSyntax($this.actor$2.ref().updateAndGet((Function1 & Serializable)x$33 -> x$33.asSubscribed())), (Function1 & Serializable)x$34 -> new LogEntry.ManuallyAssignedPartitions<F>(partitions, x$34), $this.F$3, $this.logging$1), (FlatMap)$this.F$3)));
            }

            public F assign(String topic) {
                return (F)package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFunctorOps(this.partitionsFor(topic), (Functor)this.F$3).map((Function1 & Serializable)partitionInfo -> cats.data.package$.MODULE$.NonEmptySet().fromSet((SortedSet)SortedSet$.MODULE$.apply((scala.collection.immutable.Seq)partitionInfo.map((Function1 & Serializable)x$35 -> BoxesRunTime.boxToInteger((int)anon.1.$anonfun$assign$7(x$35))), (Object)Ordering.Int$.MODULE$))), (FlatMap)this.F$3).flatMap((Function1 & Serializable)partitions -> partitions.fold((Function0 & Serializable)() -> $this.F$3.unit(), (Function1 & Serializable)x$36 -> this.assign(topic, x$36)));
            }

            public F beginningOffsets(scala.collection.immutable.Set<TopicPartition> partitions) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$38 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$38.beginningOffsets((Collection)converters$.MODULE$.collection().SetHasAsJava((Set)partitions).asJava()))));
            }

            public F beginningOffsets(scala.collection.immutable.Set<TopicPartition> partitions, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$39 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$39.beginningOffsets((Collection)converters$.MODULE$.collection().SetHasAsJava((Set)partitions).asJava(), syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout))))));
            }

            public F endOffsets(scala.collection.immutable.Set<TopicPartition> partitions) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$40 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$40.endOffsets((Collection)converters$.MODULE$.collection().SetHasAsJava((Set)partitions).asJava()))));
            }

            public F endOffsets(scala.collection.immutable.Set<TopicPartition> partitions, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$41 -> syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$41.endOffsets((Collection)converters$.MODULE$.collection().SetHasAsJava((Set)partitions).asJava(), syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout))))));
            }

            public F offsetsForTimes(scala.collection.immutable.Map<TopicPartition, Object> timestampsToSearch) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$42 -> syntax$JavaUtilMapSyntax$.MODULE$.toMapOptionValues$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$42.offsetsForTimes(converters$.MODULE$.collection().MapHasAsJava((Map)timestampsToSearch).asJava()))));
            }

            public F offsetsForTimes(scala.collection.immutable.Map<TopicPartition, Object> timestampsToSearch, FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$43 -> syntax$JavaUtilMapSyntax$.MODULE$.toMapOptionValues$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$43.offsetsForTimes(converters$.MODULE$.collection().MapHasAsJava((Map)timestampsToSearch).asJava(), syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout))))));
            }

            public F listTopics() {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$44 -> (scala.collection.immutable.Map)syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$44.listTopics())).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        List v = (List)tuple2._2();
                        return new Tuple2((Object)k, syntax$JavaUtilCollectionSyntax$.MODULE$.toList$extension(syntax$.MODULE$.JavaUtilCollectionSyntax(v)));
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }

            public F listTopics(FiniteDuration timeout) {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$45 -> (scala.collection.immutable.Map)syntax$JavaUtilMapSyntax$.MODULE$.toMap$extension(syntax$.MODULE$.JavaUtilMapSyntax(x$45.listTopics(syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout))))).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String k = (String)tuple2._1();
                        List v = (List)tuple2._2();
                        return new Tuple2((Object)k, syntax$JavaUtilCollectionSyntax$.MODULE$.toList$extension(syntax$.MODULE$.JavaUtilCollectionSyntax(v)));
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }

            public F metrics() {
                return this.withConsumer$1.blocking((Function1 & Serializable)x$46 -> converters$.MODULE$.collection().MapHasAsScala(x$46.metrics()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            public String toString() {
                return new StringBuilder(14).append("KafkaConsumer$").append(this.id$1).toString();
            }

            public F terminate() {
                return (F)package.all$.MODULE$.toFunctorOps(GenSpawnOps$.MODULE$.start$extension(implicits$.MODULE$.genSpawnOps(this.fiber$1.cancel(), (GenSpawn)this.F$3), (GenSpawn)this.F$3), (Functor)this.F$3).void();
            }

            public F awaitTermination() {
                return (F)this.fiber$1.joinWithUnit((MonadCancel)this.F$3, (.less.colon.less)$less$colon$less$.MODULE$.refl());
            }

            private final Stream partitionStream$1(TopicPartition partition) {
                return Stream$.MODULE$.force(package.all$.MODULE$.toFunctorOps(this.actor$2.getQueueAndStopSignalFor(partition), (Functor)this.F$3).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Queue chunksQueue = (Queue)tuple2._1();
                        Object partitionStop = tuple2._2();
                        Object stopStream = ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(package.all$.MODULE$.toFunctorOps($this.F$3.race(partitionStop, $this.F$3.race(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(this.awaitTermination(), (ApplicativeError)$this.F$3), (ApplicativeError)$this.F$3), $this.stopConsumingDeferred$1.get())), (Functor)$this.F$3).void(), (ApplicativeError)$this.F$3), (ApplicativeError)$this.F$3);
                        return Stream$.MODULE$.fromQueueUnterminated(chunksQueue, 1, (Functor)$this.F$3).unchunks((.less.colon.less)$less$colon$less$.MODULE$.refl()).interruptWhen(stopStream);
                    }
                    throw new MatchError((Object)tuple2);
                }));
            }

            private final Object enqueueAssignment$1(scala.collection.immutable.Set assigned, Queue partitionsMapQueue) {
                return package.all$.MODULE$.toFlatMapOps(this.stopConsumingDeferred$1.tryGet(), (FlatMap)this.F$3).flatMap((Function1 & Serializable)x0$1 -> {
                    Option option = x0$1;
                    if (None$.MODULE$.equals(option)) {
                        scala.collection.immutable.Map assignment = ((IterableOnceOps)assigned.view().map((Function1 & Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(partition), (Object)this.partitionStream$1((TopicPartition)partition)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                        return partitionsMapQueue.offer((Object)new Some((Object)assignment));
                    }
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        BoxedUnit boxedUnit = (BoxedUnit)some.value();
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        BoxedUnit boxedUnit3 = boxedUnit;
                        if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) {
                            return $this.F$3.unit();
                        }
                    }
                    throw new MatchError((Object)option);
                });
            }

            private final KafkaConsumerActor.OnRebalance onRebalance$1(Queue partitionsMapQueue) {
                Function1 & Serializable x$1 = (Function1 & Serializable)x$2 -> $this.F$3.unit();
                Function1 & Serializable x$22 = (Function1 & Serializable)assigned -> this.enqueueAssignment$1((scala.collection.immutable.Set)assigned, partitionsMapQueue);
                return new KafkaConsumerActor.OnRebalance<F>(x$22, x$1);
            }

            private final Object requestAssignment$1(Queue partitionsMapQueue) {
                F assignment = this.assignment((Option<KafkaConsumerActor.OnRebalance<F>>)new Some((Object)this.onRebalance$1(partitionsMapQueue)));
                return package.all$.MODULE$.toFlatMapOps(this.F$3.race(ApplicativeErrorOps$.MODULE$.attempt$extension(package.all$.MODULE$.catsSyntaxApplicativeError(this.awaitTermination(), (ApplicativeError)this.F$3), (ApplicativeError)this.F$3), assignment), (FlatMap)this.F$3).flatMap((Function1 & Serializable)x0$1 -> {
                    Either either = x0$1;
                    if (either instanceof Left) {
                        return $this.F$3.pure((Object)Predef$.MODULE$.Set().empty());
                    }
                    if (either instanceof Right) {
                        Right right = (Right)either;
                        SortedSet assigned = (SortedSet)right.value();
                        return $this.F$3.pure((Object)assigned);
                    }
                    throw new MatchError((Object)either);
                });
            }

            private final Object initialEnqueue$1(Queue partitionsMapQueue) {
                return package.all$.MODULE$.toFlatMapOps(this.requestAssignment$1(partitionsMapQueue), (FlatMap)this.F$3).flatMap((Function1 & Serializable)assigned -> this.enqueueAssignment$1((scala.collection.immutable.Set)assigned, partitionsMapQueue));
            }

            public static final /* synthetic */ boolean $anonfun$assignment$6(KafkaConsumerActor.State x$7) {
                return x$7.subscribed();
            }

            private final KafkaConsumerActor.OnRebalance onRebalanceWith$1(Queue updateQueue, Ref assignmentRef, Object initialAssignmentDone) {
                return new KafkaConsumerActor.OnRebalance<F>((Function1 & Serializable)assigned -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(initialAssignmentDone, (FlatMap)$this.F$3), (Function0 & Serializable)() -> assignmentRef.flatModify((Function1 & Serializable)oldAssignment -> {
                    SortedSet newAssignment = (SortedSet)oldAssignment.$plus$plus((IterableOnce)assigned);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newAssignment), updateQueue.offer((Object)newAssignment));
                }, (MonadCancel)$this.F$3), (FlatMap)$this.F$3), (Function1 & Serializable)revoked -> FlatMapOps$.MODULE$.$greater$greater$extension(package.all$.MODULE$.catsSyntaxFlatMapOps(initialAssignmentDone, (FlatMap)$this.F$3), (Function0 & Serializable)() -> assignmentRef.flatModify((Function1 & Serializable)oldAssignment -> {
                    SortedSet newAssignment = (SortedSet)oldAssignment.$minus$minus((IterableOnce)revoked);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newAssignment), updateQueue.offer((Object)newAssignment));
                }, (MonadCancel)$this.F$3), (FlatMap)$this.F$3));
            }

            public static final /* synthetic */ void $anonfun$seek$1(TopicPartition partition$1, long offset$1, Consumer x$9) {
                x$9.seek(partition$1, offset$1);
            }

            public static final /* synthetic */ void $anonfun$seekToBeginning$1(Object partitions$1, Foldable G$1, Consumer x$10) {
                x$10.seekToBeginning(syntax$FoldableSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FoldableSyntax(partitions$1), G$1));
            }

            public static final /* synthetic */ void $anonfun$seekToEnd$1(Object partitions$2, Foldable G$2, Consumer x$11) {
                x$11.seekToEnd(syntax$FoldableSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FoldableSyntax(partitions$2), G$2));
            }

            public static final /* synthetic */ long $anonfun$position$1(TopicPartition partition$2, Consumer x$14) {
                return x$14.position(partition$2);
            }

            public static final /* synthetic */ long $anonfun$position$2(TopicPartition partition$3, FiniteDuration timeout$2, Consumer x$15) {
                return x$15.position(partition$3, syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(timeout$2)));
            }

            public static final /* synthetic */ void $anonfun$subscribe$2(anon.1 $this, Object topics$1, Reducible G$3, Consumer x$19) {
                x$19.subscribe((Collection)converters$.MODULE$.collection().SeqHasAsJava((Seq)package.all$.MODULE$.toFoldableOps(topics$1, (Foldable)G$3).toList()).asJava(), $this.actor$2.consumerRebalanceListener());
            }

            public static final /* synthetic */ void $anonfun$subscribe$7(anon.1 $this, Regex regex$1, Consumer x$24) {
                x$24.subscribe(regex$1.pattern(), $this.actor$2.consumerRebalanceListener());
            }

            public static final /* synthetic */ void $anonfun$unsubscribe$2(Consumer x$28) {
                x$28.unsubscribe();
            }

            public static final /* synthetic */ void $anonfun$assign$2(Object partitions$5, Consumer x$32) {
                x$32.assign((Collection)converters$.MODULE$.collection().SeqHasAsJava((Seq)package.all$.MODULE$.toFoldableOps(partitions$5, (Foldable)NonEmptySetImpl$.MODULE$.catsDataInstancesForNonEmptySet()).toList()).asJava());
            }

            public static final /* synthetic */ int $anonfun$assign$7(PartitionInfo x$35) {
                return x$35.partition();
            }
            {
                this.actor$2 = actor$2;
                this.F$3 = F$3;
                this.stopConsumingDeferred$1 = stopConsumingDeferred$1;
                this.requests$1 = requests$1;
                this.logging$1 = logging$1;
                this.withConsumer$1 = withConsumer$1;
                this.id$1 = id$1;
                this.fiber$1 = fiber$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$assign$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.kernel.Poll ), $anonfun$assign$10(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String java.lang.Object ), $anonfun$assign$2$adapted(java.lang.Object org.apache.kafka.clients.consumer.Consumer ), $anonfun$assign$3(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object ), $anonfun$assign$4(fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$assign$5(java.lang.Object fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$assign$6(scala.collection.immutable.List ), $anonfun$assign$7$adapted(org.apache.kafka.common.PartitionInfo ), $anonfun$assign$8(fs2.kafka.KafkaConsumer$$anon$1 java.lang.String scala.Option ), $anonfun$assign$9(fs2.kafka.KafkaConsumer$$anon$1 ), $anonfun$assignment$1(fs2.kafka.KafkaConsumer$$anon$1 ), $anonfun$assignment$2(fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$assignment$3(fs2.kafka.KafkaConsumer$$anon$1 fs2.kafka.internal.KafkaConsumerActor$OnRebalance ), $anonfun$assignment$4(fs2.kafka.KafkaConsumer$$anon$1 fs2.kafka.internal.KafkaConsumerActor$OnRebalance fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$assignment$5(), $anonfun$assignment$6$adapted(fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$assignment$7(fs2.kafka.KafkaConsumer$$anon$1 ), $anonfun$assignment$8(org.apache.kafka.clients.consumer.Consumer ), $anonfun$assignmentStream$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.kernel.Ref cats.effect.std.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$10(cats.effect.kernel.Deferred ), $anonfun$assignmentStream$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Ref scala.collection.immutable.SortedSet cats.effect.std.Queue ), $anonfun$assignmentStream$3(scala.collection.immutable.SortedSet cats.effect.std.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$4(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.kernel.Ref cats.effect.std.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$5(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Ref scala.collection.immutable.SortedSet cats.effect.std.Queue ), $anonfun$assignmentStream$6(scala.collection.immutable.SortedSet cats.effect.std.Queue scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$7(fs2.kafka.KafkaConsumer$$anon$1 scala.Tuple3 ), $anonfun$assignmentStream$8(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Ref cats.effect.std.Queue cats.effect.kernel.Deferred scala.collection.immutable.SortedSet ), $anonfun$assignmentStream$9(cats.effect.std.Queue scala.collection.immutable.SortedSet ), $anonfun$beginningOffsets$1(scala.collection.immutable.Set org.apache.kafka.clients.consumer.Consumer ), $anonfun$beginningOffsets$2(scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$commitSync$1(scala.collection.immutable.Map scala.Function1 ), $anonfun$committed$1(scala.collection.immutable.Set org.apache.kafka.clients.consumer.Consumer ), $anonfun$committed$2(scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$endOffsets$1(scala.collection.immutable.Set org.apache.kafka.clients.consumer.Consumer ), $anonfun$endOffsets$2(scala.collection.immutable.Set scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$listTopics$1(org.apache.kafka.clients.consumer.Consumer ), $anonfun$listTopics$2(scala.Tuple2 ), $anonfun$listTopics$3(scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$listTopics$4(scala.Tuple2 ), $anonfun$metrics$1(org.apache.kafka.clients.consumer.Consumer ), $anonfun$offsetsForTimes$1(scala.collection.immutable.Map org.apache.kafka.clients.consumer.Consumer ), $anonfun$offsetsForTimes$2(scala.collection.immutable.Map scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionedStream$1(scala.collection.immutable.Map ), $anonfun$partitionsFor$1(java.lang.String org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionsFor$2(java.lang.String scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$partitionsMapStream$1(fs2.kafka.KafkaConsumer$$anon$1 scala.Tuple2 ), $anonfun$partitionsMapStream$10(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.std.Queue scala.runtime.BoxedUnit ), $anonfun$partitionsMapStream$11(cats.effect.std.Queue ), $anonfun$partitionsMapStream$2(fs2.kafka.KafkaConsumer$$anon$1 scala.collection.immutable.Set cats.effect.std.Queue scala.Option ), $anonfun$partitionsMapStream$3(fs2.kafka.KafkaConsumer$$anon$1 org.apache.kafka.common.TopicPartition ), $anonfun$partitionsMapStream$4(fs2.kafka.KafkaConsumer$$anon$1 scala.collection.immutable.SortedSet ), $anonfun$partitionsMapStream$5(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.std.Queue scala.collection.immutable.SortedSet ), $anonfun$partitionsMapStream$6(fs2.kafka.KafkaConsumer$$anon$1 scala.util.Either ), $anonfun$partitionsMapStream$7(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.std.Queue scala.collection.immutable.Set ), $anonfun$partitionsMapStream$8(fs2.kafka.KafkaConsumer$$anon$1 scala.Option ), $anonfun$partitionsMapStream$9(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.std.Queue ), $anonfun$position$1$adapted(org.apache.kafka.common.TopicPartition org.apache.kafka.clients.consumer.Consumer ), $anonfun$position$2$adapted(org.apache.kafka.common.TopicPartition scala.concurrent.duration.FiniteDuration org.apache.kafka.clients.consumer.Consumer ), $anonfun$request$1(fs2.kafka.KafkaConsumer$$anon$1 scala.Function1 cats.effect.kernel.Deferred ), $anonfun$request$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Deferred scala.util.Either ), $anonfun$request$3(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Deferred ), $anonfun$seek$1$adapted(org.apache.kafka.common.TopicPartition long org.apache.kafka.clients.consumer.Consumer ), $anonfun$seekToBeginning$1$adapted(java.lang.Object cats.Foldable org.apache.kafka.clients.consumer.Consumer ), $anonfun$seekToEnd$1$adapted(java.lang.Object cats.Foldable org.apache.kafka.clients.consumer.Consumer ), $anonfun$subscribe$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.Reducible cats.effect.kernel.Poll ), $anonfun$subscribe$10(scala.util.matching.Regex fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$subscribe$2$adapted(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.Reducible org.apache.kafka.clients.consumer.Consumer ), $anonfun$subscribe$3(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.Reducible ), $anonfun$subscribe$4(fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$subscribe$5(java.lang.Object cats.Reducible fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$subscribe$6(fs2.kafka.KafkaConsumer$$anon$1 scala.util.matching.Regex cats.effect.kernel.Poll ), $anonfun$subscribe$7$adapted(fs2.kafka.KafkaConsumer$$anon$1 scala.util.matching.Regex org.apache.kafka.clients.consumer.Consumer ), $anonfun$subscribe$8(fs2.kafka.KafkaConsumer$$anon$1 scala.util.matching.Regex ), $anonfun$subscribe$9(fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$unsubscribe$1(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Poll ), $anonfun$unsubscribe$2$adapted(org.apache.kafka.clients.consumer.Consumer ), $anonfun$unsubscribe$3(fs2.kafka.KafkaConsumer$$anon$1 ), $anonfun$unsubscribe$4(fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$unsubscribe$5(fs2.kafka.internal.KafkaConsumerActor$State ), $anonfun$withPermit$1(fs2.kafka.KafkaConsumer$$anon$1 java.lang.Object cats.effect.kernel.Deferred ), $anonfun$withPermit$2(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Deferred scala.util.Either ), $anonfun$withPermit$3(fs2.kafka.KafkaConsumer$$anon$1 cats.effect.kernel.Deferred )}, serializedLambda);
            }
        };
    }

    public <F, K, V> Resource<F, KafkaConsumer<F, K, V>> resource(ConsumerSettings<F, K, V> settings, Async<F> F, MkConsumer<F> mk) {
        return settings.keyDeserializer().flatMap((Function1 & Serializable)keyDeserializer -> settings.valueDeserializer().flatMap((Function1 & Serializable)valueDeserializer -> package$.MODULE$.Resource().eval(F.delay((Function0)(JFunction0.mcI.sp & Serializable)() -> new Object().hashCode())).flatMap((Function1 & Serializable)id -> KafkaConsumer$.$anonfun$resource$4(F, mk, settings, keyDeserializer, valueDeserializer, BoxesRunTime.unboxToInt((Object)id)))));
    }

    public <F, K, V> Stream<F, KafkaConsumer<F, K, V>> stream(ConsumerSettings<F, K, V> settings, Async<F> F, MkConsumer<F> mk) {
        return Stream$.MODULE$.resource(this.resource(settings, F, mk), F);
    }

    public <F> boolean apply() {
        return KafkaConsumer$ConsumerPartiallyApplied$.MODULE$.$lessinit$greater$default$1();
    }

    public final <F, K, V> KafkaConsumer.StreamOps<F, K, V> StreamOps(Stream<F, KafkaConsumer<F, K, V>> self, Functor<F> evidence$1) {
        return new KafkaConsumer.StreamOps<F, K, V>(self, evidence$1);
    }

    private <F> MkConsumer<F> mkAmbig1() {
        throw new AssertionError((Object)"should not be used");
    }

    private <F> MkConsumer<F> mkAmbig2() {
        throw new AssertionError((Object)"should not be used");
    }

    public static final /* synthetic */ Resource $anonfun$resource$4(Async F$4, MkConsumer mk$1, ConsumerSettings settings$1, GenericDeserializer keyDeserializer$1, GenericDeserializer valueDeserializer$1, int id) {
        return package$.MODULE$.Resource().eval(Jitter$.MODULE$.default(F$4)).flatMap((Function1 & Serializable)jitter -> package$.MODULE$.Resource().eval(Logging$.MODULE$.default(id, F$4)).flatMap((Function1 & Serializable)logging -> package$.MODULE$.Resource().eval(Queue$.MODULE$.unbounded((GenConcurrent)F$4)).flatMap((Function1 & Serializable)requests -> package$.MODULE$.Resource().eval(Queue$.MODULE$.bounded(1, (GenConcurrent)F$4)).flatMap((Function1 & Serializable)polls -> package$.MODULE$.Resource().eval(package$.MODULE$.Ref().of(KafkaConsumerActor$State$.MODULE$.empty(F$4), Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)F$4))).flatMap((Function1 & Serializable)ref -> Dispatcher$.MODULE$.sequential(F$4).flatMap((Function1 & Serializable)dispatcher -> package$.MODULE$.Resource().eval(package$.MODULE$.Deferred().apply((GenConcurrent)F$4)).flatMap((Function1 & Serializable)stopConsumingDeferred -> WithConsumer$.MODULE$.apply(mk$1, settings$1, F$4).flatMap((Function1 & Serializable)withConsumer -> {
            Jitter jitter0 = jitter;
            Logging logging0 = logging;
            Dispatcher dispatcher0 = dispatcher;
            KafkaConsumerActor actor = new KafkaConsumerActor(settings$1, keyDeserializer$1, valueDeserializer$1, ref, requests, withConsumer, F$4, dispatcher0, logging0, jitter0);
            return MODULE$.startBackgroundConsumer((QueueSource)requests, (Queue)polls, actor, settings$1.pollInterval(), (Async)F$4).map((Function1 & Serializable)fiber -> MODULE$.createKafkaConsumer((QueueSink)requests, actor, (Fiber)fiber, id, (WithConsumer)withConsumer, (Deferred)stopConsumingDeferred, (Async)F$4, (Logging)logging));
        }))))))));
    }

    private KafkaConsumer$() {
    }
}

