/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Show;
import cats.effect.Blocker;
import cats.effect.Sync;
import fs2.kafka.AdminClientSettings$;
import fs2.kafka.AdminClientSettings$AdminClientSettingsImpl$;
import fs2.kafka.security.KafkaCredentialStore;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class AdminClientSettings<F> {
    public static <F> Show<AdminClientSettings<F>> adminClientSettingsShow() {
        return AdminClientSettings$.MODULE$.adminClientSettingsShow();
    }

    public static <F> AdminClientSettings<F> apply(Sync<F> sync) {
        return AdminClientSettings$.MODULE$.apply(sync);
    }

    public static int ordinal(AdminClientSettings<?> adminClientSettings) {
        return AdminClientSettings$.MODULE$.ordinal(adminClientSettings);
    }

    public abstract Option<ExecutionContext> blocker();

    public abstract AdminClientSettings<F> withBlocker(ExecutionContext var1);

    public abstract Map<String, String> properties();

    public abstract AdminClientSettings<F> withBootstrapServers(String var1);

    public abstract AdminClientSettings<F> withClientId(String var1);

    public abstract AdminClientSettings<F> withReconnectBackoff(FiniteDuration var1);

    public abstract AdminClientSettings<F> withReconnectBackoffMax(FiniteDuration var1);

    public abstract AdminClientSettings<F> withRetryBackoff(FiniteDuration var1);

    public abstract AdminClientSettings<F> withConnectionsMaxIdle(FiniteDuration var1);

    public abstract AdminClientSettings<F> withRequestTimeout(FiniteDuration var1);

    public abstract AdminClientSettings<F> withMetadataMaxAge(FiniteDuration var1);

    public abstract AdminClientSettings<F> withRetries(int var1);

    public abstract AdminClientSettings<F> withProperty(String var1, String var2);

    public abstract AdminClientSettings<F> withProperties(Seq<Tuple2<String, String>> var1);

    public abstract AdminClientSettings<F> withProperties(Map<String, String> var1);

    public abstract FiniteDuration closeTimeout();

    public abstract AdminClientSettings<F> withCloseTimeout(FiniteDuration var1);

    public abstract F createAdminClient();

    public abstract AdminClientSettings<F> withCreateAdminClient(Function1<Map<String, String>, F> var1);

    public AdminClientSettings<F> withCredentials(KafkaCredentialStore credentialsStore) {
        return this.withProperties(credentialsStore.properties());
    }

    public static final class AdminClientSettingsImpl<F>
    extends AdminClientSettings<F>
    implements Product,
    Serializable {
        private final Option blocker;
        private final Map properties;
        private final FiniteDuration closeTimeout;
        private final Function1 createAdminClientWith;

        public static <F> AdminClientSettingsImpl<F> apply(Option<ExecutionContext> option, Map<String, String> map, FiniteDuration finiteDuration, Function1<Map<String, String>, Object> function1) {
            return AdminClientSettings$AdminClientSettingsImpl$.MODULE$.apply(option, map, finiteDuration, function1);
        }

        public static AdminClientSettingsImpl<?> fromProduct(Product product) {
            return AdminClientSettings$AdminClientSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static <F> AdminClientSettingsImpl<F> unapply(AdminClientSettingsImpl<F> adminClientSettingsImpl) {
            return AdminClientSettings$AdminClientSettingsImpl$.MODULE$.unapply(adminClientSettingsImpl);
        }

        public AdminClientSettingsImpl(Option<ExecutionContext> blocker, Map<String, String> properties, FiniteDuration closeTimeout, Function1<Map<String, String>, Object> createAdminClientWith) {
            this.blocker = blocker;
            this.properties = properties;
            this.closeTimeout = closeTimeout;
            this.createAdminClientWith = createAdminClientWith;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AdminClientSettingsImpl)) return false;
            AdminClientSettingsImpl adminClientSettingsImpl = (AdminClientSettingsImpl)object;
            Option<ExecutionContext> option = this.blocker();
            Option<ExecutionContext> option2 = adminClientSettingsImpl.blocker();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = adminClientSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            FiniteDuration finiteDuration = this.closeTimeout();
            FiniteDuration finiteDuration2 = adminClientSettingsImpl.closeTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            Function1<Map<String, String>, F> function1 = this.createAdminClientWith();
            Function1<Map<String, String>, F> function12 = adminClientSettingsImpl.createAdminClientWith();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof AdminClientSettingsImpl;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "AdminClientSettingsImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "blocker";
                }
                case 1: {
                    return "properties";
                }
                case 2: {
                    return "closeTimeout";
                }
                case 3: {
                    return "createAdminClientWith";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Option<ExecutionContext> blocker() {
            return this.blocker;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        @Override
        public FiniteDuration closeTimeout() {
            return this.closeTimeout;
        }

        public Function1<Map<String, String>, F> createAdminClientWith() {
            return this.createAdminClientWith;
        }

        @Override
        public AdminClientSettings<F> withBlocker(ExecutionContext blocker) {
            return this.copy((Option<ExecutionContext>)Some$.MODULE$.apply((Object)new Blocker(blocker)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        @Override
        public AdminClientSettings<F> withBootstrapServers(String bootstrapServers) {
            return this.withProperty("bootstrap.servers", bootstrapServers);
        }

        @Override
        public AdminClientSettings<F> withClientId(String clientId) {
            return this.withProperty("client.id", clientId);
        }

        @Override
        public AdminClientSettings<F> withReconnectBackoff(FiniteDuration reconnectBackoff) {
            return this.withProperty("reconnect.backoff.ms", BoxesRunTime.boxToLong((long)reconnectBackoff.toMillis()).toString());
        }

        @Override
        public AdminClientSettings<F> withReconnectBackoffMax(FiniteDuration reconnectBackoffMax) {
            return this.withProperty("reconnect.backoff.max.ms", BoxesRunTime.boxToLong((long)reconnectBackoffMax.toMillis()).toString());
        }

        @Override
        public AdminClientSettings<F> withRetryBackoff(FiniteDuration retryBackoff) {
            return this.withProperty("retry.backoff.ms", BoxesRunTime.boxToLong((long)retryBackoff.toMillis()).toString());
        }

        @Override
        public AdminClientSettings<F> withConnectionsMaxIdle(FiniteDuration connectionsMaxIdle) {
            return this.withProperty("connections.max.idle.ms", BoxesRunTime.boxToLong((long)connectionsMaxIdle.toMillis()).toString());
        }

        @Override
        public AdminClientSettings<F> withRequestTimeout(FiniteDuration requestTimeout) {
            return this.withProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)requestTimeout.toMillis()).toString());
        }

        @Override
        public AdminClientSettings<F> withMetadataMaxAge(FiniteDuration metadataMaxAge) {
            return this.withProperty("metadata.max.age.ms", BoxesRunTime.boxToLong((long)metadataMaxAge.toMillis()).toString());
        }

        @Override
        public AdminClientSettings<F> withRetries(int retries) {
            return this.withProperty("retries", BoxesRunTime.boxToInteger((int)retries).toString());
        }

        @Override
        public AdminClientSettings<F> withProperty(String key, String value) {
            Map map = (Map)this.properties().updated((Object)key, (Object)value);
            Option<ExecutionContext> option = this.copy$default$1();
            FiniteDuration finiteDuration = this.copy$default$3();
            Function1<Map<String, String>, F> function1 = this.copy$default$4();
            return this.copy(option, (Map<String, String>)map, finiteDuration, function1);
        }

        @Override
        public AdminClientSettings<F> withProperties(Seq<Tuple2<String, String>> properties) {
            Map map = (Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Option<ExecutionContext> option = this.copy$default$1();
            FiniteDuration finiteDuration = this.copy$default$3();
            Function1<Map<String, String>, F> function1 = this.copy$default$4();
            return this.copy(option, (Map<String, String>)map, finiteDuration, function1);
        }

        @Override
        public AdminClientSettings<F> withProperties(Map<String, String> properties) {
            Map map = (Map)this.properties().$plus$plus(properties);
            Option<ExecutionContext> option = this.copy$default$1();
            FiniteDuration finiteDuration = this.copy$default$3();
            Function1<Map<String, String>, F> function1 = this.copy$default$4();
            return this.copy(option, (Map<String, String>)map, finiteDuration, function1);
        }

        @Override
        public AdminClientSettings<F> withCloseTimeout(FiniteDuration closeTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), closeTimeout, this.copy$default$4());
        }

        @Override
        public F createAdminClient() {
            return (F)this.createAdminClientWith().apply(this.properties());
        }

        @Override
        public AdminClientSettings<F> withCreateAdminClient(Function1<Map<String, String>, F> createAdminClientWith) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), createAdminClientWith);
        }

        public String toString() {
            return new StringBuilder(36).append("AdminClientSettings(closeTimeout = ").append(this.closeTimeout()).append(")").toString();
        }

        public <F> AdminClientSettingsImpl<F> copy(Option<ExecutionContext> blocker, Map<String, String> properties, FiniteDuration closeTimeout, Function1<Map<String, String>, Object> createAdminClientWith) {
            return new AdminClientSettingsImpl<F>(blocker, properties, closeTimeout, createAdminClientWith);
        }

        public <F> Option<ExecutionContext> copy$default$1() {
            return this.blocker();
        }

        public <F> Map<String, String> copy$default$2() {
            return this.properties();
        }

        public <F> FiniteDuration copy$default$3() {
            return this.closeTimeout();
        }

        public <F> Function1<Map<String, String>, F> copy$default$4() {
            return this.createAdminClientWith();
        }

        public Option<ExecutionContext> _1() {
            return this.blocker();
        }

        public Map<String, String> _2() {
            return this.properties();
        }

        public FiniteDuration _3() {
            return this.closeTimeout();
        }

        public Function1<Map<String, String>, F> _4() {
            return this.createAdminClientWith();
        }
    }
}

