/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Show;
import cats.effect.Blocker;
import cats.effect.Sync;
import fs2.kafka.Acks;
import fs2.kafka.Acks$AllAcks$;
import fs2.kafka.Acks$OneAcks$;
import fs2.kafka.Acks$ZeroAcks$;
import fs2.kafka.ProducerSettings$;
import fs2.kafka.ProducerSettings$ProducerSettingsImpl$;
import fs2.kafka.RecordSerializer;
import fs2.kafka.Serializer;
import fs2.kafka.security.KafkaCredentialStore;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ProducerSettings<F, K, V> {
    public static <F, K, V> ProducerSettings<F, K, V> apply(RecordSerializer<F, K> recordSerializer, RecordSerializer<F, V> recordSerializer2, Sync<F> sync) {
        return ProducerSettings$.MODULE$.apply(recordSerializer, recordSerializer2, sync);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(RecordSerializer<F, K> recordSerializer, Serializer<F, V> serializer, Sync<F> sync) {
        return ProducerSettings$.MODULE$.apply(recordSerializer, serializer, sync);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(Serializer<F, K> serializer, RecordSerializer<F, V> recordSerializer, Sync<F> sync) {
        return ProducerSettings$.MODULE$.apply(serializer, recordSerializer, sync);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(Serializer<F, K> serializer, Serializer<F, V> serializer2, Sync<F> sync) {
        return ProducerSettings$.MODULE$.apply(serializer, serializer2, sync);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(Sync<F> sync, RecordSerializer<F, K> recordSerializer, RecordSerializer<F, V> recordSerializer2) {
        return ProducerSettings$.MODULE$.apply(sync, recordSerializer, recordSerializer2);
    }

    public static int ordinal(ProducerSettings<?, ?, ?> producerSettings) {
        return ProducerSettings$.MODULE$.ordinal(producerSettings);
    }

    public static <F, K, V> Show<ProducerSettings<F, K, V>> producerSettingsShow() {
        return ProducerSettings$.MODULE$.producerSettingsShow();
    }

    public abstract F keySerializer();

    public abstract F valueSerializer();

    public abstract Option<ExecutionContext> blocker();

    public abstract ProducerSettings<F, K, V> withBlocker(ExecutionContext var1);

    public abstract Map<String, String> properties();

    public abstract ProducerSettings<F, K, V> withBootstrapServers(String var1);

    public abstract ProducerSettings<F, K, V> withAcks(Acks var1);

    public abstract ProducerSettings<F, K, V> withBatchSize(int var1);

    public abstract ProducerSettings<F, K, V> withClientId(String var1);

    public abstract ProducerSettings<F, K, V> withRetries(int var1);

    public abstract ProducerSettings<F, K, V> withMaxInFlightRequestsPerConnection(int var1);

    public abstract ProducerSettings<F, K, V> withEnableIdempotence(boolean var1);

    public abstract ProducerSettings<F, K, V> withLinger(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withRequestTimeout(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withDeliveryTimeout(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withProperty(String var1, String var2);

    public abstract ProducerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> var1);

    public abstract ProducerSettings<F, K, V> withProperties(Map<String, String> var1);

    public abstract FiniteDuration closeTimeout();

    public abstract ProducerSettings<F, K, V> withCloseTimeout(FiniteDuration var1);

    public abstract int parallelism();

    public abstract ProducerSettings<F, K, V> withParallelism(int var1);

    public abstract F createProducer();

    public abstract ProducerSettings<F, K, V> withCreateProducer(Function1<Map<String, String>, F> var1);

    public ProducerSettings<F, K, V> withCredentials(KafkaCredentialStore credentialsStore) {
        return this.withProperties(credentialsStore.properties());
    }

    public static final class ProducerSettingsImpl<F, K, V>
    extends ProducerSettings<F, K, V>
    implements Product,
    Serializable {
        private final Object keySerializer;
        private final Object valueSerializer;
        private final Option blocker;
        private final Map properties;
        private final FiniteDuration closeTimeout;
        private final int parallelism;
        private final Function1 createProducerWith;

        public static <F, K, V> ProducerSettingsImpl<F, K, V> apply(Object object, Object object2, Option<ExecutionContext> option, Map<String, String> map, FiniteDuration finiteDuration, int n, Function1<Map<String, String>, Object> function1) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.apply(object, object2, option, map, finiteDuration, n, function1);
        }

        public static ProducerSettingsImpl<?, ?, ?> fromProduct(Product product) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> ProducerSettingsImpl<F, K, V> unapply(ProducerSettingsImpl<F, K, V> producerSettingsImpl) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.unapply(producerSettingsImpl);
        }

        public ProducerSettingsImpl(Object keySerializer, Object valueSerializer, Option<ExecutionContext> blocker, Map<String, String> properties, FiniteDuration closeTimeout, int parallelism, Function1<Map<String, String>, Object> createProducerWith) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.blocker = blocker;
            this.properties = properties;
            this.closeTimeout = closeTimeout;
            this.parallelism = parallelism;
            this.createProducerWith = createProducerWith;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keySerializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.valueSerializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.blocker()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.closeTimeout()));
            n = Statics.mix((int)n, (int)this.parallelism());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.createProducerWith()));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProducerSettingsImpl)) return false;
            ProducerSettingsImpl producerSettingsImpl = (ProducerSettingsImpl)object;
            if (this.parallelism() != producerSettingsImpl.parallelism()) return false;
            if (!BoxesRunTime.equals(this.keySerializer(), producerSettingsImpl.keySerializer())) return false;
            if (!BoxesRunTime.equals(this.valueSerializer(), producerSettingsImpl.valueSerializer())) return false;
            Option<ExecutionContext> option = this.blocker();
            Option<ExecutionContext> option2 = producerSettingsImpl.blocker();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = producerSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            FiniteDuration finiteDuration = this.closeTimeout();
            FiniteDuration finiteDuration2 = producerSettingsImpl.closeTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            Function1<Map<String, String>, F> function1 = this.createProducerWith();
            Function1<Map<String, String>, F> function12 = producerSettingsImpl.createProducerWith();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ProducerSettingsImpl;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "ProducerSettingsImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this._6());
                }
                case 6: {
                    return this._7();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "keySerializer";
                }
                case 1: {
                    return "valueSerializer";
                }
                case 2: {
                    return "blocker";
                }
                case 3: {
                    return "properties";
                }
                case 4: {
                    return "closeTimeout";
                }
                case 5: {
                    return "parallelism";
                }
                case 6: {
                    return "createProducerWith";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public F keySerializer() {
            return (F)this.keySerializer;
        }

        @Override
        public F valueSerializer() {
            return (F)this.valueSerializer;
        }

        @Override
        public Option<ExecutionContext> blocker() {
            return this.blocker;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        @Override
        public FiniteDuration closeTimeout() {
            return this.closeTimeout;
        }

        @Override
        public int parallelism() {
            return this.parallelism;
        }

        public Function1<Map<String, String>, F> createProducerWith() {
            return this.createProducerWith;
        }

        @Override
        public ProducerSettings<F, K, V> withBlocker(ExecutionContext blocker) {
            Some some = Some$.MODULE$.apply((Object)new Blocker(blocker));
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Map<String, String> map = this.copy$default$4();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            Function1<Map<String, String>, F> function1 = this.copy$default$7();
            return this.copy(f, f2, (Option<ExecutionContext>)some, map, finiteDuration, n, function1);
        }

        @Override
        public ProducerSettings<F, K, V> withBootstrapServers(String bootstrapServers) {
            return this.withProperty("bootstrap.servers", bootstrapServers);
        }

        @Override
        public ProducerSettings<F, K, V> withAcks(Acks acks) {
            String string;
            Acks acks2 = acks;
            if (Acks$ZeroAcks$.MODULE$.equals(acks2)) {
                string = "0";
            } else if (Acks$OneAcks$.MODULE$.equals(acks2)) {
                string = "1";
            } else if (Acks$AllAcks$.MODULE$.equals(acks2)) {
                string = "all";
            } else {
                throw new MatchError((Object)acks2);
            }
            return this.withProperty("acks", string);
        }

        @Override
        public ProducerSettings<F, K, V> withBatchSize(int batchSize) {
            return this.withProperty("batch.size", BoxesRunTime.boxToInteger((int)batchSize).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withClientId(String clientId) {
            return this.withProperty("client.id", clientId);
        }

        @Override
        public ProducerSettings<F, K, V> withRetries(int retries) {
            return this.withProperty("retries", BoxesRunTime.boxToInteger((int)retries).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withMaxInFlightRequestsPerConnection(int maxInFlightRequestsPerConnection) {
            return this.withProperty("max.in.flight.requests.per.connection", BoxesRunTime.boxToInteger((int)maxInFlightRequestsPerConnection).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withEnableIdempotence(boolean enableIdempotence) {
            return this.withProperty("enable.idempotence", BoxesRunTime.boxToBoolean((boolean)enableIdempotence).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withLinger(FiniteDuration linger) {
            return this.withProperty("linger.ms", BoxesRunTime.boxToLong((long)linger.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withRequestTimeout(FiniteDuration requestTimeout) {
            return this.withProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)requestTimeout.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withDeliveryTimeout(FiniteDuration deliveryTimeout) {
            return this.withProperty("delivery.timeout.ms", BoxesRunTime.boxToLong((long)deliveryTimeout.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withProperty(String key, String value) {
            Map map = (Map)this.properties().updated((Object)key, (Object)value);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            Function1<Map<String, String>, F> function1 = this.copy$default$7();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, n, function1);
        }

        @Override
        public ProducerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> properties) {
            Map map = (Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            Function1<Map<String, String>, F> function1 = this.copy$default$7();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, n, function1);
        }

        @Override
        public ProducerSettings<F, K, V> withProperties(Map<String, String> properties) {
            Map map = (Map)this.properties().$plus$plus(properties);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            Function1<Map<String, String>, F> function1 = this.copy$default$7();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, n, function1);
        }

        @Override
        public ProducerSettings<F, K, V> withCloseTimeout(FiniteDuration closeTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), closeTimeout, this.copy$default$6(), this.copy$default$7());
        }

        @Override
        public ProducerSettings<F, K, V> withParallelism(int parallelism) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), parallelism, this.copy$default$7());
        }

        @Override
        public F createProducer() {
            return (F)this.createProducerWith().apply(this.properties());
        }

        @Override
        public ProducerSettings<F, K, V> withCreateProducer(Function1<Map<String, String>, F> createProducerWith) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), createProducerWith);
        }

        public String toString() {
            return new StringBuilder(33).append("ProducerSettings(closeTimeout = ").append(this.closeTimeout()).append(")").toString();
        }

        public <F, K, V> ProducerSettingsImpl<F, K, V> copy(Object keySerializer, Object valueSerializer, Option<ExecutionContext> blocker, Map<String, String> properties, FiniteDuration closeTimeout, int parallelism, Function1<Map<String, String>, Object> createProducerWith) {
            return new ProducerSettingsImpl<F, K, V>(keySerializer, valueSerializer, blocker, properties, closeTimeout, parallelism, createProducerWith);
        }

        public <F, K, V> F copy$default$1() {
            return this.keySerializer();
        }

        public <F, K, V> F copy$default$2() {
            return this.valueSerializer();
        }

        public <F, K, V> Option<ExecutionContext> copy$default$3() {
            return this.blocker();
        }

        public <F, K, V> Map<String, String> copy$default$4() {
            return this.properties();
        }

        public <F, K, V> FiniteDuration copy$default$5() {
            return this.closeTimeout();
        }

        public int copy$default$6() {
            return this.parallelism();
        }

        public <F, K, V> Function1<Map<String, String>, F> copy$default$7() {
            return this.createProducerWith();
        }

        public F _1() {
            return this.keySerializer();
        }

        public F _2() {
            return this.valueSerializer();
        }

        public Option<ExecutionContext> _3() {
            return this.blocker();
        }

        public Map<String, String> _4() {
            return this.properties();
        }

        public FiniteDuration _5() {
            return this.closeTimeout();
        }

        public int _6() {
            return this.parallelism();
        }

        public Function1<Map<String, String>, F> _7() {
            return this.createProducerWith();
        }
    }
}

