/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.internal;

import cats.Applicative;
import cats.ApplicativeError;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.Traverse;
import cats.data.Chain;
import cats.data.Chain$;
import cats.data.IndexedStateT;
import cats.data.NonEmptyList;
import cats.data.NonEmptySetImpl$;
import cats.data.NonEmptyVector;
import cats.data.NonEmptyVector$;
import cats.data.package;
import cats.effect.ConcurrentEffect;
import cats.effect.ContextShift;
import cats.effect.Timer;
import cats.effect.concurrent.Ref;
import cats.effect.syntax.BracketOps$;
import cats.effect.syntax.ConcurrentOps$;
import cats.effect.syntax.package;
import cats.implicits$;
import cats.kernel.Semigroup;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.EitherIdOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.concurrent.Queue;
import fs2.kafka.CommitTimeoutException$;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.CommittableConsumerRecord$;
import fs2.kafka.CommittableOffset$;
import fs2.kafka.ConsumerRecord;
import fs2.kafka.ConsumerRecord$;
import fs2.kafka.ConsumerSettings;
import fs2.kafka.Deserializer;
import fs2.kafka.Jitter;
import fs2.kafka.NotSubscribedException$;
import fs2.kafka.instances$;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.KafkaConsumerActor$FetchCompletedReason$;
import fs2.kafka.internal.KafkaConsumerActor$FetchCompletedReason$FetchedRecords$;
import fs2.kafka.internal.KafkaConsumerActor$FetchCompletedReason$TopicPartitionRevoked$;
import fs2.kafka.internal.KafkaConsumerActor$FetchRequest$;
import fs2.kafka.internal.KafkaConsumerActor$HandlePollResult$;
import fs2.kafka.internal.KafkaConsumerActor$OnRebalance$;
import fs2.kafka.internal.KafkaConsumerActor$Request$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Assign$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Assignment$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Commit$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Fetch$;
import fs2.kafka.internal.KafkaConsumerActor$Request$ManualCommitAsync$;
import fs2.kafka.internal.KafkaConsumerActor$Request$ManualCommitSync$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Poll$;
import fs2.kafka.internal.KafkaConsumerActor$Request$SubscribePattern$;
import fs2.kafka.internal.KafkaConsumerActor$Request$SubscribeTopics$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Unsubscribe$;
import fs2.kafka.internal.KafkaConsumerActor$RevokedResult$;
import fs2.kafka.internal.KafkaConsumerActor$State$;
import fs2.kafka.internal.LogEntry;
import fs2.kafka.internal.LogEntry$;
import fs2.kafka.internal.LogEntry$AssignedPartitions$;
import fs2.kafka.internal.LogEntry$CommittedPendingCommits$;
import fs2.kafka.internal.LogEntry$CompletedFetchesWithRecords$;
import fs2.kafka.internal.LogEntry$ManuallyAssignedPartitions$;
import fs2.kafka.internal.LogEntry$RemovedRevokedRecords$;
import fs2.kafka.internal.LogEntry$RevokedFetchesWithRecords$;
import fs2.kafka.internal.LogEntry$RevokedFetchesWithoutRecords$;
import fs2.kafka.internal.LogEntry$RevokedPartitions$;
import fs2.kafka.internal.LogEntry$RevokedPreviousFetch$;
import fs2.kafka.internal.LogEntry$StoredFetch$;
import fs2.kafka.internal.LogEntry$StoredOnRebalance$;
import fs2.kafka.internal.LogEntry$StoredPendingCommit$;
import fs2.kafka.internal.LogEntry$StoredRecords$;
import fs2.kafka.internal.LogEntry$SubscribedPattern$;
import fs2.kafka.internal.LogEntry$SubscribedTopics$;
import fs2.kafka.internal.LogEntry$Unsubscribed$;
import fs2.kafka.internal.Logging;
import fs2.kafka.internal.WithConsumer;
import fs2.kafka.internal.converters$;
import fs2.kafka.internal.syntax$;
import fs2.kafka.internal.syntax$FiniteDurationSyntax$;
import fs2.kafka.internal.syntax$FoldableSyntax$;
import fs2.kafka.internal.syntax$JavaUtilCollectionSyntax$;
import fs2.kafka.internal.syntax$LoggingSyntax$;
import fs2.kafka.internal.syntax$MapSyntax$;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class KafkaConsumerActor<F, K, V> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(KafkaConsumerActor.class.getDeclaredField("0bitmap$1"));
    public long 0bitmap$1;
    private final ConsumerSettings<F, K, V> settings;
    private final Deserializer<F, K> keyDeserializer;
    private final Deserializer<F, V> valueDeserializer;
    private final Ref<F, State<F, K, V>> ref;
    private final Queue<F, Request<F, K, V>> requests;
    private final WithConsumer<F> withConsumer;
    public final ConcurrentEffect<F> fs2$kafka$internal$KafkaConsumerActor$$F;
    private final ContextShift<F> context;
    public final Logging<F> fs2$kafka$internal$KafkaConsumerActor$$logging;
    private final Jitter<F> jitter;
    private final Timer<F> timer;
    private final Option<String> consumerGroupId;
    private final ConsumerRebalanceListener consumerRebalanceListener;
    private final Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, F> offsetCommit;
    private final Duration pollTimeout;
    private final F poll;
    public final KafkaConsumerActor$RevokedResult$ RevokedResult$lzy1;
    private KafkaConsumerActor$HandlePollResult$ HandlePollResult$lzy1;

    public KafkaConsumerActor(ConsumerSettings<F, K, V> settings, Deserializer<F, K> keyDeserializer, Deserializer<F, V> valueDeserializer, Ref<F, State<F, K, V>> ref, Queue<F, Request<F, K, V>> requests, WithConsumer<F> withConsumer, ConcurrentEffect<F> F, ContextShift<F> context, Logging<F> logging, Jitter<F> jitter, Timer<F> timer) {
        this.settings = settings;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.ref = ref;
        this.requests = requests;
        this.withConsumer = withConsumer;
        this.fs2$kafka$internal$KafkaConsumerActor$$F = F;
        this.context = context;
        this.fs2$kafka$internal$KafkaConsumerActor$$logging = logging;
        this.jitter = jitter;
        this.timer = timer;
        this.RevokedResult$lzy1 = new KafkaConsumerActor$RevokedResult$(this);
        this.consumerGroupId = settings.properties().get((Object)"group.id");
        this.consumerRebalanceListener = new ConsumerRebalanceListener(this){
            private final /* synthetic */ KafkaConsumerActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onPartitionsRevoked(Collection partitions) {
                Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(partitions);
                this.$outer.fs2$kafka$internal$KafkaConsumerActor$$F.toIO(this.$outer.fs2$kafka$internal$KafkaConsumerActor$$revoked(syntax$JavaUtilCollectionSyntax$.MODULE$.toSortedSet$extension(collection, instances$.MODULE$.fs2KafkaTopicPartitionOrdering()))).unsafeRunSync();
            }

            public void onPartitionsAssigned(Collection partitions) {
                Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(partitions);
                this.$outer.fs2$kafka$internal$KafkaConsumerActor$$F.toIO(this.$outer.fs2$kafka$internal$KafkaConsumerActor$$assigned(syntax$JavaUtilCollectionSyntax$.MODULE$.toSortedSet$extension(collection, instances$.MODULE$.fs2KafkaTopicPartitionOrdering()))).unsafeRunSync();
            }
        };
        this.offsetCommit = (Function1 & Serializable)offsets -> {
            F commit = this.runCommitAsync((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, (Function1 & Serializable)cb -> requests.enqueue1(KafkaConsumerActor$Request$Commit$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, (Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)cb)));
            Object object = implicits$.MODULE$.catsSyntaxApplicativeError(commit, (ApplicativeError)F);
            return ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, settings.commitRecovery().recoverCommitWith((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets, commit, F, jitter, timer), (ApplicativeError)F);
        };
        this.pollTimeout = syntax$FiniteDurationSyntax$.MODULE$.asJava$extension(syntax$.MODULE$.FiniteDurationSyntax(settings.pollTimeout()));
        this.poll = implicits$.MODULE$.toFlatMapOps(ref.get(), F).flatMap((Function1 & Serializable)state -> {
            if (state.subscribed() && state.streaming()) {
                boolean initialRebalancing = state.rebalancing();
                return implicits$.MODULE$.toFlatMapOps(this.pollConsumer$1(withConsumer, (ConcurrentEffect)F, (State)state), (FlatMap)F).flatMap((Function1 & Serializable)_$35 -> this.handlePoll$1(ref, F, logging, (scala.collection.immutable.Map)_$35, initialRebalancing));
            }
            return F.unit();
        });
    }

    private F subscribe(NonEmptyList<String> topics, Function1<Either<Throwable, BoxedUnit>, F> callback) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.withConsumer.blocking((JProcedure1 & Serializable)_$2 -> _$2.subscribe((Collection)converters$.MODULE$.collection().SeqHasAsJava((Seq)topics.toList()).asJava(), this.consumerRebalanceListener)), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object subscribe = ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(subscribe, this.fs2$kafka$internal$KafkaConsumerActor$$F).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                return this.fs2$kafka$internal$KafkaConsumerActor$$F.unit();
            }
            if (either instanceof Right) {
                Object object = syntax$.MODULE$.LoggingSyntax(this.ref.updateAndGet((Function1 & Serializable)_$3 -> _$3.asSubscribed()));
                return syntax$LoggingSyntax$.MODULE$.log$extension(object, (Function1 & Serializable)_$4 -> LogEntry$SubscribedTopics$.MODULE$.apply(topics, _$4), this.fs2$kafka$internal$KafkaConsumerActor$$F, this.fs2$kafka$internal$KafkaConsumerActor$$logging);
            }
            throw new MatchError((Object)either);
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap(callback);
    }

    private F subscribe(Pattern pattern, Function1<Either<Throwable, BoxedUnit>, F> callback) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.withConsumer.blocking((JProcedure1 & Serializable)_$5 -> _$5.subscribe(pattern, this.consumerRebalanceListener)), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object subscribe = ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(subscribe, this.fs2$kafka$internal$KafkaConsumerActor$$F).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                return this.fs2$kafka$internal$KafkaConsumerActor$$F.unit();
            }
            if (either instanceof Right) {
                Object object = syntax$.MODULE$.LoggingSyntax(this.ref.updateAndGet((Function1 & Serializable)_$6 -> _$6.asSubscribed()));
                return syntax$LoggingSyntax$.MODULE$.log$extension(object, (Function1 & Serializable)_$7 -> LogEntry$SubscribedPattern$.MODULE$.apply(pattern, _$7), this.fs2$kafka$internal$KafkaConsumerActor$$F, this.fs2$kafka$internal$KafkaConsumerActor$$logging);
            }
            throw new MatchError((Object)either);
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap(callback);
    }

    private F unsubscribe(Function1<Either<Throwable, BoxedUnit>, F> callback) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.withConsumer.blocking((JProcedure1 & Serializable)_$8 -> _$8.unsubscribe()), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object unsubscribe = ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(unsubscribe, this.fs2$kafka$internal$KafkaConsumerActor$$F).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                return this.fs2$kafka$internal$KafkaConsumerActor$$F.unit();
            }
            if (either instanceof Right) {
                Object object = syntax$.MODULE$.LoggingSyntax(this.ref.updateAndGet((Function1 & Serializable)_$9 -> _$9.asUnsubscribed()));
                return syntax$LoggingSyntax$.MODULE$.log$extension(object, (Function1 & Serializable)_$10 -> LogEntry$Unsubscribed$.MODULE$.apply(_$10), this.fs2$kafka$internal$KafkaConsumerActor$$F, this.fs2$kafka$internal$KafkaConsumerActor$$logging);
            }
            throw new MatchError((Object)either);
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap(callback);
    }

    private F assign(Object partitions, Function1<Either<Throwable, BoxedUnit>, F> callback) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.withConsumer.blocking((JProcedure1 & Serializable)_$11 -> _$11.assign((Collection)converters$.MODULE$.collection().SeqHasAsJava((Seq)implicits$.MODULE$.toFoldableOps(partitions, (Foldable)NonEmptySetImpl$.MODULE$.catsDataInstancesForNonEmptySet()).toList()).asJava())), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object assign = ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)implicits$.MODULE$.toFlatMapOps(implicits$.MODULE$.toFlatMapOps(assign, this.fs2$kafka$internal$KafkaConsumerActor$$F).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                return this.fs2$kafka$internal$KafkaConsumerActor$$F.unit();
            }
            if (either instanceof Right) {
                Object object = syntax$.MODULE$.LoggingSyntax(this.ref.updateAndGet((Function1 & Serializable)_$12 -> _$12.asSubscribed()));
                return syntax$LoggingSyntax$.MODULE$.log$extension(object, (Function1 & Serializable)_$13 -> LogEntry$ManuallyAssignedPartitions$.MODULE$.apply(partitions, _$13), this.fs2$kafka$internal$KafkaConsumerActor$$F, this.fs2$kafka$internal$KafkaConsumerActor$$logging);
            }
            throw new MatchError((Object)either);
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap(callback);
    }

    private F fetch(TopicPartition partition, int streamId, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, F> callback) {
        F assigned = this.withConsumer.blocking((Function1 & Serializable)_$14 -> _$14.assignment().contains(partition));
        Object object = implicits$.MODULE$.catsSyntaxIfM(assigned, this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)IfMOps$.MODULE$.ifM$extension(object, () -> this.fetch$$anonfun$1(partition, streamId, callback), () -> KafkaConsumerActor.fetch$$anonfun$2(callback), this.fs2$kafka$internal$KafkaConsumerActor$$F);
    }

    public F fs2$kafka$internal$KafkaConsumerActor$$commitAsync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Either<Throwable, BoxedUnit>, BoxedUnit> callback) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(this.withConsumer.blocking((JProcedure1 & Serializable)_$15 -> _$15.commitAsync(converters$.MODULE$.collection().MapHasAsJava((Map)offsets).asJava(), (_$16, exception) -> callback.apply((Object)Option$.MODULE$.apply((Object)exception).toLeft((Function0 & Serializable)() -> {
            KafkaConsumerActor.commitAsync$$anonfun$1$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        })))), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)e -> this.fs2$kafka$internal$KafkaConsumerActor$$F.delay((Function0 & Serializable)() -> {
            KafkaConsumerActor.commitAsync$$anonfun$2$$anonfun$1(callback, e);
            return BoxedUnit.UNIT;
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F);
    }

    private F commit(Request.Commit<F, K, V> request) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.ref.modify((Function1 & Serializable)state -> {
            if (state.rebalancing()) {
                State newState = state.withPendingCommit(request);
                return Tuple2$.MODULE$.apply(newState, (Object)Some$.MODULE$.apply(LogEntry$StoredPendingCommit$.MODULE$.apply(request, newState)));
            }
            return Tuple2$.MODULE$.apply(state, (Object)None$.MODULE$);
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                LogEntry.StoredPendingCommit log = (LogEntry.StoredPendingCommit)((Some)option).value();
                return this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(log);
            }
            if (None$.MODULE$.equals(option)) {
                return this.fs2$kafka$internal$KafkaConsumerActor$$commitAsync(request.offsets(), request.callback());
            }
            throw new MatchError((Object)option);
        });
    }

    private F manualCommitSync(Request.ManualCommitSync<F, K, V> request) {
        F commit = this.withConsumer.blocking((JProcedure1 & Serializable)_$17 -> _$17.commitSync(converters$.MODULE$.collection().MapHasAsJava(request.offsets()).asJava()));
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(commit, this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$eq$extension(object2, request.callback(), this.fs2$kafka$internal$KafkaConsumerActor$$F);
    }

    private F runCommitAsync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>, F> k) {
        Object object = package.all$.MODULE$.catsEffectSyntaxBracket(this.fs2$kafka$internal$KafkaConsumerActor$$F.asyncF((Function1 & Serializable)cb -> k.apply(cb)), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object object2 = package.all$.MODULE$.catsEffectSyntaxConcurrent(BracketOps$.MODULE$.guarantee$extension(object, this.context.shift(), this.fs2$kafka$internal$KafkaConsumerActor$$F));
        return (F)ConcurrentOps$.MODULE$.timeoutTo$extension(object2, this.settings.commitTimeout(), this.fs2$kafka$internal$KafkaConsumerActor$$F.raiseError((Object)CommitTimeoutException$.MODULE$.apply(this.settings.commitTimeout(), offsets)), this.fs2$kafka$internal$KafkaConsumerActor$$F, this.timer);
    }

    private F manualCommitAsync(Request.ManualCommitAsync<F, K, V> request) {
        F commit = this.runCommitAsync(request.offsets(), (Function1 & Serializable)cb -> this.fs2$kafka$internal$KafkaConsumerActor$$commitAsync(request.offsets(), (Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)cb));
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(commit, this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        Object res = FlatMapOps$.MODULE$.$greater$greater$eq$extension(object2, request.callback(), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        return (F)implicits$.MODULE$.toFunctorOps(package.all$.MODULE$.toConcurrentOps(res, this.fs2$kafka$internal$KafkaConsumerActor$$F).start(), this.fs2$kafka$internal$KafkaConsumerActor$$F).void();
    }

    public F fs2$kafka$internal$KafkaConsumerActor$$assigned(SortedSet<TopicPartition> assigned) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.ref.updateAndGet((Function1 & Serializable)_$18 -> _$18.withRebalancing(false)), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap((Function1 & Serializable)state -> {
            Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$AssignedPartitions$.MODULE$.apply(assigned, state)), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.assigned$$anonfun$2$$anonfun$1(assigned, state), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        });
    }

    public F fs2$kafka$internal$KafkaConsumerActor$$revoked(SortedSet<TopicPartition> revoked) {
        return (F)implicits$.MODULE$.toFlatMapOps(this.ref.modify((Function1 & Serializable)state -> {
            State withRebalancing = state.withRebalancing(true);
            scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(withRebalancing.fetches());
            scala.collection.immutable.Set fetches = syntax$MapSyntax$.MODULE$.keySetStrict$extension(map);
            scala.collection.immutable.Map map2 = syntax$.MODULE$.MapSyntax(withRebalancing.records());
            scala.collection.immutable.Set records = syntax$MapSyntax$.MODULE$.keySetStrict$extension(map2);
            SortedSet revokedFetches = (SortedSet)revoked.intersect(fetches);
            SortedSet revokedNonFetches = (SortedSet)revoked.diff((Set)revokedFetches);
            scala.collection.immutable.Set withRecords = (scala.collection.immutable.Set)records.intersect((Set)revokedFetches);
            SortedSet withoutRecords = (SortedSet)revokedFetches.diff(records);
            return (Tuple2)this.completeWithRecords$3(withRecords).flatMap((Function1 & Serializable)completeWithRecords -> this.completeWithoutRecords$2(withoutRecords).flatMap((Function1 & Serializable)completeWithoutRecords -> this.removeRevokedRecords$1(revokedNonFetches).map((Function1 & Serializable)removeRevokedRecords -> this.RevokedResult().apply(this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$RevokedPartitions$.MODULE$.apply(revoked, withRebalancing)), completeWithRecords, completeWithoutRecords, removeRevokedRecords, withRebalancing.onRebalances()), (Functor)Invariant$.MODULE$.catsInstancesForId()), (FlatMap)Invariant$.MODULE$.catsInstancesForId()), (FlatMap)Invariant$.MODULE$.catsInstancesForId()).run(withRebalancing, (FlatMap)Invariant$.MODULE$.catsInstancesForId());
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap((Function1 & Serializable)res -> {
            Object onRevoked = res.onRebalances().foldLeft(this.fs2$kafka$internal$KafkaConsumerActor$$F.unit(), (Function2 & Serializable)(_$25, _$26) -> {
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(_$25, this.fs2$kafka$internal$KafkaConsumerActor$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> KafkaConsumerActor.$anonfun$13$$anonfun$1(revoked, _$26), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            });
            Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(res.logRevoked(), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> KafkaConsumerActor.revoked$$anonfun$2$$anonfun$1(res), this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            Object object3 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> KafkaConsumerActor.revoked$$anonfun$2$$anonfun$2(res), this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            Object object4 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> KafkaConsumerActor.revoked$$anonfun$2$$anonfun$3(res), this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object4, () -> KafkaConsumerActor.revoked$$anonfun$2$$anonfun$4(onRevoked), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        });
    }

    private F assignment(Function1<Either<Throwable, SortedSet<TopicPartition>>, F> callback, Option<OnRebalance<F, K, V>> onRebalance) {
        Option<OnRebalance<F, K, V>> option = onRebalance;
        if (option instanceof Some) {
            OnRebalance on = (OnRebalance)((Some)option).value();
            return (F)implicits$.MODULE$.toFlatMapOps(this.ref.updateAndGet((Function1 & Serializable)_$28 -> _$28.withOnRebalance(on).asStreaming()), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap((Function1 & Serializable)newState -> {
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.resolveDeferred$1(callback, newState.subscribed()), this.fs2$kafka$internal$KafkaConsumerActor$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.assignment$$anonfun$2$$anonfun$1(on, newState), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            });
        }
        if (None$.MODULE$.equals(option)) {
            return (F)implicits$.MODULE$.toFlatMapOps(this.ref.updateAndGet((Function1 & Serializable)_$29 -> _$29.asStreaming()), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap((Function1 & Serializable)newState -> this.resolveDeferred$1(callback, newState.subscribed()));
        }
        throw new MatchError(option);
    }

    private CommittableConsumerRecord<F, K, V> committableConsumerRecord(ConsumerRecord<K, V> record, TopicPartition partition) {
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(record.offset() + 1L, (String)this.settings.recordMetadata().apply(record));
        return CommittableConsumerRecord$.MODULE$.apply(record, CommittableOffset$.MODULE$.apply(partition, offsetAndMetadata, this.consumerGroupId, (Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, Object>)this.offsetCommit, this.fs2$kafka$internal$KafkaConsumerActor$$F));
    }

    private F records(ConsumerRecords<byte[], byte[]> batch) {
        Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(batch.partitions());
        return (F)implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps(syntax$JavaUtilCollectionSyntax$.MODULE$.toVector$extension(collection), (Traverse)implicits$.MODULE$.catsStdInstancesForVector()).traverse((Function1 & Serializable)partition -> {
            Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(batch.records(partition));
            return implicits$.MODULE$.toFunctorOps(implicits$.MODULE$.toTraverseOps((Object)new NonEmptyVector(NonEmptyVector$.MODULE$.fromVectorUnsafe(syntax$JavaUtilCollectionSyntax$.MODULE$.toVector$extension(collection))), (Traverse)NonEmptyVector$.MODULE$.catsDataInstancesForNonEmptyVector()).traverse((Function1 & Serializable)record -> implicits$.MODULE$.toFunctorOps(ConsumerRecord$.MODULE$.fromJava((org.apache.kafka.clients.consumer.ConsumerRecord<byte[], byte[]>)record, this.keyDeserializer, this.valueDeserializer, this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F).map((Function1 & Serializable)_$30 -> this.committableConsumerRecord((ConsumerRecord<K, V>)_$30, (TopicPartition)partition)), this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F).map((Function1 & Serializable)_$31 -> Tuple2$.MODULE$.apply((Object)partition, (Object)new NonEmptyVector(_$31 == null ? null : ((NonEmptyVector)_$31).toVector())));
        }, this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F).map((Function1 & Serializable)_$32 -> _$32.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public F handle(Request<F, K, V> request) {
        Request<F, K, V> request2 = request;
        if (request2 instanceof Request.Assignment) {
            Request.Assignment assignment = KafkaConsumerActor$Request$Assignment$.MODULE$.unapply((Request.Assignment)request2);
            Function1 function1 = assignment._1();
            Option option = assignment._2();
            Function1 callback = function1;
            Option onRebalance = option;
            return this.assignment(callback, onRebalance);
        }
        if (request2 instanceof Request.Poll && KafkaConsumerActor$Request$Poll$.MODULE$.unapply((Request.Poll)request2)) {
            return this.poll;
        }
        if (request2 instanceof Request.SubscribeTopics) {
            Request.SubscribeTopics subscribeTopics = KafkaConsumerActor$Request$SubscribeTopics$.MODULE$.unapply((Request.SubscribeTopics)request2);
            NonEmptyList<String> nonEmptyList = subscribeTopics._1();
            Function1 function1 = subscribeTopics._2();
            NonEmptyList<String> topics = nonEmptyList;
            Function1 callback = function1;
            return this.subscribe(topics, callback);
        }
        if (request2 instanceof Request.Assign) {
            Request.Assign assign = KafkaConsumerActor$Request$Assign$.MODULE$.unapply((Request.Assign)request2);
            Object object = assign._1();
            Function1 function1 = assign._2();
            Object partitions = object;
            Function1 callback = function1;
            return this.assign(partitions, callback);
        }
        if (request2 instanceof Request.SubscribePattern) {
            Request.SubscribePattern subscribePattern = KafkaConsumerActor$Request$SubscribePattern$.MODULE$.unapply((Request.SubscribePattern)request2);
            Pattern pattern = subscribePattern._1();
            Function1 function1 = subscribePattern._2();
            Pattern pattern2 = pattern;
            Function1 callback = function1;
            return this.subscribe(pattern2, callback);
        }
        if (request2 instanceof Request.Unsubscribe) {
            Function1 function1;
            Request.Unsubscribe unsubscribe = KafkaConsumerActor$Request$Unsubscribe$.MODULE$.unapply((Request.Unsubscribe)request2);
            Function1 callback = function1 = unsubscribe._1();
            return this.unsubscribe(callback);
        }
        if (request2 instanceof Request.Fetch) {
            Request.Fetch fetch = KafkaConsumerActor$Request$Fetch$.MODULE$.unapply((Request.Fetch)request2);
            TopicPartition topicPartition = fetch._1();
            int n = fetch._2();
            Function1 function1 = fetch._3();
            TopicPartition partition = topicPartition;
            int streamId = n;
            Function1 callback = function1;
            return this.fetch(partition, streamId, callback);
        }
        if (request2 instanceof Request.Commit) {
            Request.Commit commit = KafkaConsumerActor$Request$Commit$.MODULE$.unapply((Request.Commit)request2);
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = commit._1();
            Function1<Either<Throwable, BoxedUnit>, BoxedUnit> function1 = commit._2();
            Request.Commit request3 = (Request.Commit)request2;
            return this.commit(request3);
        }
        if (request2 instanceof Request.ManualCommitAsync) {
            Request.ManualCommitAsync manualCommitAsync = KafkaConsumerActor$Request$ManualCommitAsync$.MODULE$.unapply((Request.ManualCommitAsync)request2);
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = manualCommitAsync._1();
            Function1 function1 = manualCommitAsync._2();
            Request.ManualCommitAsync request4 = (Request.ManualCommitAsync)request2;
            return this.manualCommitAsync(request4);
        }
        if (request2 instanceof Request.ManualCommitSync) {
            Request.ManualCommitSync manualCommitSync = KafkaConsumerActor$Request$ManualCommitSync$.MODULE$.unapply((Request.ManualCommitSync)request2);
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = manualCommitSync._1();
            Function1 function1 = manualCommitSync._2();
            Request.ManualCommitSync request5 = (Request.ManualCommitSync)request2;
            return this.manualCommitSync(request5);
        }
        throw new MatchError(request2);
    }

    private final KafkaConsumerActor$RevokedResult$ RevokedResult() {
        return this.RevokedResult$lzy1;
    }

    private final KafkaConsumerActor$HandlePollResult$ HandlePollResult() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    KafkaConsumerActor$HandlePollResult$ kafkaConsumerActor$HandlePollResult$;
                    this.HandlePollResult$lzy1 = kafkaConsumerActor$HandlePollResult$ = new KafkaConsumerActor$HandlePollResult$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return kafkaConsumerActor$HandlePollResult$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.HandlePollResult$lzy1;
    }

    private final Object pollConsumer$1(WithConsumer withConsumer$1, ConcurrentEffect F$2, State state) {
        return implicits$.MODULE$.toFlatMapOps(withConsumer$1.blocking((Function1 & Serializable)consumer -> {
            Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(consumer.assignment());
            scala.collection.immutable.Set assigned = syntax$JavaUtilCollectionSyntax$.MODULE$.toSet$extension(collection);
            scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(state.fetches());
            scala.collection.immutable.Set requested = syntax$MapSyntax$.MODULE$.keySetStrict$extension(map);
            scala.collection.immutable.Map map2 = syntax$.MODULE$.MapSyntax(state.records());
            scala.collection.immutable.Set available = syntax$MapSyntax$.MODULE$.keySetStrict$extension(map2);
            scala.collection.immutable.Set resume = (scala.collection.immutable.Set)((SetOps)requested.intersect(assigned)).diff(available);
            scala.collection.immutable.Set pause = (scala.collection.immutable.Set)assigned.diff((Set)resume);
            if (pause.nonEmpty()) {
                consumer.pause((Collection)converters$.MODULE$.collection().SetHasAsJava((Set)pause).asJava());
            }
            if (resume.nonEmpty()) {
                consumer.resume((Collection)converters$.MODULE$.collection().SetHasAsJava((Set)resume).asJava());
            }
            return consumer.poll(this.pollTimeout);
        }), (FlatMap)F$2).flatMap((Function1 & Serializable)batch -> this.records((ConsumerRecords<byte[], byte[]>)batch));
    }

    private static final Object completeFetches$1(ConcurrentEffect F$4, State state$2, scala.collection.immutable.Map allRecords$1, scala.collection.immutable.Set canBeCompleted$1) {
        scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(state$2.fetches());
        return implicits$.MODULE$.toFoldableOps(syntax$MapSyntax$.MODULE$.filterKeysStrictList$extension(map, canBeCompleted$1), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).traverse_((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                TopicPartition partition = (TopicPartition)tuple2._1();
                scala.collection.immutable.Map fetches = (scala.collection.immutable.Map)tuple2._2();
                Chunk records = Chunk$.MODULE$.vector(((NonEmptyVector)allRecords$1.apply((Object)partition)).toVector());
                return implicits$.MODULE$.toFoldableOps((Object)fetches.values().toList(), (Foldable)implicits$.MODULE$.catsStdInstancesForList()).traverse_((Function1 & Serializable)_$33 -> _$33.completeRecords(records), (Applicative)F$4);
            }
            throw new MatchError((Object)tuple2);
        }, (Applicative)F$4);
    }

    private final Tuple2 handleBatch$1(ConcurrentEffect F$3, scala.collection.immutable.Map newRecords$1, State state, Option pendingCommits) {
        if (state.fetches().isEmpty()) {
            if (newRecords$1.isEmpty()) {
                return Tuple2$.MODULE$.apply((Object)state, (Object)this.HandlePollResult().StateNotChanged().apply((Option<HandlePollResult.PendingCommits>)pendingCommits));
            }
            State newState = state.withRecords((scala.collection.immutable.Map<TopicPartition, Vector>)newRecords$1);
            return Tuple2$.MODULE$.apply(newState, (Object)this.HandlePollResult().Stored().apply(LogEntry$StoredRecords$.MODULE$.apply((scala.collection.immutable.Map<TopicPartition, Vector>)newRecords$1, newState), (Option<HandlePollResult.PendingCommits>)pendingCommits));
        }
        scala.collection.immutable.Map allRecords = (scala.collection.immutable.Map)implicits$.MODULE$.catsSyntaxSemigroup(state.records(), (Semigroup)implicits$.MODULE$.catsKernelStdMonoidForMap(NonEmptyVector$.MODULE$.catsDataSemigroupForNonEmptyVector())).combine((Object)newRecords$1);
        if (allRecords.nonEmpty()) {
            scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(state.fetches());
            scala.collection.immutable.Set requested = syntax$MapSyntax$.MODULE$.keySetStrict$extension(map);
            scala.collection.immutable.Map map2 = syntax$.MODULE$.MapSyntax(allRecords);
            scala.collection.immutable.Set canBeCompleted = (scala.collection.immutable.Set)syntax$MapSyntax$.MODULE$.keySetStrict$extension(map2).intersect(requested);
            scala.collection.immutable.Map map3 = syntax$.MODULE$.MapSyntax(newRecords$1);
            scala.collection.immutable.Set canBeStored = (scala.collection.immutable.Set)syntax$MapSyntax$.MODULE$.keySetStrict$extension(map3).diff((Set)canBeCompleted);
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)canBeCompleted.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)canBeStored.nonEmpty()));
            if (tuple2 != null) {
                boolean bl = tuple2._1$mcZ$sp();
                boolean bl2 = tuple2._2$mcZ$sp();
                if (bl) {
                    if (bl2) {
                        scala.collection.immutable.Map map4 = syntax$.MODULE$.MapSyntax(newRecords$1);
                        scala.collection.immutable.Map storeRecords = syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map4, canBeStored);
                        State newState = state.withoutFetchesAndRecords((scala.collection.immutable.Set<TopicPartition>)canBeCompleted).withRecords(storeRecords);
                        scala.collection.immutable.Map map5 = syntax$.MODULE$.MapSyntax(allRecords);
                        return Tuple2$.MODULE$.apply(newState, (Object)this.HandlePollResult().CompletedAndStored().apply(KafkaConsumerActor.completeFetches$1(F$3, state, allRecords, canBeCompleted), LogEntry$CompletedFetchesWithRecords$.MODULE$.apply(syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map5, canBeCompleted), newState), LogEntry$StoredRecords$.MODULE$.apply(storeRecords, newState), (Option<HandlePollResult.PendingCommits>)pendingCommits));
                    }
                    if (!bl2) {
                        State newState = state.withoutFetchesAndRecords((scala.collection.immutable.Set<TopicPartition>)canBeCompleted);
                        scala.collection.immutable.Map map6 = syntax$.MODULE$.MapSyntax(allRecords);
                        return Tuple2$.MODULE$.apply(newState, (Object)this.HandlePollResult().Completed().apply(KafkaConsumerActor.completeFetches$1(F$3, state, allRecords, canBeCompleted), LogEntry$CompletedFetchesWithRecords$.MODULE$.apply(syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map6, canBeCompleted), newState), (Option<HandlePollResult.PendingCommits>)pendingCommits));
                    }
                }
                if (!bl) {
                    if (bl2) {
                        scala.collection.immutable.Map map7 = syntax$.MODULE$.MapSyntax(newRecords$1);
                        scala.collection.immutable.Map storeRecords = syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map7, canBeStored);
                        State newState = state.withRecords(storeRecords);
                        return Tuple2$.MODULE$.apply(newState, (Object)this.HandlePollResult().Stored().apply(LogEntry$StoredRecords$.MODULE$.apply(storeRecords, newState), (Option<HandlePollResult.PendingCommits>)pendingCommits));
                    }
                    if (!bl2) {
                        return Tuple2$.MODULE$.apply((Object)state, (Object)this.HandlePollResult().StateNotChanged().apply((Option<HandlePollResult.PendingCommits>)pendingCommits));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        }
        return Tuple2$.MODULE$.apply((Object)state, (Object)this.HandlePollResult().StateNotChanged().apply((Option<HandlePollResult.PendingCommits>)pendingCommits));
    }

    private final Tuple2 handlePendingCommits$1(boolean initialRebalancing$1, State state) {
        boolean currentRebalancing = state.rebalancing();
        if (initialRebalancing$1 && !currentRebalancing && state.pendingCommits().nonEmpty()) {
            State newState = state.withoutPendingCommits();
            return Tuple2$.MODULE$.apply(newState, (Object)Some$.MODULE$.apply((Object)this.HandlePollResult().PendingCommits().apply(state.pendingCommits(), LogEntry$CommittedPendingCommits$.MODULE$.apply(state.pendingCommits(), newState))));
        }
        return Tuple2$.MODULE$.apply((Object)state, (Object)None$.MODULE$);
    }

    private static final Object handlePoll$1$$anonfun$2$$anonfun$1(Logging logging$3, LogEntry.CompletedFetchesWithRecords log$1) {
        return logging$3.log(log$1);
    }

    private static final Object handlePoll$1$$anonfun$2$$anonfun$2(Logging logging$4, LogEntry.CompletedFetchesWithRecords completedLog$1) {
        return logging$4.log(completedLog$1);
    }

    private static final Object handlePoll$1$$anonfun$2$$anonfun$3(Logging logging$5, LogEntry.StoredRecords storedLog$1) {
        return logging$5.log(storedLog$1);
    }

    private static final Object handlePoll$1$$anonfun$2$$anonfun$4(ConcurrentEffect F$8, HandlePollResult result$1) {
        return implicits$.MODULE$.toFoldableOps(result$1.pendingCommits(), (Foldable)implicits$.MODULE$.catsStdInstancesForOption()).traverse_((Function1 & Serializable)_$34 -> _$34.commit(), (Applicative)F$8);
    }

    private final Object handlePoll$1(Ref ref$1, ConcurrentEffect F$6, Logging logging$1, scala.collection.immutable.Map newRecords, boolean initialRebalancing) {
        return implicits$.MODULE$.toFlatMapOps(ref$1.modify((Function1 & Serializable)state -> {
            Tuple2 tuple2 = this.handlePendingCommits$1(initialRebalancing, (State)state);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            State stateWithoutPendingCommits = (State)tuple2._1();
            Option pendingCommits = (Option)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)stateWithoutPendingCommits, (Object)pendingCommits);
            State stateWithoutPendingCommits2 = (State)tuple22._1();
            Option pendingCommits2 = (Option)tuple22._2();
            return this.handleBatch$1(F$6, newRecords, stateWithoutPendingCommits2, pendingCommits2);
        }), (FlatMap)F$6).flatMap((Function1 & Serializable)result -> {
            Object object;
            HandlePollResult handlePollResult = result;
            if (handlePollResult instanceof HandlePollResult.StateNotChanged && ((HandlePollResult.StateNotChanged)handlePollResult).fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$StateNotChanged$$$outer() == this.HandlePollResult()) {
                HandlePollResult.StateNotChanged stateNotChanged = this.HandlePollResult().StateNotChanged().unapply((HandlePollResult.StateNotChanged)handlePollResult);
                Option<HandlePollResult.PendingCommits> option = stateNotChanged._1();
                object = F$6.unit();
            } else if (handlePollResult instanceof HandlePollResult.Stored && ((HandlePollResult.Stored)handlePollResult).fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$Stored$$$outer() == this.HandlePollResult()) {
                HandlePollResult.Stored stored = this.HandlePollResult().Stored().unapply((HandlePollResult.Stored)handlePollResult);
                LogEntry.StoredRecords storedRecords = stored._1();
                Option<HandlePollResult.PendingCommits> option = stored._2();
                LogEntry.StoredRecords log = storedRecords;
                object = logging$1.log(log);
            } else if (handlePollResult instanceof HandlePollResult.Completed && ((HandlePollResult.Completed)handlePollResult).fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$Completed$$$outer() == this.HandlePollResult()) {
                HandlePollResult.Completed completed = this.HandlePollResult().Completed().unapply((HandlePollResult.Completed)handlePollResult);
                Object f = completed._1();
                LogEntry.CompletedFetchesWithRecords completedFetchesWithRecords = completed._2();
                Option<HandlePollResult.PendingCommits> option = completed._3();
                Object completeFetches = f;
                LogEntry.CompletedFetchesWithRecords log = completedFetchesWithRecords;
                Object object2 = implicits$.MODULE$.catsSyntaxFlatMapOps(completeFetches, (FlatMap)F$6);
                object = FlatMapOps$.MODULE$.$greater$greater$extension(object2, () -> KafkaConsumerActor.handlePoll$1$$anonfun$2$$anonfun$1(logging$1, log), (FlatMap)F$6);
            } else if (handlePollResult instanceof HandlePollResult.CompletedAndStored && ((HandlePollResult.CompletedAndStored)handlePollResult).fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$CompletedAndStored$$$outer() == this.HandlePollResult()) {
                HandlePollResult.CompletedAndStored completedAndStored = this.HandlePollResult().CompletedAndStored().unapply((HandlePollResult.CompletedAndStored)handlePollResult);
                Object f = completedAndStored._1();
                LogEntry.CompletedFetchesWithRecords completedFetchesWithRecords = completedAndStored._2();
                LogEntry.StoredRecords storedRecords = completedAndStored._3();
                Option<HandlePollResult.PendingCommits> option = completedAndStored._4();
                Object completeFetches = f;
                LogEntry.CompletedFetchesWithRecords completedLog = completedFetchesWithRecords;
                LogEntry.StoredRecords storedLog = storedRecords;
                Object object3 = implicits$.MODULE$.catsSyntaxFlatMapOps(completeFetches, (FlatMap)F$6);
                Object object4 = implicits$.MODULE$.catsSyntaxFlatMapOps(FlatMapOps$.MODULE$.$greater$greater$extension(object3, () -> KafkaConsumerActor.handlePoll$1$$anonfun$2$$anonfun$2(logging$1, completedLog), (FlatMap)F$6), (FlatMap)F$6);
                object = FlatMapOps$.MODULE$.$greater$greater$extension(object4, () -> KafkaConsumerActor.handlePoll$1$$anonfun$2$$anonfun$3(logging$1, storedLog), (FlatMap)F$6);
            } else {
                throw new MatchError((Object)handlePollResult);
            }
            Object object5 = implicits$.MODULE$.catsSyntaxFlatMapOps(object, (FlatMap)F$6);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object5, () -> KafkaConsumerActor.handlePoll$1$$anonfun$2$$anonfun$4(F$6, result), (FlatMap)F$6);
        });
    }

    private final Object storeFetch$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(TopicPartition partition$7, int streamId$6) {
        return this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$RevokedPreviousFetch$.MODULE$.apply(partition$7, streamId$6));
    }

    private final Object storeFetch$1$$anonfun$2$$anonfun$1(TopicPartition partition$5, int streamId$4, List oldFetches$1) {
        return implicits$.MODULE$.toFoldableOps((Object)oldFetches$1, (Foldable)implicits$.MODULE$.catsStdInstancesForList()).traverse_((Function1 & Serializable)fetch -> {
            Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(fetch.completeRevoked(Chunk$.MODULE$.empty()), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.storeFetch$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(partition$5, streamId$4), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        }, this.fs2$kafka$internal$KafkaConsumerActor$$F);
    }

    private final Object storeFetch$1(TopicPartition partition$2, int streamId$1, Function1 callback$1) {
        return implicits$.MODULE$.toFlatMapOps(this.ref.modify((Function1 & Serializable)state -> {
            Tuple2 tuple2 = state.withFetch(partition$2, streamId$1, callback$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            State newState = (State)tuple2._1();
            List oldFetch = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newState, (Object)oldFetch);
            State newState2 = (State)tuple22._1();
            List oldFetch2 = (List)tuple22._2();
            return Tuple2$.MODULE$.apply((Object)newState2, (Object)Tuple2$.MODULE$.apply((Object)newState2, (Object)oldFetch2));
        }), this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                State newState = (State)tuple2._1();
                List oldFetches = (List)tuple2._2();
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$StoredFetch$.MODULE$.apply(partition$2, callback$1, newState)), this.fs2$kafka$internal$KafkaConsumerActor$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.storeFetch$1$$anonfun$2$$anonfun$1(partition$2, streamId$1, oldFetches), this.fs2$kafka$internal$KafkaConsumerActor$$F);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Object completeRevoked$1(Function1 callback$4) {
        return callback$4.apply((Object)Tuple2$.MODULE$.apply((Object)Chunk$.MODULE$.empty(), (Object)KafkaConsumerActor$FetchCompletedReason$TopicPartitionRevoked$.MODULE$));
    }

    private final Object fetch$$anonfun$1(TopicPartition partition$11, int streamId$7, Function1 callback$11) {
        return this.storeFetch$1(partition$11, streamId$7, callback$11);
    }

    private static final Object fetch$$anonfun$2(Function1 callback$12) {
        return KafkaConsumerActor.completeRevoked$1(callback$12);
    }

    private static final void commitAsync$$anonfun$1$$anonfun$1$$anonfun$1() {
    }

    private static final void commitAsync$$anonfun$2$$anonfun$1(Function1 callback$8, Throwable e$1) {
        callback$8.apply((Object)package$.MODULE$.Left().apply((Object)e$1));
    }

    private static final Object assigned$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(SortedSet assigned$3, OnRebalance _$20$1) {
        return _$20$1.onAssigned().apply((Object)assigned$3);
    }

    private final Object assigned$$anonfun$2$$anonfun$1(SortedSet assigned$2, State state$3) {
        return state$3.onRebalances().foldLeft(this.fs2$kafka$internal$KafkaConsumerActor$$F.unit(), (Function2 & Serializable)(_$19, _$20) -> {
            Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(_$19, this.fs2$kafka$internal$KafkaConsumerActor$$F);
            return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> KafkaConsumerActor.assigned$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(assigned$2, _$20), this.fs2$kafka$internal$KafkaConsumerActor$$F);
        });
    }

    private static final Function1 withState$1() {
        return (Function1 & Serializable)_$21 -> package.StateT$.MODULE$.apply(_$21, (Applicative)Invariant$.MODULE$.catsInstancesForId());
    }

    private final Object $anonfun$10(scala.collection.immutable.Set withRecords$2, State st$2, State newState$1) {
        scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(st$2.records());
        return this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$RevokedFetchesWithRecords$.MODULE$.apply(syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map, withRecords$2), newState$1));
    }

    private final IndexedStateT completeWithRecords$3(scala.collection.immutable.Set withRecords) {
        return (IndexedStateT)KafkaConsumerActor.withState$1().apply((Function1 & Serializable)st -> {
            if (withRecords.nonEmpty()) {
                State newState = st.withoutFetchesAndRecords((scala.collection.immutable.Set<TopicPartition>)withRecords);
                scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(st.fetches());
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(implicits$.MODULE$.toTraverseOps(syntax$MapSyntax$.MODULE$.filterKeysStrictList$extension(map, withRecords), (Traverse)implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TopicPartition partition = (TopicPartition)tuple2._1();
                        scala.collection.immutable.Map partitionFetches = (scala.collection.immutable.Map)tuple2._2();
                        Chunk records = Chunk$.MODULE$.vector(((NonEmptyVector)st.records().apply((Object)partition)).toVector());
                        return implicits$.MODULE$.toTraverseOps((Object)partitionFetches.values().toList(), (Traverse)implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)_$22 -> _$22.completeRevoked(records), this.fs2$kafka$internal$KafkaConsumerActor$$F);
                    }
                    throw new MatchError((Object)tuple2);
                }, this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F);
                Object action = FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.$anonfun$10(withRecords, st, newState), this.fs2$kafka$internal$KafkaConsumerActor$$F);
                return Tuple2$.MODULE$.apply(newState, action);
            }
            return Tuple2$.MODULE$.apply(st, this.fs2$kafka$internal$KafkaConsumerActor$$F.unit());
        });
    }

    private final Object $anonfun$12(SortedSet withoutRecords$2, State newState$2) {
        return this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$RevokedFetchesWithoutRecords$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)withoutRecords$2, newState$2));
    }

    private final IndexedStateT completeWithoutRecords$2(SortedSet withoutRecords) {
        return (IndexedStateT)KafkaConsumerActor.withState$1().apply((Function1 & Serializable)st -> {
            if (withoutRecords.nonEmpty()) {
                State newState = st.withoutFetches((scala.collection.immutable.Set<TopicPartition>)withoutRecords);
                scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(st.fetches());
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(implicits$.MODULE$.toTraverseOps(syntax$MapSyntax$.MODULE$.filterKeysStrictValuesList$extension(map, withoutRecords), (Traverse)implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)_$23 -> implicits$.MODULE$.toTraverseOps((Object)_$23.values().toList(), (Traverse)implicits$.MODULE$.catsStdInstancesForList()).traverse((Function1 & Serializable)_$24 -> _$24.completeRevoked(Chunk$.MODULE$.empty()), this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F), this.fs2$kafka$internal$KafkaConsumerActor$$F);
                Object action = FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.$anonfun$12(withoutRecords, newState), this.fs2$kafka$internal$KafkaConsumerActor$$F);
                return Tuple2$.MODULE$.apply(newState, action);
            }
            return Tuple2$.MODULE$.apply(st, this.fs2$kafka$internal$KafkaConsumerActor$$F.unit());
        });
    }

    private final IndexedStateT removeRevokedRecords$1(SortedSet revokedNonFetches) {
        return (IndexedStateT)KafkaConsumerActor.withState$1().apply((Function1 & Serializable)st -> {
            if (revokedNonFetches.nonEmpty()) {
                scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(st.records());
                scala.collection.immutable.Map revokedRecords = syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map, revokedNonFetches);
                if (revokedRecords.nonEmpty()) {
                    State newState = st.withoutRecords((scala.collection.immutable.Set<TopicPartition>)revokedRecords.keySet());
                    F action = this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$RemovedRevokedRecords$.MODULE$.apply(revokedRecords, newState));
                    return Tuple2$.MODULE$.apply(newState, action);
                }
                return Tuple2$.MODULE$.apply(st, this.fs2$kafka$internal$KafkaConsumerActor$$F.unit());
            }
            return Tuple2$.MODULE$.apply(st, this.fs2$kafka$internal$KafkaConsumerActor$$F.unit());
        });
    }

    private static final Object $anonfun$13$$anonfun$1(SortedSet revoked$5, OnRebalance _$26$1) {
        return _$26$1.onRevoked().apply((Object)revoked$5);
    }

    private static final Object revoked$$anonfun$2$$anonfun$1(RevokedResult res$1) {
        return res$1.completeWithRecords();
    }

    private static final Object revoked$$anonfun$2$$anonfun$2(RevokedResult res$2) {
        return res$2.completeWithoutRecords();
    }

    private static final Object revoked$$anonfun$2$$anonfun$3(RevokedResult res$3) {
        return res$3.removeRevokedRecords();
    }

    private static final Object revoked$$anonfun$2$$anonfun$4(Object onRevoked$1) {
        return onRevoked$1;
    }

    private final Object resolveDeferred$1(Function1 callback$9, boolean subscribed) {
        F result = subscribed ? this.withConsumer.blocking((Function1 & Serializable)_$27 -> {
            Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(_$27.assignment());
            SortedSet sortedSet = (SortedSet)implicits$.MODULE$.catsSyntaxEitherId(syntax$JavaUtilCollectionSyntax$.MODULE$.toSortedSet$extension(collection, instances$.MODULE$.fs2KafkaTopicPartitionOrdering()));
            return EitherIdOps$.MODULE$.asRight$extension((Object)sortedSet);
        }) : this.fs2$kafka$internal$KafkaConsumerActor$$F.pure((Object)package$.MODULE$.Left().apply((Object)NotSubscribedException$.MODULE$.apply()));
        return implicits$.MODULE$.toFlatMapOps(result, this.fs2$kafka$internal$KafkaConsumerActor$$F).flatMap(callback$9);
    }

    private final Object assignment$$anonfun$2$$anonfun$1(OnRebalance on$3, State newState$3) {
        return this.fs2$kafka$internal$KafkaConsumerActor$$logging.log(LogEntry$StoredOnRebalance$.MODULE$.apply(on$3, newState$3));
    }

    public static abstract class FetchCompletedReason {
        public static int ordinal(FetchCompletedReason fetchCompletedReason) {
            return KafkaConsumerActor$FetchCompletedReason$.MODULE$.ordinal(fetchCompletedReason);
        }

        public final boolean topicPartitionRevoked() {
            FetchCompletedReason fetchCompletedReason = this;
            if (KafkaConsumerActor$FetchCompletedReason$TopicPartitionRevoked$.MODULE$.equals(fetchCompletedReason)) {
                return true;
            }
            if (KafkaConsumerActor$FetchCompletedReason$FetchedRecords$.MODULE$.equals(fetchCompletedReason)) {
                return false;
            }
            throw new MatchError((Object)fetchCompletedReason);
        }
    }

    public static final class FetchRequest<F, K, V>
    implements Product,
    Serializable {
        private final Function1 callback;

        public static <F, K, V> FetchRequest<F, K, V> apply(Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, Object> function1) {
            return KafkaConsumerActor$FetchRequest$.MODULE$.apply(function1);
        }

        public static FetchRequest<?, ?, ?> fromProduct(Product product) {
            return KafkaConsumerActor$FetchRequest$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> FetchRequest<F, K, V> unapply(FetchRequest<F, K, V> fetchRequest) {
            return KafkaConsumerActor$FetchRequest$.MODULE$.unapply(fetchRequest);
        }

        public FetchRequest(Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, Object> callback) {
            this.callback = callback;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FetchRequest)) return false;
            FetchRequest fetchRequest = (FetchRequest)object;
            Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, F> function1 = this.callback();
            Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, F> function12 = fetchRequest.callback();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof FetchRequest;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FetchRequest";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "callback";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, F> callback() {
            return this.callback;
        }

        public F completeRevoked(Chunk<CommittableConsumerRecord<F, K, V>> chunk) {
            return (F)this.callback().apply((Object)Tuple2$.MODULE$.apply(chunk, (Object)KafkaConsumerActor$FetchCompletedReason$TopicPartitionRevoked$.MODULE$));
        }

        public F completeRecords(Chunk<CommittableConsumerRecord<F, K, V>> chunk) {
            return (F)this.callback().apply((Object)Tuple2$.MODULE$.apply(chunk, (Object)KafkaConsumerActor$FetchCompletedReason$FetchedRecords$.MODULE$));
        }

        public String toString() {
            return new StringBuilder(13).append("FetchRequest$").append(System.identityHashCode(this)).toString();
        }

        public <F, K, V> FetchRequest<F, K, V> copy(Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, Object> callback) {
            return new FetchRequest<F, K, V>(callback);
        }

        public <F, K, V> Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, F> copy$default$1() {
            return this.callback();
        }

        public Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, F> _1() {
            return this.callback();
        }
    }

    public interface HandlePollResult {
        public Option<PendingCommits> pendingCommits();

        public class PendingCommits
        implements Product,
        Serializable {
            private final Chain commits;
            private final LogEntry.CommittedPendingCommits log;
            private final /* synthetic */ KafkaConsumerActor$HandlePollResult$ $outer;

            public PendingCommits(KafkaConsumerActor$HandlePollResult$ $outer, Chain<Request.Commit<F, K, V>> commits, LogEntry.CommittedPendingCommits<F, K, V> log) {
                this.commits = commits;
                this.log = log;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof PendingCommits)) return false;
                if (((PendingCommits)object).fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$PendingCommits$$$outer() != this.$outer) return false;
                PendingCommits pendingCommits = (PendingCommits)object;
                Chain chain = this.commits();
                Chain chain2 = pendingCommits.commits();
                if (chain == null) {
                    if (chain2 != null) {
                        return false;
                    }
                } else if (!chain.equals(chain2)) return false;
                LogEntry.CommittedPendingCommits committedPendingCommits = this.log();
                LogEntry.CommittedPendingCommits committedPendingCommits2 = pendingCommits.log();
                if (committedPendingCommits == null) {
                    if (committedPendingCommits2 != null) {
                        return false;
                    }
                } else if (!((Object)committedPendingCommits).equals(committedPendingCommits2)) return false;
                if (!pendingCommits.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof PendingCommits;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "PendingCommits";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "commits";
                }
                if (1 == n2) {
                    return "log";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Chain<Request.Commit<F, K, V>> commits() {
                return this.commits;
            }

            public LogEntry.CommittedPendingCommits<F, K, V> log() {
                return this.log;
            }

            public F commit() {
                Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(this.commits().foldLeft(this.$outer.fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$$$$outer().fs2$kafka$internal$KafkaConsumerActor$$F.unit(), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Object acc = tuple2._1();
                        Request.Commit commitRequest = (Request.Commit)tuple2._2();
                        Object object = implicits$.MODULE$.catsSyntaxFlatMapOps(acc, this.$outer.fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$$$$outer().fs2$kafka$internal$KafkaConsumerActor$$F);
                        return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.commit$$anonfun$3$$anonfun$1(commitRequest), this.$outer.fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$$$$outer().fs2$kafka$internal$KafkaConsumerActor$$F);
                    }
                    throw new MatchError((Object)tuple2);
                }), this.$outer.fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$$$$outer().fs2$kafka$internal$KafkaConsumerActor$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::commit$$anonfun$4, this.$outer.fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$$$$outer().fs2$kafka$internal$KafkaConsumerActor$$F);
            }

            public PendingCommits copy(Chain<Request.Commit<F, K, V>> commits, LogEntry.CommittedPendingCommits<F, K, V> log) {
                return new PendingCommits(this.$outer, commits, log);
            }

            public Chain<Request.Commit<F, K, V>> copy$default$1() {
                return this.commits();
            }

            public LogEntry.CommittedPendingCommits<F, K, V> copy$default$2() {
                return this.log();
            }

            public Chain<Request.Commit<F, K, V>> _1() {
                return this.commits();
            }

            public LogEntry.CommittedPendingCommits<F, K, V> _2() {
                return this.log();
            }

            public final /* synthetic */ KafkaConsumerActor$HandlePollResult$ fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$PendingCommits$$$outer() {
                return this.$outer;
            }

            private final Object commit$$anonfun$3$$anonfun$1(Request.Commit commitRequest$1) {
                return this.$outer.fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$$$$outer().fs2$kafka$internal$KafkaConsumerActor$$commitAsync(commitRequest$1.offsets(), commitRequest$1.callback());
            }

            private final Object commit$$anonfun$4() {
                return this.$outer.fs2$kafka$internal$KafkaConsumerActor$HandlePollResult$$$$outer().fs2$kafka$internal$KafkaConsumerActor$$logging.log(this.log());
            }
        }
    }

    public static final class OnRebalance<F, K, V>
    implements Product,
    Serializable {
        private final Function1 onAssigned;
        private final Function1 onRevoked;

        public static <F, K, V> OnRebalance<F, K, V> apply(Function1<SortedSet<TopicPartition>, Object> function1, Function1<SortedSet<TopicPartition>, Object> function12) {
            return KafkaConsumerActor$OnRebalance$.MODULE$.apply(function1, function12);
        }

        public static OnRebalance<?, ?, ?> fromProduct(Product product) {
            return KafkaConsumerActor$OnRebalance$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> OnRebalance<F, K, V> unapply(OnRebalance<F, K, V> onRebalance) {
            return KafkaConsumerActor$OnRebalance$.MODULE$.unapply(onRebalance);
        }

        public OnRebalance(Function1<SortedSet<TopicPartition>, Object> onAssigned, Function1<SortedSet<TopicPartition>, Object> onRevoked) {
            this.onAssigned = onAssigned;
            this.onRevoked = onRevoked;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnRebalance)) return false;
            OnRebalance onRebalance = (OnRebalance)object;
            Function1<SortedSet<TopicPartition>, F> function1 = this.onAssigned();
            Function1<SortedSet<TopicPartition>, F> function12 = onRebalance.onAssigned();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function1<SortedSet<TopicPartition>, F> function13 = this.onRevoked();
            Function1<SortedSet<TopicPartition>, F> function14 = onRebalance.onRevoked();
            if (function13 == null) {
                if (function14 == null) return true;
                return false;
            } else {
                if (!function13.equals(function14)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof OnRebalance;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OnRebalance";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "onAssigned";
            }
            if (1 == n2) {
                return "onRevoked";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<SortedSet<TopicPartition>, F> onAssigned() {
            return this.onAssigned;
        }

        public Function1<SortedSet<TopicPartition>, F> onRevoked() {
            return this.onRevoked;
        }

        public String toString() {
            return new StringBuilder(12).append("OnRebalance$").append(System.identityHashCode(this)).toString();
        }

        public <F, K, V> OnRebalance<F, K, V> copy(Function1<SortedSet<TopicPartition>, Object> onAssigned, Function1<SortedSet<TopicPartition>, Object> onRevoked) {
            return new OnRebalance<F, K, V>(onAssigned, onRevoked);
        }

        public <F, K, V> Function1<SortedSet<TopicPartition>, F> copy$default$1() {
            return this.onAssigned();
        }

        public <F, K, V> Function1<SortedSet<TopicPartition>, F> copy$default$2() {
            return this.onRevoked();
        }

        public Function1<SortedSet<TopicPartition>, F> _1() {
            return this.onAssigned();
        }

        public Function1<SortedSet<TopicPartition>, F> _2() {
            return this.onRevoked();
        }
    }

    public static abstract class Request<F, K, V> {
        public static int ordinal(Request<?, ?, ?> request) {
            return KafkaConsumerActor$Request$.MODULE$.ordinal(request);
        }

        public static <F, K, V> Poll<F, K, V> poll() {
            return KafkaConsumerActor$Request$.MODULE$.poll();
        }

        public static final class Poll<F, K, V>
        extends Request<F, K, V>
        implements Product,
        Serializable {
            public static <F, K, V> Poll<F, K, V> apply() {
                return KafkaConsumerActor$Request$Poll$.MODULE$.apply();
            }

            public static Poll<?, ?, ?> fromProduct(Product product) {
                return KafkaConsumerActor$Request$Poll$.MODULE$.fromProduct(product);
            }

            public static <F, K, V> boolean unapply(Poll<F, K, V> poll) {
                return KafkaConsumerActor$Request$Poll$.MODULE$.unapply(poll);
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Poll)) return false;
                Poll poll = (Poll)object;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Poll;
            }

            public int productArity() {
                return 0;
            }

            public String productPrefix() {
                return "Poll";
            }

            public Object productElement(int n) {
                int n2 = n;
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public <F, K, V> Poll<F, K, V> copy() {
                return new Poll<F, K, V>();
            }
        }
    }

    public class RevokedResult
    implements Product,
    Serializable {
        private final Object logRevoked;
        private final Object completeWithRecords;
        private final Object completeWithoutRecords;
        private final Object removeRevokedRecords;
        private final Chain onRebalances;
        private final /* synthetic */ KafkaConsumerActor $outer;

        public RevokedResult(KafkaConsumerActor $outer, F logRevoked, F completeWithRecords, F completeWithoutRecords, F removeRevokedRecords, Chain<OnRebalance<F, K, V>> onRebalances) {
            this.logRevoked = logRevoked;
            this.completeWithRecords = completeWithRecords;
            this.completeWithoutRecords = completeWithoutRecords;
            this.removeRevokedRecords = removeRevokedRecords;
            this.onRebalances = onRebalances;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedResult)) return false;
            if (((RevokedResult)object).fs2$kafka$internal$KafkaConsumerActor$RevokedResult$$$outer() != this.$outer) return false;
            RevokedResult revokedResult = (RevokedResult)object;
            if (!BoxesRunTime.equals(this.logRevoked(), revokedResult.logRevoked())) return false;
            if (!BoxesRunTime.equals(this.completeWithRecords(), revokedResult.completeWithRecords())) return false;
            if (!BoxesRunTime.equals(this.completeWithoutRecords(), revokedResult.completeWithoutRecords())) return false;
            if (!BoxesRunTime.equals(this.removeRevokedRecords(), revokedResult.removeRevokedRecords())) return false;
            Chain chain = this.onRebalances();
            Chain chain2 = revokedResult.onRebalances();
            if (chain == null) {
                if (chain2 != null) {
                    return false;
                }
            } else if (!chain.equals(chain2)) return false;
            if (!revokedResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedResult;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "RevokedResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "logRevoked";
                }
                case 1: {
                    return "completeWithRecords";
                }
                case 2: {
                    return "completeWithoutRecords";
                }
                case 3: {
                    return "removeRevokedRecords";
                }
                case 4: {
                    return "onRebalances";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public F logRevoked() {
            return this.logRevoked;
        }

        public F completeWithRecords() {
            return this.completeWithRecords;
        }

        public F completeWithoutRecords() {
            return this.completeWithoutRecords;
        }

        public F removeRevokedRecords() {
            return this.removeRevokedRecords;
        }

        public Chain<OnRebalance<F, K, V>> onRebalances() {
            return this.onRebalances;
        }

        public RevokedResult copy(F logRevoked, F completeWithRecords, F completeWithoutRecords, F removeRevokedRecords, Chain<OnRebalance<F, K, V>> onRebalances) {
            return new RevokedResult(this.$outer, logRevoked, completeWithRecords, completeWithoutRecords, removeRevokedRecords, onRebalances);
        }

        public F copy$default$1() {
            return this.logRevoked();
        }

        public F copy$default$2() {
            return this.completeWithRecords();
        }

        public F copy$default$3() {
            return this.completeWithoutRecords();
        }

        public F copy$default$4() {
            return this.removeRevokedRecords();
        }

        public Chain<OnRebalance<F, K, V>> copy$default$5() {
            return this.onRebalances();
        }

        public F _1() {
            return this.logRevoked();
        }

        public F _2() {
            return this.completeWithRecords();
        }

        public F _3() {
            return this.completeWithoutRecords();
        }

        public F _4() {
            return this.removeRevokedRecords();
        }

        public Chain<OnRebalance<F, K, V>> _5() {
            return this.onRebalances();
        }

        public final /* synthetic */ KafkaConsumerActor fs2$kafka$internal$KafkaConsumerActor$RevokedResult$$$outer() {
            return this.$outer;
        }
    }

    public static final class State<F, K, V>
    implements Product,
    Serializable {
        private final scala.collection.immutable.Map fetches;
        private final scala.collection.immutable.Map records;
        private final Chain pendingCommits;
        private final Chain onRebalances;
        private final boolean rebalancing;
        private final boolean subscribed;
        private final boolean streaming;

        public static <F, K, V> State<F, K, V> apply(scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map, scala.collection.immutable.Map<TopicPartition, Vector> map2, Chain<Request.Commit<F, K, V>> chain, Chain<OnRebalance<F, K, V>> chain2, boolean bl, boolean bl2, boolean bl3) {
            return KafkaConsumerActor$State$.MODULE$.apply(map, map2, chain, chain2, bl, bl2, bl3);
        }

        public static <F, K, V> State<F, K, V> empty() {
            return KafkaConsumerActor$State$.MODULE$.empty();
        }

        public static State<?, ?, ?> fromProduct(Product product) {
            return KafkaConsumerActor$State$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> State<F, K, V> unapply(State<F, K, V> state) {
            return KafkaConsumerActor$State$.MODULE$.unapply(state);
        }

        public State(scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> fetches, scala.collection.immutable.Map<TopicPartition, Vector> records, Chain<Request.Commit<F, K, V>> pendingCommits, Chain<OnRebalance<F, K, V>> onRebalances, boolean rebalancing, boolean subscribed, boolean streaming) {
            this.fetches = fetches;
            this.records = records;
            this.pendingCommits = pendingCommits;
            this.onRebalances = onRebalances;
            this.rebalancing = rebalancing;
            this.subscribed = subscribed;
            this.streaming = streaming;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.fetches()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.records()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.pendingCommits()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.onRebalances()));
            n = Statics.mix((int)n, (int)(this.rebalancing() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.subscribed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.streaming() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)7);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.rebalancing() != state.rebalancing()) return false;
            if (this.subscribed() != state.subscribed()) return false;
            if (this.streaming() != state.streaming()) return false;
            scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map = this.fetches();
            scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map2 = state.fetches();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            scala.collection.immutable.Map<TopicPartition, Vector> map3 = this.records();
            scala.collection.immutable.Map<TopicPartition, Vector> map4 = state.records();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            Chain<Request.Commit<F, K, V>> chain = this.pendingCommits();
            Chain<Request.Commit<F, K, V>> chain2 = state.pendingCommits();
            if (chain == null) {
                if (chain2 != null) {
                    return false;
                }
            } else if (!chain.equals(chain2)) return false;
            Chain<OnRebalance<F, K, V>> chain3 = this.onRebalances();
            Chain<OnRebalance<F, K, V>> chain4 = state.onRebalances();
            if (chain3 == null) {
                if (chain4 == null) return true;
                return false;
            } else {
                if (!chain3.equals(chain4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 7;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this._6());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this._7());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "fetches";
                }
                case 1: {
                    return "records";
                }
                case 2: {
                    return "pendingCommits";
                }
                case 3: {
                    return "onRebalances";
                }
                case 4: {
                    return "rebalancing";
                }
                case 5: {
                    return "subscribed";
                }
                case 6: {
                    return "streaming";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> fetches() {
            return this.fetches;
        }

        public scala.collection.immutable.Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public Chain<Request.Commit<F, K, V>> pendingCommits() {
            return this.pendingCommits;
        }

        public Chain<OnRebalance<F, K, V>> onRebalances() {
            return this.onRebalances;
        }

        public boolean rebalancing() {
            return this.rebalancing;
        }

        public boolean subscribed() {
            return this.subscribed;
        }

        public boolean streaming() {
            return this.streaming;
        }

        public State<F, K, V> withOnRebalance(OnRebalance<F, K, V> onRebalance) {
            Chain chain = this.onRebalances().append(onRebalance);
            scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map = this.copy$default$1();
            scala.collection.immutable.Map<TopicPartition, Vector> map2 = this.copy$default$2();
            Chain<Request.Commit<F, K, V>> chain2 = this.copy$default$3();
            boolean bl = this.copy$default$5();
            boolean bl2 = this.copy$default$6();
            boolean bl3 = this.copy$default$7();
            return this.copy(map, map2, chain2, chain, bl, bl2, bl3);
        }

        public Tuple2<State<F, K, V>, List<FetchRequest<F, K, V>>> withFetch(TopicPartition partition, int streamId, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, FetchCompletedReason>, F> callback) {
            FetchRequest<F, K, V> newFetchRequest = KafkaConsumerActor$FetchRequest$.MODULE$.apply(callback);
            scala.collection.immutable.Map oldPartitionFetches = (scala.collection.immutable.Map)this.fetches().getOrElse((Object)partition, this::$anonfun$15);
            scala.collection.immutable.Map newFetches = (scala.collection.immutable.Map)this.fetches().updated((Object)partition, (Object)oldPartitionFetches.updated((Object)BoxesRunTime.boxToInteger((int)streamId), newFetchRequest));
            List fetchesToRevoke = oldPartitionFetches.get((Object)BoxesRunTime.boxToInteger((int)streamId)).toList();
            return Tuple2$.MODULE$.apply(this.copy(newFetches, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7()), (Object)fetchesToRevoke);
        }

        public State<F, K, V> withoutFetches(scala.collection.immutable.Set<TopicPartition> partitions) {
            scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(this.fetches());
            return this.copy(syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map, (Function1 & Serializable)_$38 -> !partitions.contains(_$38)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        public State<F, K, V> withRecords(scala.collection.immutable.Map<TopicPartition, Vector> records) {
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)implicits$.MODULE$.catsSyntaxSemigroup(this.records(), (Semigroup)implicits$.MODULE$.catsKernelStdMonoidForMap(NonEmptyVector$.MODULE$.catsDataSemigroupForNonEmptyVector())).combine(records);
            scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map2 = this.copy$default$1();
            Chain<Request.Commit<F, K, V>> chain = this.copy$default$3();
            Chain<OnRebalance<F, K, V>> chain2 = this.copy$default$4();
            boolean bl = this.copy$default$5();
            boolean bl2 = this.copy$default$6();
            boolean bl3 = this.copy$default$7();
            return this.copy(map2, (scala.collection.immutable.Map<TopicPartition, Vector>)map, chain, chain2, bl, bl2, bl3);
        }

        public State<F, K, V> withoutFetchesAndRecords(scala.collection.immutable.Set<TopicPartition> partitions) {
            scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(this.fetches());
            scala.collection.immutable.Map map2 = syntax$.MODULE$.MapSyntax(this.records());
            return this.copy(syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map, (Function1 & Serializable)_$39 -> !partitions.contains(_$39)), syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map2, (Function1 & Serializable)_$40 -> !partitions.contains(_$40)), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7());
        }

        public State<F, K, V> withoutRecords(scala.collection.immutable.Set<TopicPartition> partitions) {
            scala.collection.immutable.Map map = syntax$.MODULE$.MapSyntax(this.records());
            scala.collection.immutable.Map map2 = syntax$MapSyntax$.MODULE$.filterKeysStrict$extension(map, (Function1 & Serializable)_$41 -> !partitions.contains(_$41));
            scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map3 = this.copy$default$1();
            Chain<Request.Commit<F, K, V>> chain = this.copy$default$3();
            Chain<OnRebalance<F, K, V>> chain2 = this.copy$default$4();
            boolean bl = this.copy$default$5();
            boolean bl2 = this.copy$default$6();
            boolean bl3 = this.copy$default$7();
            return this.copy(map3, map2, chain, chain2, bl, bl2, bl3);
        }

        public State<F, K, V> withPendingCommit(Request.Commit<F, K, V> pendingCommit) {
            Chain chain = this.pendingCommits().append(pendingCommit);
            scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map = this.copy$default$1();
            scala.collection.immutable.Map<TopicPartition, Vector> map2 = this.copy$default$2();
            Chain<OnRebalance<F, K, V>> chain2 = this.copy$default$4();
            boolean bl = this.copy$default$5();
            boolean bl2 = this.copy$default$6();
            boolean bl3 = this.copy$default$7();
            return this.copy(map, map2, chain, chain2, bl, bl2, bl3);
        }

        public State<F, K, V> withoutPendingCommits() {
            if (this.pendingCommits().isEmpty()) {
                return this;
            }
            Chain chain = Chain$.MODULE$.empty();
            scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> map = this.copy$default$1();
            scala.collection.immutable.Map<TopicPartition, Vector> map2 = this.copy$default$2();
            Chain<OnRebalance<F, K, V>> chain2 = this.copy$default$4();
            boolean bl = this.copy$default$5();
            boolean bl2 = this.copy$default$6();
            boolean bl3 = this.copy$default$7();
            return this.copy(map, map2, chain, chain2, bl, bl2, bl3);
        }

        public State<F, K, V> withRebalancing(boolean rebalancing) {
            if (this.rebalancing() == rebalancing) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), rebalancing, this.copy$default$6(), this.copy$default$7());
        }

        public State<F, K, V> asSubscribed() {
            if (this.subscribed()) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), true, this.copy$default$7());
        }

        public State<F, K, V> asUnsubscribed() {
            if (!this.subscribed()) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), false, this.copy$default$7());
        }

        public State<F, K, V> asStreaming() {
            if (this.streaming()) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), true);
        }

        public String toString() {
            List list = (List)syntax$.MODULE$.FoldableSyntax(this.fetches().toList().sortBy((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition tp = (TopicPartition)tuple2._1();
                    return tp;
                }
                throw new MatchError((Object)tuple2);
            }, instances$.MODULE$.fs2KafkaTopicPartitionOrdering()));
            String fetchesString = syntax$FoldableSyntax$.MODULE$.mkStringAppend$extension(list, (JProcedure2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Function1 append = (Function1)tuple2._1();
                    if (tuple22 != null) {
                        TopicPartition tp = (TopicPartition)tuple22._1();
                        scala.collection.immutable.Map fs = (scala.collection.immutable.Map)tuple22._2();
                        append.apply((Object)tp.toString());
                        append.apply((Object)" -> ");
                        append.apply((Object)fs.mkString("[", ", ", "]"));
                        return;
                    }
                }
                throw new MatchError((Object)tuple2);
            }, "", ", ", "", (Foldable)implicits$.MODULE$.catsStdInstancesForList());
            return new StringBuilder(120).append("State(fetches = Map(").append(fetchesString).append("), records = Map(").append(LogEntry$.MODULE$.recordsString(this.records())).append("), pendingCommits = ").append(this.pendingCommits()).append(", onRebalances = ").append(this.onRebalances()).append(", rebalancing = ").append(this.rebalancing()).append(", subscribed = ").append(this.subscribed()).append(", streaming = ").append(this.streaming()).append(")").toString();
        }

        public <F, K, V> State<F, K, V> copy(scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> fetches, scala.collection.immutable.Map<TopicPartition, Vector> records, Chain<Request.Commit<F, K, V>> pendingCommits, Chain<OnRebalance<F, K, V>> onRebalances, boolean rebalancing, boolean subscribed, boolean streaming) {
            return new State<F, K, V>(fetches, records, pendingCommits, onRebalances, rebalancing, subscribed, streaming);
        }

        public <F, K, V> scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> copy$default$1() {
            return this.fetches();
        }

        public <F, K, V> scala.collection.immutable.Map<TopicPartition, Vector> copy$default$2() {
            return this.records();
        }

        public <F, K, V> Chain<Request.Commit<F, K, V>> copy$default$3() {
            return this.pendingCommits();
        }

        public <F, K, V> Chain<OnRebalance<F, K, V>> copy$default$4() {
            return this.onRebalances();
        }

        public boolean copy$default$5() {
            return this.rebalancing();
        }

        public boolean copy$default$6() {
            return this.subscribed();
        }

        public boolean copy$default$7() {
            return this.streaming();
        }

        public scala.collection.immutable.Map<TopicPartition, scala.collection.immutable.Map<Object, FetchRequest<F, K, V>>> _1() {
            return this.fetches();
        }

        public scala.collection.immutable.Map<TopicPartition, Vector> _2() {
            return this.records();
        }

        public Chain<Request.Commit<F, K, V>> _3() {
            return this.pendingCommits();
        }

        public Chain<OnRebalance<F, K, V>> _4() {
            return this.onRebalances();
        }

        public boolean _5() {
            return this.rebalancing();
        }

        public boolean _6() {
            return this.subscribed();
        }

        public boolean _7() {
            return this.streaming();
        }

        private final scala.collection.immutable.Map $anonfun$15() {
            return Predef$.MODULE$.Map().empty();
        }
    }
}

