/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.internal;

import cats.Foldable;
import cats.data.Chain;
import cats.data.NonEmptyList;
import cats.data.NonEmptySetImpl$;
import cats.implicits$;
import fs2.Chunk;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.LogEntry$;
import fs2.kafka.internal.LogEntry$AssignedPartitions$;
import fs2.kafka.internal.LogEntry$CommittedPendingCommits$;
import fs2.kafka.internal.LogEntry$CompletedFetchesWithRecords$;
import fs2.kafka.internal.LogEntry$ManuallyAssignedPartitions$;
import fs2.kafka.internal.LogEntry$RemovedRevokedRecords$;
import fs2.kafka.internal.LogEntry$RevokedFetchesWithRecords$;
import fs2.kafka.internal.LogEntry$RevokedFetchesWithoutRecords$;
import fs2.kafka.internal.LogEntry$RevokedPartitions$;
import fs2.kafka.internal.LogEntry$RevokedPreviousFetch$;
import fs2.kafka.internal.LogEntry$StoredFetch$;
import fs2.kafka.internal.LogEntry$StoredOnRebalance$;
import fs2.kafka.internal.LogEntry$StoredPendingCommit$;
import fs2.kafka.internal.LogEntry$StoredRecords$;
import fs2.kafka.internal.LogEntry$SubscribedPattern$;
import fs2.kafka.internal.LogEntry$SubscribedTopics$;
import fs2.kafka.internal.LogEntry$Unsubscribed$;
import fs2.kafka.internal.LogLevel;
import fs2.kafka.internal.LogLevel$Debug$;
import fs2.kafka.internal.LogLevel$Warn$;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class LogEntry {
    public static int ordinal(LogEntry logEntry) {
        return LogEntry$.MODULE$.ordinal(logEntry);
    }

    public static <F, K, V> String recordsString(Map<TopicPartition, Vector> map) {
        return LogEntry$.MODULE$.recordsString(map);
    }

    public abstract LogLevel level();

    public abstract String message();

    public static final class AssignedPartitions<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final SortedSet partitions;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> AssignedPartitions<F, K, V> apply(SortedSet<TopicPartition> sortedSet, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$AssignedPartitions$.MODULE$.apply(sortedSet, state);
        }

        public static AssignedPartitions<?, ?, ?> fromProduct(Product product) {
            return LogEntry$AssignedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> AssignedPartitions<F, K, V> unapply(AssignedPartitions<F, K, V> assignedPartitions) {
            return LogEntry$AssignedPartitions$.MODULE$.unapply(assignedPartitions);
        }

        public AssignedPartitions(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, K, V> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AssignedPartitions)) return false;
            AssignedPartitions assignedPartitions = (AssignedPartitions)object;
            SortedSet<TopicPartition> sortedSet = this.partitions();
            SortedSet<TopicPartition> sortedSet2 = assignedPartitions.partitions();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = assignedPartitions.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AssignedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AssignedPartitions";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partitions";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SortedSet<TopicPartition> partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(41).append("Assigned partitions [").append(this.partitions().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> AssignedPartitions<F, K, V> copy(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, K, V> state) {
            return new AssignedPartitions<F, K, V>(partitions, state);
        }

        public <F, K, V> SortedSet<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public SortedSet<TopicPartition> _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class CommittedPendingCommits<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Chain pendingCommits;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> CommittedPendingCommits<F, K, V> apply(Chain<KafkaConsumerActor.Request.Commit<F, K, V>> chain, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$CommittedPendingCommits$.MODULE$.apply(chain, state);
        }

        public static CommittedPendingCommits<?, ?, ?> fromProduct(Product product) {
            return LogEntry$CommittedPendingCommits$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> CommittedPendingCommits<F, K, V> unapply(CommittedPendingCommits<F, K, V> committedPendingCommits) {
            return LogEntry$CommittedPendingCommits$.MODULE$.unapply(committedPendingCommits);
        }

        public CommittedPendingCommits(Chain<KafkaConsumerActor.Request.Commit<F, K, V>> pendingCommits, KafkaConsumerActor.State<F, K, V> state) {
            this.pendingCommits = pendingCommits;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommittedPendingCommits)) return false;
            CommittedPendingCommits committedPendingCommits = (CommittedPendingCommits)object;
            Chain<KafkaConsumerActor.Request.Commit<F, K, V>> chain = this.pendingCommits();
            Chain<KafkaConsumerActor.Request.Commit<F, K, V>> chain2 = committedPendingCommits.pendingCommits();
            if (chain == null) {
                if (chain2 != null) {
                    return false;
                }
            } else if (!chain.equals(chain2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = committedPendingCommits.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommittedPendingCommits;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CommittedPendingCommits";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingCommits";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chain<KafkaConsumerActor.Request.Commit<F, K, V>> pendingCommits() {
            return this.pendingCommits;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(47).append("Committed pending commits [").append(this.pendingCommits()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> CommittedPendingCommits<F, K, V> copy(Chain<KafkaConsumerActor.Request.Commit<F, K, V>> pendingCommits, KafkaConsumerActor.State<F, K, V> state) {
            return new CommittedPendingCommits<F, K, V>(pendingCommits, state);
        }

        public <F, K, V> Chain<KafkaConsumerActor.Request.Commit<F, K, V>> copy$default$1() {
            return this.pendingCommits();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Chain<KafkaConsumerActor.Request.Commit<F, K, V>> _1() {
            return this.pendingCommits();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class CompletedFetchesWithRecords<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> CompletedFetchesWithRecords<F, K, V> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$CompletedFetchesWithRecords$.MODULE$.apply(map, state);
        }

        public static CompletedFetchesWithRecords<?, ?, ?> fromProduct(Product product) {
            return LogEntry$CompletedFetchesWithRecords$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> CompletedFetchesWithRecords<F, K, V> unapply(CompletedFetchesWithRecords<F, K, V> completedFetchesWithRecords) {
            return LogEntry$CompletedFetchesWithRecords$.MODULE$.unapply(completedFetchesWithRecords);
        }

        public CompletedFetchesWithRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompletedFetchesWithRecords)) return false;
            CompletedFetchesWithRecords completedFetchesWithRecords = (CompletedFetchesWithRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = completedFetchesWithRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = completedFetchesWithRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CompletedFetchesWithRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CompletedFetchesWithRecords";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "records";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(67).append("Completed fetches with records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> CompletedFetchesWithRecords<F, K, V> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            return new CompletedFetchesWithRecords<F, K, V>(records, state);
        }

        public <F, K, V> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class ManuallyAssignedPartitions<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Object partitions;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> ManuallyAssignedPartitions<F, K, V> apply(Object object, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.apply(object, state);
        }

        public static ManuallyAssignedPartitions<?, ?, ?> fromProduct(Product product) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> ManuallyAssignedPartitions<F, K, V> unapply(ManuallyAssignedPartitions<F, K, V> manuallyAssignedPartitions) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.unapply(manuallyAssignedPartitions);
        }

        public ManuallyAssignedPartitions(Object partitions, KafkaConsumerActor.State<F, K, V> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ManuallyAssignedPartitions)) return false;
            ManuallyAssignedPartitions manuallyAssignedPartitions = (ManuallyAssignedPartitions)object;
            if (!BoxesRunTime.equals((Object)this.partitions(), (Object)manuallyAssignedPartitions.partitions())) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = manuallyAssignedPartitions.state();
            if (state != null) {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
            if (state2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ManuallyAssignedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ManuallyAssignedPartitions";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partitions";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(59).append("Consumer manually assigned partitions [").append(implicits$.MODULE$.toFoldableOps(this.partitions(), (Foldable)NonEmptySetImpl$.MODULE$.catsDataInstancesForNonEmptySet()).toList().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> ManuallyAssignedPartitions<F, K, V> copy(Object partitions, KafkaConsumerActor.State<F, K, V> state) {
            return new ManuallyAssignedPartitions<F, K, V>(partitions, state);
        }

        public <F, K, V> Object copy$default$1() {
            return this.partitions();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Object _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class RemovedRevokedRecords<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> RemovedRevokedRecords<F, K, V> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$RemovedRevokedRecords$.MODULE$.apply(map, state);
        }

        public static RemovedRevokedRecords<?, ?, ?> fromProduct(Product product) {
            return LogEntry$RemovedRevokedRecords$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> RemovedRevokedRecords<F, K, V> unapply(RemovedRevokedRecords<F, K, V> removedRevokedRecords) {
            return LogEntry$RemovedRevokedRecords$.MODULE$.unapply(removedRevokedRecords);
        }

        public RemovedRevokedRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RemovedRevokedRecords)) return false;
            RemovedRevokedRecords removedRevokedRecords = (RemovedRevokedRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = removedRevokedRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = removedRevokedRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RemovedRevokedRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RemovedRevokedRecords";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "records";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(60).append("Removed revoked records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> RemovedRevokedRecords<F, K, V> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            return new RemovedRevokedRecords<F, K, V>(records, state);
        }

        public <F, K, V> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class RevokedFetchesWithRecords<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> RevokedFetchesWithRecords<F, K, V> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$RevokedFetchesWithRecords$.MODULE$.apply(map, state);
        }

        public static RevokedFetchesWithRecords<?, ?, ?> fromProduct(Product product) {
            return LogEntry$RevokedFetchesWithRecords$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> RevokedFetchesWithRecords<F, K, V> unapply(RevokedFetchesWithRecords<F, K, V> revokedFetchesWithRecords) {
            return LogEntry$RevokedFetchesWithRecords$.MODULE$.unapply(revokedFetchesWithRecords);
        }

        public RevokedFetchesWithRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedFetchesWithRecords)) return false;
            RevokedFetchesWithRecords revokedFetchesWithRecords = (RevokedFetchesWithRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = revokedFetchesWithRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = revokedFetchesWithRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedFetchesWithRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedFetchesWithRecords";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "records";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(65).append("Revoked fetches with records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> RevokedFetchesWithRecords<F, K, V> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            return new RevokedFetchesWithRecords<F, K, V>(records, state);
        }

        public <F, K, V> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class RevokedFetchesWithoutRecords<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Set partitions;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> RevokedFetchesWithoutRecords<F, K, V> apply(Set<TopicPartition> set, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$RevokedFetchesWithoutRecords$.MODULE$.apply(set, state);
        }

        public static RevokedFetchesWithoutRecords<?, ?, ?> fromProduct(Product product) {
            return LogEntry$RevokedFetchesWithoutRecords$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> RevokedFetchesWithoutRecords<F, K, V> unapply(RevokedFetchesWithoutRecords<F, K, V> revokedFetchesWithoutRecords) {
            return LogEntry$RevokedFetchesWithoutRecords$.MODULE$.unapply(revokedFetchesWithoutRecords);
        }

        public RevokedFetchesWithoutRecords(Set<TopicPartition> partitions, KafkaConsumerActor.State<F, K, V> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedFetchesWithoutRecords)) return false;
            RevokedFetchesWithoutRecords revokedFetchesWithoutRecords = (RevokedFetchesWithoutRecords)object;
            Set<TopicPartition> set = this.partitions();
            Set<TopicPartition> set2 = revokedFetchesWithoutRecords.partitions();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = revokedFetchesWithoutRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedFetchesWithoutRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedFetchesWithoutRecords";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partitions";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<TopicPartition> partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(68).append("Revoked fetches without records for partitions [").append(this.partitions().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> RevokedFetchesWithoutRecords<F, K, V> copy(Set<TopicPartition> partitions, KafkaConsumerActor.State<F, K, V> state) {
            return new RevokedFetchesWithoutRecords<F, K, V>(partitions, state);
        }

        public <F, K, V> Set<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Set<TopicPartition> _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class RevokedPartitions<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final SortedSet partitions;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> RevokedPartitions<F, K, V> apply(SortedSet<TopicPartition> sortedSet, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$RevokedPartitions$.MODULE$.apply(sortedSet, state);
        }

        public static RevokedPartitions<?, ?, ?> fromProduct(Product product) {
            return LogEntry$RevokedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> RevokedPartitions<F, K, V> unapply(RevokedPartitions<F, K, V> revokedPartitions) {
            return LogEntry$RevokedPartitions$.MODULE$.unapply(revokedPartitions);
        }

        public RevokedPartitions(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, K, V> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedPartitions)) return false;
            RevokedPartitions revokedPartitions = (RevokedPartitions)object;
            SortedSet<TopicPartition> sortedSet = this.partitions();
            SortedSet<TopicPartition> sortedSet2 = revokedPartitions.partitions();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = revokedPartitions.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedPartitions";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partitions";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SortedSet<TopicPartition> partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(40).append("Revoked partitions [").append(this.partitions().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> RevokedPartitions<F, K, V> copy(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, K, V> state) {
            return new RevokedPartitions<F, K, V>(partitions, state);
        }

        public <F, K, V> SortedSet<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public SortedSet<TopicPartition> _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class RevokedPreviousFetch
    extends LogEntry
    implements Product,
    Serializable {
        private final TopicPartition partition;
        private final int streamId;

        public static RevokedPreviousFetch apply(TopicPartition topicPartition, int n) {
            return LogEntry$RevokedPreviousFetch$.MODULE$.apply(topicPartition, n);
        }

        public static RevokedPreviousFetch fromProduct(Product product) {
            return LogEntry$RevokedPreviousFetch$.MODULE$.fromProduct(product);
        }

        public static RevokedPreviousFetch unapply(RevokedPreviousFetch revokedPreviousFetch) {
            return LogEntry$RevokedPreviousFetch$.MODULE$.unapply(revokedPreviousFetch);
        }

        public RevokedPreviousFetch(TopicPartition partition, int streamId) {
            this.partition = partition;
            this.streamId = streamId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.partition()));
            n = Statics.mix((int)n, (int)this.streamId());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedPreviousFetch)) return false;
            RevokedPreviousFetch revokedPreviousFetch = (RevokedPreviousFetch)object;
            TopicPartition topicPartition = this.partition();
            TopicPartition topicPartition2 = revokedPreviousFetch.partition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (this.streamId() != revokedPreviousFetch.streamId()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedPreviousFetch;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedPreviousFetch";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partition";
            }
            if (1 == n2) {
                return "streamId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TopicPartition partition() {
            return this.partition;
        }

        public int streamId() {
            return this.streamId;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Warn$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(61).append("Revoked previous fetch for partition [").append(this.partition()).append("] in stream with id [").append(this.streamId()).append("].").toString();
        }

        public RevokedPreviousFetch copy(TopicPartition partition, int streamId) {
            return new RevokedPreviousFetch(partition, streamId);
        }

        public TopicPartition copy$default$1() {
            return this.partition();
        }

        public int copy$default$2() {
            return this.streamId();
        }

        public TopicPartition _1() {
            return this.partition();
        }

        public int _2() {
            return this.streamId();
        }
    }

    public static final class StoredFetch<F, K, V, A>
    extends LogEntry
    implements Product,
    Serializable {
        private final TopicPartition partition;
        private final Function1 callback;
        private final KafkaConsumerActor.State state;

        public static <F, K, V, A> StoredFetch<F, K, V, A> apply(TopicPartition topicPartition, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, Object> function1, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$StoredFetch$.MODULE$.apply(topicPartition, function1, state);
        }

        public static StoredFetch<?, ?, ?, ?> fromProduct(Product product) {
            return LogEntry$StoredFetch$.MODULE$.fromProduct(product);
        }

        public static <F, K, V, A> StoredFetch<F, K, V, A> unapply(StoredFetch<F, K, V, A> storedFetch) {
            return LogEntry$StoredFetch$.MODULE$.unapply(storedFetch);
        }

        public StoredFetch(TopicPartition partition, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, Object> callback, KafkaConsumerActor.State<F, K, V> state) {
            this.partition = partition;
            this.callback = callback;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredFetch)) return false;
            StoredFetch storedFetch = (StoredFetch)object;
            TopicPartition topicPartition = this.partition();
            TopicPartition topicPartition2 = storedFetch.partition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> function1 = this.callback();
            Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> function12 = storedFetch.callback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = storedFetch.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredFetch;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "StoredFetch";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "partition";
                }
                case 1: {
                    return "callback";
                }
                case 2: {
                    return "state";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public TopicPartition partition() {
            return this.partition;
        }

        public Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> callback() {
            return this.callback;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(51).append("Stored fetch [").append(this.callback()).append("] for partition [").append(this.partition()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V, A> StoredFetch<F, K, V, A> copy(TopicPartition partition, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, Object> callback, KafkaConsumerActor.State<F, K, V> state) {
            return new StoredFetch<F, K, V, A>(partition, callback, state);
        }

        public <F, K, V, A> TopicPartition copy$default$1() {
            return this.partition();
        }

        public <F, K, V, A> Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> copy$default$2() {
            return this.callback();
        }

        public <F, K, V, A> KafkaConsumerActor.State<F, K, V> copy$default$3() {
            return this.state();
        }

        public TopicPartition _1() {
            return this.partition();
        }

        public Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> _2() {
            return this.callback();
        }

        public KafkaConsumerActor.State<F, K, V> _3() {
            return this.state();
        }
    }

    public static final class StoredOnRebalance<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.OnRebalance onRebalance;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> StoredOnRebalance<F, K, V> apply(KafkaConsumerActor.OnRebalance<F, K, V> onRebalance, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$StoredOnRebalance$.MODULE$.apply(onRebalance, state);
        }

        public static StoredOnRebalance<?, ?, ?> fromProduct(Product product) {
            return LogEntry$StoredOnRebalance$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> StoredOnRebalance<F, K, V> unapply(StoredOnRebalance<F, K, V> storedOnRebalance) {
            return LogEntry$StoredOnRebalance$.MODULE$.unapply(storedOnRebalance);
        }

        public StoredOnRebalance(KafkaConsumerActor.OnRebalance<F, K, V> onRebalance, KafkaConsumerActor.State<F, K, V> state) {
            this.onRebalance = onRebalance;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredOnRebalance)) return false;
            StoredOnRebalance storedOnRebalance = (StoredOnRebalance)object;
            KafkaConsumerActor.OnRebalance<F, K, V> onRebalance = this.onRebalance();
            KafkaConsumerActor.OnRebalance<F, K, V> onRebalance2 = storedOnRebalance.onRebalance();
            if (onRebalance == null) {
                if (onRebalance2 != null) {
                    return false;
                }
            } else if (!((Object)onRebalance).equals(onRebalance2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = storedOnRebalance.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredOnRebalance;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredOnRebalance";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "onRebalance";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumerActor.OnRebalance<F, K, V> onRebalance() {
            return this.onRebalance;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(40).append("Stored OnRebalance [").append(this.onRebalance()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> StoredOnRebalance<F, K, V> copy(KafkaConsumerActor.OnRebalance<F, K, V> onRebalance, KafkaConsumerActor.State<F, K, V> state) {
            return new StoredOnRebalance<F, K, V>(onRebalance, state);
        }

        public <F, K, V> KafkaConsumerActor.OnRebalance<F, K, V> copy$default$1() {
            return this.onRebalance();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public KafkaConsumerActor.OnRebalance<F, K, V> _1() {
            return this.onRebalance();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class StoredPendingCommit<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.Request.Commit commit;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> StoredPendingCommit<F, K, V> apply(KafkaConsumerActor.Request.Commit<F, K, V> commit, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$StoredPendingCommit$.MODULE$.apply(commit, state);
        }

        public static StoredPendingCommit<?, ?, ?> fromProduct(Product product) {
            return LogEntry$StoredPendingCommit$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> StoredPendingCommit<F, K, V> unapply(StoredPendingCommit<F, K, V> storedPendingCommit) {
            return LogEntry$StoredPendingCommit$.MODULE$.unapply(storedPendingCommit);
        }

        public StoredPendingCommit(KafkaConsumerActor.Request.Commit<F, K, V> commit, KafkaConsumerActor.State<F, K, V> state) {
            this.commit = commit;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredPendingCommit)) return false;
            StoredPendingCommit storedPendingCommit = (StoredPendingCommit)object;
            KafkaConsumerActor.Request.Commit<F, K, V> commit = this.commit();
            KafkaConsumerActor.Request.Commit<F, K, V> commit2 = storedPendingCommit.commit();
            if (commit == null) {
                if (commit2 != null) {
                    return false;
                }
            } else if (!((Object)commit).equals(commit2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = storedPendingCommit.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredPendingCommit;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredPendingCommit";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "commit";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumerActor.Request.Commit<F, K, V> commit() {
            return this.commit;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(71).append("Stored pending commit [").append(this.commit()).append("] as rebalance is in-progress. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> StoredPendingCommit<F, K, V> copy(KafkaConsumerActor.Request.Commit<F, K, V> commit, KafkaConsumerActor.State<F, K, V> state) {
            return new StoredPendingCommit<F, K, V>(commit, state);
        }

        public <F, K, V> KafkaConsumerActor.Request.Commit<F, K, V> copy$default$1() {
            return this.commit();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public KafkaConsumerActor.Request.Commit<F, K, V> _1() {
            return this.commit();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class StoredRecords<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> StoredRecords<F, K, V> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$StoredRecords$.MODULE$.apply(map, state);
        }

        public static StoredRecords<?, ?, ?> fromProduct(Product product) {
            return LogEntry$StoredRecords$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> StoredRecords<F, K, V> unapply(StoredRecords<F, K, V> storedRecords) {
            return LogEntry$StoredRecords$.MODULE$.unapply(storedRecords);
        }

        public StoredRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredRecords)) return false;
            StoredRecords storedRecords = (StoredRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = storedRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = storedRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredRecords";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "records";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(51).append("Stored records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> StoredRecords<F, K, V> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, K, V> state) {
            return new StoredRecords<F, K, V>(records, state);
        }

        public <F, K, V> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class SubscribedPattern<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Pattern pattern;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> SubscribedPattern<F, K, V> apply(Pattern pattern, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$SubscribedPattern$.MODULE$.apply(pattern, state);
        }

        public static SubscribedPattern<?, ?, ?> fromProduct(Product product) {
            return LogEntry$SubscribedPattern$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> SubscribedPattern<F, K, V> unapply(SubscribedPattern<F, K, V> subscribedPattern) {
            return LogEntry$SubscribedPattern$.MODULE$.unapply(subscribedPattern);
        }

        public SubscribedPattern(Pattern pattern, KafkaConsumerActor.State<F, K, V> state) {
            this.pattern = pattern;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribedPattern)) return false;
            SubscribedPattern subscribedPattern = (SubscribedPattern)object;
            Pattern pattern = this.pattern();
            Pattern pattern2 = subscribedPattern.pattern();
            if (pattern == null) {
                if (pattern2 != null) {
                    return false;
                }
            } else if (!pattern.equals(pattern2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = subscribedPattern.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubscribedPattern;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubscribedPattern";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pattern";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Pattern pattern() {
            return this.pattern;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(52).append("Consumer subscribed to pattern [").append(this.pattern()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> SubscribedPattern<F, K, V> copy(Pattern pattern, KafkaConsumerActor.State<F, K, V> state) {
            return new SubscribedPattern<F, K, V>(pattern, state);
        }

        public <F, K, V> Pattern copy$default$1() {
            return this.pattern();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public Pattern _1() {
            return this.pattern();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class SubscribedTopics<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final NonEmptyList topics;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> SubscribedTopics<F, K, V> apply(NonEmptyList<String> nonEmptyList, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$SubscribedTopics$.MODULE$.apply(nonEmptyList, state);
        }

        public static SubscribedTopics<?, ?, ?> fromProduct(Product product) {
            return LogEntry$SubscribedTopics$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> SubscribedTopics<F, K, V> unapply(SubscribedTopics<F, K, V> subscribedTopics) {
            return LogEntry$SubscribedTopics$.MODULE$.unapply(subscribedTopics);
        }

        public SubscribedTopics(NonEmptyList<String> topics, KafkaConsumerActor.State<F, K, V> state) {
            this.topics = topics;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribedTopics)) return false;
            SubscribedTopics subscribedTopics = (SubscribedTopics)object;
            NonEmptyList<String> nonEmptyList = this.topics();
            NonEmptyList<String> nonEmptyList2 = subscribedTopics.topics();
            if (nonEmptyList == null) {
                if (nonEmptyList2 != null) {
                    return false;
                }
            } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = subscribedTopics.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubscribedTopics;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubscribedTopics";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "topics";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public NonEmptyList<String> topics() {
            return this.topics;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(51).append("Consumer subscribed to topics [").append(this.topics().toList().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> SubscribedTopics<F, K, V> copy(NonEmptyList<String> topics, KafkaConsumerActor.State<F, K, V> state) {
            return new SubscribedTopics<F, K, V>(topics, state);
        }

        public <F, K, V> NonEmptyList<String> copy$default$1() {
            return this.topics();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$2() {
            return this.state();
        }

        public NonEmptyList<String> _1() {
            return this.topics();
        }

        public KafkaConsumerActor.State<F, K, V> _2() {
            return this.state();
        }
    }

    public static final class Unsubscribed<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.State state;

        public static <F, K, V> Unsubscribed<F, K, V> apply(KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$Unsubscribed$.MODULE$.apply(state);
        }

        public static Unsubscribed<?, ?, ?> fromProduct(Product product) {
            return LogEntry$Unsubscribed$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> Unsubscribed<F, K, V> unapply(Unsubscribed<F, K, V> unsubscribed) {
            return LogEntry$Unsubscribed$.MODULE$.unapply(unsubscribed);
        }

        public Unsubscribed(KafkaConsumerActor.State<F, K, V> state) {
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unsubscribed)) return false;
            Unsubscribed unsubscribed = (Unsubscribed)object;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = unsubscribed.state();
            if (state != null) {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
            if (state2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Unsubscribed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Unsubscribed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(60).append("Consumer unsubscribed from all partitions. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> Unsubscribed<F, K, V> copy(KafkaConsumerActor.State<F, K, V> state) {
            return new Unsubscribed<F, K, V>(state);
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$1() {
            return this.state();
        }

        public KafkaConsumerActor.State<F, K, V> _1() {
            return this.state();
        }
    }
}

