/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Show;
import fs2.kafka.AdminClientSettings$;
import fs2.kafka.AdminClientSettings$AdminClientSettingsImpl$;
import fs2.kafka.security.KafkaCredentialStore;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class AdminClientSettings {
    public static <F> Show<AdminClientSettings> adminClientSettingsShow() {
        return AdminClientSettings$.MODULE$.adminClientSettingsShow();
    }

    public static AdminClientSettings apply() {
        return AdminClientSettings$.MODULE$.apply();
    }

    public static AdminClientSettings apply(String string) {
        return AdminClientSettings$.MODULE$.apply(string);
    }

    public static int ordinal(AdminClientSettings adminClientSettings) {
        return AdminClientSettings$.MODULE$.ordinal(adminClientSettings);
    }

    public abstract Map<String, String> properties();

    public abstract AdminClientSettings withBootstrapServers(String var1);

    public abstract AdminClientSettings withClientId(String var1);

    public abstract AdminClientSettings withReconnectBackoff(FiniteDuration var1);

    public abstract AdminClientSettings withReconnectBackoffMax(FiniteDuration var1);

    public abstract AdminClientSettings withRetryBackoff(FiniteDuration var1);

    public abstract AdminClientSettings withConnectionsMaxIdle(FiniteDuration var1);

    public abstract AdminClientSettings withRequestTimeout(FiniteDuration var1);

    public abstract AdminClientSettings withMetadataMaxAge(FiniteDuration var1);

    public abstract AdminClientSettings withRetries(int var1);

    public abstract AdminClientSettings withProperty(String var1, String var2);

    public abstract AdminClientSettings withProperties(Seq<Tuple2<String, String>> var1);

    public abstract AdminClientSettings withProperties(Map<String, String> var1);

    public abstract FiniteDuration closeTimeout();

    public abstract AdminClientSettings withCloseTimeout(FiniteDuration var1);

    public abstract AdminClientSettings withCredentials(KafkaCredentialStore var1);

    private static final class AdminClientSettingsImpl
    extends AdminClientSettings
    implements Product,
    Serializable {
        private final Map properties;
        private final FiniteDuration closeTimeout;

        public static AdminClientSettingsImpl apply(Map<String, String> map, FiniteDuration finiteDuration) {
            return AdminClientSettings$AdminClientSettingsImpl$.MODULE$.apply(map, finiteDuration);
        }

        public static AdminClientSettingsImpl fromProduct(Product product) {
            return AdminClientSettings$AdminClientSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static AdminClientSettingsImpl unapply(AdminClientSettingsImpl adminClientSettingsImpl) {
            return AdminClientSettings$AdminClientSettingsImpl$.MODULE$.unapply(adminClientSettingsImpl);
        }

        public AdminClientSettingsImpl(Map<String, String> properties, FiniteDuration closeTimeout) {
            this.properties = properties;
            this.closeTimeout = closeTimeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AdminClientSettingsImpl)) return false;
            AdminClientSettingsImpl adminClientSettingsImpl = (AdminClientSettingsImpl)object;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = adminClientSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            FiniteDuration finiteDuration = this.closeTimeout();
            FiniteDuration finiteDuration2 = adminClientSettingsImpl.closeTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof AdminClientSettingsImpl;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AdminClientSettingsImpl";
        }

        public Object productElement(int n) {
            FiniteDuration finiteDuration;
            int n2 = n;
            if (0 == n2) {
                finiteDuration = this._1();
            } else if (1 == n2) {
                finiteDuration = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return finiteDuration;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "properties";
            } else if (1 == n2) {
                string = "closeTimeout";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        @Override
        public FiniteDuration closeTimeout() {
            return this.closeTimeout;
        }

        @Override
        public AdminClientSettings withBootstrapServers(String bootstrapServers) {
            return this.withProperty("bootstrap.servers", bootstrapServers);
        }

        @Override
        public AdminClientSettings withClientId(String clientId) {
            return this.withProperty("client.id", clientId);
        }

        @Override
        public AdminClientSettings withReconnectBackoff(FiniteDuration reconnectBackoff) {
            return this.withProperty("reconnect.backoff.ms", BoxesRunTime.boxToLong((long)reconnectBackoff.toMillis()).toString());
        }

        @Override
        public AdminClientSettings withReconnectBackoffMax(FiniteDuration reconnectBackoffMax) {
            return this.withProperty("reconnect.backoff.max.ms", BoxesRunTime.boxToLong((long)reconnectBackoffMax.toMillis()).toString());
        }

        @Override
        public AdminClientSettings withRetryBackoff(FiniteDuration retryBackoff) {
            return this.withProperty("retry.backoff.ms", BoxesRunTime.boxToLong((long)retryBackoff.toMillis()).toString());
        }

        @Override
        public AdminClientSettings withConnectionsMaxIdle(FiniteDuration connectionsMaxIdle) {
            return this.withProperty("connections.max.idle.ms", BoxesRunTime.boxToLong((long)connectionsMaxIdle.toMillis()).toString());
        }

        @Override
        public AdminClientSettings withRequestTimeout(FiniteDuration requestTimeout) {
            return this.withProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)requestTimeout.toMillis()).toString());
        }

        @Override
        public AdminClientSettings withMetadataMaxAge(FiniteDuration metadataMaxAge) {
            return this.withProperty("metadata.max.age.ms", BoxesRunTime.boxToLong((long)metadataMaxAge.toMillis()).toString());
        }

        @Override
        public AdminClientSettings withRetries(int retries) {
            return this.withProperty("retries", BoxesRunTime.boxToInteger((int)retries).toString());
        }

        @Override
        public AdminClientSettings withProperty(String key, String value) {
            return this.copy((Map<String, String>)((Map)this.properties().updated((Object)key, (Object)value)), this.copy$default$2());
        }

        @Override
        public AdminClientSettings withProperties(Seq<Tuple2<String, String>> properties) {
            return this.copy((Map<String, String>)((Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))), this.copy$default$2());
        }

        @Override
        public AdminClientSettings withProperties(Map<String, String> properties) {
            return this.copy((Map<String, String>)((Map)this.properties().$plus$plus(properties)), this.copy$default$2());
        }

        @Override
        public AdminClientSettings withCloseTimeout(FiniteDuration closeTimeout) {
            return this.copy(this.copy$default$1(), closeTimeout);
        }

        @Override
        public AdminClientSettings withCredentials(KafkaCredentialStore credentialsStore) {
            return this.withProperties(credentialsStore.properties());
        }

        public String toString() {
            return new StringBuilder(36).append("AdminClientSettings(closeTimeout = ").append(this.closeTimeout()).append(")").toString();
        }

        public AdminClientSettingsImpl copy(Map<String, String> properties, FiniteDuration closeTimeout) {
            return new AdminClientSettingsImpl(properties, closeTimeout);
        }

        public Map<String, String> copy$default$1() {
            return this.properties();
        }

        public FiniteDuration copy$default$2() {
            return this.closeTimeout();
        }

        public Map<String, String> _1() {
            return this.properties();
        }

        public FiniteDuration _2() {
            return this.closeTimeout();
        }
    }
}

