/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Apply;
import cats.Bitraverse;
import cats.Show;
import cats.Traverse;
import cats.kernel.Eq;
import fs2.kafka.ConsumerRecord$;
import fs2.kafka.ConsumerRecord$ConsumerRecordImpl$;
import fs2.kafka.Deserializer;
import fs2.kafka.Headers;
import fs2.kafka.Timestamp;
import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ConsumerRecord<K, V> {
    public static <K, V> ConsumerRecord<K, V> apply(String string, int n, long l, K k, V v) {
        return ConsumerRecord$.MODULE$.apply(string, n, l, k, v);
    }

    public static Bitraverse<ConsumerRecord> consumerRecordBitraverse() {
        return ConsumerRecord$.MODULE$.consumerRecordBitraverse();
    }

    public static <K, V> Eq<ConsumerRecord<K, V>> consumerRecordEq(Eq<K> eq2, Eq<V> eq3) {
        return ConsumerRecord$.MODULE$.consumerRecordEq(eq2, eq3);
    }

    public static <K, V> Show<ConsumerRecord<K, V>> consumerRecordShow(Show<K> show, Show<V> show2) {
        return ConsumerRecord$.MODULE$.consumerRecordShow(show, show2);
    }

    public static <K> Traverse<ConsumerRecord> consumerRecordTraverse() {
        return ConsumerRecord$.MODULE$.consumerRecordTraverse();
    }

    public static <F, K, V> Object fromJava(org.apache.kafka.clients.consumer.ConsumerRecord<byte[], byte[]> consumerRecord, Deserializer<F, K> deserializer, Deserializer<F, V> deserializer2, Apply<F> apply) {
        return ConsumerRecord$.MODULE$.fromJava(consumerRecord, deserializer, deserializer2, apply);
    }

    public static int ordinal(ConsumerRecord<?, ?> consumerRecord) {
        return ConsumerRecord$.MODULE$.ordinal(consumerRecord);
    }

    public abstract String topic();

    public abstract int partition();

    public abstract long offset();

    public abstract K key();

    public abstract V value();

    public abstract Headers headers();

    public abstract Timestamp timestamp();

    public abstract Option<Object> serializedKeySize();

    public abstract Option<Object> serializedValueSize();

    public abstract Option<Object> leaderEpoch();

    public abstract ConsumerRecord<K, V> withHeaders(Headers var1);

    public abstract ConsumerRecord<K, V> withTimestamp(Timestamp var1);

    public abstract ConsumerRecord<K, V> withSerializedKeySize(int var1);

    public abstract ConsumerRecord<K, V> withSerializedValueSize(int var1);

    public abstract ConsumerRecord<K, V> withLeaderEpoch(int var1);

    public abstract <V2> ConsumerRecord<K, V2> withValue(V2 var1);

    public abstract <K2, V2> ConsumerRecord<K2, V2> withKeyValue(K2 var1, V2 var2);

    private static final class ConsumerRecordImpl<K, V>
    extends ConsumerRecord<K, V>
    implements Product,
    Serializable {
        private final String topic;
        private final int partition;
        private final long offset;
        private final Object key;
        private final Object value;
        private final Headers headers;
        private final Timestamp timestamp;
        private final Option serializedKeySize;
        private final Option serializedValueSize;
        private final Option leaderEpoch;

        public static <K, V> ConsumerRecordImpl<K, V> apply(String string, int n, long l, K k, V v, Headers headers, Timestamp timestamp, Option<Object> option, Option<Object> option2, Option<Object> option3) {
            return ConsumerRecord$ConsumerRecordImpl$.MODULE$.apply(string, n, l, k, v, headers, timestamp, option, option2, option3);
        }

        public static ConsumerRecordImpl<?, ?> fromProduct(Product product) {
            return ConsumerRecord$ConsumerRecordImpl$.MODULE$.fromProduct(product);
        }

        public static <K, V> ConsumerRecordImpl<K, V> unapply(ConsumerRecordImpl<K, V> consumerRecordImpl) {
            return ConsumerRecord$ConsumerRecordImpl$.MODULE$.unapply(consumerRecordImpl);
        }

        public ConsumerRecordImpl(String topic, int partition, long offset, K key, V value, Headers headers, Timestamp timestamp, Option<Object> serializedKeySize, Option<Object> serializedValueSize, Option<Object> leaderEpoch) {
            this.topic = topic;
            this.partition = partition;
            this.offset = offset;
            this.key = key;
            this.value = value;
            this.headers = headers;
            this.timestamp = timestamp;
            this.serializedKeySize = serializedKeySize;
            this.serializedValueSize = serializedValueSize;
            this.leaderEpoch = leaderEpoch;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.topic()));
            n = Statics.mix((int)n, (int)this.partition());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.key()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.value()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.headers()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.serializedKeySize()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.serializedValueSize()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.leaderEpoch()));
            return Statics.finalizeHash((int)n, (int)10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConsumerRecordImpl)) return false;
            ConsumerRecordImpl consumerRecordImpl = (ConsumerRecordImpl)object;
            if (this.partition() != consumerRecordImpl.partition()) return false;
            if (this.offset() != consumerRecordImpl.offset()) return false;
            String string = this.topic();
            String string2 = consumerRecordImpl.topic();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!BoxesRunTime.equals(this.key(), consumerRecordImpl.key())) return false;
            if (!BoxesRunTime.equals(this.value(), consumerRecordImpl.value())) return false;
            Headers headers = this.headers();
            Headers headers2 = consumerRecordImpl.headers();
            if (headers == null) {
                if (headers2 != null) {
                    return false;
                }
            } else if (!headers.equals(headers2)) return false;
            Timestamp timestamp = this.timestamp();
            Timestamp timestamp2 = consumerRecordImpl.timestamp();
            if (timestamp == null) {
                if (timestamp2 != null) {
                    return false;
                }
            } else if (!timestamp.equals(timestamp2)) return false;
            Option<Object> option = this.serializedKeySize();
            Option<Object> option2 = consumerRecordImpl.serializedKeySize();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.serializedValueSize();
            Option<Object> option4 = consumerRecordImpl.serializedValueSize();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Object> option5 = this.leaderEpoch();
            Option<Object> option6 = consumerRecordImpl.leaderEpoch();
            if (option5 == null) {
                if (option6 == null) return true;
                return false;
            } else {
                if (!option5.equals(option6)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ConsumerRecordImpl;
        }

        public int productArity() {
            return 10;
        }

        public String productPrefix() {
            return "ConsumerRecordImpl";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                case 6: {
                    object = this._7();
                    break;
                }
                case 7: {
                    object = this._8();
                    break;
                }
                case 8: {
                    object = this._9();
                    break;
                }
                case 9: {
                    object = this._10();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "topic";
                    break;
                }
                case 1: {
                    string = "partition";
                    break;
                }
                case 2: {
                    string = "offset";
                    break;
                }
                case 3: {
                    string = "key";
                    break;
                }
                case 4: {
                    string = "value";
                    break;
                }
                case 5: {
                    string = "headers";
                    break;
                }
                case 6: {
                    string = "timestamp";
                    break;
                }
                case 7: {
                    string = "serializedKeySize";
                    break;
                }
                case 8: {
                    string = "serializedValueSize";
                    break;
                }
                case 9: {
                    string = "leaderEpoch";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public String topic() {
            return this.topic;
        }

        @Override
        public int partition() {
            return this.partition;
        }

        @Override
        public long offset() {
            return this.offset;
        }

        @Override
        public K key() {
            return (K)this.key;
        }

        @Override
        public V value() {
            return (V)this.value;
        }

        @Override
        public Headers headers() {
            return this.headers;
        }

        @Override
        public Timestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public Option<Object> serializedKeySize() {
            return this.serializedKeySize;
        }

        @Override
        public Option<Object> serializedValueSize() {
            return this.serializedValueSize;
        }

        @Override
        public Option<Object> leaderEpoch() {
            return this.leaderEpoch;
        }

        @Override
        public ConsumerRecord<K, V> withHeaders(Headers headers) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), headers, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
        }

        @Override
        public ConsumerRecord<K, V> withTimestamp(Timestamp timestamp) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), timestamp, this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
        }

        @Override
        public ConsumerRecord<K, V> withSerializedKeySize(int serializedKeySize) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)serializedKeySize));
            String string = this.copy$default$1();
            int n = this.copy$default$2();
            long l = this.copy$default$3();
            K k = this.copy$default$4();
            V v = this.copy$default$5();
            Headers headers = this.copy$default$6();
            Timestamp timestamp = this.copy$default$7();
            Option<Object> option = this.copy$default$9();
            Option<Object> option2 = this.copy$default$10();
            return this.copy(string, n, l, k, v, headers, timestamp, (Option<Object>)some, option, option2);
        }

        @Override
        public ConsumerRecord<K, V> withSerializedValueSize(int serializedValueSize) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)serializedValueSize));
            String string = this.copy$default$1();
            int n = this.copy$default$2();
            long l = this.copy$default$3();
            K k = this.copy$default$4();
            V v = this.copy$default$5();
            Headers headers = this.copy$default$6();
            Timestamp timestamp = this.copy$default$7();
            Option<Object> option = this.copy$default$8();
            Option<Object> option2 = this.copy$default$10();
            return this.copy(string, n, l, k, v, headers, timestamp, option, (Option<Object>)some, option2);
        }

        @Override
        public ConsumerRecord<K, V> withLeaderEpoch(int leaderEpoch) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)leaderEpoch));
            String string = this.copy$default$1();
            int n = this.copy$default$2();
            long l = this.copy$default$3();
            K k = this.copy$default$4();
            V v = this.copy$default$5();
            Headers headers = this.copy$default$6();
            Timestamp timestamp = this.copy$default$7();
            Option<Object> option = this.copy$default$8();
            Option<Object> option2 = this.copy$default$9();
            return this.copy(string, n, l, k, v, headers, timestamp, option, option2, (Option<Object>)some);
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ConsumerRecord(");
            b.append("topic = ").append(this.topic());
            b.append(", partition = ").append(this.partition());
            b.append(", offset = ").append(this.offset());
            b.append(", key = ").append(this.key());
            b.append(", value = ").append(this.value());
            if (this.headers().nonEmpty()) {
                b.append(", headers = ").append(this.headers());
            }
            if (this.timestamp().nonEmpty()) {
                b.append(", timestamp = ").append(this.timestamp());
            }
            if (this.serializedKeySize().nonEmpty()) {
                b.append(", serializedKeySize = ").append(BoxesRunTime.unboxToInt((Object)this.serializedKeySize().get()));
            }
            if (this.serializedValueSize().nonEmpty()) {
                b.append(", serializedValueSize = ").append(BoxesRunTime.unboxToInt((Object)this.serializedValueSize().get()));
            }
            if (this.leaderEpoch().nonEmpty()) {
                b.append(", leaderEpoch = ").append(BoxesRunTime.unboxToInt((Object)this.leaderEpoch().get()));
            }
            return b.append(")").toString();
        }

        @Override
        public <V2> ConsumerRecord<K, V2> withValue(V2 v) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), v, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
        }

        @Override
        public <K2, V2> ConsumerRecord<K2, V2> withKeyValue(K2 k, V2 v) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), k, v, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10());
        }

        public <K, V> ConsumerRecordImpl<K, V> copy(String topic, int partition, long offset, K key, V value, Headers headers, Timestamp timestamp, Option<Object> serializedKeySize, Option<Object> serializedValueSize, Option<Object> leaderEpoch) {
            return new ConsumerRecordImpl<K, V>(topic, partition, offset, key, value, headers, timestamp, serializedKeySize, serializedValueSize, leaderEpoch);
        }

        public <K, V> String copy$default$1() {
            return this.topic();
        }

        public int copy$default$2() {
            return this.partition();
        }

        public long copy$default$3() {
            return this.offset();
        }

        public <K, V> K copy$default$4() {
            return this.key();
        }

        public <K, V> V copy$default$5() {
            return this.value();
        }

        public <K, V> Headers copy$default$6() {
            return this.headers();
        }

        public <K, V> Timestamp copy$default$7() {
            return this.timestamp();
        }

        public <K, V> Option<Object> copy$default$8() {
            return this.serializedKeySize();
        }

        public <K, V> Option<Object> copy$default$9() {
            return this.serializedValueSize();
        }

        public <K, V> Option<Object> copy$default$10() {
            return this.leaderEpoch();
        }

        public String _1() {
            return this.topic();
        }

        public int _2() {
            return this.partition();
        }

        public long _3() {
            return this.offset();
        }

        public K _4() {
            return this.key();
        }

        public V _5() {
            return this.value();
        }

        public Headers _6() {
            return this.headers();
        }

        public Timestamp _7() {
            return this.timestamp();
        }

        public Option<Object> _8() {
            return this.serializedKeySize();
        }

        public Option<Object> _9() {
            return this.serializedValueSize();
        }

        public Option<Object> _10() {
            return this.leaderEpoch();
        }
    }
}

