/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.Show;
import fs2.kafka.AutoOffsetReset;
import fs2.kafka.AutoOffsetReset$EarliestOffsetReset$;
import fs2.kafka.AutoOffsetReset$LatestOffsetReset$;
import fs2.kafka.AutoOffsetReset$NoneOffsetReset$;
import fs2.kafka.CommitRecovery;
import fs2.kafka.ConsumerRecord;
import fs2.kafka.ConsumerSettings$;
import fs2.kafka.ConsumerSettings$ConsumerSettingsImpl$;
import fs2.kafka.Deserializer;
import fs2.kafka.IsolationLevel;
import fs2.kafka.IsolationLevel$ReadCommittedIsolationLevel$;
import fs2.kafka.IsolationLevel$ReadUncommittedIsolationLevel$;
import fs2.kafka.RecordDeserializer;
import fs2.kafka.security.KafkaCredentialStore;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ConsumerSettings<F, K, V> {
    public static <F, K, V> ConsumerSettings<F, K, V> apply(Deserializer<F, K> deserializer, Deserializer<F, V> deserializer2, Applicative<F> applicative) {
        return ConsumerSettings$.MODULE$.apply(deserializer, deserializer2, applicative);
    }

    public static <F, K, V> ConsumerSettings<F, K, V> apply(Deserializer<F, K> deserializer, RecordDeserializer<F, V> recordDeserializer, Applicative<F> applicative) {
        return ConsumerSettings$.MODULE$.apply(deserializer, recordDeserializer, applicative);
    }

    public static <F, K, V> ConsumerSettings<F, K, V> apply(RecordDeserializer<F, K> recordDeserializer, Deserializer<F, V> deserializer, Applicative<F> applicative) {
        return ConsumerSettings$.MODULE$.apply(recordDeserializer, deserializer, applicative);
    }

    public static <F, K, V> ConsumerSettings<F, K, V> apply(RecordDeserializer<F, K> recordDeserializer, RecordDeserializer<F, V> recordDeserializer2) {
        return ConsumerSettings$.MODULE$.apply(recordDeserializer, recordDeserializer2);
    }

    public static <F, K, V> Show<ConsumerSettings<F, K, V>> consumerSettingsShow() {
        return ConsumerSettings$.MODULE$.consumerSettingsShow();
    }

    public static int ordinal(ConsumerSettings<?, ?, ?> consumerSettings) {
        return ConsumerSettings$.MODULE$.ordinal(consumerSettings);
    }

    public abstract F keyDeserializer();

    public abstract F valueDeserializer();

    public abstract Option<ExecutionContext> customBlockingContext();

    public abstract ConsumerSettings<F, K, V> withCustomBlockingContext(ExecutionContext var1);

    public abstract Map<String, String> properties();

    public abstract ConsumerSettings<F, K, V> withBootstrapServers(String var1);

    public abstract ConsumerSettings<F, K, V> withAutoOffsetReset(AutoOffsetReset var1);

    public abstract ConsumerSettings<F, K, V> withClientId(String var1);

    public abstract ConsumerSettings<F, K, V> withGroupId(String var1);

    public abstract ConsumerSettings<F, K, V> withGroupInstanceId(String var1);

    public abstract ConsumerSettings<F, K, V> withMaxPollRecords(int var1);

    public abstract ConsumerSettings<F, K, V> withMaxPollInterval(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withSessionTimeout(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withHeartbeatInterval(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withEnableAutoCommit(boolean var1);

    public abstract ConsumerSettings<F, K, V> withAutoCommitInterval(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withRequestTimeout(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withDefaultApiTimeout(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withIsolationLevel(IsolationLevel var1);

    public abstract ConsumerSettings<F, K, V> withAllowAutoCreateTopics(boolean var1);

    public abstract ConsumerSettings<F, K, V> withClientRack(String var1);

    public abstract ConsumerSettings<F, K, V> withProperty(String var1, String var2);

    public abstract ConsumerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> var1);

    public abstract ConsumerSettings<F, K, V> withProperties(Map<String, String> var1);

    public abstract FiniteDuration closeTimeout();

    public abstract ConsumerSettings<F, K, V> withCloseTimeout(FiniteDuration var1);

    public abstract FiniteDuration commitTimeout();

    public abstract ConsumerSettings<F, K, V> withCommitTimeout(FiniteDuration var1);

    public abstract FiniteDuration pollInterval();

    public abstract ConsumerSettings<F, K, V> withPollInterval(FiniteDuration var1);

    public abstract FiniteDuration pollTimeout();

    public abstract ConsumerSettings<F, K, V> withPollTimeout(FiniteDuration var1);

    public abstract CommitRecovery commitRecovery();

    public abstract ConsumerSettings<F, K, V> withCommitRecovery(CommitRecovery var1);

    public abstract Function1<ConsumerRecord<K, V>, String> recordMetadata();

    public abstract ConsumerSettings<F, K, V> withRecordMetadata(Function1<ConsumerRecord<K, V>, String> var1);

    public abstract int maxPrefetchBatches();

    public abstract ConsumerSettings<F, K, V> withMaxPrefetchBatches(int var1);

    public abstract ConsumerSettings<F, K, V> withCredentials(KafkaCredentialStore var1);

    private static final class ConsumerSettingsImpl<F, K, V>
    extends ConsumerSettings<F, K, V>
    implements Product,
    Serializable {
        private final Object keyDeserializer;
        private final Object valueDeserializer;
        private final Option customBlockingContext;
        private final Map properties;
        private final FiniteDuration closeTimeout;
        private final FiniteDuration commitTimeout;
        private final FiniteDuration pollInterval;
        private final FiniteDuration pollTimeout;
        private final CommitRecovery commitRecovery;
        private final Function1 recordMetadata;
        private final int maxPrefetchBatches;

        public static <F, K, V> ConsumerSettingsImpl<F, K, V> apply(Object object, Object object2, Option<ExecutionContext> option, Map<String, String> map, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, FiniteDuration finiteDuration3, FiniteDuration finiteDuration4, CommitRecovery commitRecovery, Function1<ConsumerRecord<K, V>, String> function1, int n) {
            return ConsumerSettings$ConsumerSettingsImpl$.MODULE$.apply(object, object2, option, map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n);
        }

        public static ConsumerSettingsImpl<?, ?, ?> fromProduct(Product product) {
            return ConsumerSettings$ConsumerSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> ConsumerSettingsImpl<F, K, V> unapply(ConsumerSettingsImpl<F, K, V> consumerSettingsImpl) {
            return ConsumerSettings$ConsumerSettingsImpl$.MODULE$.unapply(consumerSettingsImpl);
        }

        public ConsumerSettingsImpl(Object keyDeserializer, Object valueDeserializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, FiniteDuration commitTimeout, FiniteDuration pollInterval, FiniteDuration pollTimeout, CommitRecovery commitRecovery, Function1<ConsumerRecord<K, V>, String> recordMetadata, int maxPrefetchBatches) {
            this.keyDeserializer = keyDeserializer;
            this.valueDeserializer = valueDeserializer;
            this.customBlockingContext = customBlockingContext;
            this.properties = properties;
            this.closeTimeout = closeTimeout;
            this.commitTimeout = commitTimeout;
            this.pollInterval = pollInterval;
            this.pollTimeout = pollTimeout;
            this.commitRecovery = commitRecovery;
            this.recordMetadata = recordMetadata;
            this.maxPrefetchBatches = maxPrefetchBatches;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keyDeserializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.valueDeserializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.customBlockingContext()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.closeTimeout()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commitTimeout()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pollInterval()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pollTimeout()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commitRecovery()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.recordMetadata()));
            n = Statics.mix((int)n, (int)this.maxPrefetchBatches());
            return Statics.finalizeHash((int)n, (int)11);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConsumerSettingsImpl)) return false;
            ConsumerSettingsImpl consumerSettingsImpl = (ConsumerSettingsImpl)object;
            if (this.maxPrefetchBatches() != consumerSettingsImpl.maxPrefetchBatches()) return false;
            if (!BoxesRunTime.equals(this.keyDeserializer(), consumerSettingsImpl.keyDeserializer())) return false;
            if (!BoxesRunTime.equals(this.valueDeserializer(), consumerSettingsImpl.valueDeserializer())) return false;
            Option<ExecutionContext> option = this.customBlockingContext();
            Option<ExecutionContext> option2 = consumerSettingsImpl.customBlockingContext();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = consumerSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            FiniteDuration finiteDuration = this.closeTimeout();
            FiniteDuration finiteDuration2 = consumerSettingsImpl.closeTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            FiniteDuration finiteDuration3 = this.commitTimeout();
            FiniteDuration finiteDuration4 = consumerSettingsImpl.commitTimeout();
            if (finiteDuration3 == null) {
                if (finiteDuration4 != null) {
                    return false;
                }
            } else if (!finiteDuration3.equals(finiteDuration4)) return false;
            FiniteDuration finiteDuration5 = this.pollInterval();
            FiniteDuration finiteDuration6 = consumerSettingsImpl.pollInterval();
            if (finiteDuration5 == null) {
                if (finiteDuration6 != null) {
                    return false;
                }
            } else if (!finiteDuration5.equals(finiteDuration6)) return false;
            FiniteDuration finiteDuration7 = this.pollTimeout();
            FiniteDuration finiteDuration8 = consumerSettingsImpl.pollTimeout();
            if (finiteDuration7 == null) {
                if (finiteDuration8 != null) {
                    return false;
                }
            } else if (!finiteDuration7.equals(finiteDuration8)) return false;
            CommitRecovery commitRecovery = this.commitRecovery();
            CommitRecovery commitRecovery2 = consumerSettingsImpl.commitRecovery();
            if (commitRecovery == null) {
                if (commitRecovery2 != null) {
                    return false;
                }
            } else if (!commitRecovery.equals(commitRecovery2)) return false;
            Function1<ConsumerRecord<K, V>, String> function1 = this.recordMetadata();
            Function1<ConsumerRecord<K, V>, String> function12 = consumerSettingsImpl.recordMetadata();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ConsumerSettingsImpl;
        }

        public int productArity() {
            return 11;
        }

        public String productPrefix() {
            return "ConsumerSettingsImpl";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                case 6: {
                    object = this._7();
                    break;
                }
                case 7: {
                    object = this._8();
                    break;
                }
                case 8: {
                    object = this._9();
                    break;
                }
                case 9: {
                    object = this._10();
                    break;
                }
                case 10: {
                    object = BoxesRunTime.boxToInteger((int)this._11());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "keyDeserializer";
                    break;
                }
                case 1: {
                    string = "valueDeserializer";
                    break;
                }
                case 2: {
                    string = "customBlockingContext";
                    break;
                }
                case 3: {
                    string = "properties";
                    break;
                }
                case 4: {
                    string = "closeTimeout";
                    break;
                }
                case 5: {
                    string = "commitTimeout";
                    break;
                }
                case 6: {
                    string = "pollInterval";
                    break;
                }
                case 7: {
                    string = "pollTimeout";
                    break;
                }
                case 8: {
                    string = "commitRecovery";
                    break;
                }
                case 9: {
                    string = "recordMetadata";
                    break;
                }
                case 10: {
                    string = "maxPrefetchBatches";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public F keyDeserializer() {
            return (F)this.keyDeserializer;
        }

        @Override
        public F valueDeserializer() {
            return (F)this.valueDeserializer;
        }

        @Override
        public Option<ExecutionContext> customBlockingContext() {
            return this.customBlockingContext;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        @Override
        public FiniteDuration closeTimeout() {
            return this.closeTimeout;
        }

        @Override
        public FiniteDuration commitTimeout() {
            return this.commitTimeout;
        }

        @Override
        public FiniteDuration pollInterval() {
            return this.pollInterval;
        }

        @Override
        public FiniteDuration pollTimeout() {
            return this.pollTimeout;
        }

        @Override
        public CommitRecovery commitRecovery() {
            return this.commitRecovery;
        }

        @Override
        public Function1<ConsumerRecord<K, V>, String> recordMetadata() {
            return this.recordMetadata;
        }

        @Override
        public int maxPrefetchBatches() {
            return this.maxPrefetchBatches;
        }

        @Override
        public ConsumerSettings<F, K, V> withCustomBlockingContext(ExecutionContext ec) {
            Some some = Some$.MODULE$.apply((Object)ec);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Map<String, String> map = this.copy$default$4();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            return this.copy(f, f2, (Option<ExecutionContext>)some, map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n);
        }

        @Override
        public ConsumerSettings<F, K, V> withBootstrapServers(String bootstrapServers) {
            return this.withProperty("bootstrap.servers", bootstrapServers);
        }

        @Override
        public ConsumerSettings<F, K, V> withAutoOffsetReset(AutoOffsetReset autoOffsetReset) {
            String string;
            AutoOffsetReset autoOffsetReset2 = autoOffsetReset;
            if (AutoOffsetReset$EarliestOffsetReset$.MODULE$.equals(autoOffsetReset2)) {
                string = "earliest";
            } else if (AutoOffsetReset$LatestOffsetReset$.MODULE$.equals(autoOffsetReset2)) {
                string = "latest";
            } else if (AutoOffsetReset$NoneOffsetReset$.MODULE$.equals(autoOffsetReset2)) {
                string = "none";
            } else {
                throw new MatchError((Object)autoOffsetReset2);
            }
            return this.withProperty("auto.offset.reset", string);
        }

        @Override
        public ConsumerSettings<F, K, V> withClientId(String clientId) {
            return this.withProperty("client.id", clientId);
        }

        @Override
        public ConsumerSettings<F, K, V> withGroupId(String groupId) {
            return this.withProperty("group.id", groupId);
        }

        @Override
        public ConsumerSettings<F, K, V> withGroupInstanceId(String groupInstanceId) {
            return this.withProperty("group.instance.id", groupInstanceId);
        }

        @Override
        public ConsumerSettings<F, K, V> withMaxPollRecords(int maxPollRecords) {
            return this.withProperty("max.poll.records", BoxesRunTime.boxToInteger((int)maxPollRecords).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withMaxPollInterval(FiniteDuration maxPollInterval) {
            return this.withProperty("max.poll.interval.ms", BoxesRunTime.boxToLong((long)maxPollInterval.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withSessionTimeout(FiniteDuration sessionTimeout) {
            return this.withProperty("session.timeout.ms", BoxesRunTime.boxToLong((long)sessionTimeout.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withHeartbeatInterval(FiniteDuration heartbeatInterval) {
            return this.withProperty("heartbeat.interval.ms", BoxesRunTime.boxToLong((long)heartbeatInterval.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withEnableAutoCommit(boolean enableAutoCommit) {
            return this.withProperty("enable.auto.commit", BoxesRunTime.boxToBoolean((boolean)enableAutoCommit).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withAutoCommitInterval(FiniteDuration autoCommitInterval) {
            return this.withProperty("auto.commit.interval.ms", BoxesRunTime.boxToLong((long)autoCommitInterval.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withRequestTimeout(FiniteDuration requestTimeout) {
            return this.withProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)requestTimeout.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withDefaultApiTimeout(FiniteDuration defaultApiTimeout) {
            return this.withProperty("default.api.timeout.ms", BoxesRunTime.boxToLong((long)defaultApiTimeout.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withIsolationLevel(IsolationLevel isolationLevel) {
            String string;
            IsolationLevel isolationLevel2 = isolationLevel;
            if (IsolationLevel$ReadCommittedIsolationLevel$.MODULE$.equals(isolationLevel2)) {
                string = "read_committed";
            } else if (IsolationLevel$ReadUncommittedIsolationLevel$.MODULE$.equals(isolationLevel2)) {
                string = "read_uncommitted";
            } else {
                throw new MatchError((Object)isolationLevel2);
            }
            return this.withProperty("isolation.level", string);
        }

        @Override
        public ConsumerSettings<F, K, V> withAllowAutoCreateTopics(boolean allowAutoCreateTopics) {
            return this.withProperty("allow.auto.create.topics", BoxesRunTime.boxToBoolean((boolean)allowAutoCreateTopics).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withClientRack(String clientRack) {
            return this.withProperty("client.rack", clientRack);
        }

        @Override
        public ConsumerSettings<F, K, V> withProperty(String key, String value) {
            Map map = (Map)this.properties().updated((Object)key, (Object)value);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n);
        }

        @Override
        public ConsumerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> properties) {
            Map map = (Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n);
        }

        @Override
        public ConsumerSettings<F, K, V> withProperties(Map<String, String> properties) {
            Map map = (Map)this.properties().$plus$plus(properties);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n);
        }

        @Override
        public ConsumerSettings<F, K, V> withCloseTimeout(FiniteDuration closeTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), closeTimeout, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public ConsumerSettings<F, K, V> withCommitTimeout(FiniteDuration commitTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), commitTimeout, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public ConsumerSettings<F, K, V> withPollInterval(FiniteDuration pollInterval) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), pollInterval, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public ConsumerSettings<F, K, V> withPollTimeout(FiniteDuration pollTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), pollTimeout, this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public ConsumerSettings<F, K, V> withCommitRecovery(CommitRecovery commitRecovery) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), commitRecovery, this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public ConsumerSettings<F, K, V> withRecordMetadata(Function1<ConsumerRecord<K, V>, String> recordMetadata) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), recordMetadata, this.copy$default$11());
        }

        @Override
        public ConsumerSettings<F, K, V> withMaxPrefetchBatches(int maxPrefetchBatches) {
            int n = Math.max(2, maxPrefetchBatches);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            Map<String, String> map = this.copy$default$4();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            return this.copy(f, f2, option, map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n);
        }

        @Override
        public ConsumerSettings<F, K, V> withCredentials(KafkaCredentialStore credentialsStore) {
            return this.withProperties(credentialsStore.properties());
        }

        public String toString() {
            return new StringBuilder(103).append("ConsumerSettings(closeTimeout = ").append(this.closeTimeout()).append(", commitTimeout = ").append(this.commitTimeout()).append(", pollInterval = ").append(this.pollInterval()).append(", pollTimeout = ").append(this.pollTimeout()).append(", commitRecovery = ").append(this.commitRecovery()).append(")").toString();
        }

        public <F, K, V> ConsumerSettingsImpl<F, K, V> copy(Object keyDeserializer, Object valueDeserializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, FiniteDuration commitTimeout, FiniteDuration pollInterval, FiniteDuration pollTimeout, CommitRecovery commitRecovery, Function1<ConsumerRecord<K, V>, String> recordMetadata, int maxPrefetchBatches) {
            return new ConsumerSettingsImpl<F, K, V>(keyDeserializer, valueDeserializer, customBlockingContext, properties, closeTimeout, commitTimeout, pollInterval, pollTimeout, commitRecovery, recordMetadata, maxPrefetchBatches);
        }

        public <F, K, V> F copy$default$1() {
            return this.keyDeserializer();
        }

        public <F, K, V> F copy$default$2() {
            return this.valueDeserializer();
        }

        public <F, K, V> Option<ExecutionContext> copy$default$3() {
            return this.customBlockingContext();
        }

        public <F, K, V> Map<String, String> copy$default$4() {
            return this.properties();
        }

        public <F, K, V> FiniteDuration copy$default$5() {
            return this.closeTimeout();
        }

        public <F, K, V> FiniteDuration copy$default$6() {
            return this.commitTimeout();
        }

        public <F, K, V> FiniteDuration copy$default$7() {
            return this.pollInterval();
        }

        public <F, K, V> FiniteDuration copy$default$8() {
            return this.pollTimeout();
        }

        public <F, K, V> CommitRecovery copy$default$9() {
            return this.commitRecovery();
        }

        public <F, K, V> Function1<ConsumerRecord<K, V>, String> copy$default$10() {
            return this.recordMetadata();
        }

        public int copy$default$11() {
            return this.maxPrefetchBatches();
        }

        public F _1() {
            return this.keyDeserializer();
        }

        public F _2() {
            return this.valueDeserializer();
        }

        public Option<ExecutionContext> _3() {
            return this.customBlockingContext();
        }

        public Map<String, String> _4() {
            return this.properties();
        }

        public FiniteDuration _5() {
            return this.closeTimeout();
        }

        public FiniteDuration _6() {
            return this.commitTimeout();
        }

        public FiniteDuration _7() {
            return this.pollInterval();
        }

        public FiniteDuration _8() {
            return this.pollTimeout();
        }

        public CommitRecovery _9() {
            return this.commitRecovery();
        }

        public Function1<ConsumerRecord<K, V>, String> _10() {
            return this.recordMetadata();
        }

        public int _11() {
            return this.maxPrefetchBatches();
        }
    }
}

