/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Bitraverse;
import cats.Show;
import cats.Traverse;
import cats.kernel.Eq;
import fs2.kafka.Headers;
import fs2.kafka.ProducerRecord$;
import fs2.kafka.ProducerRecord$ProducerRecordImpl$;
import java.io.Serializable;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class ProducerRecord<K, V> {
    public static <K, V> ProducerRecord<K, V> apply(String string, K k, V v) {
        return ProducerRecord$.MODULE$.apply(string, k, v);
    }

    public static int ordinal(ProducerRecord<?, ?> producerRecord) {
        return ProducerRecord$.MODULE$.ordinal(producerRecord);
    }

    public static Bitraverse<ProducerRecord> producerRecordBitraverse() {
        return ProducerRecord$.MODULE$.producerRecordBitraverse();
    }

    public static <K, V> Eq<ProducerRecord<K, V>> producerRecordEq(Eq<K> eq2, Eq<V> eq3) {
        return ProducerRecord$.MODULE$.producerRecordEq(eq2, eq3);
    }

    public static <K, V> Show<ProducerRecord<K, V>> producerRecordShow(Show<K> show, Show<V> show2) {
        return ProducerRecord$.MODULE$.producerRecordShow(show, show2);
    }

    public static <K> Traverse<ProducerRecord> producerRecordTraverse() {
        return ProducerRecord$.MODULE$.producerRecordTraverse();
    }

    public abstract String topic();

    public abstract Option<Object> partition();

    public abstract Option<Object> timestamp();

    public abstract K key();

    public abstract V value();

    public abstract Headers headers();

    public abstract ProducerRecord<K, V> withPartition(int var1);

    public abstract ProducerRecord<K, V> withTimestamp(long var1);

    public abstract ProducerRecord<K, V> withHeaders(Headers var1);

    public abstract <V2> ProducerRecord<K, V2> withValue(V2 var1);

    public abstract <K2, V2> ProducerRecord<K2, V2> withKeyValue(K2 var1, V2 var2);

    private static final class ProducerRecordImpl<K, V>
    extends ProducerRecord<K, V>
    implements Product,
    Serializable {
        private final String topic;
        private final Option partition;
        private final Option timestamp;
        private final Object key;
        private final Object value;
        private final Headers headers;

        public static <K, V> ProducerRecordImpl<K, V> apply(String string, Option<Object> option, Option<Object> option2, K k, V v, Headers headers) {
            return ProducerRecord$ProducerRecordImpl$.MODULE$.apply(string, option, option2, k, v, headers);
        }

        public static ProducerRecordImpl<?, ?> fromProduct(Product product) {
            return ProducerRecord$ProducerRecordImpl$.MODULE$.fromProduct(product);
        }

        public static <K, V> ProducerRecordImpl<K, V> unapply(ProducerRecordImpl<K, V> producerRecordImpl) {
            return ProducerRecord$ProducerRecordImpl$.MODULE$.unapply(producerRecordImpl);
        }

        public ProducerRecordImpl(String topic, Option<Object> partition, Option<Object> timestamp, K key, V value, Headers headers) {
            this.topic = topic;
            this.partition = partition;
            this.timestamp = timestamp;
            this.key = key;
            this.value = value;
            this.headers = headers;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProducerRecordImpl)) return false;
            ProducerRecordImpl producerRecordImpl = (ProducerRecordImpl)object;
            String string = this.topic();
            String string2 = producerRecordImpl.topic();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Object> option = this.partition();
            Option<Object> option2 = producerRecordImpl.partition();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.timestamp();
            Option<Object> option4 = producerRecordImpl.timestamp();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!BoxesRunTime.equals(this.key(), producerRecordImpl.key())) return false;
            if (!BoxesRunTime.equals(this.value(), producerRecordImpl.value())) return false;
            Headers headers = this.headers();
            Headers headers2 = producerRecordImpl.headers();
            if (headers == null) {
                if (headers2 == null) return true;
                return false;
            } else {
                if (!headers.equals(headers2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ProducerRecordImpl;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "ProducerRecordImpl";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "topic";
                    break;
                }
                case 1: {
                    string = "partition";
                    break;
                }
                case 2: {
                    string = "timestamp";
                    break;
                }
                case 3: {
                    string = "key";
                    break;
                }
                case 4: {
                    string = "value";
                    break;
                }
                case 5: {
                    string = "headers";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public String topic() {
            return this.topic;
        }

        @Override
        public Option<Object> partition() {
            return this.partition;
        }

        @Override
        public Option<Object> timestamp() {
            return this.timestamp;
        }

        @Override
        public K key() {
            return (K)this.key;
        }

        @Override
        public V value() {
            return (V)this.value;
        }

        @Override
        public Headers headers() {
            return this.headers;
        }

        @Override
        public ProducerRecord<K, V> withPartition(int partition) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)partition));
            String string = this.copy$default$1();
            Option<Object> option = this.copy$default$3();
            K k = this.copy$default$4();
            V v = this.copy$default$5();
            Headers headers = this.copy$default$6();
            return this.copy(string, (Option<Object>)some, option, k, v, headers);
        }

        @Override
        public ProducerRecord<K, V> withTimestamp(long timestamp) {
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)timestamp));
            String string = this.copy$default$1();
            Option<Object> option = this.copy$default$2();
            K k = this.copy$default$4();
            V v = this.copy$default$5();
            Headers headers = this.copy$default$6();
            return this.copy(string, option, (Option<Object>)some, k, v, headers);
        }

        @Override
        public ProducerRecord<K, V> withHeaders(Headers headers) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), headers);
        }

        public String toString() {
            StringBuilder b = new StringBuilder("ProducerRecord(");
            b.append("topic = ").append(this.topic());
            if (this.partition().nonEmpty()) {
                b.append(", partition = ").append(BoxesRunTime.unboxToInt((Object)this.partition().get()));
            }
            if (this.timestamp().nonEmpty()) {
                b.append(", timestamp = ").append(BoxesRunTime.unboxToLong((Object)this.timestamp().get()));
            }
            b.append(", key = ").append(this.key());
            b.append(", value = ").append(this.value());
            if (this.headers().nonEmpty()) {
                b.append(", headers = ").append(this.headers());
            }
            return b.append(")").toString();
        }

        @Override
        public <V2> ProducerRecord<K, V2> withValue(V2 v) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), v, this.copy$default$6());
        }

        @Override
        public <K2, V2> ProducerRecord<K2, V2> withKeyValue(K2 k, V2 v) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), k, v, this.copy$default$6());
        }

        public <K, V> ProducerRecordImpl<K, V> copy(String topic, Option<Object> partition, Option<Object> timestamp, K key, V value, Headers headers) {
            return new ProducerRecordImpl<K, V>(topic, partition, timestamp, key, value, headers);
        }

        public <K, V> String copy$default$1() {
            return this.topic();
        }

        public <K, V> Option<Object> copy$default$2() {
            return this.partition();
        }

        public <K, V> Option<Object> copy$default$3() {
            return this.timestamp();
        }

        public <K, V> K copy$default$4() {
            return this.key();
        }

        public <K, V> V copy$default$5() {
            return this.value();
        }

        public <K, V> Headers copy$default$6() {
            return this.headers();
        }

        public String _1() {
            return this.topic();
        }

        public Option<Object> _2() {
            return this.partition();
        }

        public Option<Object> _3() {
            return this.timestamp();
        }

        public K _4() {
            return this.key();
        }

        public V _5() {
            return this.value();
        }

        public Headers _6() {
            return this.headers();
        }
    }
}

