/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Foldable;
import cats.Show;
import cats.Traverse;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.kafka.ProducerRecord;
import fs2.kafka.ProducerRecords$;
import fs2.kafka.internal.syntax$;
import fs2.kafka.internal.syntax$FoldableSyntax$;
import scala.runtime.BoxedUnit;

public abstract class ProducerRecords<P, K, V> {
    public static <F, P, K, V> ProducerRecords<P, K, V> apply(Object object, P p, Traverse<F> traverse) {
        return ProducerRecords$.MODULE$.apply(object, p, traverse);
    }

    public static <F, K, V> ProducerRecords<BoxedUnit, K, V> apply(Object object, Traverse<F> traverse) {
        return ProducerRecords$.MODULE$.apply(object, traverse);
    }

    public static <K, V> ProducerRecords<BoxedUnit, K, V> one(ProducerRecord<K, V> producerRecord) {
        return ProducerRecords$.MODULE$.one(producerRecord);
    }

    public static <P, K, V> ProducerRecords<P, K, V> one(ProducerRecord<K, V> producerRecord, P p) {
        return ProducerRecords$.MODULE$.one(producerRecord, p);
    }

    public static <P, K, V> Show<ProducerRecords<P, K, V>> producerRecordsShow(Show<K> show, Show<V> show2, Show<P> show3) {
        return ProducerRecords$.MODULE$.producerRecordsShow(show, show2, show3);
    }

    public abstract Chunk<ProducerRecord<K, V>> records();

    public abstract P passthrough();

    private static final class ProducerRecordsImpl<P, K, V>
    extends ProducerRecords<P, K, V> {
        private final Chunk records;
        private final Object passthrough;

        public ProducerRecordsImpl(Chunk<ProducerRecord<K, V>> records, P passthrough) {
            this.records = records;
            this.passthrough = passthrough;
        }

        @Override
        public Chunk<ProducerRecord<K, V>> records() {
            return this.records;
        }

        @Override
        public P passthrough() {
            return (P)this.passthrough;
        }

        public String toString() {
            String string;
            if (this.records().isEmpty()) {
                string = new StringBuilder(26).append("ProducerRecords(<empty>, ").append(this.passthrough()).append(")").toString();
            } else {
                Chunk chunk = (Chunk)syntax$.MODULE$.FoldableSyntax(this.records());
                string = syntax$FoldableSyntax$.MODULE$.mkString$extension(chunk, "ProducerRecords(", ", ", new StringBuilder(3).append(", ").append(this.passthrough()).append(")").toString(), (Foldable)Chunk$.MODULE$.instance());
            }
            return string;
        }
    }
}

