/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Applicative;
import cats.Show;
import fs2.kafka.Acks;
import fs2.kafka.Acks$AllAcks$;
import fs2.kafka.Acks$OneAcks$;
import fs2.kafka.Acks$ZeroAcks$;
import fs2.kafka.ProducerSettings$;
import fs2.kafka.ProducerSettings$ProducerSettingsImpl$;
import fs2.kafka.RecordSerializer;
import fs2.kafka.Serializer;
import fs2.kafka.security.KafkaCredentialStore;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ProducerSettings<F, K, V> {
    public static <F, K, V> ProducerSettings<F, K, V> apply(RecordSerializer<F, K> recordSerializer, RecordSerializer<F, V> recordSerializer2) {
        return ProducerSettings$.MODULE$.apply(recordSerializer, recordSerializer2);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(RecordSerializer<F, K> recordSerializer, Serializer<F, V> serializer, Applicative<F> applicative) {
        return ProducerSettings$.MODULE$.apply(recordSerializer, serializer, applicative);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(Serializer<F, K> serializer, RecordSerializer<F, V> recordSerializer, Applicative<F> applicative) {
        return ProducerSettings$.MODULE$.apply(serializer, recordSerializer, applicative);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(Serializer<F, K> serializer, Serializer<F, V> serializer2, Applicative<F> applicative) {
        return ProducerSettings$.MODULE$.apply(serializer, serializer2, applicative);
    }

    public static int ordinal(ProducerSettings<?, ?, ?> producerSettings) {
        return ProducerSettings$.MODULE$.ordinal(producerSettings);
    }

    public static <F, K, V> Show<ProducerSettings<F, K, V>> producerSettingsShow() {
        return ProducerSettings$.MODULE$.producerSettingsShow();
    }

    public abstract F keySerializer();

    public abstract F valueSerializer();

    public abstract Option<ExecutionContext> customBlockingContext();

    public abstract ProducerSettings<F, K, V> withCustomBlockingContext(ExecutionContext var1);

    public abstract Map<String, String> properties();

    public abstract ProducerSettings<F, K, V> withBootstrapServers(String var1);

    public abstract ProducerSettings<F, K, V> withAcks(Acks var1);

    public abstract ProducerSettings<F, K, V> withBatchSize(int var1);

    public abstract ProducerSettings<F, K, V> withClientId(String var1);

    public abstract ProducerSettings<F, K, V> withRetries(int var1);

    public abstract ProducerSettings<F, K, V> withMaxInFlightRequestsPerConnection(int var1);

    public abstract ProducerSettings<F, K, V> withEnableIdempotence(boolean var1);

    public abstract ProducerSettings<F, K, V> withLinger(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withRequestTimeout(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withDeliveryTimeout(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withProperty(String var1, String var2);

    public abstract ProducerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> var1);

    public abstract ProducerSettings<F, K, V> withProperties(Map<String, String> var1);

    public abstract FiniteDuration closeTimeout();

    public abstract ProducerSettings<F, K, V> withCloseTimeout(FiniteDuration var1);

    public abstract int parallelism();

    public abstract ProducerSettings<F, K, V> withParallelism(int var1);

    public abstract ProducerSettings<F, K, V> withCredentials(KafkaCredentialStore var1);

    private static final class ProducerSettingsImpl<F, K, V>
    extends ProducerSettings<F, K, V>
    implements Product,
    Serializable {
        private final Object keySerializer;
        private final Object valueSerializer;
        private final Option customBlockingContext;
        private final Map properties;
        private final FiniteDuration closeTimeout;
        private final int parallelism;

        public static <F, K, V> ProducerSettingsImpl<F, K, V> apply(Object object, Object object2, Option<ExecutionContext> option, Map<String, String> map, FiniteDuration finiteDuration, int n) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.apply(object, object2, option, map, finiteDuration, n);
        }

        public static ProducerSettingsImpl<?, ?, ?> fromProduct(Product product) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> ProducerSettingsImpl<F, K, V> unapply(ProducerSettingsImpl<F, K, V> producerSettingsImpl) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.unapply(producerSettingsImpl);
        }

        public ProducerSettingsImpl(Object keySerializer, Object valueSerializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, int parallelism) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.customBlockingContext = customBlockingContext;
            this.properties = properties;
            this.closeTimeout = closeTimeout;
            this.parallelism = parallelism;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keySerializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.valueSerializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.customBlockingContext()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.closeTimeout()));
            n = Statics.mix((int)n, (int)this.parallelism());
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProducerSettingsImpl)) return false;
            ProducerSettingsImpl producerSettingsImpl = (ProducerSettingsImpl)object;
            if (this.parallelism() != producerSettingsImpl.parallelism()) return false;
            if (!BoxesRunTime.equals(this.keySerializer(), producerSettingsImpl.keySerializer())) return false;
            if (!BoxesRunTime.equals(this.valueSerializer(), producerSettingsImpl.valueSerializer())) return false;
            Option<ExecutionContext> option = this.customBlockingContext();
            Option<ExecutionContext> option2 = producerSettingsImpl.customBlockingContext();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = producerSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            FiniteDuration finiteDuration = this.closeTimeout();
            FiniteDuration finiteDuration2 = producerSettingsImpl.closeTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ProducerSettingsImpl;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "ProducerSettingsImpl";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this._6());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "keySerializer";
                    break;
                }
                case 1: {
                    string = "valueSerializer";
                    break;
                }
                case 2: {
                    string = "customBlockingContext";
                    break;
                }
                case 3: {
                    string = "properties";
                    break;
                }
                case 4: {
                    string = "closeTimeout";
                    break;
                }
                case 5: {
                    string = "parallelism";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public F keySerializer() {
            return (F)this.keySerializer;
        }

        @Override
        public F valueSerializer() {
            return (F)this.valueSerializer;
        }

        @Override
        public Option<ExecutionContext> customBlockingContext() {
            return this.customBlockingContext;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        @Override
        public FiniteDuration closeTimeout() {
            return this.closeTimeout;
        }

        @Override
        public int parallelism() {
            return this.parallelism;
        }

        @Override
        public ProducerSettings<F, K, V> withCustomBlockingContext(ExecutionContext ec) {
            Some some = Some$.MODULE$.apply((Object)ec);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Map<String, String> map = this.copy$default$4();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            return this.copy(f, f2, (Option<ExecutionContext>)some, map, finiteDuration, n);
        }

        @Override
        public ProducerSettings<F, K, V> withBootstrapServers(String bootstrapServers) {
            return this.withProperty("bootstrap.servers", bootstrapServers);
        }

        @Override
        public ProducerSettings<F, K, V> withAcks(Acks acks) {
            String string;
            Acks acks2 = acks;
            if (Acks$ZeroAcks$.MODULE$.equals(acks2)) {
                string = "0";
            } else if (Acks$OneAcks$.MODULE$.equals(acks2)) {
                string = "1";
            } else if (Acks$AllAcks$.MODULE$.equals(acks2)) {
                string = "all";
            } else {
                throw new MatchError((Object)acks2);
            }
            return this.withProperty("acks", string);
        }

        @Override
        public ProducerSettings<F, K, V> withBatchSize(int batchSize) {
            return this.withProperty("batch.size", BoxesRunTime.boxToInteger((int)batchSize).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withClientId(String clientId) {
            return this.withProperty("client.id", clientId);
        }

        @Override
        public ProducerSettings<F, K, V> withRetries(int retries) {
            return this.withProperty("retries", BoxesRunTime.boxToInteger((int)retries).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withMaxInFlightRequestsPerConnection(int maxInFlightRequestsPerConnection) {
            return this.withProperty("max.in.flight.requests.per.connection", BoxesRunTime.boxToInteger((int)maxInFlightRequestsPerConnection).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withEnableIdempotence(boolean enableIdempotence) {
            return this.withProperty("enable.idempotence", BoxesRunTime.boxToBoolean((boolean)enableIdempotence).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withLinger(FiniteDuration linger) {
            return this.withProperty("linger.ms", BoxesRunTime.boxToLong((long)linger.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withRequestTimeout(FiniteDuration requestTimeout) {
            return this.withProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)requestTimeout.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withDeliveryTimeout(FiniteDuration deliveryTimeout) {
            return this.withProperty("delivery.timeout.ms", BoxesRunTime.boxToLong((long)deliveryTimeout.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withProperty(String key, String value) {
            Map map = (Map)this.properties().updated((Object)key, (Object)value);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, n);
        }

        @Override
        public ProducerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> properties) {
            Map map = (Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, n);
        }

        @Override
        public ProducerSettings<F, K, V> withProperties(Map<String, String> properties) {
            Map map = (Map)this.properties().$plus$plus(properties);
            F f = this.copy$default$1();
            F f2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            int n = this.copy$default$6();
            return this.copy(f, f2, option, (Map<String, String>)map, finiteDuration, n);
        }

        @Override
        public ProducerSettings<F, K, V> withCloseTimeout(FiniteDuration closeTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), closeTimeout, this.copy$default$6());
        }

        @Override
        public ProducerSettings<F, K, V> withParallelism(int parallelism) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), parallelism);
        }

        @Override
        public ProducerSettings<F, K, V> withCredentials(KafkaCredentialStore credentialsStore) {
            return this.withProperties(credentialsStore.properties());
        }

        public String toString() {
            return new StringBuilder(33).append("ProducerSettings(closeTimeout = ").append(this.closeTimeout()).append(")").toString();
        }

        public <F, K, V> ProducerSettingsImpl<F, K, V> copy(Object keySerializer, Object valueSerializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, int parallelism) {
            return new ProducerSettingsImpl<F, K, V>(keySerializer, valueSerializer, customBlockingContext, properties, closeTimeout, parallelism);
        }

        public <F, K, V> F copy$default$1() {
            return this.keySerializer();
        }

        public <F, K, V> F copy$default$2() {
            return this.valueSerializer();
        }

        public <F, K, V> Option<ExecutionContext> copy$default$3() {
            return this.customBlockingContext();
        }

        public <F, K, V> Map<String, String> copy$default$4() {
            return this.properties();
        }

        public <F, K, V> FiniteDuration copy$default$5() {
            return this.closeTimeout();
        }

        public int copy$default$6() {
            return this.parallelism();
        }

        public F _1() {
            return this.keySerializer();
        }

        public F _2() {
            return this.valueSerializer();
        }

        public Option<ExecutionContext> _3() {
            return this.customBlockingContext();
        }

        public Map<String, String> _4() {
            return this.properties();
        }

        public FiniteDuration _5() {
            return this.closeTimeout();
        }

        public int _6() {
            return this.parallelism();
        }
    }
}

