/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.internal;

import cats.Foldable;
import cats.data.Chain;
import cats.data.NonEmptyList;
import cats.data.NonEmptySetImpl$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.LogEntry$;
import fs2.kafka.internal.LogEntry$AssignedPartitions$;
import fs2.kafka.internal.LogEntry$CommittedPendingCommits$;
import fs2.kafka.internal.LogEntry$CompletedFetchesWithRecords$;
import fs2.kafka.internal.LogEntry$ManuallyAssignedPartitions$;
import fs2.kafka.internal.LogEntry$RemovedRevokedRecords$;
import fs2.kafka.internal.LogEntry$RevokedFetchesWithRecords$;
import fs2.kafka.internal.LogEntry$RevokedFetchesWithoutRecords$;
import fs2.kafka.internal.LogEntry$RevokedPartitions$;
import fs2.kafka.internal.LogEntry$RevokedPreviousFetch$;
import fs2.kafka.internal.LogEntry$StoredFetch$;
import fs2.kafka.internal.LogEntry$StoredOnRebalance$;
import fs2.kafka.internal.LogEntry$StoredPendingCommit$;
import fs2.kafka.internal.LogEntry$StoredRecords$;
import fs2.kafka.internal.LogEntry$SubscribedPattern$;
import fs2.kafka.internal.LogEntry$SubscribedTopics$;
import fs2.kafka.internal.LogEntry$Unsubscribed$;
import fs2.kafka.internal.LogLevel;
import fs2.kafka.internal.LogLevel$Debug$;
import fs2.kafka.internal.LogLevel$Warn$;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class LogEntry {
    public static int ordinal(LogEntry logEntry) {
        return LogEntry$.MODULE$.ordinal(logEntry);
    }

    public static <F> String recordsString(Map<TopicPartition, Vector> map) {
        return LogEntry$.MODULE$.recordsString(map);
    }

    public abstract LogLevel level();

    public abstract String message();

    public static final class AssignedPartitions<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final SortedSet partitions;
        private final KafkaConsumerActor.State state;

        public static <F> AssignedPartitions<F> apply(SortedSet<TopicPartition> sortedSet, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$AssignedPartitions$.MODULE$.apply(sortedSet, state);
        }

        public static AssignedPartitions<?> fromProduct(Product product) {
            return LogEntry$AssignedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F> AssignedPartitions<F> unapply(AssignedPartitions<F> assignedPartitions) {
            return LogEntry$AssignedPartitions$.MODULE$.unapply(assignedPartitions);
        }

        public AssignedPartitions(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AssignedPartitions)) return false;
            AssignedPartitions assignedPartitions = (AssignedPartitions)object;
            SortedSet<TopicPartition> sortedSet = this.partitions();
            SortedSet<TopicPartition> sortedSet2 = assignedPartitions.partitions();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = assignedPartitions.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AssignedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AssignedPartitions";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "partitions";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public SortedSet<TopicPartition> partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(41).append("Assigned partitions [").append(this.partitions().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> AssignedPartitions<F> copy(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            return new AssignedPartitions<F>(partitions, state);
        }

        public <F> SortedSet<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public SortedSet<TopicPartition> _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class CommittedPendingCommits<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Chain pendingCommits;
        private final KafkaConsumerActor.State state;

        public static <F> CommittedPendingCommits<F> apply(Chain<KafkaConsumerActor.Request.Commit<F>> chain, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$CommittedPendingCommits$.MODULE$.apply(chain, state);
        }

        public static CommittedPendingCommits<?> fromProduct(Product product) {
            return LogEntry$CommittedPendingCommits$.MODULE$.fromProduct(product);
        }

        public static <F> CommittedPendingCommits<F> unapply(CommittedPendingCommits<F> committedPendingCommits) {
            return LogEntry$CommittedPendingCommits$.MODULE$.unapply(committedPendingCommits);
        }

        public CommittedPendingCommits(Chain<KafkaConsumerActor.Request.Commit<F>> pendingCommits, KafkaConsumerActor.State<F, ?, ?> state) {
            this.pendingCommits = pendingCommits;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommittedPendingCommits)) return false;
            CommittedPendingCommits committedPendingCommits = (CommittedPendingCommits)object;
            Chain<KafkaConsumerActor.Request.Commit<F>> chain = this.pendingCommits();
            Chain<KafkaConsumerActor.Request.Commit<F>> chain2 = committedPendingCommits.pendingCommits();
            if (chain == null) {
                if (chain2 != null) {
                    return false;
                }
            } else if (!chain.equals(chain2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = committedPendingCommits.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommittedPendingCommits;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CommittedPendingCommits";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "pendingCommits";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Chain<KafkaConsumerActor.Request.Commit<F>> pendingCommits() {
            return this.pendingCommits;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(47).append("Committed pending commits [").append(this.pendingCommits()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> CommittedPendingCommits<F> copy(Chain<KafkaConsumerActor.Request.Commit<F>> pendingCommits, KafkaConsumerActor.State<F, ?, ?> state) {
            return new CommittedPendingCommits<F>(pendingCommits, state);
        }

        public <F> Chain<KafkaConsumerActor.Request.Commit<F>> copy$default$1() {
            return this.pendingCommits();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Chain<KafkaConsumerActor.Request.Commit<F>> _1() {
            return this.pendingCommits();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class CompletedFetchesWithRecords<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F> CompletedFetchesWithRecords<F> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$CompletedFetchesWithRecords$.MODULE$.apply(map, state);
        }

        public static CompletedFetchesWithRecords<?> fromProduct(Product product) {
            return LogEntry$CompletedFetchesWithRecords$.MODULE$.fromProduct(product);
        }

        public static <F> CompletedFetchesWithRecords<F> unapply(CompletedFetchesWithRecords<F> completedFetchesWithRecords) {
            return LogEntry$CompletedFetchesWithRecords$.MODULE$.unapply(completedFetchesWithRecords);
        }

        public CompletedFetchesWithRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CompletedFetchesWithRecords)) return false;
            CompletedFetchesWithRecords completedFetchesWithRecords = (CompletedFetchesWithRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = completedFetchesWithRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = completedFetchesWithRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CompletedFetchesWithRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CompletedFetchesWithRecords";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "records";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(67).append("Completed fetches with records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> CompletedFetchesWithRecords<F> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            return new CompletedFetchesWithRecords<F>(records, state);
        }

        public <F> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class ManuallyAssignedPartitions<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Object partitions;
        private final KafkaConsumerActor.State state;

        public static <F> ManuallyAssignedPartitions<F> apply(Object object, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.apply(object, state);
        }

        public static ManuallyAssignedPartitions<?> fromProduct(Product product) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F> ManuallyAssignedPartitions<F> unapply(ManuallyAssignedPartitions<F> manuallyAssignedPartitions) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.unapply(manuallyAssignedPartitions);
        }

        public ManuallyAssignedPartitions(Object partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ManuallyAssignedPartitions)) return false;
            ManuallyAssignedPartitions manuallyAssignedPartitions = (ManuallyAssignedPartitions)object;
            if (!BoxesRunTime.equals((Object)this.partitions(), (Object)manuallyAssignedPartitions.partitions())) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = manuallyAssignedPartitions.state();
            if (state != null) {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
            if (state2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ManuallyAssignedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ManuallyAssignedPartitions";
        }

        public Object productElement(int n) {
            KafkaConsumerActor.State<F, ?, ?> state;
            int n2 = n;
            if (0 == n2) {
                state = this._1();
            } else if (1 == n2) {
                state = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return state;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "partitions";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Object partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(59).append("Consumer manually assigned partitions [").append(package.all$.MODULE$.toFoldableOps(this.partitions(), (Foldable)NonEmptySetImpl$.MODULE$.catsDataInstancesForNonEmptySet()).toList().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> ManuallyAssignedPartitions<F> copy(Object partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            return new ManuallyAssignedPartitions<F>(partitions, state);
        }

        public <F> Object copy$default$1() {
            return this.partitions();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Object _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class RemovedRevokedRecords<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F> RemovedRevokedRecords<F> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$RemovedRevokedRecords$.MODULE$.apply(map, state);
        }

        public static RemovedRevokedRecords<?> fromProduct(Product product) {
            return LogEntry$RemovedRevokedRecords$.MODULE$.fromProduct(product);
        }

        public static <F> RemovedRevokedRecords<F> unapply(RemovedRevokedRecords<F> removedRevokedRecords) {
            return LogEntry$RemovedRevokedRecords$.MODULE$.unapply(removedRevokedRecords);
        }

        public RemovedRevokedRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RemovedRevokedRecords)) return false;
            RemovedRevokedRecords removedRevokedRecords = (RemovedRevokedRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = removedRevokedRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = removedRevokedRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RemovedRevokedRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RemovedRevokedRecords";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "records";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(60).append("Removed revoked records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> RemovedRevokedRecords<F> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            return new RemovedRevokedRecords<F>(records, state);
        }

        public <F> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class RevokedFetchesWithRecords<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F> RevokedFetchesWithRecords<F> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$RevokedFetchesWithRecords$.MODULE$.apply(map, state);
        }

        public static RevokedFetchesWithRecords<?> fromProduct(Product product) {
            return LogEntry$RevokedFetchesWithRecords$.MODULE$.fromProduct(product);
        }

        public static <F> RevokedFetchesWithRecords<F> unapply(RevokedFetchesWithRecords<F> revokedFetchesWithRecords) {
            return LogEntry$RevokedFetchesWithRecords$.MODULE$.unapply(revokedFetchesWithRecords);
        }

        public RevokedFetchesWithRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedFetchesWithRecords)) return false;
            RevokedFetchesWithRecords revokedFetchesWithRecords = (RevokedFetchesWithRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = revokedFetchesWithRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = revokedFetchesWithRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedFetchesWithRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedFetchesWithRecords";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "records";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(65).append("Revoked fetches with records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> RevokedFetchesWithRecords<F> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            return new RevokedFetchesWithRecords<F>(records, state);
        }

        public <F> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class RevokedFetchesWithoutRecords<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Set partitions;
        private final KafkaConsumerActor.State state;

        public static <F> RevokedFetchesWithoutRecords<F> apply(Set<TopicPartition> set, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$RevokedFetchesWithoutRecords$.MODULE$.apply(set, state);
        }

        public static RevokedFetchesWithoutRecords<?> fromProduct(Product product) {
            return LogEntry$RevokedFetchesWithoutRecords$.MODULE$.fromProduct(product);
        }

        public static <F> RevokedFetchesWithoutRecords<F> unapply(RevokedFetchesWithoutRecords<F> revokedFetchesWithoutRecords) {
            return LogEntry$RevokedFetchesWithoutRecords$.MODULE$.unapply(revokedFetchesWithoutRecords);
        }

        public RevokedFetchesWithoutRecords(Set<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedFetchesWithoutRecords)) return false;
            RevokedFetchesWithoutRecords revokedFetchesWithoutRecords = (RevokedFetchesWithoutRecords)object;
            Set<TopicPartition> set = this.partitions();
            Set<TopicPartition> set2 = revokedFetchesWithoutRecords.partitions();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = revokedFetchesWithoutRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedFetchesWithoutRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedFetchesWithoutRecords";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "partitions";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Set<TopicPartition> partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(68).append("Revoked fetches without records for partitions [").append(this.partitions().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> RevokedFetchesWithoutRecords<F> copy(Set<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            return new RevokedFetchesWithoutRecords<F>(partitions, state);
        }

        public <F> Set<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Set<TopicPartition> _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class RevokedPartitions<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final SortedSet partitions;
        private final KafkaConsumerActor.State state;

        public static <F> RevokedPartitions<F> apply(SortedSet<TopicPartition> sortedSet, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$RevokedPartitions$.MODULE$.apply(sortedSet, state);
        }

        public static RevokedPartitions<?> fromProduct(Product product) {
            return LogEntry$RevokedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F> RevokedPartitions<F> unapply(RevokedPartitions<F> revokedPartitions) {
            return LogEntry$RevokedPartitions$.MODULE$.unapply(revokedPartitions);
        }

        public RevokedPartitions(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedPartitions)) return false;
            RevokedPartitions revokedPartitions = (RevokedPartitions)object;
            SortedSet<TopicPartition> sortedSet = this.partitions();
            SortedSet<TopicPartition> sortedSet2 = revokedPartitions.partitions();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = revokedPartitions.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedPartitions";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "partitions";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public SortedSet<TopicPartition> partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(40).append("Revoked partitions [").append(this.partitions().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> RevokedPartitions<F> copy(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            return new RevokedPartitions<F>(partitions, state);
        }

        public <F> SortedSet<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public SortedSet<TopicPartition> _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class RevokedPreviousFetch
    extends LogEntry
    implements Product,
    Serializable {
        private final TopicPartition partition;
        private final int streamId;

        public static RevokedPreviousFetch apply(TopicPartition topicPartition, int n) {
            return LogEntry$RevokedPreviousFetch$.MODULE$.apply(topicPartition, n);
        }

        public static RevokedPreviousFetch fromProduct(Product product) {
            return LogEntry$RevokedPreviousFetch$.MODULE$.fromProduct(product);
        }

        public static RevokedPreviousFetch unapply(RevokedPreviousFetch revokedPreviousFetch) {
            return LogEntry$RevokedPreviousFetch$.MODULE$.unapply(revokedPreviousFetch);
        }

        public RevokedPreviousFetch(TopicPartition partition, int streamId) {
            this.partition = partition;
            this.streamId = streamId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.partition()));
            n = Statics.mix((int)n, (int)this.streamId());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedPreviousFetch)) return false;
            RevokedPreviousFetch revokedPreviousFetch = (RevokedPreviousFetch)object;
            TopicPartition topicPartition = this.partition();
            TopicPartition topicPartition2 = revokedPreviousFetch.partition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            if (this.streamId() != revokedPreviousFetch.streamId()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedPreviousFetch;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokedPreviousFetch";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = BoxesRunTime.boxToInteger((int)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "partition";
            } else if (1 == n2) {
                string = "streamId";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public TopicPartition partition() {
            return this.partition;
        }

        public int streamId() {
            return this.streamId;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Warn$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(61).append("Revoked previous fetch for partition [").append(this.partition()).append("] in stream with id [").append(this.streamId()).append("].").toString();
        }

        public RevokedPreviousFetch copy(TopicPartition partition, int streamId) {
            return new RevokedPreviousFetch(partition, streamId);
        }

        public TopicPartition copy$default$1() {
            return this.partition();
        }

        public int copy$default$2() {
            return this.streamId();
        }

        public TopicPartition _1() {
            return this.partition();
        }

        public int _2() {
            return this.streamId();
        }
    }

    public static final class StoredFetch<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final TopicPartition partition;
        private final Function1 callback;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> StoredFetch<F, K, V> apply(TopicPartition topicPartition, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, Object> function1, KafkaConsumerActor.State<F, K, V> state) {
            return LogEntry$StoredFetch$.MODULE$.apply(topicPartition, function1, state);
        }

        public static StoredFetch<?, ?, ?> fromProduct(Product product) {
            return LogEntry$StoredFetch$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> StoredFetch<F, K, V> unapply(StoredFetch<F, K, V> storedFetch) {
            return LogEntry$StoredFetch$.MODULE$.unapply(storedFetch);
        }

        public StoredFetch(TopicPartition partition, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, Object> callback, KafkaConsumerActor.State<F, K, V> state) {
            this.partition = partition;
            this.callback = callback;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredFetch)) return false;
            StoredFetch storedFetch = (StoredFetch)object;
            TopicPartition topicPartition = this.partition();
            TopicPartition topicPartition2 = storedFetch.partition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> function1 = this.callback();
            Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> function12 = storedFetch.callback();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            KafkaConsumerActor.State<F, K, V> state = this.state();
            KafkaConsumerActor.State<F, K, V> state2 = storedFetch.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredFetch;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "StoredFetch";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "partition";
                    break;
                }
                case 1: {
                    string = "callback";
                    break;
                }
                case 2: {
                    string = "state";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public TopicPartition partition() {
            return this.partition;
        }

        public Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> callback() {
            return this.callback;
        }

        public KafkaConsumerActor.State<F, K, V> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(51).append("Stored fetch [").append(this.callback()).append("] for partition [").append(this.partition()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F, K, V> StoredFetch<F, K, V> copy(TopicPartition partition, Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, Object> callback, KafkaConsumerActor.State<F, K, V> state) {
            return new StoredFetch<F, K, V>(partition, callback, state);
        }

        public <F, K, V> TopicPartition copy$default$1() {
            return this.partition();
        }

        public <F, K, V> Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> copy$default$2() {
            return this.callback();
        }

        public <F, K, V> KafkaConsumerActor.State<F, K, V> copy$default$3() {
            return this.state();
        }

        public TopicPartition _1() {
            return this.partition();
        }

        public Function1<Tuple2<Chunk<CommittableConsumerRecord<F, K, V>>, KafkaConsumerActor.FetchCompletedReason>, F> _2() {
            return this.callback();
        }

        public KafkaConsumerActor.State<F, K, V> _3() {
            return this.state();
        }
    }

    public static final class StoredOnRebalance<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.OnRebalance onRebalance;
        private final KafkaConsumerActor.State state;

        public static <F> StoredOnRebalance<F> apply(KafkaConsumerActor.OnRebalance<F> onRebalance, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$StoredOnRebalance$.MODULE$.apply(onRebalance, state);
        }

        public static StoredOnRebalance<?> fromProduct(Product product) {
            return LogEntry$StoredOnRebalance$.MODULE$.fromProduct(product);
        }

        public static <F> StoredOnRebalance<F> unapply(StoredOnRebalance<F> storedOnRebalance) {
            return LogEntry$StoredOnRebalance$.MODULE$.unapply(storedOnRebalance);
        }

        public StoredOnRebalance(KafkaConsumerActor.OnRebalance<F> onRebalance, KafkaConsumerActor.State<F, ?, ?> state) {
            this.onRebalance = onRebalance;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredOnRebalance)) return false;
            StoredOnRebalance storedOnRebalance = (StoredOnRebalance)object;
            KafkaConsumerActor.OnRebalance<F> onRebalance = this.onRebalance();
            KafkaConsumerActor.OnRebalance<F> onRebalance2 = storedOnRebalance.onRebalance();
            if (onRebalance == null) {
                if (onRebalance2 != null) {
                    return false;
                }
            } else if (!((Object)onRebalance).equals(onRebalance2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = storedOnRebalance.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredOnRebalance;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredOnRebalance";
        }

        public Object productElement(int n) {
            Product product;
            int n2 = n;
            if (0 == n2) {
                product = this._1();
            } else if (1 == n2) {
                product = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return product;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "onRebalance";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public KafkaConsumerActor.OnRebalance<F> onRebalance() {
            return this.onRebalance;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(40).append("Stored OnRebalance [").append(this.onRebalance()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> StoredOnRebalance<F> copy(KafkaConsumerActor.OnRebalance<F> onRebalance, KafkaConsumerActor.State<F, ?, ?> state) {
            return new StoredOnRebalance<F>(onRebalance, state);
        }

        public <F> KafkaConsumerActor.OnRebalance<F> copy$default$1() {
            return this.onRebalance();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public KafkaConsumerActor.OnRebalance<F> _1() {
            return this.onRebalance();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class StoredPendingCommit<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.Request.Commit commit;
        private final KafkaConsumerActor.State state;

        public static <F> StoredPendingCommit<F> apply(KafkaConsumerActor.Request.Commit<F> commit, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$StoredPendingCommit$.MODULE$.apply(commit, state);
        }

        public static StoredPendingCommit<?> fromProduct(Product product) {
            return LogEntry$StoredPendingCommit$.MODULE$.fromProduct(product);
        }

        public static <F> StoredPendingCommit<F> unapply(StoredPendingCommit<F> storedPendingCommit) {
            return LogEntry$StoredPendingCommit$.MODULE$.unapply(storedPendingCommit);
        }

        public StoredPendingCommit(KafkaConsumerActor.Request.Commit<F> commit, KafkaConsumerActor.State<F, ?, ?> state) {
            this.commit = commit;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredPendingCommit)) return false;
            StoredPendingCommit storedPendingCommit = (StoredPendingCommit)object;
            KafkaConsumerActor.Request.Commit<F> commit = this.commit();
            KafkaConsumerActor.Request.Commit<F> commit2 = storedPendingCommit.commit();
            if (commit == null) {
                if (commit2 != null) {
                    return false;
                }
            } else if (!((Object)commit).equals(commit2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = storedPendingCommit.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredPendingCommit;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredPendingCommit";
        }

        public Object productElement(int n) {
            Product product;
            int n2 = n;
            if (0 == n2) {
                product = this._1();
            } else if (1 == n2) {
                product = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return product;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "commit";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public KafkaConsumerActor.Request.Commit<F> commit() {
            return this.commit;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(71).append("Stored pending commit [").append(this.commit()).append("] as rebalance is in-progress. Current state [").append(this.state()).append("].").toString();
        }

        public <F> StoredPendingCommit<F> copy(KafkaConsumerActor.Request.Commit<F> commit, KafkaConsumerActor.State<F, ?, ?> state) {
            return new StoredPendingCommit<F>(commit, state);
        }

        public <F> KafkaConsumerActor.Request.Commit<F> copy$default$1() {
            return this.commit();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public KafkaConsumerActor.Request.Commit<F> _1() {
            return this.commit();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class StoredRecords<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Map records;
        private final KafkaConsumerActor.State state;

        public static <F> StoredRecords<F> apply(Map<TopicPartition, Vector> map, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$StoredRecords$.MODULE$.apply(map, state);
        }

        public static StoredRecords<?> fromProduct(Product product) {
            return LogEntry$StoredRecords$.MODULE$.fromProduct(product);
        }

        public static <F> StoredRecords<F> unapply(StoredRecords<F> storedRecords) {
            return LogEntry$StoredRecords$.MODULE$.unapply(storedRecords);
        }

        public StoredRecords(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            this.records = records;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredRecords)) return false;
            StoredRecords storedRecords = (StoredRecords)object;
            Map<TopicPartition, Vector> map = this.records();
            Map<TopicPartition, Vector> map2 = storedRecords.records();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = storedRecords.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredRecords;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredRecords";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "records";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Map<TopicPartition, Vector> records() {
            return this.records;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(51).append("Stored records for partitions [").append(LogEntry$.MODULE$.recordsString(this.records())).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> StoredRecords<F> copy(Map<TopicPartition, Vector> records, KafkaConsumerActor.State<F, ?, ?> state) {
            return new StoredRecords<F>(records, state);
        }

        public <F> Map<TopicPartition, Vector> copy$default$1() {
            return this.records();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Map<TopicPartition, Vector> _1() {
            return this.records();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class SubscribedPattern<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Pattern pattern;
        private final KafkaConsumerActor.State state;

        public static <F> SubscribedPattern<F> apply(Pattern pattern, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$SubscribedPattern$.MODULE$.apply(pattern, state);
        }

        public static SubscribedPattern<?> fromProduct(Product product) {
            return LogEntry$SubscribedPattern$.MODULE$.fromProduct(product);
        }

        public static <F> SubscribedPattern<F> unapply(SubscribedPattern<F> subscribedPattern) {
            return LogEntry$SubscribedPattern$.MODULE$.unapply(subscribedPattern);
        }

        public SubscribedPattern(Pattern pattern, KafkaConsumerActor.State<F, ?, ?> state) {
            this.pattern = pattern;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribedPattern)) return false;
            SubscribedPattern subscribedPattern = (SubscribedPattern)object;
            Pattern pattern = this.pattern();
            Pattern pattern2 = subscribedPattern.pattern();
            if (pattern == null) {
                if (pattern2 != null) {
                    return false;
                }
            } else if (!pattern.equals(pattern2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = subscribedPattern.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubscribedPattern;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubscribedPattern";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            if (0 == n2) {
                serializable = this._1();
            } else if (1 == n2) {
                serializable = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "pattern";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Pattern pattern() {
            return this.pattern;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(52).append("Consumer subscribed to pattern [").append(this.pattern()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> SubscribedPattern<F> copy(Pattern pattern, KafkaConsumerActor.State<F, ?, ?> state) {
            return new SubscribedPattern<F>(pattern, state);
        }

        public <F> Pattern copy$default$1() {
            return this.pattern();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Pattern _1() {
            return this.pattern();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class SubscribedTopics<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final NonEmptyList topics;
        private final KafkaConsumerActor.State state;

        public static <F> SubscribedTopics<F> apply(NonEmptyList<String> nonEmptyList, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$SubscribedTopics$.MODULE$.apply(nonEmptyList, state);
        }

        public static SubscribedTopics<?> fromProduct(Product product) {
            return LogEntry$SubscribedTopics$.MODULE$.fromProduct(product);
        }

        public static <F> SubscribedTopics<F> unapply(SubscribedTopics<F> subscribedTopics) {
            return LogEntry$SubscribedTopics$.MODULE$.unapply(subscribedTopics);
        }

        public SubscribedTopics(NonEmptyList<String> topics, KafkaConsumerActor.State<F, ?, ?> state) {
            this.topics = topics;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribedTopics)) return false;
            SubscribedTopics subscribedTopics = (SubscribedTopics)object;
            NonEmptyList<String> nonEmptyList = this.topics();
            NonEmptyList<String> nonEmptyList2 = subscribedTopics.topics();
            if (nonEmptyList == null) {
                if (nonEmptyList2 != null) {
                    return false;
                }
            } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = subscribedTopics.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubscribedTopics;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubscribedTopics";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "topics";
            } else if (1 == n2) {
                string = "state";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public NonEmptyList<String> topics() {
            return this.topics;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(51).append("Consumer subscribed to topics [").append(this.topics().toList().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> SubscribedTopics<F> copy(NonEmptyList<String> topics, KafkaConsumerActor.State<F, ?, ?> state) {
            return new SubscribedTopics<F>(topics, state);
        }

        public <F> NonEmptyList<String> copy$default$1() {
            return this.topics();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public NonEmptyList<String> _1() {
            return this.topics();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class Unsubscribed<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.State state;

        public static <F> Unsubscribed<F> apply(KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$Unsubscribed$.MODULE$.apply(state);
        }

        public static Unsubscribed<?> fromProduct(Product product) {
            return LogEntry$Unsubscribed$.MODULE$.fromProduct(product);
        }

        public static <F> Unsubscribed<F> unapply(Unsubscribed<F> unsubscribed) {
            return LogEntry$Unsubscribed$.MODULE$.unapply(unsubscribed);
        }

        public Unsubscribed(KafkaConsumerActor.State<F, ?, ?> state) {
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unsubscribed)) return false;
            Unsubscribed unsubscribed = (Unsubscribed)object;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = unsubscribed.state();
            if (state != null) {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
            if (state2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Unsubscribed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Unsubscribed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "state";
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(60).append("Consumer unsubscribed from all partitions. Current state [").append(this.state()).append("].").toString();
        }

        public <F> Unsubscribed<F> copy(KafkaConsumerActor.State<F, ?, ?> state) {
            return new Unsubscribed<F>(state);
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$1() {
            return this.state();
        }

        public KafkaConsumerActor.State<F, ?, ?> _1() {
            return this.state();
        }
    }
}

