/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.internal;

import cats.Applicative;
import cats.FlatMap;
import cats.Foldable;
import cats.Functor;
import cats.Invariant$;
import cats.NonEmptyParallel;
import cats.UnorderedFoldable$;
import cats.data.Chain;
import cats.data.Chain$;
import cats.effect.implicits$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Ref;
import cats.effect.kernel.syntax.GenTemporalOps_$;
import cats.effect.std.Dispatcher;
import cats.effect.std.Queue;
import cats.effect.std.Queue$;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.IfFOps$;
import cats.syntax.IfMOps$;
import cats.syntax.NestedFoldableOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.kafka.CommitTimeoutException$;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.CommittableConsumerRecord$;
import fs2.kafka.CommittableOffset$;
import fs2.kafka.ConsumerRecord;
import fs2.kafka.ConsumerRecord$;
import fs2.kafka.ConsumerSettings;
import fs2.kafka.GenericDeserializer;
import fs2.kafka.Jitter;
import fs2.kafka.Key;
import fs2.kafka.Value;
import fs2.kafka.instances$;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.KafkaConsumerActor$;
import fs2.kafka.internal.KafkaConsumerActor$OnRebalance$;
import fs2.kafka.internal.KafkaConsumerActor$PartitionState$;
import fs2.kafka.internal.KafkaConsumerActor$Request$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Commit$;
import fs2.kafka.internal.KafkaConsumerActor$Request$ManualCommitSync$;
import fs2.kafka.internal.KafkaConsumerActor$Request$Poll$;
import fs2.kafka.internal.KafkaConsumerActor$Request$WithPermit$;
import fs2.kafka.internal.KafkaConsumerActor$State$;
import fs2.kafka.internal.LogEntry$AssignedPartitions$;
import fs2.kafka.internal.LogEntry$CommittedPendingCommit$;
import fs2.kafka.internal.LogEntry$RevokedPartitions$;
import fs2.kafka.internal.LogEntry$StoredPendingCommit$;
import fs2.kafka.internal.Logging;
import fs2.kafka.internal.WithConsumer;
import fs2.kafka.internal.converters$;
import fs2.kafka.internal.syntax$;
import fs2.kafka.internal.syntax$FiniteDurationSyntax$;
import fs2.kafka.internal.syntax$JavaUtilCollectionSyntax$;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedSet;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public final class KafkaConsumerActor<F, K, V> {
    private final ConsumerSettings<F, K, V> settings;
    private final GenericDeserializer<Key, F, K> keyDeserializer;
    private final GenericDeserializer<Value, F, V> valueDeserializer;
    private final Ref ref;
    private final Queue<F, Request<F, K, V>> requests;
    private final WithConsumer<F> withConsumer;
    private final Async<F> F;
    public final Dispatcher<F> fs2$kafka$internal$KafkaConsumerActor$$dispatcher;
    private final Logging<F> logging;
    private final Jitter<F> jitter;
    private final Option<String> consumerGroupId;
    private final ConsumerRebalanceListener consumerRebalanceListener;
    private final Duration pollTimeout;
    private final F poll;

    public KafkaConsumerActor(ConsumerSettings<F, K, V> settings, GenericDeserializer<Key, F, K> keyDeserializer, GenericDeserializer<Value, F, V> valueDeserializer, Ref<F, State<F, K, V>> ref, Queue<F, Request<F, K, V>> requests, WithConsumer<F> withConsumer, Async<F> F, Dispatcher<F> dispatcher, Logging<F> logging, Jitter<F> jitter) {
        this.settings = settings;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.ref = ref;
        this.requests = requests;
        this.withConsumer = withConsumer;
        this.F = F;
        this.fs2$kafka$internal$KafkaConsumerActor$$dispatcher = dispatcher;
        this.logging = logging;
        this.jitter = jitter;
        this.consumerGroupId = settings.properties().get((Object)"group.id");
        this.consumerRebalanceListener = new ConsumerRebalanceListener(this){
            private final /* synthetic */ KafkaConsumerActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onPartitionsRevoked(Collection partitions) {
                Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(partitions);
                this.$outer.fs2$kafka$internal$KafkaConsumerActor$$dispatcher.unsafeRunSync(this.$outer.fs2$kafka$internal$KafkaConsumerActor$$revoked(syntax$JavaUtilCollectionSyntax$.MODULE$.toSortedSet$extension(collection, instances$.MODULE$.fs2KafkaTopicPartitionOrdering())));
            }

            public void onPartitionsAssigned(Collection partitions) {
                Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(partitions);
                this.$outer.fs2$kafka$internal$KafkaConsumerActor$$dispatcher.unsafeRunSync(this.$outer.fs2$kafka$internal$KafkaConsumerActor$$assigned(syntax$JavaUtilCollectionSyntax$.MODULE$.toSortedSet$extension(collection, instances$.MODULE$.fs2KafkaTopicPartitionOrdering())));
            }
        };
        this.pollTimeout = syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(settings.pollTimeout()));
        Object updateStateBeforePoll = package.all$.MODULE$.toFlatMapOps(withConsumer.blocking((Function1 & Serializable)_$9 -> {
            Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(_$9.assignment());
            return syntax$JavaUtilCollectionSyntax$.MODULE$.toSet$extension(collection);
        }), F).flatMap((Function1 & Serializable)assignment -> ref.flatModify((Function1 & Serializable)x$1 -> {
            State state = x$1;
            State state2 = state;
            if (state2.subscribed() && state2.streaming()) {
                boolean isStreaming = true;
                Tuple2 tuple2 = state2.dropUnassignedPartitions((scala.collection.immutable.Set<TopicPartition>)assignment, logging);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                State newState = (State)tuple2._1();
                Object result = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)newState, result);
                State newState2 = (State)tuple22._1();
                Object result2 = tuple22._2();
                return Tuple2$.MODULE$.apply((Object)newState2, package.all$.MODULE$.toFunctorOps(result2, (Functor)F).map((Function1 & Serializable)_$10 -> Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)isStreaming), assignment, _$10)));
            }
            State state3 = state;
            boolean isStreaming = false;
            return Tuple2$.MODULE$.apply((Object)state3, F.pure((Object)Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)isStreaming), assignment, (Object)package$.MODULE$.List().empty())));
        }, (MonadCancel)F));
        Function2 & Serializable pollForRecords = (Function2 & Serializable)(assignment, queueIsFull) -> package.all$.MODULE$.toFlatMapOps(withConsumer.blocking((Function1 & Serializable)consumer -> {
            scala.collection.immutable.Set resumePartitions = (scala.collection.immutable.Set)assignment.$minus$minus((IterableOnce)queueIsFull);
            if (queueIsFull.nonEmpty()) {
                consumer.pause((Collection)converters$.MODULE$.collection().SeqHasAsJava((Seq)queueIsFull).asJava());
            }
            if (resumePartitions.nonEmpty()) {
                consumer.resume((Collection)converters$.MODULE$.collection().SetHasAsJava((Set)resumePartitions).asJava());
            }
            return consumer.poll(this.pollTimeout);
        }), (FlatMap)F).flatMap((Function1 & Serializable)batch -> this.records((ConsumerRecords<byte[], byte[]>)batch));
        Function2 & Serializable queueRecords = (Function2 & Serializable)(partitionState, newRecords) -> {
            Predef$.MODULE$.require(newRecords.forall((Function1 & Serializable)kv -> partitionState.contains(kv._1())));
            return package.all$.MODULE$.toTraverseOps((Object)partitionState.toList(), UnorderedFoldable$.MODULE$.catsTraverseForList()).flatTraverse((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    PartitionState partitionState = (PartitionState)tuple2._2();
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    if (partitionState != null) {
                        PartitionState partitionState2 = KafkaConsumerActor$PartitionState$.MODULE$.unapply(partitionState);
                        Queue queue = partitionState2._1();
                        Chunk chunk = partitionState2._2();
                        Deferred deferred = partitionState2._3();
                        Queue queue2 = queue;
                        Chunk spillover = chunk;
                        Chunk chunk2 = spillover.$plus$plus((Chunk)newRecords.getOrElse((Object)partition, KafkaConsumerActor::$anonfun$5));
                        Object object = package.all$.MODULE$.catsSyntaxIfM(F.pure((Object)BoxesRunTime.boxToBoolean((boolean)chunk2.isEmpty())), (FlatMap)F);
                        return IfMOps$.MODULE$.ifM$extension(object, () -> KafkaConsumerActor.$anonfun$4$$anonfun$2$$anonfun$1(F), () -> KafkaConsumerActor.$anonfun$4$$anonfun$2$$anonfun$2(queue2, chunk2, partition, F), (FlatMap)F);
                    }
                }
                throw new MatchError((Object)tuple2);
            }, (Applicative)F, (FlatMap)Invariant$.MODULE$.catsInstancesForList());
        };
        Function1 & Serializable updateStateAfterPoll = (Function1 & Serializable)spillover -> ref.flatModify((Function1 & Serializable)_$11 -> _$11.resetSpilloverAfterPoll(spillover).resetPendingCommitsAfterPoll(), (MonadCancel)F);
        this.poll = package.all$.MODULE$.toFlatMapOps(updateStateBeforePoll, F).flatMap((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple3 tuple3 = x$1;
            if (tuple3 != null && (bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1()))) {
                boolean isStreaming = bl;
                scala.collection.immutable.Set assignment = (scala.collection.immutable.Set)tuple3._2();
                List queueIsFull = (List)tuple3._3();
                return package.all$.MODULE$.toFlatMapOps(pollForRecords.apply((Object)assignment, (Object)queueIsFull), (FlatMap)F).flatMap((Function1 & Serializable)newRecords -> package.all$.MODULE$.toFlatMapOps(this.ensurePartitionStateFor((scala.collection.immutable.Set<TopicPartition>)newRecords.keySet()), (FlatMap)F).flatMap((Function1 & Serializable)partitionState -> package.all$.MODULE$.toFlatMapOps(queueRecords.apply(partitionState, newRecords), (FlatMap)F).flatMap((Function1 & Serializable)spillover -> package.all$.MODULE$.toFunctorOps(updateStateAfterPoll.apply((Object)spillover.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), (Functor)F).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }))));
            }
            return F.unit();
        });
    }

    public Ref<F, State<F, K, V>> ref() {
        return this.ref;
    }

    public ConsumerRebalanceListener consumerRebalanceListener() {
        return this.consumerRebalanceListener;
    }

    private F commitAsync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Either<Throwable, BoxedUnit>, BoxedUnit> callback) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.withConsumer.blocking((JProcedure1 & Serializable)_$2 -> _$2.commitAsync(converters$.MODULE$.collection().MapHasAsJava((Map)offsets).asJava(), (_$3, exception) -> callback.apply((Object)Option$.MODULE$.apply((Object)exception).toLeft((Function0 & Serializable)() -> {
            KafkaConsumerActor.commitAsync$$anonfun$1$$anonfun$1$$anonfun$1();
            return BoxedUnit.UNIT;
        })))), this.F);
        return (F)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, (Function1 & Serializable)e -> this.F.delay((Function0 & Serializable)() -> {
            KafkaConsumerActor.commitAsync$$anonfun$2$$anonfun$1(callback, e);
            return BoxedUnit.UNIT;
        }), this.F);
    }

    private F commit(Request.Commit<F> request) {
        return (F)this.ref().flatModify((Function1 & Serializable)state -> {
            F commitF = this.commitAsync(request.offsets(), request.callback());
            if (state.rebalancing() || state.pendingCommits().nonEmpty()) {
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(commitF, this.F);
                State newState = state.withPendingCommit(FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.$anonfun$7(request), this.F));
                return Tuple2$.MODULE$.apply(newState, this.logging.log(LogEntry$StoredPendingCommit$.MODULE$.apply(request, newState)));
            }
            return Tuple2$.MODULE$.apply(state, commitF);
        }, this.F);
    }

    private F manualCommitSync(Request.ManualCommitSync<F> request) {
        F commit = this.withConsumer.blocking((JProcedure1 & Serializable)_$4 -> _$4.commitSync(converters$.MODULE$.collection().MapHasAsJava(request.offsets()).asJava(), syntax$FiniteDurationSyntax$.MODULE$.toJava$extension(syntax$.MODULE$.FiniteDurationSyntax(this.settings.commitTimeout()))));
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(commit, this.F);
        Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), this.F);
        return (F)FlatMapOps$.MODULE$.$greater$greater$eq$extension(object2, request.callback(), this.F);
    }

    private F runCommitAsync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets, Function1<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>, F> k) {
        Object object = implicits$.MODULE$.genTemporalOps_(this.F.async((Function1 & Serializable)cb -> package.all$.MODULE$.toFunctorOps(k.apply(cb), this.F).as((Object)Some$.MODULE$.apply(this.F.unit()))));
        return (F)GenTemporalOps_$.MODULE$.timeoutTo$extension(object, this.settings.commitTimeout(), this.F.defer(() -> this.runCommitAsync$$anonfun$2(offsets)), this.F);
    }

    public F fs2$kafka$internal$KafkaConsumerActor$$assigned(SortedSet<TopicPartition> assigned) {
        Object object = package.all$.MODULE$.catsSyntaxFlatten(this.ref().flatModify((Function1 & Serializable)_$5 -> _$5.withAssignedPartitions(assigned, this.logging), this.F), this.F);
        return (F)FlattenOps$.MODULE$.flatten$extension(object, this.F);
    }

    public F fs2$kafka$internal$KafkaConsumerActor$$revoked(SortedSet<TopicPartition> revoked) {
        Object object = package.all$.MODULE$.catsSyntaxFlatten(this.ref().flatModify((Function1 & Serializable)_$6 -> _$6.withRevokedPartitions(revoked, this.logging), this.F), this.F);
        return (F)FlattenOps$.MODULE$.flatten$extension(object, this.F);
    }

    public F offsetCommitAsync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        return this.runCommitAsync(offsets, (Function1 & Serializable)cb -> this.requests.offer(KafkaConsumerActor$Request$Commit$.MODULE$.apply(offsets, (Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)cb)));
    }

    private F resilientOffsetCommitAsync(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.offsetCommitAsync(offsets), this.F);
        return (F)ApplicativeErrorOps$.MODULE$.handleErrorWith$extension(object, this.settings.commitRecovery().recoverCommitWith(offsets, this.offsetCommitAsync(offsets), this.F, this.jitter), this.F);
    }

    private CommittableConsumerRecord<F, K, V> committableConsumerRecord(ConsumerRecord<K, V> record, TopicPartition partition) {
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(record.offset() + 1L, (String)this.settings.recordMetadata().apply(record));
        return CommittableConsumerRecord$.MODULE$.apply(record, CommittableOffset$.MODULE$.apply(partition, offsetAndMetadata, this.consumerGroupId, (Function1<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, Object>)(Function1 & Serializable)offsets -> this.resilientOffsetCommitAsync((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets), this.F));
    }

    private F records(ConsumerRecords<byte[], byte[]> batch) {
        Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(batch.partitions());
        return (F)package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toTraverseOps(syntax$JavaUtilCollectionSyntax$.MODULE$.toVector$extension(collection), UnorderedFoldable$.MODULE$.catsTraverseForVector()).traverse((Function1 & Serializable)partition -> {
            Collection collection = syntax$.MODULE$.JavaUtilCollectionSyntax(batch.records(partition));
            return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toTraverseOps(syntax$JavaUtilCollectionSyntax$.MODULE$.toVector$extension(collection), UnorderedFoldable$.MODULE$.catsTraverseForVector()).traverse((Function1 & Serializable)record -> package.all$.MODULE$.toFunctorOps(ConsumerRecord$.MODULE$.fromJava((org.apache.kafka.clients.consumer.ConsumerRecord<byte[], byte[]>)record, this.keyDeserializer, this.valueDeserializer, this.F), this.F).map((Function1 & Serializable)_$7 -> this.committableConsumerRecord((ConsumerRecord<K, V>)_$7, (TopicPartition)partition)), this.F), this.F).map((Function1 & Serializable)records -> Tuple2$.MODULE$.apply(partition, (Object)Chunk$.MODULE$.from((Iterable)records)));
        }, this.F), this.F).map((Function1 & Serializable)_$8 -> _$8.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private F ensurePartitionStateFor(scala.collection.immutable.Set<TopicPartition> partitions) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.ref().get(), this.F).flatMap((Function1 & Serializable)state -> {
            List list = partitions.$minus$minus((IterableOnce)state.partitionState().keys()).toList();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list2 = list;
            if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                return this.F.pure(state.partitionState());
            }
            List missing = list;
            return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toTraverseOps((Object)missing, UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)partition -> package.all$.MODULE$.catsSyntaxTuple3Parallel(Tuple3$.MODULE$.apply(Queue$.MODULE$.bounded(this.settings.maxPrefetchBatches(), this.F), this.F.pure((Object)Chunk$.MODULE$.empty()), this.F.deferred())).parMapN((Function3 & Serializable)(_$12, _$13, _$14) -> {
                TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc(partition);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, KafkaConsumerActor$PartitionState$.MODULE$.apply(_$12, _$13, _$14, this.F));
            }, (NonEmptyParallel)implicits$.MODULE$.parallelForGenSpawn(this.F)), this.F), this.F).flatMap((Function1 & Serializable)newPartitionState -> {
                scala.collection.immutable.Map newPartitionStateMap = newPartitionState.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                return this.ref().modify((Function1 & Serializable)_$15 -> _$15.addPartitionStates(newPartitionStateMap));
            });
        });
    }

    public F getQueueAndStopSignalFor(TopicPartition partition) {
        return (F)package.all$.MODULE$.toFlatMapOps(this.ensurePartitionStateFor((scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition})))), this.F).flatMap((Function1 & Serializable)partitionState -> {
            Option option = partitionState.get((Object)partition);
            if (option instanceof Some) {
                PartitionState ps = (PartitionState)((Some)option).value();
                return this.F.pure((Object)Tuple2$.MODULE$.apply(ps.queue(), ps.closeSignal().get()));
            }
            if (None$.MODULE$.equals(option)) {
                return this.F.raiseError((Object)new IllegalStateException(new StringBuilder(29).append("PartitionState not added for ").append(partition).toString()));
            }
            throw new MatchError((Object)option);
        });
    }

    public F handle(Request<F, K, V> request) {
        Request<F, K, V> request2 = request;
        if (request2 instanceof Request.Poll && KafkaConsumerActor$Request$Poll$.MODULE$.unapply((Request.Poll)request2)) {
            return this.poll;
        }
        if (request2 instanceof Request.Commit) {
            Request.Commit commit = KafkaConsumerActor$Request$Commit$.MODULE$.unapply((Request.Commit)request2);
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = commit._1();
            Function1<Either<Throwable, BoxedUnit>, BoxedUnit> function1 = commit._2();
            Request.Commit request3 = (Request.Commit)request2;
            return this.commit(request3);
        }
        if (request2 instanceof Request.ManualCommitSync) {
            Request.ManualCommitSync manualCommitSync = KafkaConsumerActor$Request$ManualCommitSync$.MODULE$.unapply((Request.ManualCommitSync)request2);
            scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> map = manualCommitSync._1();
            Function1 function1 = manualCommitSync._2();
            Request.ManualCommitSync request4 = (Request.ManualCommitSync)request2;
            return this.manualCommitSync(request4);
        }
        if (request2 instanceof Request.WithPermit) {
            Request.WithPermit withPermit = KafkaConsumerActor$Request$WithPermit$.MODULE$.unapply((Request.WithPermit)request2);
            Object f = withPermit._1();
            Function1 function1 = withPermit._2();
            Object fa = f;
            Function1 cb = function1;
            Object object = package.all$.MODULE$.catsSyntaxApplicativeError(fa, this.F);
            Object object2 = package.all$.MODULE$.catsSyntaxFlatMapOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.F), this.F);
            return (F)FlatMapOps$.MODULE$.$greater$greater$eq$extension(object2, cb, this.F);
        }
        throw new MatchError(request2);
    }

    private static final Chunk $anonfun$5() {
        return Chunk$.MODULE$.empty();
    }

    private static final Object $anonfun$4$$anonfun$2$$anonfun$1(Async F$6) {
        return F$6.pure((Object)package$.MODULE$.Nil());
    }

    private static final List $anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final List $anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2(TopicPartition partition$2, Chunk chunk$2) {
        TopicPartition topicPartition = (TopicPartition)Predef$.MODULE$.ArrowAssoc((Object)partition$2);
        return (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)topicPartition, (Object)chunk$2), (List)Nil$.MODULE$);
    }

    private static final Object $anonfun$4$$anonfun$2$$anonfun$2(Queue queue$2, Chunk chunk$1, TopicPartition partition$1, Async F$7) {
        Object object = package.all$.MODULE$.catsSyntaxIfF(queue$2.tryOffer((Object)chunk$1));
        return IfFOps$.MODULE$.ifF$extension(object, KafkaConsumerActor::$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$1, () -> KafkaConsumerActor.$anonfun$4$$anonfun$2$$anonfun$2$$anonfun$2(partition$1, chunk$1), (Functor)F$7);
    }

    private static final void commitAsync$$anonfun$1$$anonfun$1$$anonfun$1() {
    }

    private static final void commitAsync$$anonfun$2$$anonfun$1(Function1 callback$4, Throwable e$1) {
        callback$4.apply((Object)package$.MODULE$.Left().apply((Object)e$1));
    }

    private final Object $anonfun$7(Request.Commit request$2) {
        return this.logging.log(LogEntry$CommittedPendingCommit$.MODULE$.apply(request$2));
    }

    private final Object runCommitAsync$$anonfun$2(scala.collection.immutable.Map offsets$2) {
        return this.F.raiseError((Object)CommitTimeoutException$.MODULE$.apply(this.settings.commitTimeout(), (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsets$2));
    }

    public static final class OnRebalance<F>
    implements Product,
    Serializable {
        private final Function1 onAssigned;
        private final Function1 onRevoked;

        public static <F> OnRebalance<F> apply(Function1<SortedSet<TopicPartition>, Object> function1, Function1<SortedSet<TopicPartition>, Object> function12) {
            return KafkaConsumerActor$OnRebalance$.MODULE$.apply(function1, function12);
        }

        public static OnRebalance<?> fromProduct(Product product) {
            return KafkaConsumerActor$OnRebalance$.MODULE$.fromProduct(product);
        }

        public static <F> OnRebalance<F> unapply(OnRebalance<F> onRebalance) {
            return KafkaConsumerActor$OnRebalance$.MODULE$.unapply(onRebalance);
        }

        public OnRebalance(Function1<SortedSet<TopicPartition>, Object> onAssigned, Function1<SortedSet<TopicPartition>, Object> onRevoked) {
            this.onAssigned = onAssigned;
            this.onRevoked = onRevoked;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OnRebalance)) return false;
            OnRebalance onRebalance = (OnRebalance)object;
            Function1<SortedSet<TopicPartition>, F> function1 = this.onAssigned();
            Function1<SortedSet<TopicPartition>, F> function12 = onRebalance.onAssigned();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function1<SortedSet<TopicPartition>, F> function13 = this.onRevoked();
            Function1<SortedSet<TopicPartition>, F> function14 = onRebalance.onRevoked();
            if (function13 == null) {
                if (function14 == null) return true;
                return false;
            } else {
                if (!function13.equals(function14)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof OnRebalance;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "OnRebalance";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "onAssigned";
            }
            if (1 == n2) {
                return "onRevoked";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<SortedSet<TopicPartition>, F> onAssigned() {
            return this.onAssigned;
        }

        public Function1<SortedSet<TopicPartition>, F> onRevoked() {
            return this.onRevoked;
        }

        public String toString() {
            return new StringBuilder(12).append("OnRebalance$").append(System.identityHashCode(this)).toString();
        }

        public <F> OnRebalance<F> copy(Function1<SortedSet<TopicPartition>, Object> onAssigned, Function1<SortedSet<TopicPartition>, Object> onRevoked) {
            return new OnRebalance<F>(onAssigned, onRevoked);
        }

        public <F> Function1<SortedSet<TopicPartition>, F> copy$default$1() {
            return this.onAssigned();
        }

        public <F> Function1<SortedSet<TopicPartition>, F> copy$default$2() {
            return this.onRevoked();
        }

        public Function1<SortedSet<TopicPartition>, F> _1() {
            return this.onAssigned();
        }

        public Function1<SortedSet<TopicPartition>, F> _2() {
            return this.onRevoked();
        }
    }

    public static final class PartitionState<F, K, V>
    implements Product,
    Serializable {
        private final Queue queue;
        private final Chunk spillover;
        private final Deferred closeSignal;
        private final Async<F> evidence$1;

        public static <F, K, V> PartitionState<F, K, V> apply(Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> queue, Chunk<CommittableConsumerRecord<F, K, V>> chunk, Deferred<F, BoxedUnit> deferred, Async<F> async) {
            return KafkaConsumerActor$PartitionState$.MODULE$.apply(queue, chunk, deferred, async);
        }

        public static <F, K, V> PartitionState<F, K, V> unapply(PartitionState<F, K, V> partitionState) {
            return KafkaConsumerActor$PartitionState$.MODULE$.unapply(partitionState);
        }

        public PartitionState(Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> queue, Chunk<CommittableConsumerRecord<F, K, V>> spillover, Deferred<F, BoxedUnit> closeSignal, Async<F> evidence$1) {
            this.queue = queue;
            this.spillover = spillover;
            this.closeSignal = closeSignal;
            this.evidence$1 = evidence$1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PartitionState)) return false;
            PartitionState partitionState = (PartitionState)object;
            Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> queue = this.queue();
            Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> queue2 = partitionState.queue();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            Chunk<CommittableConsumerRecord<F, K, V>> chunk = this.spillover();
            Chunk<CommittableConsumerRecord<F, K, V>> chunk2 = partitionState.spillover();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Deferred<F, BoxedUnit> deferred = this.closeSignal();
            Deferred<F, BoxedUnit> deferred2 = partitionState.closeSignal();
            if (deferred == null) {
                if (deferred2 == null) return true;
                return false;
            } else {
                if (!deferred.equals(deferred2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof PartitionState;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PartitionState";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "queue";
                }
                case 1: {
                    return "spillover";
                }
                case 2: {
                    return "closeSignal";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> queue() {
            return this.queue;
        }

        public Chunk<CommittableConsumerRecord<F, K, V>> spillover() {
            return this.spillover;
        }

        public Deferred<F, BoxedUnit> closeSignal() {
            return this.closeSignal;
        }

        public boolean isQueueFull() {
            return this.spillover().nonEmpty();
        }

        public F close() {
            return (F)package.all$.MODULE$.toFunctorOps(this.closeSignal().complete((Object)BoxedUnit.UNIT), this.evidence$1).void();
        }

        public String toString() {
            Option option = this.spillover().head();
            if (None$.MODULE$.equals(option)) {
                return "()";
            }
            if (option instanceof Some) {
                CommittableConsumerRecord record = (CommittableConsumerRecord)((Some)option).value();
                return new StringBuilder(20).append("(offset = ").append(record.offset()).append(", size = ").append(this.spillover().size()).append(")").toString();
            }
            throw new MatchError((Object)option);
        }

        public <F, K, V> PartitionState<F, K, V> copy(Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> queue, Chunk<CommittableConsumerRecord<F, K, V>> spillover, Deferred<F, BoxedUnit> closeSignal, Async<F> evidence$1) {
            return new PartitionState<F, K, V>(queue, spillover, closeSignal, evidence$1);
        }

        public <F, K, V> Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> copy$default$1() {
            return this.queue();
        }

        public <F, K, V> Chunk<CommittableConsumerRecord<F, K, V>> copy$default$2() {
            return this.spillover();
        }

        public <F, K, V> Deferred<F, BoxedUnit> copy$default$3() {
            return this.closeSignal();
        }

        public Queue<F, Chunk<CommittableConsumerRecord<F, K, V>>> _1() {
            return this.queue();
        }

        public Chunk<CommittableConsumerRecord<F, K, V>> _2() {
            return this.spillover();
        }

        public Deferred<F, BoxedUnit> _3() {
            return this.closeSignal();
        }
    }

    public static abstract class Request<F, K, V> {
        public static int ordinal(Request<?, ?, ?> request) {
            return KafkaConsumerActor$Request$.MODULE$.ordinal(request);
        }

        public static <F> Poll<F> poll() {
            return KafkaConsumerActor$Request$.MODULE$.poll();
        }

        public static final class Poll<F>
        extends Request<F, Object, Object>
        implements Product,
        Serializable {
            public static <F> Poll<F> apply() {
                return KafkaConsumerActor$Request$Poll$.MODULE$.apply();
            }

            public static Poll<?> fromProduct(Product product) {
                return KafkaConsumerActor$Request$Poll$.MODULE$.fromProduct(product);
            }

            public static <F> boolean unapply(Poll<F> poll) {
                return KafkaConsumerActor$Request$Poll$.MODULE$.unapply(poll);
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Poll)) return false;
                Poll poll = (Poll)object;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Poll;
            }

            public int productArity() {
                return 0;
            }

            public String productPrefix() {
                return "Poll";
            }

            public Object productElement(int n) {
                int n2 = n;
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public <F> Poll<F> copy() {
                return new Poll<F>();
            }
        }
    }

    public static final class State<F, K, V>
    implements Product,
    Serializable {
        private final scala.collection.immutable.Map partitionState;
        private final Chain pendingCommits;
        private final Chain onRebalances;
        private final boolean rebalancing;
        private final boolean subscribed;
        private final boolean streaming;
        private final Async<F> F;

        public static <F, K, V> State<F, K, V> apply(scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> map, Chain<Object> chain, Chain<OnRebalance<F>> chain2, boolean bl, boolean bl2, boolean bl3, Async<F> async) {
            return KafkaConsumerActor$State$.MODULE$.apply(map, chain, chain2, bl, bl2, bl3, async);
        }

        public static <F, K, V> State<F, K, V> empty(Async<F> async) {
            return KafkaConsumerActor$State$.MODULE$.empty(async);
        }

        public static <F, K, V> State<F, K, V> unapply(State<F, K, V> state) {
            return KafkaConsumerActor$State$.MODULE$.unapply(state);
        }

        public State(scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> partitionState, Chain<Object> pendingCommits, Chain<OnRebalance<F>> onRebalances, boolean rebalancing, boolean subscribed, boolean streaming, Async<F> F) {
            this.partitionState = partitionState;
            this.pendingCommits = pendingCommits;
            this.onRebalances = onRebalances;
            this.rebalancing = rebalancing;
            this.subscribed = subscribed;
            this.streaming = streaming;
            this.F = F;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.partitionState()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.pendingCommits()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.onRebalances()));
            n = Statics.mix((int)n, (int)(this.rebalancing() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.subscribed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.streaming() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.rebalancing() != state.rebalancing()) return false;
            if (this.subscribed() != state.subscribed()) return false;
            if (this.streaming() != state.streaming()) return false;
            scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> map = this.partitionState();
            scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> map2 = state.partitionState();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Chain<F> chain = this.pendingCommits();
            Chain<F> chain2 = state.pendingCommits();
            if (chain == null) {
                if (chain2 != null) {
                    return false;
                }
            } else if (!chain.equals(chain2)) return false;
            Chain<OnRebalance<F>> chain3 = this.onRebalances();
            Chain<OnRebalance<F>> chain4 = state.onRebalances();
            if (chain3 == null) {
                if (chain4 == null) return true;
                return false;
            } else {
                if (!chain3.equals(chain4)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "partitionState";
                }
                case 1: {
                    return "pendingCommits";
                }
                case 2: {
                    return "onRebalances";
                }
                case 3: {
                    return "rebalancing";
                }
                case 4: {
                    return "subscribed";
                }
                case 5: {
                    return "streaming";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> partitionState() {
            return this.partitionState;
        }

        public Chain<F> pendingCommits() {
            return this.pendingCommits;
        }

        public Chain<OnRebalance<F>> onRebalances() {
            return this.onRebalances;
        }

        public boolean rebalancing() {
            return this.rebalancing;
        }

        public boolean subscribed() {
            return this.subscribed;
        }

        public boolean streaming() {
            return this.streaming;
        }

        public Tuple2<State<F, K, V>, scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>>> addPartitionStates(scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> newPartitionState) {
            State<F, K, V> newState = this.copy((scala.collection.immutable.Map)newPartitionState.$plus$plus(this.partitionState()), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.F);
            return Tuple2$.MODULE$.apply(newState, newState.partitionState());
        }

        public Tuple2<State<F, K, V>, F> withAssignedPartitions(SortedSet<TopicPartition> assigned, Logging<F> logging) {
            State<F, K, V> newState = !this.rebalancing() ? this : this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), false, this.copy$default$5(), this.copy$default$6(), this.F);
            return Tuple2$.MODULE$.apply(newState, package.all$.MODULE$.toFunctorOps(logging.log(LogEntry$AssignedPartitions$.MODULE$.apply(assigned, newState)), this.F).as(package.all$.MODULE$.toFoldableOps(this.onRebalances(), (Foldable)Chain$.MODULE$.catsDataInstancesForChain()).traverse_(arg_0 -> KafkaConsumerActor$.fs2$kafka$internal$KafkaConsumerActor$State$$_$withAssignedPartitions$$anonfun$1(assigned, arg_0), this.F)));
        }

        public Tuple2<State<F, K, V>, F> withRevokedPartitions(SortedSet<TopicPartition> revoked, Logging<F> logging) {
            Tuple2 tuple2 = this.partitionState().partition(arg_0 -> KafkaConsumerActor$.fs2$kafka$internal$KafkaConsumerActor$State$$_$_$$anonfun$9(revoked, arg_0));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map revokedToClose = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map stillAssigned = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)revokedToClose, (Object)stillAssigned);
            scala.collection.immutable.Map revokedToClose2 = (scala.collection.immutable.Map)tuple22._1();
            scala.collection.immutable.Map stillAssigned2 = (scala.collection.immutable.Map)tuple22._2();
            State<F, K, V> newState = this.copy(stillAssigned2, this.copy$default$2(), this.copy$default$3(), true, this.copy$default$5(), this.copy$default$6(), this.F);
            return Tuple2$.MODULE$.apply(newState, package.all$.MODULE$.toFlatMapOps(logging.log(LogEntry$RevokedPartitions$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)revoked, revokedToClose2, newState)), this.F).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFunctorOps(package.all$.MODULE$.toFoldableOps((Object)revokedToClose2.values().toList(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_(KafkaConsumerActor$::fs2$kafka$internal$KafkaConsumerActor$State$$_$withRevokedPartitions$$anonfun$1$$anonfun$1, this.F), this.F).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return package.all$.MODULE$.toFoldableOps(this.onRebalances(), (Foldable)Chain$.MODULE$.catsDataInstancesForChain()).traverse_(arg_0 -> KafkaConsumerActor$.fs2$kafka$internal$KafkaConsumerActor$State$$_$withRevokedPartitions$$anonfun$1$$anonfun$2$$anonfun$1(revoked, arg_0), this.F);
                });
            }));
        }

        public Tuple2<State<F, K, V>, F> dropUnassignedPartitions(scala.collection.immutable.Set<TopicPartition> assignment, Logging<F> logging) {
            Tuple2 tuple2 = this.partitionState().partition(arg_0 -> KafkaConsumerActor$.fs2$kafka$internal$KafkaConsumerActor$State$$_$_$$anonfun$10(assignment, arg_0));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map assigned = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map revoked = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)assigned, (Object)revoked);
            scala.collection.immutable.Map assigned2 = (scala.collection.immutable.Map)tuple22._1();
            scala.collection.immutable.Map revoked2 = (scala.collection.immutable.Map)tuple22._2();
            State<F, K, V> newState = this.copy(assigned2, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.F);
            List queueIsFull = ((MapOps)assigned2.filter(KafkaConsumerActor$::fs2$kafka$internal$KafkaConsumerActor$State$$_$_$$anonfun$11)).keys().toList();
            Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(() -> this.dropUnassignedPartitions$$anonfun$1(revoked2, logging, newState));
            return Tuple2$.MODULE$.apply(newState, package.all$.MODULE$.toFunctorOps(ApplicativeByNameOps$.MODULE$.whenA$extension(function0, revoked2.nonEmpty(), this.F), this.F).as((Object)queueIsFull));
        }

        public State<F, K, V> resetSpilloverAfterPoll(scala.collection.immutable.Map<TopicPartition, Chunk<CommittableConsumerRecord<F, K, V>>> spillover) {
            Predef$.MODULE$.require(spillover.forall((Function1 & Serializable)kv -> this.partitionState().contains(kv._1())));
            scala.collection.immutable.Map newPartitionState = (scala.collection.immutable.Map)this.partitionState().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TopicPartition partition = (TopicPartition)tuple2._1();
                    PartitionState partitionState = (PartitionState)tuple2._2();
                    return Tuple2$.MODULE$.apply((Object)partition, spillover.get((Object)partition).map((Function1 & Serializable)spillover -> partitionState.copy(partitionState.copy$default$1(), spillover, partitionState.copy$default$3(), this.F)).getOrElse(() -> this.$anonfun$12$$anonfun$2(partitionState)));
                }
                throw new MatchError((Object)tuple2);
            });
            return this.copy(newPartitionState, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.F);
        }

        public Tuple2<State<F, K, V>, F> resetPendingCommitsAfterPoll() {
            if (this.pendingCommits().isEmpty() || this.rebalancing()) {
                return Tuple2$.MODULE$.apply((Object)this, this.F.unit());
            }
            Chain chain = Chain$.MODULE$.empty();
            scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> map = this.copy$default$1();
            Chain<OnRebalance<F>> chain2 = this.copy$default$3();
            boolean bl = this.copy$default$4();
            boolean bl2 = this.copy$default$5();
            boolean bl3 = this.copy$default$6();
            Chain chain3 = (Chain)package.all$.MODULE$.catsSyntaxNestedFoldable(this.pendingCommits(), (Foldable)Chain$.MODULE$.catsDataInstancesForChain());
            return Tuple2$.MODULE$.apply(this.copy(map, (Chain<Object>)chain, chain2, bl, bl2, bl3, this.F), NestedFoldableOps$.MODULE$.sequence_$extension((Object)chain3, (Foldable)Chain$.MODULE$.catsDataInstancesForChain(), this.F));
        }

        public State<F, K, V> withOnRebalance(OnRebalance<F> onRebalance) {
            Chain chain = this.onRebalances().append(onRebalance);
            scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> map = this.copy$default$1();
            Chain<F> chain2 = this.copy$default$2();
            boolean bl = this.copy$default$4();
            boolean bl2 = this.copy$default$5();
            boolean bl3 = this.copy$default$6();
            return this.copy(map, chain2, chain, bl, bl2, bl3, this.F);
        }

        public State<F, K, V> withPendingCommit(F pendingCommit) {
            Chain chain = this.pendingCommits().append(pendingCommit);
            scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> map = this.copy$default$1();
            Chain<OnRebalance<F>> chain2 = this.copy$default$3();
            boolean bl = this.copy$default$4();
            boolean bl2 = this.copy$default$5();
            boolean bl3 = this.copy$default$6();
            return this.copy(map, (Chain<Object>)chain, chain2, bl, bl2, bl3, this.F);
        }

        public State<F, K, V> asSubscribed() {
            if (this.subscribed()) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), true, this.copy$default$6(), this.F);
        }

        public State<F, K, V> asUnsubscribed() {
            if (!this.subscribed()) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), false, this.copy$default$6(), this.F);
        }

        public State<F, K, V> asStreaming() {
            if (this.streaming()) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), true, this.F);
        }

        public String toString() {
            return new StringBuilder(105).append("State(partitionState = ").append(this.partitionState()).append(", pendingCommits = ").append(this.pendingCommits()).append(", onRebalances = ").append(this.onRebalances()).append(", rebalancing = ").append(this.rebalancing()).append(", subscribed = ").append(this.subscribed()).append(", streaming = ").append(this.streaming()).append(")").toString();
        }

        public <F, K, V> State<F, K, V> copy(scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> partitionState, Chain<Object> pendingCommits, Chain<OnRebalance<F>> onRebalances, boolean rebalancing, boolean subscribed, boolean streaming, Async<F> F) {
            return new State<F, K, V>(partitionState, pendingCommits, onRebalances, rebalancing, subscribed, streaming, F);
        }

        public <F, K, V> scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> copy$default$1() {
            return this.partitionState();
        }

        public <F, K, V> Chain<F> copy$default$2() {
            return this.pendingCommits();
        }

        public <F, K, V> Chain<OnRebalance<F>> copy$default$3() {
            return this.onRebalances();
        }

        public boolean copy$default$4() {
            return this.rebalancing();
        }

        public boolean copy$default$5() {
            return this.subscribed();
        }

        public boolean copy$default$6() {
            return this.streaming();
        }

        public scala.collection.immutable.Map<TopicPartition, PartitionState<F, K, V>> _1() {
            return this.partitionState();
        }

        public Chain<F> _2() {
            return this.pendingCommits();
        }

        public Chain<OnRebalance<F>> _3() {
            return this.onRebalances();
        }

        public boolean _4() {
            return this.rebalancing();
        }

        public boolean _5() {
            return this.subscribed();
        }

        public boolean _6() {
            return this.streaming();
        }

        private final Object dropUnassignedPartitions$$anonfun$1(scala.collection.immutable.Map revoked$6, Logging logging$3, State newState$1) {
            return package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFoldableOps((Object)revoked$6.values().toList(), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_(KafkaConsumerActor$::fs2$kafka$internal$KafkaConsumerActor$State$$_$dropUnassignedPartitions$$anonfun$1$$anonfun$1, this.F), this.F).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package.all$.MODULE$.toFunctorOps(logging$3.log(LogEntry$RevokedPartitions$.MODULE$.apply((scala.collection.immutable.Set<TopicPartition>)revoked$6.keySet(), revoked$6, newState$1)), this.F).map((Function1)((JProcedure1 & Serializable)KafkaConsumerActor$::fs2$kafka$internal$KafkaConsumerActor$State$$_$dropUnassignedPartitions$$anonfun$1$$anonfun$2$$anonfun$1));
            });
        }

        private final PartitionState $anonfun$12$$anonfun$2(PartitionState partitionState$6) {
            if (partitionState$6.spillover().isEmpty()) {
                return partitionState$6;
            }
            Chunk chunk = Chunk$.MODULE$.empty();
            Queue queue = partitionState$6.copy$default$1();
            Deferred deferred = partitionState$6.copy$default$3();
            return partitionState$6.copy(queue, chunk, deferred, this.F);
        }
    }
}

