/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Show;
import cats.effect.kernel.Resource;
import fs2.kafka.AutoOffsetReset;
import fs2.kafka.AutoOffsetReset$EarliestOffsetReset$;
import fs2.kafka.AutoOffsetReset$LatestOffsetReset$;
import fs2.kafka.AutoOffsetReset$NoneOffsetReset$;
import fs2.kafka.CommitRecovery;
import fs2.kafka.ConsumerRecord;
import fs2.kafka.ConsumerSettings$;
import fs2.kafka.ConsumerSettings$ConsumerSettingsImpl$;
import fs2.kafka.GenericDeserializer;
import fs2.kafka.IsolationLevel;
import fs2.kafka.IsolationLevel$ReadCommittedIsolationLevel$;
import fs2.kafka.IsolationLevel$ReadUncommittedIsolationLevel$;
import fs2.kafka.Key;
import fs2.kafka.RebalanceRevokeMode;
import fs2.kafka.Value;
import fs2.kafka.security.KafkaCredentialStore;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ConsumerSettings<F, K, V> {
    public static <F, K, V> ConsumerSettings<F, K, V> apply(GenericDeserializer<Key, F, K> genericDeserializer, GenericDeserializer<Value, F, V> genericDeserializer2) {
        return ConsumerSettings$.MODULE$.apply(genericDeserializer, genericDeserializer2);
    }

    public static <F, K, V> ConsumerSettings<F, K, V> apply(GenericDeserializer<Key, F, K> genericDeserializer, Resource<F, GenericDeserializer<Value, F, V>> resource) {
        return ConsumerSettings$.MODULE$.apply(genericDeserializer, resource);
    }

    public static <F, K, V> ConsumerSettings<F, K, V> apply(Resource<F, GenericDeserializer<Key, F, K>> resource, GenericDeserializer<Value, F, V> genericDeserializer) {
        return ConsumerSettings$.MODULE$.apply(resource, genericDeserializer);
    }

    public static <F, K, V> ConsumerSettings<F, K, V> apply(Resource<F, GenericDeserializer<Key, F, K>> resource, Resource<F, GenericDeserializer<Value, F, V>> resource2) {
        return ConsumerSettings$.MODULE$.apply(resource, resource2);
    }

    public static <F, K, V> Show<ConsumerSettings<F, K, V>> consumerSettingsShow() {
        return ConsumerSettings$.MODULE$.consumerSettingsShow();
    }

    public static int ordinal(ConsumerSettings<?, ?, ?> consumerSettings) {
        return ConsumerSettings$.MODULE$.ordinal(consumerSettings);
    }

    public abstract Resource<F, GenericDeserializer<Key, F, K>> keyDeserializer();

    public abstract Resource<F, GenericDeserializer<Value, F, V>> valueDeserializer();

    public abstract <K0, V0> ConsumerSettings<F, K0, V0> withDeserializers(Resource<F, GenericDeserializer<Key, F, K0>> var1, Resource<F, GenericDeserializer<Value, F, V0>> var2);

    public abstract Option<ExecutionContext> customBlockingContext();

    public abstract ConsumerSettings<F, K, V> withCustomBlockingContext(ExecutionContext var1);

    public abstract Map<String, String> properties();

    public abstract ConsumerSettings<F, K, V> withBootstrapServers(String var1);

    public abstract ConsumerSettings<F, K, V> withAutoOffsetReset(AutoOffsetReset var1);

    public abstract ConsumerSettings<F, K, V> withClientId(String var1);

    public abstract ConsumerSettings<F, K, V> withGroupId(String var1);

    public abstract ConsumerSettings<F, K, V> withGroupInstanceId(String var1);

    public abstract ConsumerSettings<F, K, V> withMaxPollRecords(int var1);

    public abstract ConsumerSettings<F, K, V> withMaxPollInterval(FiniteDuration var1);

    public abstract FiniteDuration sessionTimeout();

    public abstract ConsumerSettings<F, K, V> withSessionTimeout(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withHeartbeatInterval(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withEnableAutoCommit(boolean var1);

    public abstract ConsumerSettings<F, K, V> withAutoCommitInterval(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withRequestTimeout(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withDefaultApiTimeout(FiniteDuration var1);

    public abstract ConsumerSettings<F, K, V> withIsolationLevel(IsolationLevel var1);

    public abstract ConsumerSettings<F, K, V> withAllowAutoCreateTopics(boolean var1);

    public abstract ConsumerSettings<F, K, V> withClientRack(String var1);

    public abstract ConsumerSettings<F, K, V> withProperty(String var1, String var2);

    public abstract ConsumerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> var1);

    public abstract ConsumerSettings<F, K, V> withProperties(Map<String, String> var1);

    public abstract FiniteDuration closeTimeout();

    public abstract ConsumerSettings<F, K, V> withCloseTimeout(FiniteDuration var1);

    public abstract FiniteDuration commitTimeout();

    public abstract ConsumerSettings<F, K, V> withCommitTimeout(FiniteDuration var1);

    public abstract FiniteDuration pollInterval();

    public abstract ConsumerSettings<F, K, V> withPollInterval(FiniteDuration var1);

    public abstract FiniteDuration pollTimeout();

    public abstract ConsumerSettings<F, K, V> withPollTimeout(FiniteDuration var1);

    public abstract CommitRecovery commitRecovery();

    public abstract ConsumerSettings<F, K, V> withCommitRecovery(CommitRecovery var1);

    public abstract Function1<ConsumerRecord<K, V>, String> recordMetadata();

    public abstract ConsumerSettings<F, K, V> withRecordMetadata(Function1<ConsumerRecord<K, V>, String> var1);

    public abstract int maxPrefetchBatches();

    public abstract ConsumerSettings<F, K, V> withMaxPrefetchBatches(int var1);

    public abstract ConsumerSettings<F, K, V> withCredentials(KafkaCredentialStore var1);

    public abstract RebalanceRevokeMode rebalanceRevokeMode();

    public abstract ConsumerSettings<F, K, V> withRebalanceRevokeMode(RebalanceRevokeMode var1);

    public static final class ConsumerSettingsImpl<F, K, V>
    extends ConsumerSettings<F, K, V>
    implements Product,
    Serializable {
        private final Resource keyDeserializer;
        private final Resource valueDeserializer;
        private final Option customBlockingContext;
        private final Map properties;
        private final FiniteDuration closeTimeout;
        private final FiniteDuration commitTimeout;
        private final FiniteDuration pollInterval;
        private final FiniteDuration pollTimeout;
        private final CommitRecovery commitRecovery;
        private final Function1 recordMetadata;
        private final int maxPrefetchBatches;
        private final RebalanceRevokeMode rebalanceRevokeMode;

        public static <F, K, V> ConsumerSettingsImpl<F, K, V> apply(Resource<F, GenericDeserializer<Key, F, K>> resource, Resource<F, GenericDeserializer<Value, F, V>> resource2, Option<ExecutionContext> option, Map<String, String> map, FiniteDuration finiteDuration, FiniteDuration finiteDuration2, FiniteDuration finiteDuration3, FiniteDuration finiteDuration4, CommitRecovery commitRecovery, Function1<ConsumerRecord<K, V>, String> function1, int n, RebalanceRevokeMode rebalanceRevokeMode) {
            return ConsumerSettings$ConsumerSettingsImpl$.MODULE$.apply(resource, resource2, option, map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n, rebalanceRevokeMode);
        }

        public static ConsumerSettingsImpl<?, ?, ?> fromProduct(Product product) {
            return ConsumerSettings$ConsumerSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> ConsumerSettingsImpl<F, K, V> unapply(ConsumerSettingsImpl<F, K, V> consumerSettingsImpl) {
            return ConsumerSettings$ConsumerSettingsImpl$.MODULE$.unapply(consumerSettingsImpl);
        }

        public ConsumerSettingsImpl(Resource<F, GenericDeserializer<Key, F, K>> keyDeserializer, Resource<F, GenericDeserializer<Value, F, V>> valueDeserializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, FiniteDuration commitTimeout, FiniteDuration pollInterval, FiniteDuration pollTimeout, CommitRecovery commitRecovery, Function1<ConsumerRecord<K, V>, String> recordMetadata, int maxPrefetchBatches, RebalanceRevokeMode rebalanceRevokeMode) {
            this.keyDeserializer = keyDeserializer;
            this.valueDeserializer = valueDeserializer;
            this.customBlockingContext = customBlockingContext;
            this.properties = properties;
            this.closeTimeout = closeTimeout;
            this.commitTimeout = commitTimeout;
            this.pollInterval = pollInterval;
            this.pollTimeout = pollTimeout;
            this.commitRecovery = commitRecovery;
            this.recordMetadata = recordMetadata;
            this.maxPrefetchBatches = maxPrefetchBatches;
            this.rebalanceRevokeMode = rebalanceRevokeMode;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keyDeserializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.valueDeserializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.customBlockingContext()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.closeTimeout()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commitTimeout()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pollInterval()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pollTimeout()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commitRecovery()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.recordMetadata()));
            n = Statics.mix((int)n, (int)this.maxPrefetchBatches());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.rebalanceRevokeMode()));
            return Statics.finalizeHash((int)n, (int)12);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConsumerSettingsImpl)) return false;
            ConsumerSettingsImpl consumerSettingsImpl = (ConsumerSettingsImpl)object;
            if (this.maxPrefetchBatches() != consumerSettingsImpl.maxPrefetchBatches()) return false;
            Resource<F, GenericDeserializer<Key, F, K>> resource = this.keyDeserializer();
            Resource<F, GenericDeserializer<Key, F, K>> resource2 = consumerSettingsImpl.keyDeserializer();
            if (resource == null) {
                if (resource2 != null) {
                    return false;
                }
            } else if (!resource.equals(resource2)) return false;
            Resource<F, GenericDeserializer<Value, F, V>> resource3 = this.valueDeserializer();
            Resource<F, GenericDeserializer<Value, F, V>> resource4 = consumerSettingsImpl.valueDeserializer();
            if (resource3 == null) {
                if (resource4 != null) {
                    return false;
                }
            } else if (!resource3.equals(resource4)) return false;
            Option<ExecutionContext> option = this.customBlockingContext();
            Option<ExecutionContext> option2 = consumerSettingsImpl.customBlockingContext();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = consumerSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            FiniteDuration finiteDuration = this.closeTimeout();
            FiniteDuration finiteDuration2 = consumerSettingsImpl.closeTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!finiteDuration.equals(finiteDuration2)) return false;
            FiniteDuration finiteDuration3 = this.commitTimeout();
            FiniteDuration finiteDuration4 = consumerSettingsImpl.commitTimeout();
            if (finiteDuration3 == null) {
                if (finiteDuration4 != null) {
                    return false;
                }
            } else if (!finiteDuration3.equals(finiteDuration4)) return false;
            FiniteDuration finiteDuration5 = this.pollInterval();
            FiniteDuration finiteDuration6 = consumerSettingsImpl.pollInterval();
            if (finiteDuration5 == null) {
                if (finiteDuration6 != null) {
                    return false;
                }
            } else if (!finiteDuration5.equals(finiteDuration6)) return false;
            FiniteDuration finiteDuration7 = this.pollTimeout();
            FiniteDuration finiteDuration8 = consumerSettingsImpl.pollTimeout();
            if (finiteDuration7 == null) {
                if (finiteDuration8 != null) {
                    return false;
                }
            } else if (!finiteDuration7.equals(finiteDuration8)) return false;
            CommitRecovery commitRecovery = this.commitRecovery();
            CommitRecovery commitRecovery2 = consumerSettingsImpl.commitRecovery();
            if (commitRecovery == null) {
                if (commitRecovery2 != null) {
                    return false;
                }
            } else if (!commitRecovery.equals(commitRecovery2)) return false;
            Function1<ConsumerRecord<K, V>, String> function1 = this.recordMetadata();
            Function1<ConsumerRecord<K, V>, String> function12 = consumerSettingsImpl.recordMetadata();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            RebalanceRevokeMode rebalanceRevokeMode = this.rebalanceRevokeMode();
            RebalanceRevokeMode rebalanceRevokeMode2 = consumerSettingsImpl.rebalanceRevokeMode();
            if (rebalanceRevokeMode == null) {
                if (rebalanceRevokeMode2 == null) return true;
                return false;
            } else {
                if (!rebalanceRevokeMode.equals(rebalanceRevokeMode2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ConsumerSettingsImpl;
        }

        public int productArity() {
            return 12;
        }

        public String productPrefix() {
            return "ConsumerSettingsImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return this._9();
                }
                case 9: {
                    return this._10();
                }
                case 10: {
                    return BoxesRunTime.boxToInteger((int)this._11());
                }
                case 11: {
                    return this._12();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "keyDeserializer";
                }
                case 1: {
                    return "valueDeserializer";
                }
                case 2: {
                    return "customBlockingContext";
                }
                case 3: {
                    return "properties";
                }
                case 4: {
                    return "closeTimeout";
                }
                case 5: {
                    return "commitTimeout";
                }
                case 6: {
                    return "pollInterval";
                }
                case 7: {
                    return "pollTimeout";
                }
                case 8: {
                    return "commitRecovery";
                }
                case 9: {
                    return "recordMetadata";
                }
                case 10: {
                    return "maxPrefetchBatches";
                }
                case 11: {
                    return "rebalanceRevokeMode";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Resource<F, GenericDeserializer<Key, F, K>> keyDeserializer() {
            return this.keyDeserializer;
        }

        @Override
        public Resource<F, GenericDeserializer<Value, F, V>> valueDeserializer() {
            return this.valueDeserializer;
        }

        @Override
        public Option<ExecutionContext> customBlockingContext() {
            return this.customBlockingContext;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        @Override
        public FiniteDuration closeTimeout() {
            return this.closeTimeout;
        }

        @Override
        public FiniteDuration commitTimeout() {
            return this.commitTimeout;
        }

        @Override
        public FiniteDuration pollInterval() {
            return this.pollInterval;
        }

        @Override
        public FiniteDuration pollTimeout() {
            return this.pollTimeout;
        }

        @Override
        public CommitRecovery commitRecovery() {
            return this.commitRecovery;
        }

        @Override
        public Function1<ConsumerRecord<K, V>, String> recordMetadata() {
            return this.recordMetadata;
        }

        @Override
        public int maxPrefetchBatches() {
            return this.maxPrefetchBatches;
        }

        @Override
        public RebalanceRevokeMode rebalanceRevokeMode() {
            return this.rebalanceRevokeMode;
        }

        @Override
        public ConsumerSettings<F, K, V> withCustomBlockingContext(ExecutionContext ec) {
            Some some = Some$.MODULE$.apply((Object)ec);
            Resource<F, GenericDeserializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericDeserializer<Value, F, V>> resource2 = this.copy$default$2();
            Map<String, String> map = this.copy$default$4();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            RebalanceRevokeMode rebalanceRevokeMode = this.copy$default$12();
            return this.copy(resource, resource2, (Option<ExecutionContext>)some, map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n, rebalanceRevokeMode);
        }

        @Override
        public ConsumerSettings<F, K, V> withBootstrapServers(String bootstrapServers) {
            return this.withProperty("bootstrap.servers", bootstrapServers);
        }

        @Override
        public ConsumerSettings<F, K, V> withAutoOffsetReset(AutoOffsetReset autoOffsetReset) {
            String string;
            AutoOffsetReset autoOffsetReset2 = autoOffsetReset;
            if (AutoOffsetReset$EarliestOffsetReset$.MODULE$.equals(autoOffsetReset2)) {
                string = "earliest";
            } else if (AutoOffsetReset$LatestOffsetReset$.MODULE$.equals(autoOffsetReset2)) {
                string = "latest";
            } else if (AutoOffsetReset$NoneOffsetReset$.MODULE$.equals(autoOffsetReset2)) {
                string = "none";
            } else {
                throw new MatchError((Object)autoOffsetReset2);
            }
            return this.withProperty("auto.offset.reset", string);
        }

        @Override
        public ConsumerSettings<F, K, V> withClientId(String clientId) {
            return this.withProperty("client.id", clientId);
        }

        @Override
        public ConsumerSettings<F, K, V> withGroupId(String groupId) {
            return this.withProperty("group.id", groupId);
        }

        @Override
        public ConsumerSettings<F, K, V> withGroupInstanceId(String groupInstanceId) {
            return this.withProperty("group.instance.id", groupInstanceId);
        }

        @Override
        public ConsumerSettings<F, K, V> withMaxPollRecords(int maxPollRecords) {
            return this.withProperty("max.poll.records", BoxesRunTime.boxToInteger((int)maxPollRecords).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withMaxPollInterval(FiniteDuration maxPollInterval) {
            return this.withProperty("max.poll.interval.ms", BoxesRunTime.boxToLong((long)maxPollInterval.toMillis()).toString());
        }

        @Override
        public FiniteDuration sessionTimeout() {
            return (FiniteDuration)this.properties().get((Object)"session.timeout.ms").flatMap(ConsumerSettings$::fs2$kafka$ConsumerSettings$ConsumerSettingsImpl$$_$sessionTimeout$$anonfun$1).map(ConsumerSettings$::fs2$kafka$ConsumerSettings$ConsumerSettingsImpl$$_$sessionTimeout$$anonfun$adapted$1).getOrElse(ConsumerSettings$::fs2$kafka$ConsumerSettings$ConsumerSettingsImpl$$_$sessionTimeout$$anonfun$3);
        }

        @Override
        public ConsumerSettings<F, K, V> withSessionTimeout(FiniteDuration sessionTimeout) {
            return this.withProperty("session.timeout.ms", BoxesRunTime.boxToLong((long)sessionTimeout.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withHeartbeatInterval(FiniteDuration heartbeatInterval) {
            return this.withProperty("heartbeat.interval.ms", BoxesRunTime.boxToLong((long)heartbeatInterval.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withEnableAutoCommit(boolean enableAutoCommit) {
            return this.withProperty("enable.auto.commit", BoxesRunTime.boxToBoolean((boolean)enableAutoCommit).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withAutoCommitInterval(FiniteDuration autoCommitInterval) {
            return this.withProperty("auto.commit.interval.ms", BoxesRunTime.boxToLong((long)autoCommitInterval.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withRequestTimeout(FiniteDuration requestTimeout) {
            return this.withProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)requestTimeout.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withDefaultApiTimeout(FiniteDuration defaultApiTimeout) {
            return this.withProperty("default.api.timeout.ms", BoxesRunTime.boxToLong((long)defaultApiTimeout.toMillis()).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withIsolationLevel(IsolationLevel isolationLevel) {
            String string;
            IsolationLevel isolationLevel2 = isolationLevel;
            if (IsolationLevel$ReadCommittedIsolationLevel$.MODULE$.equals(isolationLevel2)) {
                string = "read_committed";
            } else if (IsolationLevel$ReadUncommittedIsolationLevel$.MODULE$.equals(isolationLevel2)) {
                string = "read_uncommitted";
            } else {
                throw new MatchError((Object)isolationLevel2);
            }
            return this.withProperty("isolation.level", string);
        }

        @Override
        public ConsumerSettings<F, K, V> withAllowAutoCreateTopics(boolean allowAutoCreateTopics) {
            return this.withProperty("allow.auto.create.topics", BoxesRunTime.boxToBoolean((boolean)allowAutoCreateTopics).toString());
        }

        @Override
        public ConsumerSettings<F, K, V> withClientRack(String clientRack) {
            return this.withProperty("client.rack", clientRack);
        }

        @Override
        public ConsumerSettings<F, K, V> withProperty(String key, String value) {
            Map map = (Map)this.properties().updated((Object)key, (Object)value);
            Resource<F, GenericDeserializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericDeserializer<Value, F, V>> resource2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            RebalanceRevokeMode rebalanceRevokeMode = this.copy$default$12();
            return this.copy(resource, resource2, option, (Map<String, String>)map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n, rebalanceRevokeMode);
        }

        @Override
        public ConsumerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> properties) {
            Map map = (Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Resource<F, GenericDeserializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericDeserializer<Value, F, V>> resource2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            RebalanceRevokeMode rebalanceRevokeMode = this.copy$default$12();
            return this.copy(resource, resource2, option, (Map<String, String>)map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n, rebalanceRevokeMode);
        }

        @Override
        public ConsumerSettings<F, K, V> withProperties(Map<String, String> properties) {
            Map map = (Map)this.properties().$plus$plus(properties);
            Resource<F, GenericDeserializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericDeserializer<Value, F, V>> resource2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            int n = this.copy$default$11();
            RebalanceRevokeMode rebalanceRevokeMode = this.copy$default$12();
            return this.copy(resource, resource2, option, (Map<String, String>)map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n, rebalanceRevokeMode);
        }

        @Override
        public ConsumerSettings<F, K, V> withCloseTimeout(FiniteDuration closeTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), closeTimeout, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12());
        }

        @Override
        public ConsumerSettings<F, K, V> withCommitTimeout(FiniteDuration commitTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), commitTimeout, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12());
        }

        @Override
        public ConsumerSettings<F, K, V> withPollInterval(FiniteDuration pollInterval) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), pollInterval, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12());
        }

        @Override
        public ConsumerSettings<F, K, V> withPollTimeout(FiniteDuration pollTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), pollTimeout, this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12());
        }

        @Override
        public ConsumerSettings<F, K, V> withCommitRecovery(CommitRecovery commitRecovery) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), commitRecovery, this.copy$default$10(), this.copy$default$11(), this.copy$default$12());
        }

        @Override
        public ConsumerSettings<F, K, V> withRecordMetadata(Function1<ConsumerRecord<K, V>, String> recordMetadata) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), recordMetadata, this.copy$default$11(), this.copy$default$12());
        }

        @Override
        public ConsumerSettings<F, K, V> withMaxPrefetchBatches(int maxPrefetchBatches) {
            int n = Math.max(2, maxPrefetchBatches);
            Resource<F, GenericDeserializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericDeserializer<Value, F, V>> resource2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            Map<String, String> map = this.copy$default$4();
            FiniteDuration finiteDuration = this.copy$default$5();
            FiniteDuration finiteDuration2 = this.copy$default$6();
            FiniteDuration finiteDuration3 = this.copy$default$7();
            FiniteDuration finiteDuration4 = this.copy$default$8();
            CommitRecovery commitRecovery = this.copy$default$9();
            Function1<ConsumerRecord<K, V>, String> function1 = this.copy$default$10();
            RebalanceRevokeMode rebalanceRevokeMode = this.copy$default$12();
            return this.copy(resource, resource2, option, map, finiteDuration, finiteDuration2, finiteDuration3, finiteDuration4, commitRecovery, function1, n, rebalanceRevokeMode);
        }

        @Override
        public ConsumerSettings<F, K, V> withCredentials(KafkaCredentialStore credentialsStore) {
            return this.withProperties(credentialsStore.properties());
        }

        @Override
        public ConsumerSettings<F, K, V> withRebalanceRevokeMode(RebalanceRevokeMode rebalanceRevokeMode) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), rebalanceRevokeMode);
        }

        public String toString() {
            return new StringBuilder(103).append("ConsumerSettings(closeTimeout = ").append(this.closeTimeout()).append(", commitTimeout = ").append(this.commitTimeout()).append(", pollInterval = ").append(this.pollInterval()).append(", pollTimeout = ").append(this.pollTimeout()).append(", commitRecovery = ").append(this.commitRecovery()).append(")").toString();
        }

        @Override
        public <K0, V0> ConsumerSettings<F, K0, V0> withDeserializers(Resource<F, GenericDeserializer<Key, F, K0>> keyDeserializer, Resource<F, GenericDeserializer<Value, F, V0>> valueDeserializer) {
            return this.copy(keyDeserializer, valueDeserializer, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), ConsumerSettings$::fs2$kafka$ConsumerSettings$ConsumerSettingsImpl$$_$withDeserializers$$anonfun$1, this.copy$default$11(), this.copy$default$12());
        }

        public <F, K, V> ConsumerSettingsImpl<F, K, V> copy(Resource<F, GenericDeserializer<Key, F, K>> keyDeserializer, Resource<F, GenericDeserializer<Value, F, V>> valueDeserializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, FiniteDuration commitTimeout, FiniteDuration pollInterval, FiniteDuration pollTimeout, CommitRecovery commitRecovery, Function1<ConsumerRecord<K, V>, String> recordMetadata, int maxPrefetchBatches, RebalanceRevokeMode rebalanceRevokeMode) {
            return new ConsumerSettingsImpl<F, K, V>(keyDeserializer, valueDeserializer, customBlockingContext, properties, closeTimeout, commitTimeout, pollInterval, pollTimeout, commitRecovery, recordMetadata, maxPrefetchBatches, rebalanceRevokeMode);
        }

        public <F, K, V> Resource<F, GenericDeserializer<Key, F, K>> copy$default$1() {
            return this.keyDeserializer();
        }

        public <F, K, V> Resource<F, GenericDeserializer<Value, F, V>> copy$default$2() {
            return this.valueDeserializer();
        }

        public <F, K, V> Option<ExecutionContext> copy$default$3() {
            return this.customBlockingContext();
        }

        public <F, K, V> Map<String, String> copy$default$4() {
            return this.properties();
        }

        public <F, K, V> FiniteDuration copy$default$5() {
            return this.closeTimeout();
        }

        public <F, K, V> FiniteDuration copy$default$6() {
            return this.commitTimeout();
        }

        public <F, K, V> FiniteDuration copy$default$7() {
            return this.pollInterval();
        }

        public <F, K, V> FiniteDuration copy$default$8() {
            return this.pollTimeout();
        }

        public <F, K, V> CommitRecovery copy$default$9() {
            return this.commitRecovery();
        }

        public <F, K, V> Function1<ConsumerRecord<K, V>, String> copy$default$10() {
            return this.recordMetadata();
        }

        public int copy$default$11() {
            return this.maxPrefetchBatches();
        }

        public <F, K, V> RebalanceRevokeMode copy$default$12() {
            return this.rebalanceRevokeMode();
        }

        public Resource<F, GenericDeserializer<Key, F, K>> _1() {
            return this.keyDeserializer();
        }

        public Resource<F, GenericDeserializer<Value, F, V>> _2() {
            return this.valueDeserializer();
        }

        public Option<ExecutionContext> _3() {
            return this.customBlockingContext();
        }

        public Map<String, String> _4() {
            return this.properties();
        }

        public FiniteDuration _5() {
            return this.closeTimeout();
        }

        public FiniteDuration _6() {
            return this.commitTimeout();
        }

        public FiniteDuration _7() {
            return this.pollInterval();
        }

        public FiniteDuration _8() {
            return this.pollTimeout();
        }

        public CommitRecovery _9() {
            return this.commitRecovery();
        }

        public Function1<ConsumerRecord<K, V>, String> _10() {
            return this.recordMetadata();
        }

        public int _11() {
            return this.maxPrefetchBatches();
        }

        public RebalanceRevokeMode _12() {
            return this.rebalanceRevokeMode();
        }
    }
}

