/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka;

import cats.Show;
import cats.effect.kernel.Resource;
import fs2.kafka.Acks;
import fs2.kafka.Acks$AllAcks$;
import fs2.kafka.Acks$OneAcks$;
import fs2.kafka.Acks$ZeroAcks$;
import fs2.kafka.GenericSerializer;
import fs2.kafka.Key;
import fs2.kafka.ProducerSettings$;
import fs2.kafka.ProducerSettings$ProducerSettingsImpl$;
import fs2.kafka.Value;
import fs2.kafka.security.KafkaCredentialStore;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public abstract class ProducerSettings<F, K, V> {
    public static <F, K, V> ProducerSettings<F, K, V> apply(GenericSerializer<Key, F, K> genericSerializer, GenericSerializer<Value, F, V> genericSerializer2) {
        return ProducerSettings$.MODULE$.apply(genericSerializer, genericSerializer2);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(GenericSerializer<Key, F, K> genericSerializer, Resource<F, GenericSerializer<Value, F, V>> resource) {
        return ProducerSettings$.MODULE$.apply(genericSerializer, resource);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(Resource<F, GenericSerializer<Key, F, K>> resource, GenericSerializer<Value, F, V> genericSerializer) {
        return ProducerSettings$.MODULE$.apply(resource, genericSerializer);
    }

    public static <F, K, V> ProducerSettings<F, K, V> apply(Resource<F, GenericSerializer<Key, F, K>> resource, Resource<F, GenericSerializer<Value, F, V>> resource2) {
        return ProducerSettings$.MODULE$.apply(resource, resource2);
    }

    public static int ordinal(ProducerSettings<?, ?, ?> producerSettings) {
        return ProducerSettings$.MODULE$.ordinal(producerSettings);
    }

    public static <F, K, V> Show<ProducerSettings<F, K, V>> producerSettingsShow() {
        return ProducerSettings$.MODULE$.producerSettingsShow();
    }

    public abstract Resource<F, GenericSerializer<Key, F, K>> keySerializer();

    public abstract Resource<F, GenericSerializer<Value, F, V>> valueSerializer();

    public abstract <K1, V1> ProducerSettings<F, K1, V1> withSerializers(Resource<F, GenericSerializer<Key, F, K1>> var1, Resource<F, GenericSerializer<Value, F, V1>> var2);

    public abstract Option<ExecutionContext> customBlockingContext();

    public abstract ProducerSettings<F, K, V> withCustomBlockingContext(ExecutionContext var1);

    public abstract Map<String, String> properties();

    public abstract ProducerSettings<F, K, V> withBootstrapServers(String var1);

    public abstract ProducerSettings<F, K, V> withAcks(Acks var1);

    public abstract ProducerSettings<F, K, V> withBatchSize(int var1);

    public abstract ProducerSettings<F, K, V> withClientId(String var1);

    public abstract ProducerSettings<F, K, V> withRetries(int var1);

    public abstract ProducerSettings<F, K, V> withMaxInFlightRequestsPerConnection(int var1);

    public abstract ProducerSettings<F, K, V> withEnableIdempotence(boolean var1);

    public abstract ProducerSettings<F, K, V> withLinger(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withRequestTimeout(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withDeliveryTimeout(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withProperty(String var1, String var2);

    public abstract ProducerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> var1);

    public abstract ProducerSettings<F, K, V> withProperties(Map<String, String> var1);

    public abstract FiniteDuration closeTimeout();

    public abstract ProducerSettings<F, K, V> withCloseTimeout(FiniteDuration var1);

    public abstract ProducerSettings<F, K, V> withCredentials(KafkaCredentialStore var1);

    public abstract boolean failFastProduce();

    public abstract ProducerSettings<F, K, V> withFailFastProduce(boolean var1);

    public static final class ProducerSettingsImpl<F, K, V>
    extends ProducerSettings<F, K, V>
    implements Product,
    Serializable {
        private final Resource keySerializer;
        private final Resource valueSerializer;
        private final Option customBlockingContext;
        private final Map properties;
        private final FiniteDuration closeTimeout;
        private final boolean failFastProduce;

        public static <F, K, V> ProducerSettingsImpl<F, K, V> apply(Resource<F, GenericSerializer<Key, F, K>> resource, Resource<F, GenericSerializer<Value, F, V>> resource2, Option<ExecutionContext> option, Map<String, String> map, FiniteDuration finiteDuration, boolean bl) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.apply(resource, resource2, option, map, finiteDuration, bl);
        }

        public static ProducerSettingsImpl<?, ?, ?> fromProduct(Product product) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> ProducerSettingsImpl<F, K, V> unapply(ProducerSettingsImpl<F, K, V> producerSettingsImpl) {
            return ProducerSettings$ProducerSettingsImpl$.MODULE$.unapply(producerSettingsImpl);
        }

        public ProducerSettingsImpl(Resource<F, GenericSerializer<Key, F, K>> keySerializer, Resource<F, GenericSerializer<Value, F, V>> valueSerializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, boolean failFastProduce) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.customBlockingContext = customBlockingContext;
            this.properties = properties;
            this.closeTimeout = closeTimeout;
            this.failFastProduce = failFastProduce;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.keySerializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.valueSerializer()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.customBlockingContext()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.properties()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.closeTimeout()));
            n = Statics.mix((int)n, (int)(this.failFastProduce() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProducerSettingsImpl)) return false;
            ProducerSettingsImpl producerSettingsImpl = (ProducerSettingsImpl)object;
            if (this.failFastProduce() != producerSettingsImpl.failFastProduce()) return false;
            Resource<F, GenericSerializer<Key, F, K>> resource = this.keySerializer();
            Resource<F, GenericSerializer<Key, F, K>> resource2 = producerSettingsImpl.keySerializer();
            if (resource == null) {
                if (resource2 != null) {
                    return false;
                }
            } else if (!resource.equals(resource2)) return false;
            Resource<F, GenericSerializer<Value, F, V>> resource3 = this.valueSerializer();
            Resource<F, GenericSerializer<Value, F, V>> resource4 = producerSettingsImpl.valueSerializer();
            if (resource3 == null) {
                if (resource4 != null) {
                    return false;
                }
            } else if (!resource3.equals(resource4)) return false;
            Option<ExecutionContext> option = this.customBlockingContext();
            Option<ExecutionContext> option2 = producerSettingsImpl.customBlockingContext();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Map<String, String> map = this.properties();
            Map<String, String> map2 = producerSettingsImpl.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            FiniteDuration finiteDuration = this.closeTimeout();
            FiniteDuration finiteDuration2 = producerSettingsImpl.closeTimeout();
            if (finiteDuration == null) {
                if (finiteDuration2 == null) return true;
                return false;
            } else {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ProducerSettingsImpl;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "ProducerSettingsImpl";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "keySerializer";
                }
                case 1: {
                    return "valueSerializer";
                }
                case 2: {
                    return "customBlockingContext";
                }
                case 3: {
                    return "properties";
                }
                case 4: {
                    return "closeTimeout";
                }
                case 5: {
                    return "failFastProduce";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Resource<F, GenericSerializer<Key, F, K>> keySerializer() {
            return this.keySerializer;
        }

        @Override
        public Resource<F, GenericSerializer<Value, F, V>> valueSerializer() {
            return this.valueSerializer;
        }

        @Override
        public Option<ExecutionContext> customBlockingContext() {
            return this.customBlockingContext;
        }

        @Override
        public Map<String, String> properties() {
            return this.properties;
        }

        @Override
        public FiniteDuration closeTimeout() {
            return this.closeTimeout;
        }

        @Override
        public boolean failFastProduce() {
            return this.failFastProduce;
        }

        @Override
        public ProducerSettings<F, K, V> withCustomBlockingContext(ExecutionContext ec) {
            Some some = Some$.MODULE$.apply((Object)ec);
            Resource<F, GenericSerializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericSerializer<Value, F, V>> resource2 = this.copy$default$2();
            Map<String, String> map = this.copy$default$4();
            FiniteDuration finiteDuration = this.copy$default$5();
            boolean bl = this.copy$default$6();
            return this.copy(resource, resource2, (Option<ExecutionContext>)some, map, finiteDuration, bl);
        }

        @Override
        public ProducerSettings<F, K, V> withBootstrapServers(String bootstrapServers) {
            return this.withProperty("bootstrap.servers", bootstrapServers);
        }

        @Override
        public ProducerSettings<F, K, V> withAcks(Acks acks) {
            String string;
            Acks acks2 = acks;
            if (Acks$ZeroAcks$.MODULE$.equals(acks2)) {
                string = "0";
            } else if (Acks$OneAcks$.MODULE$.equals(acks2)) {
                string = "1";
            } else if (Acks$AllAcks$.MODULE$.equals(acks2)) {
                string = "all";
            } else {
                throw new MatchError((Object)acks2);
            }
            return this.withProperty("acks", string);
        }

        @Override
        public ProducerSettings<F, K, V> withBatchSize(int batchSize) {
            return this.withProperty("batch.size", BoxesRunTime.boxToInteger((int)batchSize).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withClientId(String clientId) {
            return this.withProperty("client.id", clientId);
        }

        @Override
        public ProducerSettings<F, K, V> withRetries(int retries) {
            return this.withProperty("retries", BoxesRunTime.boxToInteger((int)retries).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withMaxInFlightRequestsPerConnection(int maxInFlightRequestsPerConnection) {
            return this.withProperty("max.in.flight.requests.per.connection", BoxesRunTime.boxToInteger((int)maxInFlightRequestsPerConnection).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withEnableIdempotence(boolean enableIdempotence) {
            return this.withProperty("enable.idempotence", BoxesRunTime.boxToBoolean((boolean)enableIdempotence).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withLinger(FiniteDuration linger) {
            return this.withProperty("linger.ms", BoxesRunTime.boxToLong((long)linger.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withRequestTimeout(FiniteDuration requestTimeout) {
            return this.withProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)requestTimeout.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withDeliveryTimeout(FiniteDuration deliveryTimeout) {
            return this.withProperty("delivery.timeout.ms", BoxesRunTime.boxToLong((long)deliveryTimeout.toMillis()).toString());
        }

        @Override
        public ProducerSettings<F, K, V> withProperty(String key, String value) {
            Map map = (Map)this.properties().updated((Object)key, (Object)value);
            Resource<F, GenericSerializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericSerializer<Value, F, V>> resource2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            boolean bl = this.copy$default$6();
            return this.copy(resource, resource2, option, (Map<String, String>)map, finiteDuration, bl);
        }

        @Override
        public ProducerSettings<F, K, V> withProperties(Seq<Tuple2<String, String>> properties) {
            Map map = (Map)this.properties().$plus$plus((IterableOnce)properties.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            Resource<F, GenericSerializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericSerializer<Value, F, V>> resource2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            boolean bl = this.copy$default$6();
            return this.copy(resource, resource2, option, (Map<String, String>)map, finiteDuration, bl);
        }

        @Override
        public ProducerSettings<F, K, V> withProperties(Map<String, String> properties) {
            Map map = (Map)this.properties().$plus$plus(properties);
            Resource<F, GenericSerializer<Key, F, K>> resource = this.copy$default$1();
            Resource<F, GenericSerializer<Value, F, V>> resource2 = this.copy$default$2();
            Option<ExecutionContext> option = this.copy$default$3();
            FiniteDuration finiteDuration = this.copy$default$5();
            boolean bl = this.copy$default$6();
            return this.copy(resource, resource2, option, (Map<String, String>)map, finiteDuration, bl);
        }

        @Override
        public ProducerSettings<F, K, V> withCloseTimeout(FiniteDuration closeTimeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), closeTimeout, this.copy$default$6());
        }

        @Override
        public ProducerSettings<F, K, V> withCredentials(KafkaCredentialStore credentialsStore) {
            return this.withProperties(credentialsStore.properties());
        }

        public String toString() {
            return new StringBuilder(33).append("ProducerSettings(closeTimeout = ").append(this.closeTimeout()).append(")").toString();
        }

        @Override
        public <K1, V1> ProducerSettings<F, K1, V1> withSerializers(Resource<F, GenericSerializer<Key, F, K1>> keySerializer, Resource<F, GenericSerializer<Value, F, V1>> valueSerializer) {
            return this.copy(keySerializer, valueSerializer, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        @Override
        public ProducerSettings<F, K, V> withFailFastProduce(boolean failFastProduce) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), failFastProduce);
        }

        public <F, K, V> ProducerSettingsImpl<F, K, V> copy(Resource<F, GenericSerializer<Key, F, K>> keySerializer, Resource<F, GenericSerializer<Value, F, V>> valueSerializer, Option<ExecutionContext> customBlockingContext, Map<String, String> properties, FiniteDuration closeTimeout, boolean failFastProduce) {
            return new ProducerSettingsImpl<F, K, V>(keySerializer, valueSerializer, customBlockingContext, properties, closeTimeout, failFastProduce);
        }

        public <F, K, V> Resource<F, GenericSerializer<Key, F, K>> copy$default$1() {
            return this.keySerializer();
        }

        public <F, K, V> Resource<F, GenericSerializer<Value, F, V>> copy$default$2() {
            return this.valueSerializer();
        }

        public <F, K, V> Option<ExecutionContext> copy$default$3() {
            return this.customBlockingContext();
        }

        public <F, K, V> Map<String, String> copy$default$4() {
            return this.properties();
        }

        public <F, K, V> FiniteDuration copy$default$5() {
            return this.closeTimeout();
        }

        public boolean copy$default$6() {
            return this.failFastProduce();
        }

        public Resource<F, GenericSerializer<Key, F, K>> _1() {
            return this.keySerializer();
        }

        public Resource<F, GenericSerializer<Value, F, V>> _2() {
            return this.valueSerializer();
        }

        public Option<ExecutionContext> _3() {
            return this.customBlockingContext();
        }

        public Map<String, String> _4() {
            return this.properties();
        }

        public FiniteDuration _5() {
            return this.closeTimeout();
        }

        public boolean _6() {
            return this.failFastProduce();
        }
    }
}

