/*
 * Decompiled with CFR 0.152.
 */
package fs2.kafka.internal;

import cats.Foldable;
import cats.data.NonEmptyList;
import cats.data.NonEmptySetImpl$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.kafka.CommittableConsumerRecord;
import fs2.kafka.internal.KafkaConsumerActor;
import fs2.kafka.internal.LogEntry$;
import fs2.kafka.internal.LogEntry$AssignedPartitions$;
import fs2.kafka.internal.LogEntry$CommittedPendingCommit$;
import fs2.kafka.internal.LogEntry$ManuallyAssignedPartitions$;
import fs2.kafka.internal.LogEntry$RevokeTimeoutOccurred$;
import fs2.kafka.internal.LogEntry$RevokedPartitions$;
import fs2.kafka.internal.LogEntry$StoredOnRebalance$;
import fs2.kafka.internal.LogEntry$StoredPendingCommit$;
import fs2.kafka.internal.LogEntry$SubscribedPattern$;
import fs2.kafka.internal.LogEntry$SubscribedTopics$;
import fs2.kafka.internal.LogEntry$Unsubscribed$;
import fs2.kafka.internal.LogLevel;
import fs2.kafka.internal.LogLevel$Debug$;
import fs2.kafka.internal.LogLevel$Info$;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import scala.;
import scala.$less$colon$less$;
import scala.Product;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class LogEntry {
    public static int ordinal(LogEntry logEntry) {
        return LogEntry$.MODULE$.ordinal(logEntry);
    }

    public static <F> String recordsString(Map<TopicPartition, Chunk<CommittableConsumerRecord<F, ?, ?>>> map) {
        return LogEntry$.MODULE$.recordsString(map);
    }

    public abstract LogLevel level();

    public abstract String message();

    public static final class AssignedPartitions<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final SortedSet partitions;
        private final KafkaConsumerActor.State state;

        public static <F> AssignedPartitions<F> apply(SortedSet<TopicPartition> sortedSet, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$AssignedPartitions$.MODULE$.apply(sortedSet, state);
        }

        public static AssignedPartitions<?> fromProduct(Product product) {
            return LogEntry$AssignedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F> AssignedPartitions<F> unapply(AssignedPartitions<F> assignedPartitions) {
            return LogEntry$AssignedPartitions$.MODULE$.unapply(assignedPartitions);
        }

        public AssignedPartitions(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AssignedPartitions)) return false;
            AssignedPartitions assignedPartitions = (AssignedPartitions)object;
            SortedSet<TopicPartition> sortedSet = this.partitions();
            SortedSet<TopicPartition> sortedSet2 = assignedPartitions.partitions();
            if (sortedSet == null) {
                if (sortedSet2 != null) {
                    return false;
                }
            } else if (!sortedSet.equals(sortedSet2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = assignedPartitions.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AssignedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AssignedPartitions";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partitions";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SortedSet<TopicPartition> partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(41).append("Assigned partitions [").append(this.partitions().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> AssignedPartitions<F> copy(SortedSet<TopicPartition> partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            return new AssignedPartitions<F>(partitions, state);
        }

        public <F> SortedSet<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public SortedSet<TopicPartition> _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class CommittedPendingCommit<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.Request.Commit pendingCommit;

        public static <F> CommittedPendingCommit<F> apply(KafkaConsumerActor.Request.Commit<F> commit) {
            return LogEntry$CommittedPendingCommit$.MODULE$.apply(commit);
        }

        public static CommittedPendingCommit<?> fromProduct(Product product) {
            return LogEntry$CommittedPendingCommit$.MODULE$.fromProduct(product);
        }

        public static <F> CommittedPendingCommit<F> unapply(CommittedPendingCommit<F> committedPendingCommit) {
            return LogEntry$CommittedPendingCommit$.MODULE$.unapply(committedPendingCommit);
        }

        public CommittedPendingCommit(KafkaConsumerActor.Request.Commit<F> pendingCommit) {
            this.pendingCommit = pendingCommit;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CommittedPendingCommit)) return false;
            CommittedPendingCommit committedPendingCommit = (CommittedPendingCommit)object;
            KafkaConsumerActor.Request.Commit<F> commit = this.pendingCommit();
            KafkaConsumerActor.Request.Commit<F> commit2 = committedPendingCommit.pendingCommit();
            if (commit != null) {
                if (!((Object)commit).equals(commit2)) return false;
                return true;
            }
            if (commit2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CommittedPendingCommit;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CommittedPendingCommit";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pendingCommit";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumerActor.Request.Commit<F> pendingCommit() {
            return this.pendingCommit;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(28).append("Committed pending commit [").append(this.pendingCommit()).append("].").toString();
        }

        public <F> CommittedPendingCommit<F> copy(KafkaConsumerActor.Request.Commit<F> pendingCommit) {
            return new CommittedPendingCommit<F>(pendingCommit);
        }

        public <F> KafkaConsumerActor.Request.Commit<F> copy$default$1() {
            return this.pendingCommit();
        }

        public KafkaConsumerActor.Request.Commit<F> _1() {
            return this.pendingCommit();
        }
    }

    public static final class ManuallyAssignedPartitions<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Object partitions;
        private final KafkaConsumerActor.State state;

        public static <F> ManuallyAssignedPartitions<F> apply(Object object, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.apply(object, state);
        }

        public static ManuallyAssignedPartitions<?> fromProduct(Product product) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F> ManuallyAssignedPartitions<F> unapply(ManuallyAssignedPartitions<F> manuallyAssignedPartitions) {
            return LogEntry$ManuallyAssignedPartitions$.MODULE$.unapply(manuallyAssignedPartitions);
        }

        public ManuallyAssignedPartitions(Object partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            this.partitions = partitions;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ManuallyAssignedPartitions)) return false;
            ManuallyAssignedPartitions manuallyAssignedPartitions = (ManuallyAssignedPartitions)object;
            if (!BoxesRunTime.equals((Object)this.partitions(), (Object)manuallyAssignedPartitions.partitions())) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = manuallyAssignedPartitions.state();
            if (state != null) {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
            if (state2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ManuallyAssignedPartitions;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ManuallyAssignedPartitions";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "partitions";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object partitions() {
            return this.partitions;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(59).append("Consumer manually assigned partitions [").append(package.all$.MODULE$.toFoldableOps(this.partitions(), (Foldable)NonEmptySetImpl$.MODULE$.catsDataInstancesForNonEmptySet()).toList().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> ManuallyAssignedPartitions<F> copy(Object partitions, KafkaConsumerActor.State<F, ?, ?> state) {
            return new ManuallyAssignedPartitions<F>(partitions, state);
        }

        public <F> Object copy$default$1() {
            return this.partitions();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Object _1() {
            return this.partitions();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class RevokeTimeoutOccurred<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Set revoked;
        private final KafkaConsumerActor.State state;

        public static <F> RevokeTimeoutOccurred<F> apply(Set<TopicPartition> set, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$RevokeTimeoutOccurred$.MODULE$.apply(set, state);
        }

        public static RevokeTimeoutOccurred<?> fromProduct(Product product) {
            return LogEntry$RevokeTimeoutOccurred$.MODULE$.fromProduct(product);
        }

        public static <F> RevokeTimeoutOccurred<F> unapply(RevokeTimeoutOccurred<F> revokeTimeoutOccurred) {
            return LogEntry$RevokeTimeoutOccurred$.MODULE$.unapply(revokeTimeoutOccurred);
        }

        public RevokeTimeoutOccurred(Set<TopicPartition> revoked, KafkaConsumerActor.State<F, ?, ?> state) {
            this.revoked = revoked;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokeTimeoutOccurred)) return false;
            RevokeTimeoutOccurred revokeTimeoutOccurred = (RevokeTimeoutOccurred)object;
            Set<TopicPartition> set = this.revoked();
            Set<TopicPartition> set2 = revokeTimeoutOccurred.revoked();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = revokeTimeoutOccurred.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokeTimeoutOccurred;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RevokeTimeoutOccurred";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "revoked";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<TopicPartition> revoked() {
            return this.revoked;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Info$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(79).append("Consuming streams did not signal processing completion of [").append(this.revoked()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> RevokeTimeoutOccurred<F> copy(Set<TopicPartition> revoked, KafkaConsumerActor.State<F, ?, ?> state) {
            return new RevokeTimeoutOccurred<F>(revoked, state);
        }

        public <F> Set<TopicPartition> copy$default$1() {
            return this.revoked();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Set<TopicPartition> _1() {
            return this.revoked();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class RevokedPartitions<F, K, V>
    extends LogEntry
    implements Product,
    Serializable {
        private final Set partitions;
        private final Map partitionState;
        private final KafkaConsumerActor.State state;

        public static <F, K, V> RevokedPartitions<F, K, V> apply(Set<TopicPartition> set, Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> map, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$RevokedPartitions$.MODULE$.apply(set, map, state);
        }

        public static RevokedPartitions<?, ?, ?> fromProduct(Product product) {
            return LogEntry$RevokedPartitions$.MODULE$.fromProduct(product);
        }

        public static <F, K, V> RevokedPartitions<F, K, V> unapply(RevokedPartitions<F, K, V> revokedPartitions) {
            return LogEntry$RevokedPartitions$.MODULE$.unapply(revokedPartitions);
        }

        public RevokedPartitions(Set<TopicPartition> partitions, Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> partitionState, KafkaConsumerActor.State<F, ?, ?> state) {
            this.partitions = partitions;
            this.partitionState = partitionState;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RevokedPartitions)) return false;
            RevokedPartitions revokedPartitions = (RevokedPartitions)object;
            Set<TopicPartition> set = this.partitions();
            Set<TopicPartition> set2 = revokedPartitions.partitions();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> map = this.partitionState();
            Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> map2 = revokedPartitions.partitionState();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = revokedPartitions.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RevokedPartitions;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "RevokedPartitions";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "partitions";
                }
                case 1: {
                    return "partitionState";
                }
                case 2: {
                    return "state";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<TopicPartition> partitions() {
            return this.partitions;
        }

        public Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> partitionState() {
            return this.partitionState;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            String message = new StringBuilder(21).append("Revoked partitions [").append(this.partitions().mkString(", ")).append("]").toString();
            if (this.partitionState().nonEmpty()) {
                Map withSpillover = this.partitionState().view().filter(LogEntry$::fs2$kafka$internal$LogEntry$RevokedPartitions$$_$_$$anonfun$1).map(LogEntry$::fs2$kafka$internal$LogEntry$RevokedPartitions$$_$_$$anonfun$2).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                message = new StringBuilder(0).append(message).append(new StringBuilder(26).append(", dropped record queues [").append(this.partitionState().keys().mkString(", ")).append("]").toString()).toString();
                if (withSpillover.nonEmpty()) {
                    message = new StringBuilder(0).append(message).append(new StringBuilder(30).append(", dropped spillover records [").append(LogEntry$.MODULE$.recordsString(withSpillover)).append("]").toString()).toString();
                }
            }
            message = new StringBuilder(0).append(message).append(new StringBuilder(18).append(". Current state [").append(this.state()).append("]").toString()).toString();
            return message;
        }

        public <F, K, V> RevokedPartitions<F, K, V> copy(Set<TopicPartition> partitions, Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> partitionState, KafkaConsumerActor.State<F, ?, ?> state) {
            return new RevokedPartitions<F, K, V>(partitions, partitionState, state);
        }

        public <F, K, V> Set<TopicPartition> copy$default$1() {
            return this.partitions();
        }

        public <F, K, V> Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> copy$default$2() {
            return this.partitionState();
        }

        public <F, K, V> KafkaConsumerActor.State<F, ?, ?> copy$default$3() {
            return this.state();
        }

        public Set<TopicPartition> _1() {
            return this.partitions();
        }

        public Map<TopicPartition, KafkaConsumerActor.PartitionState<F, K, V>> _2() {
            return this.partitionState();
        }

        public KafkaConsumerActor.State<F, ?, ?> _3() {
            return this.state();
        }
    }

    public static final class StoredOnRebalance<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.OnRebalance onRebalance;
        private final KafkaConsumerActor.State state;

        public static <F> StoredOnRebalance<F> apply(KafkaConsumerActor.OnRebalance<F> onRebalance, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$StoredOnRebalance$.MODULE$.apply(onRebalance, state);
        }

        public static StoredOnRebalance<?> fromProduct(Product product) {
            return LogEntry$StoredOnRebalance$.MODULE$.fromProduct(product);
        }

        public static <F> StoredOnRebalance<F> unapply(StoredOnRebalance<F> storedOnRebalance) {
            return LogEntry$StoredOnRebalance$.MODULE$.unapply(storedOnRebalance);
        }

        public StoredOnRebalance(KafkaConsumerActor.OnRebalance<F> onRebalance, KafkaConsumerActor.State<F, ?, ?> state) {
            this.onRebalance = onRebalance;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredOnRebalance)) return false;
            StoredOnRebalance storedOnRebalance = (StoredOnRebalance)object;
            KafkaConsumerActor.OnRebalance<F> onRebalance = this.onRebalance();
            KafkaConsumerActor.OnRebalance<F> onRebalance2 = storedOnRebalance.onRebalance();
            if (onRebalance == null) {
                if (onRebalance2 != null) {
                    return false;
                }
            } else if (!((Object)onRebalance).equals(onRebalance2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = storedOnRebalance.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredOnRebalance;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredOnRebalance";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "onRebalance";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumerActor.OnRebalance<F> onRebalance() {
            return this.onRebalance;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(40).append("Stored OnRebalance [").append(this.onRebalance()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> StoredOnRebalance<F> copy(KafkaConsumerActor.OnRebalance<F> onRebalance, KafkaConsumerActor.State<F, ?, ?> state) {
            return new StoredOnRebalance<F>(onRebalance, state);
        }

        public <F> KafkaConsumerActor.OnRebalance<F> copy$default$1() {
            return this.onRebalance();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public KafkaConsumerActor.OnRebalance<F> _1() {
            return this.onRebalance();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class StoredPendingCommit<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.Request.Commit commit;
        private final KafkaConsumerActor.State state;

        public static <F> StoredPendingCommit<F> apply(KafkaConsumerActor.Request.Commit<F> commit, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$StoredPendingCommit$.MODULE$.apply(commit, state);
        }

        public static StoredPendingCommit<?> fromProduct(Product product) {
            return LogEntry$StoredPendingCommit$.MODULE$.fromProduct(product);
        }

        public static <F> StoredPendingCommit<F> unapply(StoredPendingCommit<F> storedPendingCommit) {
            return LogEntry$StoredPendingCommit$.MODULE$.unapply(storedPendingCommit);
        }

        public StoredPendingCommit(KafkaConsumerActor.Request.Commit<F> commit, KafkaConsumerActor.State<F, ?, ?> state) {
            this.commit = commit;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoredPendingCommit)) return false;
            StoredPendingCommit storedPendingCommit = (StoredPendingCommit)object;
            KafkaConsumerActor.Request.Commit<F> commit = this.commit();
            KafkaConsumerActor.Request.Commit<F> commit2 = storedPendingCommit.commit();
            if (commit == null) {
                if (commit2 != null) {
                    return false;
                }
            } else if (!((Object)commit).equals(commit2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = storedPendingCommit.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoredPendingCommit;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoredPendingCommit";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "commit";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumerActor.Request.Commit<F> commit() {
            return this.commit;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(71).append("Stored pending commit [").append(this.commit()).append("] as rebalance is in-progress. Current state [").append(this.state()).append("].").toString();
        }

        public <F> StoredPendingCommit<F> copy(KafkaConsumerActor.Request.Commit<F> commit, KafkaConsumerActor.State<F, ?, ?> state) {
            return new StoredPendingCommit<F>(commit, state);
        }

        public <F> KafkaConsumerActor.Request.Commit<F> copy$default$1() {
            return this.commit();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public KafkaConsumerActor.Request.Commit<F> _1() {
            return this.commit();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class SubscribedPattern<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final Pattern pattern;
        private final KafkaConsumerActor.State state;

        public static <F> SubscribedPattern<F> apply(Pattern pattern, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$SubscribedPattern$.MODULE$.apply(pattern, state);
        }

        public static SubscribedPattern<?> fromProduct(Product product) {
            return LogEntry$SubscribedPattern$.MODULE$.fromProduct(product);
        }

        public static <F> SubscribedPattern<F> unapply(SubscribedPattern<F> subscribedPattern) {
            return LogEntry$SubscribedPattern$.MODULE$.unapply(subscribedPattern);
        }

        public SubscribedPattern(Pattern pattern, KafkaConsumerActor.State<F, ?, ?> state) {
            this.pattern = pattern;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribedPattern)) return false;
            SubscribedPattern subscribedPattern = (SubscribedPattern)object;
            Pattern pattern = this.pattern();
            Pattern pattern2 = subscribedPattern.pattern();
            if (pattern == null) {
                if (pattern2 != null) {
                    return false;
                }
            } else if (!pattern.equals(pattern2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = subscribedPattern.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubscribedPattern;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubscribedPattern";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pattern";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Pattern pattern() {
            return this.pattern;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(52).append("Consumer subscribed to pattern [").append(this.pattern()).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> SubscribedPattern<F> copy(Pattern pattern, KafkaConsumerActor.State<F, ?, ?> state) {
            return new SubscribedPattern<F>(pattern, state);
        }

        public <F> Pattern copy$default$1() {
            return this.pattern();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public Pattern _1() {
            return this.pattern();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class SubscribedTopics<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final NonEmptyList topics;
        private final KafkaConsumerActor.State state;

        public static <F> SubscribedTopics<F> apply(NonEmptyList<String> nonEmptyList, KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$SubscribedTopics$.MODULE$.apply(nonEmptyList, state);
        }

        public static SubscribedTopics<?> fromProduct(Product product) {
            return LogEntry$SubscribedTopics$.MODULE$.fromProduct(product);
        }

        public static <F> SubscribedTopics<F> unapply(SubscribedTopics<F> subscribedTopics) {
            return LogEntry$SubscribedTopics$.MODULE$.unapply(subscribedTopics);
        }

        public SubscribedTopics(NonEmptyList<String> topics, KafkaConsumerActor.State<F, ?, ?> state) {
            this.topics = topics;
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribedTopics)) return false;
            SubscribedTopics subscribedTopics = (SubscribedTopics)object;
            NonEmptyList<String> nonEmptyList = this.topics();
            NonEmptyList<String> nonEmptyList2 = subscribedTopics.topics();
            if (nonEmptyList == null) {
                if (nonEmptyList2 != null) {
                    return false;
                }
            } else if (!nonEmptyList.equals(nonEmptyList2)) return false;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = subscribedTopics.state();
            if (state == null) {
                if (state2 == null) return true;
                return false;
            } else {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SubscribedTopics;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SubscribedTopics";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "topics";
            }
            if (1 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public NonEmptyList<String> topics() {
            return this.topics;
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(51).append("Consumer subscribed to topics [").append(this.topics().toList().mkString(", ")).append("]. Current state [").append(this.state()).append("].").toString();
        }

        public <F> SubscribedTopics<F> copy(NonEmptyList<String> topics, KafkaConsumerActor.State<F, ?, ?> state) {
            return new SubscribedTopics<F>(topics, state);
        }

        public <F> NonEmptyList<String> copy$default$1() {
            return this.topics();
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$2() {
            return this.state();
        }

        public NonEmptyList<String> _1() {
            return this.topics();
        }

        public KafkaConsumerActor.State<F, ?, ?> _2() {
            return this.state();
        }
    }

    public static final class Unsubscribed<F>
    extends LogEntry
    implements Product,
    Serializable {
        private final KafkaConsumerActor.State state;

        public static <F> Unsubscribed<F> apply(KafkaConsumerActor.State<F, ?, ?> state) {
            return LogEntry$Unsubscribed$.MODULE$.apply(state);
        }

        public static Unsubscribed<?> fromProduct(Product product) {
            return LogEntry$Unsubscribed$.MODULE$.fromProduct(product);
        }

        public static <F> Unsubscribed<F> unapply(Unsubscribed<F> unsubscribed) {
            return LogEntry$Unsubscribed$.MODULE$.unapply(unsubscribed);
        }

        public Unsubscribed(KafkaConsumerActor.State<F, ?, ?> state) {
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unsubscribed)) return false;
            Unsubscribed unsubscribed = (Unsubscribed)object;
            KafkaConsumerActor.State<F, ?, ?> state = this.state();
            KafkaConsumerActor.State<F, ?, ?> state2 = unsubscribed.state();
            if (state != null) {
                if (!((Object)state).equals(state2)) return false;
                return true;
            }
            if (state2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Unsubscribed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Unsubscribed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public KafkaConsumerActor.State<F, ?, ?> state() {
            return this.state;
        }

        @Override
        public LogLevel level() {
            return LogLevel$Debug$.MODULE$;
        }

        @Override
        public String message() {
            return new StringBuilder(60).append("Consumer unsubscribed from all partitions. Current state [").append(this.state()).append("].").toString();
        }

        public <F> Unsubscribed<F> copy(KafkaConsumerActor.State<F, ?, ?> state) {
            return new Unsubscribed<F>(state);
        }

        public <F> KafkaConsumerActor.State<F, ?, ?> copy$default$1() {
            return this.state();
        }

        public KafkaConsumerActor.State<F, ?, ?> _1() {
            return this.state();
        }
    }
}

