/*
 * Decompiled with CFR 0.152.
 */
package vulcan;

import cats.Show;
import cats.Show$;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.instances.package;
import cats.kernel.Eq;
import cats.package$;
import java.io.Serializable;
import java.time.LocalDate;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.util.Either;
import scala.util.control.NonFatal$;
import vulcan.AvroError;
import vulcan.AvroException$;

public final class AvroError$ {
    public static final AvroError$ MODULE$ = new AvroError$();
    private static final Show<AvroError> avroErrorShow = Show$.MODULE$.fromToString();
    private static final Eq<AvroError> avroErrorEq = package$.MODULE$.Eq().by((Function1 & Serializable)x$1 -> x$1.message(), (Eq)package.string$.MODULE$.catsKernelStdOrderForString());
    private static final AvroError decodeEmptyCollection = MODULE$.apply((Function0<String>)(Function0 & Serializable)() -> "Got unexpected empty collection");

    public final AvroError apply(Function0<String> message) {
        Function0<String> _message = message;
        return new AvroError(_message){
            private final Function0 _message$2;

            public final String message() {
                return (String)this._message$2.apply();
            }

            public final Throwable throwable() {
                return AvroException$.MODULE$.apply(this.message(), AvroException$.MODULE$.apply$default$2());
            }
            {
                this._message$2 = _message$2;
            }
        };
    }

    public final Show<AvroError> avroErrorShow() {
        return avroErrorShow;
    }

    public final Eq<AvroError> avroErrorEq() {
        return avroErrorEq;
    }

    public final <A> Either<AvroError, A> catchNonFatal(Function0<Either<AvroError, A>> either) {
        Either either2;
        try {
            either2 = (Either)either.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                either2 = scala.package$.MODULE$.Left().apply((Object)this.fromThrowable(throwable2));
            }
            throw throwable;
        }
        return either2;
    }

    public AvroError errorDecodingTo(String decodingTypeName, AvroError cause) {
        return new AvroError.ErrorDecodingType(decodingTypeName, cause);
    }

    public final AvroError decodeDecimalPrecisionExceeded(int actualPrecision, int expectedPrecision) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Unable to decode decimal with precision ").append(actualPrecision).append(" exceeding schema precision ").append(expectedPrecision).toString());
    }

    public AvroError decodeEmptyCollection() {
        return decodeEmptyCollection;
    }

    public final AvroError decodeNotEqualFixedSize(int length, int fixedSize) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Got ").append(length).append(" bytes, expected fixed size ").append(fixedSize).toString());
    }

    public final AvroError decodeMissingRecordField(String fieldName) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Record writer schema is missing field '").append(fieldName).append("'").toString());
    }

    public final AvroError decodeMissingUnionSchema(String subtypeName) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Missing schema ").append(subtypeName).append(" in union").toString());
    }

    public final AvroError decodeMissingUnionAlternative(String alternativeName) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Missing alternative ").append(alternativeName).append(" in union").toString());
    }

    public final AvroError decodeNameMismatch(String fullName, String decodingTypeName) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Unable to decode ").append(decodingTypeName).append(" using schema with name ").append(fullName).append(" since names do not match").toString());
    }

    public final AvroError decodeSymbolNotInSchema(String symbol, Seq<String> symbols) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append(symbol).append(" is not one of schema symbols ").append(symbols.mkString("[", ", ", "]")).toString());
    }

    public final AvroError decodeUnexpectedLogicalType(LogicalType actualLogicalType) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> {
            if (actualLogicalType == null) {
                return "Got unexpected missing logical type";
            }
            return new StringBuilder(28).append("Got unexpected logical type ").append(actualLogicalType.getName()).toString();
        });
    }

    public final AvroError decodeUnexpectedMapKey(Object key) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> {
            String typeName = key != null ? key.getClass().getTypeName() : "null";
            return new StringBuilder(48).append("Got unexpected map key with type ").append(typeName).append(", expected Utf8").toString();
        });
    }

    public final AvroError decodeUnexpectedRecordName(String expectedRecordName, String recordName) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Got record writer schema with name ").append(recordName).append(", expected name ").append(expectedRecordName).toString());
    }

    public final AvroError decodeUnexpectedSchemaType(Schema.Type actualSchemaType, Schema.Type expectedSchemaType) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Got unexpected schema type ").append(actualSchemaType).append(", expected schema type ").append(expectedSchemaType).toString());
    }

    public final AvroError decodeUnexpectedType(Object value, String expectedType) {
        return this.decodeUnexpectedTypes(value, (NonEmptyList<String>)NonEmptyList$.MODULE$.one((Object)expectedType));
    }

    public final AvroError decodeUnexpectedTypes(Object value, NonEmptyList<String> expectedTypes) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> {
            String expected = expectedTypes.toList().mkString(", ");
            String types = expectedTypes.size() > 1 ? "types" : "type";
            String typeName = value != null ? value.getClass().getTypeName() : "null";
            return new StringBuilder(32).append("Got unexpected type ").append(typeName).append(", expected ").append(types).append(" ").append(expected).toString();
        });
    }

    public final AvroError decodeExhaustedAlternatives(Object value) {
        String typeName = value != null ? value.getClass().getTypeName() : "null";
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Exhausted alternatives for type ").append(typeName).toString());
    }

    public final AvroError unexpectedChar(int length) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Got unexpected String with length ").append(length).append(", expected length 1").toString());
    }

    public final AvroError unexpectedByte(int value) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(82).append("Got unexpected Int value ").append(value).append(", expected value in range ").append(-128).append(" to ").append(127).toString());
    }

    public final AvroError unexpectedShort(int value) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("Got unexpected Int value ").append(value).append(", expected value in range ").append(Short.MIN_VALUE).append(" to ").append(Short.MAX_VALUE).toString());
    }

    public AvroError errorEncodingFrom(String encodingTypeName, AvroError cause) {
        return new AvroError.ErrorEncodingType(encodingTypeName, cause);
    }

    public final AvroError encodeDateSizeExceeded(LocalDate date) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Unable to encode date as epoch days of ").append(date.toEpochDay()).append(" exceeds the maximum integer size").toString());
    }

    public final AvroError encodeDecimalPrecisionExceeded(int actualPrecision, int expectedPrecision) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Unable to encode decimal with precision ").append(actualPrecision).append(" exceeding schema precision ").append(expectedPrecision).toString());
    }

    public final AvroError encodeDecimalScalesMismatch(int actualScale, int expectedScale) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Unable to encode decimal with scale ").append(actualScale).append(" as scale ").append(expectedScale).toString());
    }

    public final AvroError encodeExceedsFixedSize(int length, int fixedSize) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Got ").append(length).append(" bytes, expected maximum fixed size ").append(fixedSize).toString());
    }

    public final AvroError encodeExhaustedAlternatives(Object value) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> {
            String typeName = value != null ? value.getClass().getTypeName() : "null";
            return new StringBuilder(32).append("Exhausted alternatives for type ").append(typeName).toString();
        });
    }

    public final AvroError encodeSymbolNotInSchema(String symbol, Seq<String> symbols) {
        return this.apply((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Symbol ").append(symbol).append(" is not part of schema symbols [").append(symbols.mkString(", ")).append("]").toString());
    }

    public final AvroError fromThrowable(Throwable cause) {
        return new AvroError(cause){
            private final Throwable cause$1;

            public String message() {
                return this.cause$1.toString();
            }

            public Throwable throwable() {
                return AvroException$.MODULE$.apply(this.message(), (Option<Throwable>)new Some((Object)this.cause$1));
            }
            {
                this.cause$1 = cause$1;
            }
        };
    }

    private AvroError$() {
    }
}

