/*
 * Decompiled with CFR 0.152.
 */
package org.flips.describe.controller;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.flips.describe.model.FlipDescription;
import org.flips.store.FlipAnnotationsStore;
import org.flips.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/describe"})
public class FlipDescriptionController {
    private FlipAnnotationsStore flipAnnotationsStore;

    @Autowired
    public FlipDescriptionController(@Lazy FlipAnnotationsStore flipAnnotationsStore) {
        this.flipAnnotationsStore = flipAnnotationsStore;
    }

    @RequestMapping(value={"/features"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FlipDescription> describeFeatures() {
        return this.getAllFlipDescription(null);
    }

    @RequestMapping(value={"/features/{featureName}"}, method={RequestMethod.GET})
    @ResponseBody
    public List<FlipDescription> describeFeaturesWithFilter(@PathVariable(value="featureName") String featureName) {
        return this.getAllFlipDescription(featureName);
    }

    private List<FlipDescription> getAllFlipDescription(String featureName) {
        return this.getAllMethodsCached().stream().filter(this.getFeatureFilter(featureName)).map(this::buildFlipDescription).sorted(Comparator.comparing(FlipDescription::getMethodName)).collect(Collectors.toList());
    }

    private Set<Method> getAllMethodsCached() {
        return this.flipAnnotationsStore.allMethodsCached();
    }

    private Predicate<Method> getFeatureFilter(String featureName) {
        if (Utils.isEmpty((String)featureName)) {
            return method -> true;
        }
        return method -> method.getName().equals(featureName);
    }

    private FlipDescription buildFlipDescription(Method method) {
        return new FlipDescription(method.getName(), method.getDeclaringClass().getName(), this.flipAnnotationsStore.isFeatureEnabled(method));
    }
}

