/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather;

import com.github.fedy2.weather.data.unit.DegreeUnit;
import java.util.HashMap;
import java.util.Map;

public class QueryBuilder {
    private static final String WOEID_PARAMETER_NAME = "woeid";
    private static final String DEGREES_PARAMETER_CELSIUS = "u=\"c\"";
    private static final String DEGREES_PARAMETER_FAHRENHEIT = "u=\"f\"";
    private static final String FIRST_PARAMETER_NAME = "truncate";
    private static final String LAST_PARAMETER_NAME = "tail";
    private String unitCondition;
    private String woeidCondition;
    private Map<String, String> limits = new HashMap<String, String>();

    public QueryBuilder woeid(String woeid) {
        this.woeidCondition = "woeid=\"" + woeid + "\"";
        return this;
    }

    public QueryBuilder location(String location) {
        this.woeidCondition = "woeid in (select woeid from geo.places where text=\"" + location + "\")";
        return this;
    }

    public QueryBuilder unit(DegreeUnit unit) {
        switch (unit) {
            case CELSIUS: {
                this.unitCondition = DEGREES_PARAMETER_CELSIUS;
                break;
            }
            case FAHRENHEIT: {
                this.unitCondition = DEGREES_PARAMETER_FAHRENHEIT;
            }
        }
        return this;
    }

    public QueryBuilder first(int limit) {
        this.limits.put(FIRST_PARAMETER_NAME, String.valueOf(limit));
        return this;
    }

    public QueryBuilder last(int limit) {
        this.limits.put(LAST_PARAMETER_NAME, String.valueOf(limit));
        return this;
    }

    public String build() {
        StringBuilder query = new StringBuilder("SELECT * FROM weather.forecast WHERE ");
        query.append(this.woeidCondition).append(" ");
        if (this.unitCondition != null) {
            query.append("AND ").append(this.unitCondition).append(" ");
        }
        for (Map.Entry<String, String> limit : this.limits.entrySet()) {
            query.append("| ").append(limit.getKey()).append("(count=").append(limit.getValue()).append(") ");
        }
        return query.toString();
    }
}

