/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import com.github.fedy2.weather.data.unit.BarometricPressureState;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarometricPressureStateAdapter
extends XmlAdapter<Integer, BarometricPressureState> {
    private static final int FALLING = 2;
    private static final int RISING = 1;
    private static final int STEADY = 0;
    private Logger logger = LoggerFactory.getLogger(BarometricPressureStateAdapter.class);

    public BarometricPressureState unmarshal(Integer v) throws Exception {
        switch (v) {
            case 0: {
                return BarometricPressureState.STEADY;
            }
            case 1: {
                return BarometricPressureState.RISING;
            }
            case 2: {
                return BarometricPressureState.FALLING;
            }
        }
        this.logger.warn("Unknown barometric pressure state \"" + v + "\"");
        return null;
    }

    public Integer marshal(BarometricPressureState v) throws Exception {
        switch (v) {
            case STEADY: {
                return 0;
            }
            case RISING: {
                return 1;
            }
            case FALLING: {
                return 2;
            }
        }
        return -1;
    }
}

