/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateAdapter
extends XmlAdapter<String, Date> {
    private Logger logger = LoggerFactory.getLogger(DateAdapter.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("d MMM yyyy", Locale.US);

    public String marshal(Date v) throws Exception {
        return this.dateFormat.format(v);
    }

    public Date unmarshal(String v) throws Exception {
        try {
            return this.dateFormat.parse(v);
        }
        catch (Exception e) {
            this.logger.warn("Unknown date format \"{}\"", (Object)v);
            return null;
        }
    }
}

