/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import com.github.fedy2.weather.data.unit.DegreeUnit;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegreeUnitAdapter
extends XmlAdapter<String, DegreeUnit> {
    private static final String CELSIUS = "c";
    private static final String FAHRENHEIT = "f";
    private Logger logger = LoggerFactory.getLogger(DegreeUnitAdapter.class);

    public DegreeUnit unmarshal(String v) throws Exception {
        if (FAHRENHEIT.equalsIgnoreCase(v)) {
            return DegreeUnit.FAHRENHEIT;
        }
        if (CELSIUS.equalsIgnoreCase(v)) {
            return DegreeUnit.CELSIUS;
        }
        this.logger.warn("Unknown degree unit \"{}\"", (Object)v);
        return null;
    }

    public String marshal(DegreeUnit v) throws Exception {
        switch (v) {
            case CELSIUS: {
                return CELSIUS;
            }
            case FAHRENHEIT: {
                return FAHRENHEIT;
            }
        }
        return "";
    }
}

