/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import com.github.fedy2.weather.data.unit.PressureUnit;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PressureUnitAdapter
extends XmlAdapter<String, PressureUnit> {
    private static final String MB = "mb";
    private static final String IN = "in";
    private Logger logger = LoggerFactory.getLogger(PressureUnitAdapter.class);

    public PressureUnit unmarshal(String v) throws Exception {
        if (IN.equalsIgnoreCase(v)) {
            return PressureUnit.IN;
        }
        if (MB.equalsIgnoreCase(v)) {
            return PressureUnit.MB;
        }
        this.logger.warn("Unknown pressure unit \"{}\"", (Object)v);
        return null;
    }

    public String marshal(PressureUnit v) throws Exception {
        switch (v) {
            case IN: {
                return IN;
            }
            case MB: {
                return MB;
            }
        }
        return "";
    }
}

