/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RFC822DateAdapter
extends XmlAdapter<String, Date> {
    private static final SimpleDateFormat[] rfc822DateFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yy HH:mm:ss z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm z", Locale.US), new SimpleDateFormat("d MMM yyyy HH:mm:ss z", Locale.US), new SimpleDateFormat("EEE, d MMM yyyy hh:mm a z", Locale.US)};
    private Logger logger = LoggerFactory.getLogger(RFC822DateAdapter.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss z", Locale.US);

    public String marshal(Date v) throws Exception {
        return this.dateFormat.format(v);
    }

    public Date unmarshal(String v) throws Exception {
        for (SimpleDateFormat format : rfc822DateFormats) {
            try {
                return format.parse(v);
            }
            catch (Exception exception) {
            }
        }
        this.logger.warn("Unknown date format \"{}\"", (Object)v);
        return null;
    }
}

