/*
 * Decompiled with CFR 0.152.
 */
package com.github.fedy2.weather.binding.adapter;

import com.github.fedy2.weather.data.unit.Time;
import com.github.fedy2.weather.data.unit.TimeConvention;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAdapter
extends XmlAdapter<String, Time> {
    private static final String TIME_PATTERN = "(\\d?\\d):(\\d?\\d)\\s(am|pm)";
    private static final Pattern PATTERN = Pattern.compile("(\\d?\\d):(\\d?\\d)\\s(am|pm)");
    private Logger logger = LoggerFactory.getLogger(TimeAdapter.class);

    public Time unmarshal(String v) throws Exception {
        Matcher matcher;
        if (v != null && (matcher = PATTERN.matcher(v)).groupCount() == 3) {
            matcher.find();
            try {
                String hoursToken = matcher.group(1);
                int hours = Integer.parseInt(hoursToken);
                String minutesToken = matcher.group(2);
                int minutes = Integer.parseInt(minutesToken);
                String conventionToken = matcher.group(3);
                TimeConvention convention = TimeConvention.valueOf(conventionToken.toUpperCase());
                return new Time(hours, minutes, convention);
            }
            catch (NumberFormatException nfe) {
                this.logger.warn("Error converting time value " + v, (Throwable)nfe);
            }
        }
        this.logger.warn("Unparsable time value \"{}\"", (Object)v);
        return null;
    }

    public String marshal(Time v) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(v.getHours());
        sb.append(':');
        sb.append(v.getMinutes());
        sb.append(' ');
        sb.append(v.getConvention().toString().toLowerCase());
        return sb.toString();
    }
}

