/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.util.List;
import javapns.notification.exceptions.PayloadMaxSizeExceededException;
import javapns.notification.exceptions.PayloadMaxSizeProbablyExceededException;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Payload {
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    protected static final Logger logger = Logger.getLogger(Payload.class);
    private JSONObject payload;
    private String characterEncoding = "UTF-8";
    private int expiry = 86400;
    private boolean payloadSizeEstimatedWhenAdding = false;
    private int preSendConfiguration = 0;

    public Payload() {
        this.payload = new JSONObject();
    }

    public Payload(String rawJSON) throws JSONException {
        this.payload = new JSONObject(rawJSON);
    }

    public JSONObject getPayload() {
        return this.payload;
    }

    public void addCustomDictionary(String name, String value) throws JSONException {
        logger.debug((Object)("Adding custom Dictionary [" + name + "] = [" + value + "]"));
        this.put(name, value, this.payload, false);
    }

    public void addCustomDictionary(String name, int value) throws JSONException {
        logger.debug((Object)("Adding custom Dictionary [" + name + "] = [" + value + "]"));
        this.put(name, value, this.payload, false);
    }

    public void addCustomDictionary(String name, List values) throws JSONException {
        logger.debug((Object)("Adding custom Dictionary [" + name + "] = (list)"));
        this.put(name, values, this.payload, false);
    }

    public void addCustomDictionary(String name, Object value) throws JSONException {
        logger.debug((Object)("Adding custom Dictionary [" + name + "] = [" + value + "]"));
        this.put(name, value, this.payload, false);
    }

    public String toString() {
        return this.payload.toString();
    }

    void verifyPayloadIsNotEmpty() {
        if (this.getPreSendConfiguration() != 0) {
            return;
        }
        if (this.toString().equals("{}")) {
            throw new IllegalArgumentException("Payload cannot be empty");
        }
    }

    public byte[] getPayloadAsBytes() throws Exception {
        byte[] payload = this.getPayloadAsBytesUnchecked();
        this.validateMaximumPayloadSize(payload.length);
        return payload;
    }

    private byte[] getPayloadAsBytesUnchecked() throws Exception {
        byte[] bytes = null;
        try {
            bytes = this.toString().getBytes(this.characterEncoding);
        }
        catch (Exception ex) {
            bytes = this.toString().getBytes();
        }
        return bytes;
    }

    public int getPayloadSize() throws Exception {
        return this.getPayloadAsBytesUnchecked().length;
    }

    private boolean isPayloadTooLong() {
        try {
            byte[] bytes = this.getPayloadAsBytesUnchecked();
            if (bytes.length > this.getMaximumPayloadSize()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int estimatePayloadSizeAfterAdding(String propertyName, Object propertyValue) {
        try {
            int currentPayloadSize;
            int maximumPayloadSize = this.getMaximumPayloadSize();
            int estimatedSize = currentPayloadSize = this.getPayloadAsBytesUnchecked().length;
            if (propertyName != null && propertyValue != null) {
                estimatedSize += 5;
                estimatedSize += propertyName.getBytes(this.getCharacterEncoding()).length;
                int estimatedValueSize = 0;
                if (propertyValue instanceof String || propertyValue instanceof Number) {
                    estimatedValueSize = propertyValue.toString().getBytes(this.getCharacterEncoding()).length;
                }
                estimatedSize += estimatedValueSize;
            }
            return estimatedSize;
        }
        catch (Exception e) {
            try {
                return this.getPayloadSize();
            }
            catch (Exception e1) {
                return 0;
            }
        }
    }

    public boolean isEstimatedPayloadSizeAllowedAfterAdding(String propertyName, Object propertyValue) {
        int maximumPayloadSize = this.getMaximumPayloadSize();
        int estimatedPayloadSize = this.estimatePayloadSizeAfterAdding(propertyName, propertyValue);
        boolean estimatedToBeAllowed = estimatedPayloadSize <= maximumPayloadSize;
        return estimatedToBeAllowed;
    }

    private void validateMaximumPayloadSize(int currentPayloadSize) throws PayloadMaxSizeExceededException {
        int maximumPayloadSize = this.getMaximumPayloadSize();
        if (currentPayloadSize > maximumPayloadSize) {
            throw new PayloadMaxSizeExceededException(maximumPayloadSize, currentPayloadSize);
        }
    }

    protected void put(String propertyName, Object propertyValue, JSONObject object, boolean opt) throws JSONException {
        try {
            if (this.isPayloadSizeEstimatedWhenAdding()) {
                boolean estimatedToExceed;
                int maximumPayloadSize = this.getMaximumPayloadSize();
                int estimatedPayloadSize = this.estimatePayloadSizeAfterAdding(propertyName, propertyValue);
                boolean bl = estimatedToExceed = estimatedPayloadSize > maximumPayloadSize;
                if (estimatedToExceed) {
                    throw new PayloadMaxSizeProbablyExceededException(maximumPayloadSize, estimatedPayloadSize);
                }
            }
        }
        catch (PayloadMaxSizeProbablyExceededException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (opt) {
            object.putOpt(propertyName, propertyValue);
        } else {
            object.put(propertyName, propertyValue);
        }
    }

    public boolean isPayloadSizeEstimatedWhenAdding() {
        return this.payloadSizeEstimatedWhenAdding;
    }

    public void setPayloadSizeEstimatedWhenAdding(boolean checked) {
        this.payloadSizeEstimatedWhenAdding = checked;
    }

    public int getMaximumPayloadSize() {
        return Integer.MAX_VALUE;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setExpiry(int seconds) {
        this.expiry = seconds;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public Payload asSimulationOnly() {
        this.setExpiry(919191);
        return this;
    }

    protected void setPreSendConfiguration(int preSendConfiguration) {
        this.preSendConfiguration = preSendConfiguration;
    }

    protected int getPreSendConfiguration() {
        return this.preSendConfiguration;
    }
}

