/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.DependencyGraphException;
import com.github.ferstl.depgraph.GraphFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.ScopeArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.StrictPatternIncludesArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

abstract class AbstractGraphMojo
extends AbstractMojo {
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\r?\n");
    private static final String DOT_EXTENSION = ".dot";
    private static final String OUTPUT_DOT_FILE_NAME = "dependency-graph.dot";
    @Parameter(property="scope")
    private String scope;
    @Parameter(property="includes", defaultValue="")
    private List<String> includes;
    @Parameter(property="excludes", defaultValue="")
    private List<String> excludes;
    @Parameter(property="targetIncludes", defaultValue="")
    private List<String> targetIncludes;
    @Parameter(property="outputFile", defaultValue="${project.build.directory}/dependency-graph.dot")
    private File outputFile;
    @Parameter(property="createImage", defaultValue="false")
    private boolean createImage;
    @Parameter(property="imageFormat", defaultValue="png")
    private String imageFormat;
    @Parameter(property="dotExecutable")
    private File dotExecutable;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    ArtifactRepository localRepository;
    @Component
    private MavenProject project;
    @Component(hint="default")
    DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    DependencyTreeBuilder dependencyTreeBuilder;

    AbstractGraphMojo() {
    }

    public void execute() throws MojoExecutionException {
        ArtifactFilter globalFilter = this.createGlobalArtifactFilter();
        ArtifactFilter targetFilter = this.createTargetArtifactFilter();
        try {
            GraphFactory graphFactory = this.createGraphFactory(globalFilter, targetFilter);
            this.writeDotFile(graphFactory.createGraph(this.project));
            if (this.createImage) {
                this.createGraphImage();
            }
        }
        catch (DependencyGraphException e) {
            throw new MojoExecutionException("Unable to create dependency graph.", e.getCause());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to write graph file.", (Exception)e);
        }
    }

    protected abstract GraphFactory createGraphFactory(ArtifactFilter var1, ArtifactFilter var2);

    private ArtifactFilter createGlobalArtifactFilter() {
        ArrayList<Object> filters = new ArrayList<Object>(3);
        if (this.scope != null) {
            filters.add(new ScopeArtifactFilter(this.scope));
        }
        if (!this.includes.isEmpty()) {
            filters.add(new StrictPatternIncludesArtifactFilter(this.includes));
        }
        if (!this.excludes.isEmpty()) {
            filters.add(new StrictPatternExcludesArtifactFilter(this.excludes));
        }
        return new AndArtifactFilter(filters);
    }

    private ArtifactFilter createTargetArtifactFilter() {
        AndArtifactFilter filter = new AndArtifactFilter();
        if (!this.targetIncludes.isEmpty()) {
            filter.add((ArtifactFilter)new StrictPatternIncludesArtifactFilter(this.targetIncludes));
        }
        return filter;
    }

    private void writeDotFile(String dotGraph) throws IOException {
        Path outputFilePath = this.outputFile.toPath();
        Files.createDirectories(outputFilePath.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(outputFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(dotGraph);
        }
    }

    private void createGraphImage() throws IOException {
        int exitCode;
        String graphFileName = this.createGraphFileName();
        Path graphFile = this.outputFile.toPath().getParent().resolve(graphFileName);
        String dotExecutable = this.determineDotExecutable();
        Object[] arguments = new String[]{"-T", this.imageFormat, "-o", graphFile.toAbsolutePath().toString(), this.outputFile.getAbsolutePath()};
        Commandline cmd = new Commandline();
        cmd.setExecutable(dotExecutable);
        cmd.addArguments((String[])arguments);
        this.getLog().info((CharSequence)("Running Graphviz: " + dotExecutable + " " + Joiner.on((String)" ").join(arguments)));
        CommandLineUtils.StringStreamConsumer systemOut = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer systemErr = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)systemOut, (StreamConsumer)systemErr);
        }
        catch (CommandLineException e) {
            throw new IOException("Unable to execute Graphviz", e);
        }
        Splitter lineSplitter = Splitter.on((Pattern)LINE_SEPARATOR_PATTERN).omitEmptyStrings().trimResults();
        Iterable output = Iterables.concat((Iterable)lineSplitter.split((CharSequence)systemOut.getOutput()), (Iterable)lineSplitter.split((CharSequence)systemErr.getOutput()));
        for (String line : output) {
            this.getLog().info((CharSequence)("  dot> " + line));
        }
        if (exitCode != 0) {
            throw new IOException("Graphviz terminated abnormally. Exit code: " + exitCode);
        }
        this.getLog().info((CharSequence)("Graph image created on " + graphFile.toAbsolutePath()));
    }

    private String createGraphFileName() {
        String dotFileName = this.outputFile.getName();
        String graphFileName = dotFileName.endsWith(DOT_EXTENSION) ? dotFileName.substring(0, dotFileName.lastIndexOf(".")) + "." + this.imageFormat : dotFileName + this.imageFormat;
        return graphFileName;
    }

    private String determineDotExecutable() throws IOException {
        if (this.dotExecutable == null) {
            return "dot";
        }
        Path dotExecutablePath = this.dotExecutable.toPath();
        if (!Files.exists(dotExecutablePath, new LinkOption[0])) {
            throw new NoSuchFileException("The dot executable '" + this.dotExecutable + "' does not exist.");
        }
        if (Files.isDirectory(dotExecutablePath, new LinkOption[0]) || !Files.isExecutable(dotExecutablePath)) {
            throw new IOException("The dot executable '" + this.dotExecutable + "' is not a file or cannot be executed.");
        }
        return dotExecutablePath.toAbsolutePath().toString();
    }
}

