/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.AbstractGraphMojo;
import com.github.ferstl.depgraph.AggregatingGraphFactory;
import com.github.ferstl.depgraph.GraphBuilderAdapter;
import com.github.ferstl.depgraph.GraphFactory;
import com.github.ferstl.depgraph.NodeRenderers;
import com.github.ferstl.depgraph.dot.DotBuilder;
import com.github.ferstl.depgraph.dot.NodeRenderer;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="aggregate", aggregator=true, defaultPhase=LifecyclePhase.NONE, inheritByDefault=false, requiresDependencyCollection=ResolutionScope.TEST, requiresDirectInvocation=false, threadSafe=true)
public class AggregatingDependencyGraphMojo
extends AbstractGraphMojo {
    @Parameter(property="showGroupIds", defaultValue="false")
    boolean showGroupIds;
    @Parameter(property="showVersions", defaultValue="false")
    boolean showVersions;
    @Parameter(property="includeParentProjects", defaultValue="false")
    private boolean includeParentProjects;

    @Override
    protected GraphFactory createGraphFactory(ArtifactFilter globalFilter, ArtifactFilter targetFilter) {
        DotBuilder dotBuilder = new DotBuilder().useNodeRenderer(NodeRenderers.VERSIONLESS_ID).useNodeLabelRenderer(this.determineNodeLabelRenderer());
        GraphBuilderAdapter adapter = new GraphBuilderAdapter(this.dependencyGraphBuilder, targetFilter);
        return new AggregatingGraphFactory(adapter, globalFilter, dotBuilder, this.includeParentProjects);
    }

    private NodeRenderer determineNodeLabelRenderer() {
        NodeRenderers renderer = NodeRenderers.ARTIFACT_ID_LABEL;
        if (this.showGroupIds && this.showVersions) {
            renderer = NodeRenderers.GROUP_ID_ARTIFACT_ID_VERSION_LABEL;
        } else if (this.showVersions) {
            renderer = NodeRenderers.ARTIFACT_ID_VERSION_LABEL;
        } else if (this.showGroupIds) {
            renderer = NodeRenderers.GROUP_ID_ARTIFACT_ID_LABEL;
        }
        return renderer;
    }
}

