/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.DependencyNodeAdapter;
import com.github.ferstl.depgraph.GraphBuilderAdapter;
import com.github.ferstl.depgraph.GraphFactory;
import com.github.ferstl.depgraph.dot.AttributeBuilder;
import com.github.ferstl.depgraph.dot.DotBuilder;
import com.github.ferstl.depgraph.dot.EdgeRenderer;
import com.github.ferstl.depgraph.dot.Node;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;

class AggregatingGraphFactory
implements GraphFactory {
    private final GraphBuilderAdapter graphBuilderAdapter;
    private final ArtifactFilter globalFilter;
    private final DotBuilder dotBuilder;
    private final boolean includeParentProjects;

    public AggregatingGraphFactory(GraphBuilderAdapter graphBuilderAdapter, ArtifactFilter globalFilter, DotBuilder dotBuilder, boolean includeParentProjects) {
        this.graphBuilderAdapter = graphBuilderAdapter;
        this.globalFilter = globalFilter;
        this.dotBuilder = dotBuilder;
        this.includeParentProjects = includeParentProjects;
    }

    @Override
    public String createGraph(MavenProject parent) {
        List collectedProjects = parent.getCollectedProjects();
        if (this.includeParentProjects) {
            this.buildModuleTree(parent, this.dotBuilder);
        }
        for (MavenProject collectedProject : collectedProjects) {
            if (!this.isPartOfGraph(collectedProject)) continue;
            this.graphBuilderAdapter.buildDependencyGraph(collectedProject, this.globalFilter, this.dotBuilder);
        }
        return this.dotBuilder.toString();
    }

    private void buildModuleTree(MavenProject parentProject, DotBuilder dotBuilder) {
        List collectedProjects = parentProject.getCollectedProjects();
        Iterator iterator = collectedProjects.iterator();
        block0: while (iterator.hasNext()) {
            MavenProject collectedProject;
            MavenProject child = collectedProject = (MavenProject)iterator.next();
            for (MavenProject parent = collectedProject.getParent(); parent != null; parent = parent.getParent()) {
                Node parentNode = this.filterProject(parent);
                Node childNode = this.filterProject(child);
                dotBuilder.addEdge(parentNode, childNode, DottedEdgeRenderer.INSTANCE);
                if (parent.equals((Object)parentProject)) continue block0;
                child = parent;
            }
        }
    }

    private boolean isPartOfGraph(MavenProject project) {
        boolean result = this.globalFilter.include(project.getArtifact());
        if (result && project.getModules().size() > 0) {
            result = result && this.includeParentProjects;
        }
        return result;
    }

    private Node filterProject(MavenProject project) {
        Artifact artifact = project.getArtifact();
        if (this.globalFilter.include(artifact)) {
            return new DependencyNodeAdapter(artifact);
        }
        return null;
    }

    static enum DottedEdgeRenderer implements EdgeRenderer
    {
        INSTANCE{

            @Override
            public String createEdgeAttributes(Node from, Node to) {
                return new AttributeBuilder().style("dotted").toString();
            }
        };

    }
}

