/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.NodeResolution;
import com.github.ferstl.depgraph.dot.AttributeBuilder;
import com.github.ferstl.depgraph.dot.EdgeRenderer;
import com.github.ferstl.depgraph.dot.Node;

class DependencyEdgeRenderer
implements EdgeRenderer {
    private static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    private final boolean renderVersions;
    private final boolean renderDuplicates;
    private final boolean renderConflicts;

    public DependencyEdgeRenderer(boolean renderVersions, boolean renderDuplicates, boolean renderConflicts) {
        this.renderVersions = renderVersions;
        this.renderDuplicates = renderDuplicates;
        this.renderConflicts = renderConflicts;
    }

    @Override
    public String createEdgeAttributes(Node from, Node to) {
        AttributeBuilder builder = new AttributeBuilder();
        NodeResolution resolution = to.getResolution();
        if (this.renderVersions) {
            builder.label(this.abbreviateVersion(to.getArtifact().getVersion()));
        }
        if (this.renderDuplicates && resolution == NodeResolution.OMITTED_FOR_DUPLICATE) {
            builder.style("dotted");
        }
        if (this.renderConflicts && resolution == NodeResolution.OMITTED_FOR_CONFLICT) {
            builder.style("dashed").color("red").fontColor("red");
        }
        return builder.toString();
    }

    private String abbreviateVersion(String version) {
        if (version.endsWith(SNAPSHOT_SUFFIX)) {
            return version.substring(0, version.length() - SNAPSHOT_SUFFIX.length()) + "-S.";
        }
        return version;
    }
}

