/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.AbstractGraphMojo;
import com.github.ferstl.depgraph.DependencyEdgeRenderer;
import com.github.ferstl.depgraph.GraphBuilderAdapter;
import com.github.ferstl.depgraph.GraphFactory;
import com.github.ferstl.depgraph.NodeRenderers;
import com.github.ferstl.depgraph.SimpleGraphFactory;
import com.github.ferstl.depgraph.dot.DotBuilder;
import com.github.ferstl.depgraph.dot.NodeRenderer;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="graph", aggregator=false, defaultPhase=LifecyclePhase.NONE, requiresDependencyCollection=ResolutionScope.TEST, requiresDirectInvocation=false, threadSafe=true)
public class DependencyGraphMojo
extends AbstractGraphMojo {
    @Parameter(property="showGroupIds", defaultValue="false")
    boolean showGroupIds;
    @Parameter(property="showVersions", defaultValue="false")
    boolean showVersions;
    @Parameter(property="showConflicts", defaultValue="false")
    boolean showConflicts;
    @Parameter(property="showDuplicates", defaultValue="false")
    boolean showDuplicates;

    @Override
    protected GraphFactory createGraphFactory(ArtifactFilter globalFilter, ArtifactFilter targetFilter) {
        DotBuilder dotBuilder = this.createGraphBuilder();
        GraphBuilderAdapter adapter = this.createGraphBuilderAdapter(targetFilter);
        return new SimpleGraphFactory(adapter, globalFilter, dotBuilder);
    }

    private DotBuilder createGraphBuilder() {
        DotBuilder dotBuilder = new DotBuilder().useNodeRenderer(NodeRenderers.VERSIONLESS_ID);
        boolean fullGraph = this.requiresFullGraph();
        if (fullGraph) {
            dotBuilder.useEdgeRenderer(new DependencyEdgeRenderer(this.showVersions, this.showDuplicates, this.showConflicts));
        }
        dotBuilder.useNodeLabelRenderer(this.determineNodeLabelRenderer(fullGraph));
        return dotBuilder;
    }

    private GraphBuilderAdapter createGraphBuilderAdapter(ArtifactFilter targetFilter) {
        GraphBuilderAdapter adapter = this.requiresFullGraph() ? new GraphBuilderAdapter(this.dependencyTreeBuilder, this.localRepository, targetFilter) : new GraphBuilderAdapter(this.dependencyGraphBuilder, targetFilter);
        return adapter;
    }

    private boolean requiresFullGraph() {
        return this.showConflicts || this.showDuplicates;
    }

    private NodeRenderer determineNodeLabelRenderer(boolean isFullGraph) {
        NodeRenderers renderer = NodeRenderers.ARTIFACT_ID_LABEL;
        if (this.showGroupIds && this.showVersions && !isFullGraph) {
            renderer = NodeRenderers.GROUP_ID_ARTIFACT_ID_VERSION_LABEL;
        } else if (this.showVersions && !isFullGraph) {
            renderer = NodeRenderers.ARTIFACT_ID_VERSION_LABEL;
        } else if (this.showGroupIds) {
            renderer = NodeRenderers.GROUP_ID_ARTIFACT_ID_LABEL;
        }
        return renderer;
    }
}

