/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.NodeResolution;
import com.github.ferstl.depgraph.dot.Node;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.graph.DependencyNode;

public class DependencyNodeAdapter
implements Node {
    private DependencyNode graphNode;
    private org.apache.maven.shared.dependency.tree.DependencyNode treeNode;
    private final Artifact artifact;
    private final NodeResolution resolution;

    public DependencyNodeAdapter(Artifact artifact) {
        this(artifact, NodeResolution.INCLUDED);
    }

    public DependencyNodeAdapter(DependencyNode dependencyNode) {
        this(dependencyNode.getArtifact());
        this.graphNode = dependencyNode;
    }

    public DependencyNodeAdapter(org.apache.maven.shared.dependency.tree.DependencyNode dependencyNode) {
        this(dependencyNode.getArtifact(), DependencyNodeAdapter.determineResolution(dependencyNode.getState()));
        this.treeNode = dependencyNode;
    }

    private DependencyNodeAdapter(Artifact artifact, NodeResolution resolution) {
        if (artifact == null) {
            throw new NullPointerException("Artifact must not be null");
        }
        if (artifact.getScope() == null) {
            artifact.setScope("compile");
        }
        this.artifact = artifact;
        this.resolution = resolution;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    @Override
    public NodeResolution getResolution() {
        return this.resolution;
    }

    public Collection<DependencyNodeAdapter> getChildren() {
        if (this.treeNode != null) {
            return Collections2.transform((Collection)this.treeNode.getChildren(), (Function)TreeNode2Adapter.INSTANCE);
        }
        if (this.graphNode != null) {
            return Collections2.transform((Collection)this.graphNode.getChildren(), (Function)GraphNode2Adapter.INSTANCE);
        }
        return null;
    }

    private static NodeResolution determineResolution(int res) {
        switch (res) {
            case 1: {
                return NodeResolution.OMITTED_FOR_DUPLICATE;
            }
            case 2: {
                return NodeResolution.OMITTED_FOR_CONFLICT;
            }
            case 3: {
                return NodeResolution.OMITTED_FOR_CYCLE;
            }
        }
        return NodeResolution.INCLUDED;
    }

    private static enum GraphNode2Adapter implements Function<DependencyNode, DependencyNodeAdapter>
    {
        INSTANCE;


        public DependencyNodeAdapter apply(DependencyNode tn) {
            return new DependencyNodeAdapter(tn);
        }
    }

    private static enum TreeNode2Adapter implements Function<org.apache.maven.shared.dependency.tree.DependencyNode, DependencyNodeAdapter>
    {
        INSTANCE;


        public DependencyNodeAdapter apply(org.apache.maven.shared.dependency.tree.DependencyNode tn) {
            return new DependencyNodeAdapter(tn);
        }
    }
}

