/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.DependencyNodeAdapter;
import com.github.ferstl.depgraph.dot.DotBuilder;
import com.github.ferstl.depgraph.dot.Node;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

class DotBuildingVisitor
implements DependencyNodeVisitor,
org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor {
    private final DotBuilder dotBuilder;
    private final Deque<Node> stack;
    private final ArtifactFilter globalFilter;
    private final ArtifactFilter targetFilter;

    public DotBuildingVisitor(DotBuilder dotBuilder, ArtifactFilter globalFilter, ArtifactFilter targetFilter) {
        this.dotBuilder = dotBuilder;
        this.stack = new ArrayDeque<Node>();
        this.globalFilter = globalFilter;
        this.targetFilter = targetFilter;
    }

    public DotBuildingVisitor(DotBuilder dotBuilder, ArtifactFilter targetFilter) {
        this(dotBuilder, DoNothingArtifactFilter.INSTANCE, targetFilter);
    }

    public boolean visit(DependencyNode node) {
        return this.internalVisit(new DependencyNodeAdapter(node));
    }

    public boolean endVisit(DependencyNode node) {
        return this.internalEndVisit(new DependencyNodeAdapter(node));
    }

    public boolean visit(org.apache.maven.shared.dependency.tree.DependencyNode node) {
        return this.internalVisit(new DependencyNodeAdapter(node));
    }

    public boolean endVisit(org.apache.maven.shared.dependency.tree.DependencyNode node) {
        return this.internalEndVisit(new DependencyNodeAdapter(node));
    }

    private boolean internalVisit(DependencyNodeAdapter node) {
        Node currentParent = this.stack.peek();
        if (this.globalFilter.include(node.getArtifact()) && this.leadsToTargetDependency(node)) {
            if (currentParent != null) {
                this.dotBuilder.addEdge(currentParent, node);
            }
            this.stack.push(node);
            return true;
        }
        return false;
    }

    private boolean leadsToTargetDependency(DependencyNodeAdapter node) {
        if (this.targetFilter.include(node.getArtifact())) {
            return true;
        }
        for (DependencyNodeAdapter c : node.getChildren()) {
            if (!this.leadsToTargetDependency(c)) continue;
            return true;
        }
        return false;
    }

    private boolean internalEndVisit(DependencyNodeAdapter node) {
        if (this.globalFilter.include(node.getArtifact()) && this.leadsToTargetDependency(node)) {
            this.stack.pop();
        }
        return true;
    }

    private static enum DoNothingArtifactFilter implements ArtifactFilter
    {
        INSTANCE;


        public boolean include(Artifact artifact) {
            return true;
        }
    }
}

