/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.DependencyGraphException;
import com.github.ferstl.depgraph.DotBuildingVisitor;
import com.github.ferstl.depgraph.dot.DotBuilder;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;

final class GraphBuilderAdapter {
    private DependencyGraphBuilder dependencyGraphBuilder;
    private DependencyTreeBuilder dependencyTreeBuilder;
    private ArtifactRepository artifactRepository;
    private final ArtifactFilter targetFilter;

    public GraphBuilderAdapter(DependencyGraphBuilder builder, ArtifactFilter targetFilter) {
        this.dependencyGraphBuilder = builder;
        this.targetFilter = targetFilter;
    }

    public GraphBuilderAdapter(DependencyTreeBuilder builder, ArtifactRepository artifactRepository, ArtifactFilter targetFilter) {
        this.dependencyTreeBuilder = builder;
        this.artifactRepository = artifactRepository;
        this.targetFilter = targetFilter;
    }

    public void buildDependencyGraph(MavenProject project, ArtifactFilter globalFilter, DotBuilder dotBuilder) {
        if (this.dependencyGraphBuilder != null) {
            this.createGraph(project, globalFilter, dotBuilder);
        } else {
            this.createTree(project, globalFilter, dotBuilder);
        }
    }

    private void createGraph(MavenProject project, ArtifactFilter globalFilter, DotBuilder dotBuilder) throws DependencyGraphException {
        DependencyNode root;
        try {
            root = this.dependencyGraphBuilder.buildDependencyGraph(project, globalFilter);
        }
        catch (DependencyGraphBuilderException e) {
            throw new DependencyGraphException(e);
        }
        DotBuildingVisitor visitor = new DotBuildingVisitor(dotBuilder, this.targetFilter);
        root.accept((DependencyNodeVisitor)visitor);
    }

    private void createTree(MavenProject project, ArtifactFilter globalFilter, DotBuilder dotBuilder) throws DependencyGraphException {
        org.apache.maven.shared.dependency.tree.DependencyNode root;
        try {
            root = this.dependencyTreeBuilder.buildDependencyTree(project, this.artifactRepository, globalFilter);
        }
        catch (DependencyTreeBuilderException e) {
            throw new DependencyGraphException(e);
        }
        DotBuildingVisitor visitor = new DotBuildingVisitor(dotBuilder, globalFilter, this.targetFilter);
        root.accept((org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor)visitor);
    }
}

