/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.dot.Node;
import com.github.ferstl.depgraph.dot.NodeRenderer;
import com.google.common.base.Joiner;
import org.apache.maven.artifact.Artifact;

enum NodeRenderers implements NodeRenderer
{
    ARTIFACT_ID_LABEL{

        @Override
        public String render(Node node) {
            Artifact artifact = node.getArtifact();
            return NodeRenderers.toScopedString(artifact.getArtifactId(), artifact.getScope());
        }
    }
    ,
    ARTIFACT_ID_VERSION_LABEL{

        @Override
        public String render(Node node) {
            Artifact artifact = node.getArtifact();
            String artifactLabel = artifact.getArtifactId() + "\n" + artifact.getVersion();
            return NodeRenderers.toScopedString(artifactLabel, artifact.getScope());
        }
    }
    ,
    GROUP_ID_ARTIFACT_ID_LABEL{

        @Override
        public String render(Node node) {
            Artifact artifact = node.getArtifact();
            String artifactLabel = artifact.getGroupId() + "\n" + artifact.getArtifactId();
            return NodeRenderers.toScopedString(artifactLabel, artifact.getScope());
        }
    }
    ,
    GROUP_ID_ARTIFACT_ID_VERSION_LABEL{

        @Override
        public String render(Node node) {
            Artifact artifact = node.getArtifact();
            String artifactLabel = artifact.getGroupId() + "\n" + artifact.getArtifactId() + "\n" + artifact.getVersion();
            return NodeRenderers.toScopedString(artifactLabel, artifact.getScope());
        }
    }
    ,
    GROUP_ID_LABEL{

        @Override
        public String render(Node node) {
            Artifact artifact = node.getArtifact();
            return NodeRenderers.toScopedString(artifact.getGroupId(), artifact.getScope());
        }
    }
    ,
    SCOPED_GROUP_ID{

        @Override
        public String render(Node node) {
            Artifact artifact = node.getArtifact();
            return COLON_JOINER.join((Object)artifact.getGroupId(), (Object)artifact.getScope(), new Object[0]);
        }
    }
    ,
    VERSIONLESS_ID{

        @Override
        public String render(Node node) {
            Artifact artifact = node.getArtifact();
            return COLON_JOINER.join((Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), new Object[]{artifact.getType(), artifact.getClassifier(), artifact.getScope()});
        }
    };

    private static final Joiner COLON_JOINER;

    private static String toScopedString(String string, String scope) {
        if (scope != null && !"compile".equals(scope)) {
            return string + "\n(" + scope + ")";
        }
        return string;
    }

    static {
        COLON_JOINER = Joiner.on((String)":").useForNull("");
    }
}

