/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dot;

import com.github.ferstl.depgraph.dot.DotEscaper;
import java.util.LinkedHashMap;
import java.util.Map;

public class AttributeBuilder {
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    public AttributeBuilder label(String label) {
        return this.addAttribute("label", label);
    }

    public AttributeBuilder fontName(String fontName) {
        return this.addAttribute("fontname", fontName);
    }

    public AttributeBuilder fontSize(int fontSize) {
        return this.addAttribute("fontsize", Integer.toString(fontSize));
    }

    public AttributeBuilder fontColor(String color) {
        return this.addAttribute("fontcolor", color);
    }

    public AttributeBuilder style(String style) {
        return this.addAttribute("style", style);
    }

    public AttributeBuilder color(String color) {
        return this.addAttribute("color", color);
    }

    public AttributeBuilder shape(String shape) {
        return this.addAttribute("shape", shape);
    }

    public AttributeBuilder addAttribute(String key, String value) {
        this.attributes.put(key, DotEscaper.escape(value));
        return this;
    }

    public String toString() {
        if (this.attributes.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("[");
        for (Map.Entry<String, String> attribute : this.attributes.entrySet()) {
            sb.append(attribute.getKey() + "=" + attribute.getValue()).append(",");
        }
        return sb.delete(sb.length() - 1, sb.length()).append("]").toString();
    }
}

