/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph;

import com.github.ferstl.depgraph.AbstractGraphMojo;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphFactory;
import com.github.ferstl.depgraph.dependency.GraphStyleConfigurer;
import com.github.ferstl.depgraph.dependency.MavenGraphAdapter;
import com.github.ferstl.depgraph.dependency.NodeIdRenderers;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.dependency.SimpleGraphFactory;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.EnumSet;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="graph", aggregator=false, defaultPhase=LifecyclePhase.NONE, requiresDependencyCollection=ResolutionScope.TEST, requiresDirectInvocation=false, threadSafe=true)
public class DependencyGraphMojo
extends AbstractGraphMojo {
    @Parameter(property="showGroupIds", defaultValue="false")
    boolean showGroupIds;
    @Parameter(property="showVersions", defaultValue="false")
    boolean showVersions;
    @Parameter(property="showConflicts", defaultValue="false")
    boolean showConflicts;
    @Parameter(property="showDuplicates", defaultValue="false")
    boolean showDuplicates;

    @Override
    protected GraphFactory createGraphFactory(ArtifactFilter globalFilter, ArtifactFilter targetFilter, GraphStyleConfigurer graphStyleConfigurer) {
        GraphBuilder<DependencyNode> graphBuilder = this.createGraphBuilder(graphStyleConfigurer);
        MavenGraphAdapter adapter = this.createMavenGraphAdapter(targetFilter);
        return new SimpleGraphFactory(adapter, globalFilter, graphBuilder);
    }

    GraphBuilder<DependencyNode> createGraphBuilder(GraphStyleConfigurer graphStyleConfigurer) {
        return graphStyleConfigurer.showGroupIds(this.showGroupIds).showArtifactIds(true).showVersionsOnNodes(this.showVersions).showVersionsOnEdges(this.showVersions && this.requiresFullGraph()).configure(GraphBuilder.create()).useNodeIdRenderer(NodeIdRenderers.VERSIONLESS_ID);
    }

    private MavenGraphAdapter createMavenGraphAdapter(ArtifactFilter targetFilter) {
        MavenGraphAdapter adapter;
        if (this.requiresFullGraph()) {
            EnumSet<NodeResolution> resolutions = EnumSet.allOf(NodeResolution.class);
            resolutions = !this.showConflicts ? EnumSet.complementOf(EnumSet.of(NodeResolution.OMITTED_FOR_CONFLICT)) : resolutions;
            resolutions = !this.showDuplicates ? EnumSet.complementOf(EnumSet.of(NodeResolution.OMITTED_FOR_DUPLICATE)) : resolutions;
            adapter = new MavenGraphAdapter(this.dependencyTreeBuilder, this.localRepository, targetFilter, resolutions);
        } else {
            adapter = new MavenGraphAdapter(this.dependencyGraphBuilder, targetFilter);
        }
        return adapter;
    }

    private boolean requiresFullGraph() {
        return this.showConflicts || this.showDuplicates;
    }
}

