/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;

public final class DependencyNode {
    private org.apache.maven.shared.dependency.graph.DependencyNode graphNode;
    private org.apache.maven.shared.dependency.tree.DependencyNode treeNode;
    private final Artifact artifact;
    private final NodeResolution resolution;
    private final TreeSet<String> scopes;

    public DependencyNode(Artifact artifact) {
        this(artifact, NodeResolution.INCLUDED);
    }

    public DependencyNode(org.apache.maven.shared.dependency.graph.DependencyNode dependencyNode) {
        this(dependencyNode.getArtifact());
        this.graphNode = dependencyNode;
    }

    public DependencyNode(org.apache.maven.shared.dependency.tree.DependencyNode dependencyNode) {
        this(dependencyNode.getArtifact(), DependencyNode.determineResolution(dependencyNode.getState()));
        this.treeNode = dependencyNode;
    }

    private DependencyNode(Artifact artifact, NodeResolution resolution) {
        if (artifact == null) {
            throw new NullPointerException("Artifact must not be null");
        }
        if (artifact.getScope() == null) {
            artifact.setScope("compile");
        }
        this.scopes = new TreeSet();
        this.artifact = artifact;
        this.resolution = resolution;
        this.scopes.add(artifact.getScope());
    }

    public void merge(DependencyNode other) {
        if (this == other) {
            return;
        }
        this.scopes.addAll(other.getScopes());
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public NodeResolution getResolution() {
        return this.resolution;
    }

    public Set<String> getScopes() {
        return ImmutableSet.copyOf(this.scopes);
    }

    public String getEffectiveVersion() {
        if (this.treeNode == null || this.treeNode.getRelatedArtifact() == null) {
            return this.artifact.getVersion();
        }
        return this.treeNode.getRelatedArtifact().getVersion();
    }

    public Collection<DependencyNode> getChildren() {
        if (this.treeNode != null) {
            return Collections2.transform((Collection)this.treeNode.getChildren(), (Function)TreeNode2Adapter.INSTANCE);
        }
        if (this.graphNode != null) {
            return Collections2.transform((Collection)this.graphNode.getChildren(), (Function)GraphNode2Adapter.INSTANCE);
        }
        throw new IllegalStateException("Tree node and graph node are null");
    }

    public String toString() {
        return this.artifact.toString();
    }

    private static NodeResolution determineResolution(int res) {
        switch (res) {
            case 1: {
                return NodeResolution.OMITTED_FOR_DUPLICATE;
            }
            case 2: {
                return NodeResolution.OMITTED_FOR_CONFLICT;
            }
            case 3: {
                return NodeResolution.OMITTED_FOR_CYCLE;
            }
        }
        return NodeResolution.INCLUDED;
    }

    private static enum GraphNode2Adapter implements Function<org.apache.maven.shared.dependency.graph.DependencyNode, DependencyNode>
    {
        INSTANCE;


        public DependencyNode apply(org.apache.maven.shared.dependency.graph.DependencyNode tn) {
            return new DependencyNode(tn);
        }
    }

    private static enum TreeNode2Adapter implements Function<org.apache.maven.shared.dependency.tree.DependencyNode, DependencyNode>
    {
        INSTANCE;


        public DependencyNode apply(org.apache.maven.shared.dependency.tree.DependencyNode tn) {
            return new DependencyNode(tn);
        }
    }
}

