/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.dependency.VersionAbbreviator;
import com.github.ferstl.depgraph.dependency.style.StyleConfiguration;
import com.github.ferstl.depgraph.graph.EdgeRenderer;
import com.github.ferstl.depgraph.graph.dot.DotAttributeBuilder;
import com.google.common.collect.Iterables;

public class DotDependencyEdgeRenderer
implements EdgeRenderer<DependencyNode> {
    private final boolean renderVersions;
    private final StyleConfiguration styleConfiguration;

    public DotDependencyEdgeRenderer(boolean renderVersions, StyleConfiguration styleConfiguration) {
        this.renderVersions = renderVersions;
        this.styleConfiguration = styleConfiguration;
    }

    @Override
    public String render(DependencyNode from, DependencyNode to) {
        NodeResolution resolution = to.getResolution();
        DotAttributeBuilder builder = this.styleConfiguration.edgeAttributes(resolution, (String)Iterables.getFirst(to.getScopes(), null));
        if (resolution == NodeResolution.OMITTED_FOR_CONFLICT && this.renderVersions) {
            builder.label(VersionAbbreviator.abbreviateVersion(to.getArtifact().getVersion()));
        }
        return builder.toString();
    }
}

