/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.style.StyleConfiguration;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class DotDependencyNodeNameRenderer
implements NodeRenderer<DependencyNode> {
    private static final Joiner SLASH_JOINER = Joiner.on((String)"/").skipNulls();
    private final boolean showGroupId;
    private final boolean showArtifactId;
    private final boolean showVersion;
    private final StyleConfiguration styleConfiguration;

    public DotDependencyNodeNameRenderer(boolean showGroupId, boolean showArtifactId, boolean showVersion, StyleConfiguration styleConfiguration) {
        this.showGroupId = showGroupId;
        this.showArtifactId = showArtifactId;
        this.showVersion = showVersion;
        this.styleConfiguration = styleConfiguration;
    }

    @Override
    public String render(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        String scopes = DotDependencyNodeNameRenderer.createScopeString(node.getScopes());
        return this.styleConfiguration.nodeAttributes(this.showGroupId ? artifact.getGroupId() : null, this.showArtifactId ? artifact.getArtifactId() : null, this.showVersion ? node.getEffectiveVersion() : null, artifact.getType(), scopes, (String)Iterables.getFirst(node.getScopes(), null)).toString();
    }

    private static String createScopeString(Set<String> scopes) {
        if (scopes.size() > 1 || !scopes.contains("compile")) {
            return "(" + SLASH_JOINER.join(scopes) + ")";
        }
        return "";
    }
}

