/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

class GraphBuildingVisitor
implements DependencyNodeVisitor,
org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor {
    private final GraphBuilder<DependencyNode> graphBuilder;
    private final Deque<DependencyNode> nodeStack;
    private final ArtifactFilter globalFilter;
    private final ArtifactFilter targetFilter;
    private final Set<NodeResolution> includedResolutions;

    GraphBuildingVisitor(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter globalFilter, ArtifactFilter targetFilter, Set<NodeResolution> includedResolutions) {
        this.graphBuilder = graphBuilder;
        this.nodeStack = new ArrayDeque<DependencyNode>();
        this.globalFilter = globalFilter;
        this.targetFilter = targetFilter;
        this.includedResolutions = includedResolutions;
    }

    GraphBuildingVisitor(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter targetFilter) {
        this(graphBuilder, DoNothingArtifactFilter.INSTANCE, targetFilter, EnumSet.allOf(NodeResolution.class));
    }

    public boolean visit(org.apache.maven.shared.dependency.graph.DependencyNode node) {
        return this.internalVisit(new DependencyNode(node));
    }

    public boolean endVisit(org.apache.maven.shared.dependency.graph.DependencyNode node) {
        return this.internalEndVisit(new DependencyNode(node));
    }

    public boolean visit(org.apache.maven.shared.dependency.tree.DependencyNode node) {
        return this.internalVisit(new DependencyNode(node));
    }

    public boolean endVisit(org.apache.maven.shared.dependency.tree.DependencyNode node) {
        return this.internalEndVisit(new DependencyNode(node));
    }

    private boolean internalVisit(DependencyNode node) {
        DependencyNode currentParent = this.nodeStack.peek();
        if (this.globalFilter.include(node.getArtifact()) && this.leadsToTargetDependency(node)) {
            if (currentParent != null && this.includedResolutions.contains((Object)node.getResolution())) {
                this.mergeWithExisting(node);
                this.graphBuilder.addEdge(currentParent, node);
            }
            this.nodeStack.push(node);
            return true;
        }
        return false;
    }

    private void mergeWithExisting(DependencyNode node) {
        DependencyNode effectiveNode = this.graphBuilder.getEffectiveNode(node);
        node.merge(effectiveNode);
    }

    private boolean leadsToTargetDependency(DependencyNode node) {
        if (this.targetFilter.include(node.getArtifact())) {
            return true;
        }
        for (DependencyNode c : node.getChildren()) {
            if (!this.leadsToTargetDependency(c)) continue;
            return true;
        }
        return false;
    }

    private boolean internalEndVisit(DependencyNode node) {
        if (this.globalFilter.include(node.getArtifact()) && this.leadsToTargetDependency(node)) {
            this.nodeStack.pop();
        }
        return true;
    }

    private static enum DoNothingArtifactFilter implements ArtifactFilter
    {
        INSTANCE;


        public boolean include(Artifact artifact) {
            return true;
        }
    }
}

