/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyGraphException;
import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.GraphBuildingVisitor;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.EnumSet;
import java.util.Set;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;

public final class MavenGraphAdapter {
    private final DependencyGraphBuilder dependencyGraphBuilder;
    private final DependencyTreeBuilder dependencyTreeBuilder;
    private final ArtifactRepository artifactRepository;
    private final ArtifactFilter targetFilter;
    private final Set<NodeResolution> includedResolutions;

    public MavenGraphAdapter(DependencyGraphBuilder builder, ArtifactFilter targetFilter) {
        this.dependencyGraphBuilder = builder;
        this.targetFilter = targetFilter;
        this.includedResolutions = EnumSet.allOf(NodeResolution.class);
        this.dependencyTreeBuilder = null;
        this.artifactRepository = null;
    }

    public MavenGraphAdapter(DependencyTreeBuilder builder, ArtifactRepository artifactRepository, ArtifactFilter targetFilter, Set<NodeResolution> includedResolutions) {
        this.dependencyTreeBuilder = builder;
        this.artifactRepository = artifactRepository;
        this.targetFilter = targetFilter;
        this.includedResolutions = includedResolutions;
        this.dependencyGraphBuilder = null;
    }

    public void buildDependencyGraph(MavenProject project, ArtifactFilter globalFilter, GraphBuilder<DependencyNode> graphBuilder) {
        if (this.dependencyGraphBuilder != null) {
            this.createGraph(project, globalFilter, graphBuilder);
        } else {
            this.createTree(project, globalFilter, graphBuilder);
        }
    }

    private void createGraph(MavenProject project, ArtifactFilter globalFilter, GraphBuilder<DependencyNode> graphBuilder) throws DependencyGraphException {
        org.apache.maven.shared.dependency.graph.DependencyNode root;
        try {
            root = this.dependencyGraphBuilder.buildDependencyGraph(project, globalFilter);
        }
        catch (DependencyGraphBuilderException e) {
            throw new DependencyGraphException(e);
        }
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(graphBuilder, this.targetFilter);
        root.accept((DependencyNodeVisitor)visitor);
    }

    private void createTree(MavenProject project, ArtifactFilter globalFilter, GraphBuilder<DependencyNode> graphBuilder) throws DependencyGraphException {
        org.apache.maven.shared.dependency.tree.DependencyNode root;
        try {
            root = this.dependencyTreeBuilder.buildDependencyTree(project, this.artifactRepository, globalFilter);
        }
        catch (DependencyTreeBuilderException e) {
            throw new DependencyGraphException(e);
        }
        GraphBuildingVisitor visitor = new GraphBuildingVisitor(graphBuilder, globalFilter, this.targetFilter, this.includedResolutions);
        root.accept((org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor)visitor);
    }
}

