/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.graph.NodeRenderer;
import com.google.common.base.Joiner;
import org.apache.maven.artifact.Artifact;

public enum NodeIdRenderers implements NodeRenderer<DependencyNode>
{
    GROUP_ID{

        @Override
        public String render(DependencyNode node) {
            return node.getArtifact().getGroupId();
        }
    }
    ,
    GROUP_ID_WITH_SCOPE{

        @Override
        public String render(DependencyNode node) {
            Artifact artifact = node.getArtifact();
            return COLON_JOINER.join((Object)artifact.getGroupId(), (Object)artifact.getScope(), new Object[0]);
        }
    }
    ,
    VERSIONLESS_ID{

        @Override
        public String render(DependencyNode node) {
            Artifact artifact = node.getArtifact();
            return COLON_JOINER.join((Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), new Object[]{artifact.getType(), artifact.getClassifier()});
        }
    }
    ,
    VERSIONLESS_ID_WITH_SCOPE{

        @Override
        public String render(DependencyNode node) {
            Artifact artifact = node.getArtifact();
            return COLON_JOINER.join((Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), new Object[]{artifact.getType(), artifact.getClassifier(), artifact.getScope()});
        }
    };

    private static final Joiner COLON_JOINER;

    static {
        COLON_JOINER = Joiner.on((String)":").useForNull("");
    }
}

