/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency.style;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.github.ferstl.depgraph.dependency.style.Font;
import com.github.ferstl.depgraph.dependency.style.NodeTypeResolver;
import com.github.ferstl.depgraph.graph.dot.DotAttributeBuilder;
import com.github.ferstl.depgraph.graph.dot.DotLabelBuilder;
import org.apache.commons.lang3.StringUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonTypeIdResolver(value=NodeTypeResolver.class)
abstract class AbstractNode {
    private final String type;
    private String color;
    private String fillColor;
    private String style;
    private final Font defaultFont = new Font();
    private final Font groupIdFont = new Font();
    private final Font artifactIdFont = new Font();
    private final Font versionFont = new Font();
    private final Font scopeFont = new Font();

    AbstractNode(String type) {
        this.type = type;
    }

    DotAttributeBuilder createAttributes() {
        Font defaultFont = this.defaultFont;
        return new DotAttributeBuilder().shape(this.type).style(this.style).color(this.color).fillColor(this.fillColor).fontName(defaultFont.name).fontSize(defaultFont.size).fontColor(defaultFont.color);
    }

    DotAttributeBuilder createAttributes(String groupId, String artifactId, String version, String scopes, boolean includeNodeAttributes) {
        Font groupIdFont = this.groupIdFont;
        Font artifactIdFont = this.artifactIdFont;
        Font versionFont = this.versionFont;
        Font scopeFont = this.scopeFont;
        DotAttributeBuilder builder = includeNodeAttributes ? this.createAttributes() : new DotAttributeBuilder();
        return builder.label(new DotLabelBuilder().font().name(groupIdFont.name).color(groupIdFont.color).size(groupIdFont.size).text(groupId).smartNewLine().font().name(artifactIdFont.name).color(artifactIdFont.color).size(artifactIdFont.size).text(artifactId).smartNewLine().font().name(versionFont.name).color(versionFont.color).size(versionFont.size).text(version).smartNewLine().font().name(scopeFont.name).color(scopeFont.color).size(scopeFont.size).text(scopes).build());
    }

    void merge(AbstractNode other) {
        this.color = (String)StringUtils.defaultIfBlank((CharSequence)other.color, (CharSequence)this.color);
        this.fillColor = (String)StringUtils.defaultIfBlank((CharSequence)other.fillColor, (CharSequence)this.fillColor);
        this.style = (String)StringUtils.defaultIfBlank((CharSequence)other.style, (CharSequence)this.style);
        this.defaultFont.merge(other.defaultFont);
        this.groupIdFont.merge(other.groupIdFont);
        this.artifactIdFont.merge(other.artifactIdFont);
        this.versionFont.merge(other.versionFont);
        this.scopeFont.merge(other.scopeFont);
    }
}

